/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.parser.stax;

import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.abdera.model.Base;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.ElementWrapper;
import org.apache.abdera.model.ExtensibleElement;
import org.apache.abdera.parser.stax.FOMElement;
import org.apache.abdera.parser.stax.FOMFactory;
import org.apache.abdera.parser.stax.util.FOMElementIteratorWrapper;
import org.apache.abdera.parser.stax.util.FOMExtensionIterator;
import org.apache.axiom.fom.AbderaElement;
import org.apache.axiom.fom.AbderaExtensibleElement;
import org.apache.axiom.fom.FOMList;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FOMExtensibleElement
extends FOMElement
implements AbderaExtensibleElement {
    public List<Element> getExtensions() {
        return new FOMList<Element>((Iterator<Element>)((Object)new FOMExtensionIterator((OMElement)this)));
    }

    public List<Element> getExtensions(String uri) {
        return new FOMList<Element>((Iterator<Element>)((Object)new FOMExtensionIterator((OMElement)this, uri)));
    }

    public <T extends Element> List<T> getExtensions(QName qname) {
        FOMFactory factory = (FOMFactory)this.getFactory();
        return new FOMList(new FOMElementIteratorWrapper(factory, this._getChildrenWithName(qname)));
    }

    public <T extends Element> T getExtension(QName qname) {
        FOMFactory factory = (FOMFactory)this.getFactory();
        AbderaElement t = this._getFirstChildWithName(qname);
        return t != null ? (T)factory.getElementWrapper(t) : null;
    }

    public <T extends ExtensibleElement> T addExtension(Element extension) {
        if (extension instanceof ElementWrapper) {
            ElementWrapper wrapper = (ElementWrapper)extension;
            extension = wrapper.getInternal();
        }
        QName qname = extension.getQName();
        String prefix = qname.getPrefix();
        this.declareIfNecessary(qname.getNamespaceURI(), prefix);
        this._addChild((AbderaElement)extension);
        return (T)this;
    }

    public <T extends Element> T addExtension(QName qname) {
        String prefix = qname.getPrefix();
        this.declareIfNecessary(qname.getNamespaceURI(), prefix);
        return (T)this.getFactory().newExtensionElement(qname, (Base)this);
    }

    public <T extends Element> T addExtension(String namespace, String localpart, String prefix) {
        this.declareIfNecessary(namespace, prefix);
        return prefix != null ? this.addExtension(new QName(namespace, localpart, prefix)) : this.addExtension(new QName(namespace, localpart, ""));
    }

    public Element addSimpleExtension(QName qname, String value) {
        Element el = this.getFactory().newElement(qname, (Base)this);
        el.setText(value);
        String prefix = qname.getPrefix();
        this.declareIfNecessary(qname.getNamespaceURI(), prefix);
        return el;
    }

    public Element addSimpleExtension(String namespace, String localPart, String prefix, String value) {
        this.declareIfNecessary(namespace, prefix);
        return this.addSimpleExtension(prefix != null ? new QName(namespace, localPart, prefix) : new QName(namespace, localPart), value);
    }

    public String getSimpleExtension(QName qname) {
        Object el = this.getExtension(qname);
        return el != null ? el.getText() : null;
    }

    public String getSimpleExtension(String namespace, String localPart, String prefix) {
        return this.getSimpleExtension(new QName(namespace, localPart, prefix));
    }

    public void addExtensions(List<Element> extensions) {
        for (Element e : extensions) {
            this.addExtension(e);
        }
    }

    public <T extends Element> T getExtension(Class<T> _class) {
        Element t = null;
        List<Element> extensions = this.getExtensions();
        for (Element ext : extensions) {
            if (!_class.isAssignableFrom(ext.getClass())) continue;
            t = ext;
            break;
        }
        return (T)t;
    }

    private Element getInternal(Element element) {
        if (element instanceof ElementWrapper) {
            ElementWrapper wrapper = (ElementWrapper)element;
            element = wrapper.getInternal();
        }
        return element;
    }

    public <T extends ExtensibleElement> T addExtension(Element extension, Element before) {
        extension = this.getInternal(extension);
        if ((before = this.getInternal(before)) instanceof ElementWrapper) {
            ElementWrapper wrapper = (ElementWrapper)before;
            before = wrapper.getInternal();
        }
        if (before == null) {
            this.addExtension(extension);
        } else {
            ((OMElement)before).insertSiblingBefore((OMNode)((OMElement)extension));
        }
        return (T)this;
    }

    public <T extends Element> T addExtension(QName qname, QName before) {
        OMElement el = (OMElement)this._getFirstChildWithName(before);
        Element element = this.getFactory().newElement(qname);
        if (el == null) {
            this.addExtension(element);
        } else {
            el.insertSiblingBefore((OMNode)((OMElement)this.getInternal(element)));
        }
        return (T)element;
    }
}

