/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.c14n.omwrapper;

import javax.xml.namespace.QName;
import org.apache.axiom.c14n.omwrapper.NodeImpl;
import org.apache.axiom.c14n.omwrapper.factory.WrapperFactory;
import org.apache.axiom.c14n.omwrapper.interfaces.Attr;
import org.apache.axiom.c14n.omwrapper.interfaces.Element;
import org.apache.axiom.c14n.omwrapper.interfaces.Node;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;

public class AttrImpl
extends NodeImpl
implements Attr {
    public static final String XMLNS = "xmlns";
    public static final String XMLNS_URI = "http://www.w3.org/2000/xmlns/";
    private boolean isOMAttribute = false;
    private OMElement parent = null;
    private OMNamespace omns = null;
    private OMAttribute omattr = null;

    public AttrImpl(Object o, OMElement parent, WrapperFactory fac) {
        this.parent = parent;
        this.fac = fac;
        if (o instanceof OMAttribute) {
            this.isOMAttribute = true;
            this.omattr = (OMAttribute)o;
        } else {
            this.isOMAttribute = false;
            this.omns = (OMNamespace)o;
        }
    }

    public String getName() {
        return this.getNodeName();
    }

    public String getValue() {
        return this.getNodeValue();
    }

    public Element getOwnerElement() {
        return (Element)this.fac.getNode(this.parent);
    }

    public short getNodeType() {
        return 2;
    }

    public String getLocalName() {
        return this.isOMAttribute ? this.omattr.getLocalName() : this.getOMNamespaceLocalName();
    }

    public String getNamespaceURI() {
        return this.isOMAttribute ? this.getOMAttributeNsURI() : XMLNS_URI;
    }

    public String getNodeName() {
        return this.isOMAttribute ? this.getOMAttributeName() : this.getOMNamespaceName();
    }

    public String getNodeValue() {
        return this.isOMAttribute ? this.omattr.getAttributeValue() : this.omns.getNamespaceURI();
    }

    public String getPrefix() {
        return this.isOMAttribute ? this.getOMAttributePrefix() : this.getOMNamespacePrefix();
    }

    private String getOMAttributeName() {
        QName qn = this.omattr.getQName();
        if (qn.getPrefix() == null || "".equals(qn.getPrefix())) {
            return qn.getLocalPart();
        }
        return qn.getPrefix() + ":" + qn.getLocalPart();
    }

    private String getOMNamespaceName() {
        String prefix = this.omns.getPrefix();
        if (prefix == null || "".equals(prefix)) {
            return XMLNS;
        }
        return "xmlns:" + prefix;
    }

    private String getOMNamespaceLocalName() {
        String prefix = this.omns.getPrefix();
        if (prefix == null || "".equals(prefix)) {
            return XMLNS;
        }
        return prefix;
    }

    private String getOMAttributeNsURI() {
        String nsURI = this.omattr.getQName().getNamespaceURI();
        if (nsURI == null || "".equals(nsURI)) {
            return null;
        }
        return nsURI;
    }

    private String getOMAttributePrefix() {
        String prefix = this.omattr.getQName().getPrefix();
        if (prefix == null || "".equals(prefix)) {
            return null;
        }
        return prefix;
    }

    private String getOMNamespacePrefix() {
        String prefix = this.omns.getPrefix();
        if (prefix == null || "".equals(prefix)) {
            return null;
        }
        return XMLNS;
    }

    public Node getNextSibling() {
        return null;
    }

    public Node getPreviousSibling() {
        return null;
    }

    public Node getParentNode() {
        return null;
    }
}

