/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.blob;

import java.io.File;
import org.apache.axiom.blob.MemoryBlob;
import org.apache.axiom.blob.MemoryBlobImpl;
import org.apache.axiom.blob.OverflowableBlob;
import org.apache.axiom.blob.OverflowableBlobImpl;
import org.apache.axiom.blob.TempFileBlobFactory;
import org.apache.axiom.blob.WritableBlobFactory;

public final class Blobs {
    private Blobs() {
    }

    public static MemoryBlob createMemoryBlob() {
        return new MemoryBlobImpl();
    }

    public static OverflowableBlob createOverflowableBlob(int threshold, WritableBlobFactory overflowBlobFactory) {
        int numberOfChunks = Math.max(16, Math.min(1, threshold / 4096));
        int chunkSize = threshold / numberOfChunks;
        return new OverflowableBlobImpl(numberOfChunks, chunkSize, overflowBlobFactory);
    }

    public static OverflowableBlob createOverflowableBlob(int threshold, String tempPrefix, String tempSuffix, File tempDirectory) {
        return Blobs.createOverflowableBlob(threshold, new TempFileBlobFactory(tempPrefix, tempSuffix, tempDirectory));
    }
}

