/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.common.serializer.pull;

import java.io.IOException;
import java.io.Writer;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.ext.stax.CharacterDataReader;
import org.apache.axiom.ext.stax.DTDReader;
import org.apache.axiom.ext.stax.datahandler.DataHandlerReader;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.impl.common.serializer.pull.NullDTDReader;
import org.apache.axiom.om.impl.common.serializer.pull.NullDataHandlerReader;
import org.apache.axiom.om.impl.common.serializer.pull.PullSerializer;
import org.apache.axiom.om.impl.common.serializer.pull.PullSerializerState;
import org.apache.axiom.util.stax.XMLStreamReaderUtils;

abstract class AbstractWrapper
extends PullSerializerState
implements CharacterDataReader {
    protected final XMLStreamReader reader;
    private final PullSerializer serializer;
    private int depth;
    private DTDReader dtdReader;
    private DataHandlerReader dataHandlerReader;
    private CharacterDataReader characterDataReader;

    AbstractWrapper(PullSerializer serializer, XMLStreamReader reader, int startDepth) {
        this.reader = reader;
        this.serializer = serializer;
        this.depth = startDepth;
        if (reader.getEventType() == 2) {
            --this.depth;
        }
    }

    final DTDReader getDTDReader() {
        if (this.dtdReader == null) {
            try {
                this.dtdReader = (DTDReader)this.reader.getProperty(DTDReader.PROPERTY);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            if (this.dtdReader == null) {
                this.dtdReader = NullDTDReader.INSTANCE;
            }
        }
        return this.dtdReader;
    }

    final DataHandlerReader getDataHandlerReader() {
        if (this.dataHandlerReader == null) {
            this.dataHandlerReader = XMLStreamReaderUtils.getDataHandlerReader(this.reader);
            if (this.dataHandlerReader == null) {
                this.dataHandlerReader = NullDataHandlerReader.INSTANCE;
            }
        }
        return this.dataHandlerReader;
    }

    final CharacterDataReader getCharacterDataReader() {
        if (this.characterDataReader == null) {
            try {
                this.characterDataReader = (CharacterDataReader)this.reader.getProperty(CharacterDataReader.PROPERTY);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            if (this.characterDataReader == null) {
                this.characterDataReader = this;
            }
        }
        return this.characterDataReader;
    }

    public final void writeTextTo(Writer writer) throws XMLStreamException, IOException {
        writer.write(this.reader.getText());
    }

    final int getEventType() {
        return this.reader.getEventType();
    }

    final boolean hasNext() throws XMLStreamException {
        return this.reader.hasNext();
    }

    final void next() throws XMLStreamException {
        if (!this.doNext()) {
            this.serializer.popState();
        }
    }

    final boolean doNext() throws XMLStreamException {
        if (this.reader.getEventType() == 1) {
            ++this.depth;
        }
        if (this.depth == 0) {
            return false;
        }
        if (this.reader.next() == 2) {
            --this.depth;
        }
        return true;
    }

    final int nextTag() throws XMLStreamException {
        int result = this.reader.nextTag();
        switch (result) {
            case 1: {
                ++this.depth;
                break;
            }
            case 2: {
                --this.depth;
            }
        }
        return result;
    }

    final Object getProperty(String name) throws IllegalArgumentException {
        return this.reader.getProperty(name);
    }

    final String getVersion() {
        return this.reader.getVersion();
    }

    final String getCharacterEncodingScheme() {
        return this.reader.getCharacterEncodingScheme();
    }

    final String getEncoding() {
        return this.reader.getEncoding();
    }

    final boolean isStandalone() {
        return this.reader.isStandalone();
    }

    final boolean standaloneSet() {
        return this.reader.standaloneSet();
    }

    final String getPrefix() {
        return this.reader.getPrefix();
    }

    final String getNamespaceURI() {
        return this.reader.getNamespaceURI();
    }

    final String getLocalName() {
        return this.reader.getLocalName();
    }

    final QName getName() {
        return this.reader.getName();
    }

    final int getNamespaceCount() {
        return this.reader.getNamespaceCount();
    }

    final String getNamespacePrefix(int index) {
        return this.reader.getNamespacePrefix(index);
    }

    final String getNamespaceURI(int index) {
        return this.reader.getNamespaceURI(index);
    }

    final int getAttributeCount() {
        return this.reader.getAttributeCount();
    }

    final String getAttributePrefix(int index) {
        return this.reader.getAttributePrefix(index);
    }

    final String getAttributeNamespace(int index) {
        return this.reader.getAttributeNamespace(index);
    }

    final String getAttributeLocalName(int index) {
        return this.reader.getAttributeLocalName(index);
    }

    final QName getAttributeName(int index) {
        return this.reader.getAttributeName(index);
    }

    final boolean isAttributeSpecified(int index) {
        return this.reader.isAttributeSpecified(index);
    }

    final String getAttributeType(int index) {
        return this.reader.getAttributeType(index);
    }

    final String getAttributeValue(int index) {
        return this.reader.getAttributeValue(index);
    }

    final String getAttributeValue(String namespaceURI, String localName) {
        return this.reader.getAttributeValue(namespaceURI, localName);
    }

    final NamespaceContext getNamespaceContext() {
        return this.reader.getNamespaceContext();
    }

    final String getNamespaceURI(String prefix) {
        return this.reader.getNamespaceURI(prefix);
    }

    final String getElementText() throws XMLStreamException {
        return this.reader.getElementText();
    }

    final String getText() {
        return this.reader.getText();
    }

    final char[] getTextCharacters() {
        return this.reader.getTextCharacters();
    }

    final int getTextStart() {
        return this.reader.getTextStart();
    }

    final int getTextLength() {
        return this.reader.getTextLength();
    }

    final int getTextCharacters(int sourceStart, char[] target, int targetStart, int length) throws XMLStreamException {
        return this.reader.getTextCharacters(sourceStart, target, targetStart, length);
    }

    final Boolean isWhiteSpace() {
        return this.reader.isWhiteSpace();
    }

    final String getPIData() {
        return this.reader.getPIData();
    }

    final String getPITarget() {
        return this.reader.getPITarget();
    }

    final OMDataSource getDataSource() {
        return null;
    }

    final void restored() {
    }

    public String toString() {
        return String.valueOf(super.toString()) + "[reader=" + this.reader + "]";
    }
}

