/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.common.builder;

import java.util.ArrayList;
import org.apache.axiom.core.CoreModelException;
import org.apache.axiom.core.CoreNode;
import org.apache.axiom.core.impl.builder.BuilderListener;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.ds.custombuilder.CustomBuilder;
import org.apache.axiom.om.impl.common.AxiomExceptionTranslator;
import org.apache.axiom.om.impl.common.AxiomSemantics;
import org.apache.axiom.om.impl.common.OMNamespaceImpl;
import org.apache.axiom.om.impl.common.builder.CustomBuilderRegistration;
import org.apache.axiom.om.impl.intf.AxiomElement;
import org.apache.axiom.om.impl.intf.AxiomSourcedElement;
import org.apache.axiom.om.impl.mixin.AxiomChildNodeSupport;
import org.apache.axiom.om.impl.mixin.AxiomNamedInformationItemSupport;
import org.apache.axiom.om.impl.mixin.AxiomSourcedElementSupport;
import org.apache.axiom.soap.impl.intf.AxiomSOAPElement;
import org.apache.axiom.soap.impl.intf.AxiomSOAPHeaderBlock;
import org.apache.axiom.soap.impl.intf.soap11.AxiomSOAP11HeaderBlock;
import org.apache.axiom.soap.impl.intf.soap12.AxiomSOAP12HeaderBlock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

final class CustomBuilderManager
implements BuilderListener {
    private static final Log log = LogFactory.getLog(CustomBuilderManager.class);
    private ArrayList<CustomBuilderRegistration> registrations;
    private AxiomElement lastCandidateElement;
    private int lastCandidateDepth = -1;

    CustomBuilderManager() {
    }

    void register(CustomBuilder.Selector selector, CustomBuilder customBuilder) {
        Runnable action;
        if (this.registrations == null) {
            this.registrations = new ArrayList();
        }
        this.registrations.add(new CustomBuilderRegistration(selector, customBuilder));
        if (this.lastCandidateElement != null && (action = this.getAction(this.lastCandidateElement, this.lastCandidateDepth, this.registrations.size() - 1)) != null) {
            action.run();
        }
    }

    @Override
    public Runnable nodeAdded(CoreNode node, int depth) {
        return this.getAction(node, depth, 0);
    }

    private Runnable getAction(CoreNode node, int depth, int firstCustomBuilder) {
        this.lastCandidateElement = null;
        this.lastCandidateDepth = -1;
        if (node instanceof AxiomElement && (node instanceof AxiomSOAPHeaderBlock || !(node instanceof AxiomSOAPElement))) {
            final AxiomElement element = (AxiomElement)node;
            if (this.registrations != null) {
                int i = firstCustomBuilder;
                while (i < this.registrations.size()) {
                    CustomBuilderRegistration registration = this.registrations.get(i);
                    final String namespaceURI = AxiomNamedInformationItemSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_mixin_AxiomNamedInformationItemSupport$org_apache_axiom_om_impl_intf_AxiomNamedInformationItem$coreGetNamespaceURI(element);
                    final String localName = AxiomNamedInformationItemSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_mixin_AxiomNamedInformationItemSupport$org_apache_axiom_om_impl_intf_AxiomNamedInformationItem$coreGetLocalName(element);
                    if (registration.getSelector().accepts(AxiomChildNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_mixin_AxiomChildNodeSupport$org_apache_axiom_om_impl_intf_AxiomChildNode$getParent(element), depth, namespaceURI, localName)) {
                        final CustomBuilder customBuilder = registration.getCustomBuilder();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Custom builder " + customBuilder + " accepted element {" + namespaceURI + "}" + localName + " at depth " + depth));
                        }
                        return new Runnable(){

                            @Override
                            public void run() {
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("Invoking custom builder " + customBuilder));
                                }
                                OMDataSource dataSource = customBuilder.create((OMElement)element);
                                Class type = element instanceof AxiomSOAP11HeaderBlock ? AxiomSOAP11HeaderBlock.class : (element instanceof AxiomSOAP12HeaderBlock ? AxiomSOAP12HeaderBlock.class : AxiomSourcedElement.class);
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("Replacing element with new sourced element of type " + type));
                                }
                                AxiomSourcedElement newElement = (AxiomSourcedElement)element.coreCreateNode(type);
                                AxiomSourcedElementSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_mixin_AxiomSourcedElementSupport$org_apache_axiom_om_impl_intf_AxiomSourcedElement$init(newElement, localName, new OMNamespaceImpl(namespaceURI, null), dataSource);
                                try {
                                    element.coreReplaceWith(newElement, AxiomSemantics.INSTANCE);
                                }
                                catch (CoreModelException ex) {
                                    throw AxiomExceptionTranslator.translate(ex);
                                }
                            }
                        };
                    }
                    ++i;
                }
            }
            this.lastCandidateElement = element;
            this.lastCandidateDepth = depth;
        }
        return null;
    }
}

