
/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001-2004 World Wide Web Consortium, 
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All 
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the 
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level3.core;

import org.w3c.dom.*;


import org.w3c.domts.DOMTestCase;
import org.w3c.domts.DOMTestDocumentBuilderFactory;



/**
 *      Create a new namespace attribute on the second strong element.  Invoke setIdAttributeNode on a newly created 
 *      attribute node.  Verify by calling isID on the attribute node and getElementById on document node. 
 *      Call setIdAttributeNode again with isId=false to reset.  Invoke isId on the attribute node should return false.
 *     
* @author IBM
* @author Jenny Hsu
* @see <a href="http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#ID-ElSetIdAttrNode">http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#ID-ElSetIdAttrNode</a>
*/
public final class elementsetidattributenode04 extends DOMTestCase {

   /**
    * Constructor.
    * @param factory document factory, may not be null
    * @throws org.w3c.domts.DOMTestIncompatibleException Thrown if test is not compatible with parser configuration
    */
   public elementsetidattributenode04(final DOMTestDocumentBuilderFactory factory)  throws org.w3c.domts.DOMTestIncompatibleException {
      super(factory);

    //
    //   check if loaded documents are supported for content type
    //
    String contentType = getContentType();
    preload(contentType, "hc_staff", true);
    }

   /**
    * Runs the test case.
    * @throws Throwable Any uncaught exception causes test to fail
    */
   public void runTest() throws Throwable {
      Document doc;
      NodeList elemList;
      Element nameElem;
      NamedNodeMap attributesMap;
      Attr attr;
      Attr newAttr;
      boolean id = false;
      Element elem;
      String elemName;
      doc = (Document) load("hc_staff", true);
      elemList = doc.getElementsByTagName("strong");
      nameElem = (Element) elemList.item(1);
      nameElem.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:middle", "http://www.example.com/middle");
      attributesMap = nameElem.getAttributes();
      attr = (Attr) attributesMap.getNamedItem("xmlns:middle");
      nameElem.setIdAttributeNode(attr, true);
      id = attr.isId();
      assertTrue("elementsetidattributenodeIsIdTrue04", id);
      elem = doc.getElementById("http://www.example.com/middle");
      elemName = elem.getTagName();
      assertEquals("elementsetidattributenodeGetElementById04", "strong", elemName);
      elem.setIdAttributeNode(attr, false);
      id = attr.isId();
      assertFalse("elementsetidattributenodeIsIdFalse04", id);
}
   /**
    *  Gets URI that identifies the test.
    *  @return uri identifier of test
    */
   public String getTargetURI() {
      return "http://www.w3.org/2001/DOM-Test-Suite/level3/core/elementsetidattributenode04";
   }
   /**
    * Runs this test from the command line.
    * @param args command line arguments
    */
   public static void main(final String[] args) {
        DOMTestCase.doMain(elementsetidattributenode04.class, args);
   }
}

