/*
 * Decompiled with CFR 0.152.
 */
package jaxp;

import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;

public class DatatypeAPIUsage {
    public static void main(String[] stringArray) {
        try {
            DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();
            Duration duration = datatypeFactory.newDuration(9054133519L);
            Duration duration2 = datatypeFactory.newDuration(true, 29, 2, 15, 13, 45, 0);
            int n = duration.compare(duration2);
            switch (n) {
                case -1: {
                    System.out.println("There are fewer milliseconds in my phone number than my lifespan.");
                    break;
                }
                case 0: {
                    System.out.println("The same number of milliseconds are in my phone number and my lifespan.");
                    break;
                }
                case 1: {
                    System.out.println("There are more milliseconds in my phone number than my lifespan.");
                    break;
                }
                case 2: {
                    System.out.println("The comparison could not be carried out.");
                }
            }
            Duration duration3 = datatypeFactory.newDurationYearMonth("P12Y10M");
            System.out.println("P12Y10M is of type: " + duration3.getXMLSchemaType());
            Duration duration4 = datatypeFactory.newDurationDayTime("P10DT10H12M0S");
            System.out.println("P10DT10H12M0S is of type: " + duration4.getXMLSchemaType());
            try {
                duration3 = datatypeFactory.newDurationYearMonth("P12Y10M1D");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                System.out.println("'duration': P12Y10M1D is not 'yearMonthDuration'!!!");
            }
            XMLGregorianCalendar xMLGregorianCalendar = datatypeFactory.newXMLGregorianCalendar();
            xMLGregorianCalendar.setYear(1975);
            xMLGregorianCalendar.setMonth(8);
            xMLGregorianCalendar.setDay(11);
            xMLGregorianCalendar.setHour(6);
            xMLGregorianCalendar.setMinute(44);
            xMLGregorianCalendar.setSecond(0);
            xMLGregorianCalendar.setMillisecond(0);
            xMLGregorianCalendar.setTimezone(5);
            xMLGregorianCalendar.add(duration);
            System.out.println("The approximate end of the number of milliseconds in my phone number was " + xMLGregorianCalendar);
            xMLGregorianCalendar.add(duration2);
            System.out.println("Adding the duration myLife to the above calendar:" + xMLGregorianCalendar);
            XMLGregorianCalendar xMLGregorianCalendar2 = datatypeFactory.newXMLGregorianCalendar(xMLGregorianCalendar.toXMLFormat());
            if (xMLGregorianCalendar2.compare(xMLGregorianCalendar) != 0) {
                System.out.println("oooops!");
            } else {
                System.out.println("Very good: " + xMLGregorianCalendar + " is equal to " + xMLGregorianCalendar2);
            }
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            System.err.println("error: Datatype error occurred - " + datatypeConfigurationException.getMessage());
            datatypeConfigurationException.printStackTrace(System.err);
        }
    }
}

