/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.test.xml;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.apache.batik.test.xml.Messages;
import org.apache.batik.test.xml.XMLReflectConstants;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLReflect
implements XMLReflectConstants {
    public static final String NO_MATCHING_CONSTRUCTOR = "xml.XMLReflect.error.no.matching.constructor";

    public static Object buildObject(Element element) throws Exception {
        Constructor constructor;
        Element classDefiningElement = XMLReflect.getClassDefiningElement(element);
        String className = classDefiningElement.getAttribute("class");
        Class<?> cl = Class.forName(className);
        Object[] argsArray = null;
        Class[] argsClasses = null;
        NodeList children = element.getChildNodes();
        if (children != null && children.getLength() > 0) {
            int i;
            int n = children.getLength();
            ArrayList<Object> args = new ArrayList<Object>();
            for (i = 0; i < n; ++i) {
                Element childElement;
                String string;
                Node child = children.item(i);
                if (child.getNodeType() != 1 || (string = (childElement = (Element)child).getTagName().intern()) != "arg") continue;
                Object arg = XMLReflect.buildArgument(childElement);
                args.add(arg);
            }
            if (args.size() > 0) {
                argsArray = new Object[args.size()];
                args.toArray(argsArray);
                argsClasses = new Class[args.size()];
                for (i = 0; i < args.size(); ++i) {
                    argsClasses[i] = argsArray[i].getClass();
                }
            }
        }
        if ((constructor = XMLReflect.getDeclaredConstructor(cl, argsClasses)) == null) {
            String argsClassesStr = "null";
            if (argsClasses != null) {
                argsClassesStr = "";
                for (void var12_18 : argsClasses) {
                    argsClassesStr = argsClassesStr + var12_18.getName() + " / ";
                }
            }
            throw new Exception(Messages.formatMessage(NO_MATCHING_CONSTRUCTOR, new Object[]{className, argsClassesStr}));
        }
        return XMLReflect.configureObject(constructor.newInstance(argsArray), element, classDefiningElement);
    }

    public static Object configureObject(Object obj, Element element, Element classDefiningElement) throws Exception {
        ArrayList<Element> v = new ArrayList<Element>();
        v.add(element);
        while (element != classDefiningElement) {
            element = (Element)element.getParentNode();
            v.add(element);
        }
        int ne = v.size();
        for (int j = ne - 1; j >= 0; --j) {
            element = (Element)v.get(j);
            NodeList children = element.getChildNodes();
            if (children == null || children.getLength() <= 0) continue;
            int n = children.getLength();
            for (int i = 0; i < n; ++i) {
                Element childElement;
                String tagName;
                Node child = children.item(i);
                if (child.getNodeType() != 1 || (tagName = (childElement = (Element)child).getTagName().intern()) != "property") continue;
                Object arg = XMLReflect.buildArgument(childElement);
                String propertyName = childElement.getAttribute("name");
                XMLReflect.setObjectProperty(obj, propertyName, arg);
            }
        }
        return obj;
    }

    public static void setObjectProperty(Object obj, String propertyName, Object propertyValue) throws Exception {
        Class<?> cl = obj.getClass();
        Method m = null;
        try {
            m = cl.getMethod("set" + propertyName, propertyValue.getClass());
        }
        catch (NoSuchMethodException e) {
            Class<?> propertyClass = propertyValue.getClass();
            if (propertyClass == Double.class) {
                m = cl.getMethod("set" + propertyName, Double.TYPE);
            }
            if (propertyClass == Float.class) {
                m = cl.getMethod("set" + propertyName, Float.TYPE);
            }
            if (propertyClass == Integer.class) {
                m = cl.getMethod("set" + propertyName, Integer.TYPE);
            }
            if (propertyClass == Boolean.class) {
                m = cl.getMethod("set" + propertyName, Boolean.TYPE);
            }
            System.err.println("Could not find a set method for property : " + propertyName + " with value " + propertyValue + " and class " + propertyValue.getClass().getName());
            throw e;
        }
        if (m != null) {
            m.invoke(obj, propertyValue);
        }
    }

    public static Constructor getDeclaredConstructor(Class cl, Class[] argClasses) {
        Constructor<?>[] cs;
        for (Constructor<?> c : cs = cl.getDeclaredConstructors()) {
            Class<?>[] reqArgClasses = c.getParameterTypes();
            if (reqArgClasses != null && reqArgClasses.length > 0) {
                int j;
                if (reqArgClasses.length != argClasses.length) continue;
                for (j = 0; j < argClasses.length && reqArgClasses[j].isAssignableFrom(argClasses[j]); ++j) {
                }
                if (j != argClasses.length) continue;
                return c;
            }
            if (argClasses != null && argClasses.length != 0) continue;
            return c;
        }
        return null;
    }

    public static Object buildArgument(Element element) throws Exception {
        if (!element.hasChildNodes()) {
            Element classDefiningElement = XMLReflect.getClassDefiningElement(element);
            String classAttr = classDefiningElement.getAttribute("class");
            Class<?> cl = Class.forName(classAttr);
            if (element.hasAttribute("value")) {
                String value = element.getAttribute("value");
                Constructor<?> constructor = cl.getDeclaredConstructor(String.class);
                return constructor.newInstance(value);
            }
            return cl.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        return XMLReflect.buildObject(element);
    }

    public static Element getClassDefiningElement(Element element) {
        if (element != null) {
            String classAttr = element.getAttribute("class");
            if (classAttr == null || "".equals(classAttr)) {
                Node parent = element.getParentNode();
                if (parent != null && parent.getNodeType() == 1) {
                    return XMLReflect.getClassDefiningElement((Element)parent);
                }
                return null;
            }
            return element;
        }
        return null;
    }
}

