/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.technology;

import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.Dimension2D;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.NodeProtoId;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.prototype.PortProtoId;
import com.sun.electric.database.text.ArrayIterator;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.user.User;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class PrimitiveNode
implements NodeProtoId,
NodeProto,
Comparable<PrimitiveNode> {
    public static final int NORMAL = 0;
    public static final int SERPTRANS = 1;
    public static final int POLYGONAL = 2;
    private static final int NODESHRINK = 1;
    private static final int ARCSWIPE = 512;
    private static final int NSQUARE = 1024;
    private static final int HOLDSTRACE = 2048;
    private static final int CANBEZEROSIZE = 4096;
    private static final int WIPEON1OR2 = 8192;
    private static final int LOCKEDPRIM = 16384;
    private static final int NEDGESELECT = 32768;
    private static final int ARCSHRINK = 65536;
    private static final int NINVISIBLE = 131072;
    private static final int SKIPSIZEINPALETTE = 262144;
    private static final int NNOTUSED = 524288;
    public static final int LOWVTBIT = 8;
    public static final int HIGHVTBIT = 16;
    public static final int NATIVEBIT = 32;
    public static final int OD18BIT = 64;
    public static final int OD25BIT = 128;
    public static final int OD33BIT = 256;
    private String protoName;
    private String fullName;
    private Technology tech;
    private Function function;
    private Technology.NodeLayer[] layers;
    private Technology.NodeLayer[] electricalLayers;
    private PrimitivePort[] primPorts;
    private int userBits;
    private int globalPrimNodeIndex;
    private int techPrimNodeIndex = -1;
    private int specialType;
    private double[] specialValues;
    private int numMultiCuts;
    private NodeSizeRule minNodeSize;
    EPoint sizeCorrector;
    private SizeOffset offset;
    private Dimension2D autoGrowth;
    private static int primNodeNumber = 0;
    private static HashMap<PrimitiveNode, Pref> defaultExtendXPrefs = new HashMap();
    private static HashMap<PrimitiveNode, Pref> defaultExtendYPrefs = new HashMap();
    private static final String[] nodeBits = new String[]{"NODESHRINK", null, null, "LOWVTBIT", "HIGHVTBIT", "NATIVEBIT", "OD18BIT", "OD25BIT", "OD33BIT", "ARCSWIPE", "NSQUARE", "HOLDSTRACE", "CANBEZEROSIZE", "WIPEON1OR2", "LOCKEDPRIM", "NEDGESELECT", "ARCSHRINK", "NINVISIBLE", "SKIPSIZEINPALETTE", "NNOTUSED", null};

    protected PrimitiveNode(String protoName, Technology tech, EPoint sizeCorrector, double defWidth, double defHeight, SizeOffset offset, Technology.NodeLayer[] layers) {
        if (!Technology.jelibSafeName(protoName)) {
            System.out.println("PrimitiveNode name " + protoName + " is not safe to write in the JELIB");
        }
        this.protoName = protoName;
        this.fullName = tech.getTechName() + ":" + protoName;
        this.function = Function.UNKNOWN;
        this.tech = tech;
        this.layers = layers;
        this.electricalLayers = null;
        this.userBits = 0;
        this.specialType = 0;
        this.sizeCorrector = sizeCorrector;
        this.setFactoryDefSize(defWidth, defHeight);
        if (offset == null) {
            offset = new SizeOffset(0.0, 0.0, 0.0, 0.0);
        }
        this.offset = offset;
        this.autoGrowth = null;
        this.minNodeSize = null;
        this.globalPrimNodeIndex = primNodeNumber++;
        int numMultiCuts = 0;
        for (Technology.NodeLayer nodeLayer : layers) {
            if (nodeLayer.getRepresentation() != 3) continue;
            ++numMultiCuts;
        }
        this.numMultiCuts = numMultiCuts;
        tech.addNodeProto(this);
    }

    public static PrimitiveNode newInstance(String protoName, Technology tech, double width, double height, SizeOffset offset, Technology.NodeLayer[] layers) {
        return PrimitiveNode.newInstance(protoName, tech, EPoint.fromLambda(-0.5 * width, -0.5 * height), width, height, offset, layers);
    }

    public static PrimitiveNode newInstance0(String protoName, Technology tech, double width, double height, SizeOffset offset, Technology.NodeLayer[] layers) {
        return PrimitiveNode.newInstance(protoName, tech, EPoint.ORIGIN, width, height, offset, layers);
    }

    static PrimitiveNode newInstance(String protoName, Technology tech, EPoint sizeCorrector, double width, double height, SizeOffset offset, Technology.NodeLayer[] layers) {
        if (tech.findNodeProto(protoName) != null) {
            System.out.println("Error: technology " + tech.getTechName() + " has multiple nodes named " + protoName);
            return null;
        }
        if (width < 0.0 || height < 0.0) {
            System.out.println("Error: technology " + tech.getTechName() + " node " + protoName + " has negative size");
            return null;
        }
        PrimitiveNode pn = new PrimitiveNode(protoName, tech, sizeCorrector, width, height, offset, layers);
        return pn;
    }

    @Override
    public PrimitivePort getPortId(int chronIndex) {
        return this.primPorts[chronIndex];
    }

    @Override
    public PrimitiveNode inDatabase(EDatabase database) {
        return this;
    }

    @Override
    public PrimitiveNode getId() {
        return this;
    }

    @Override
    public String getName() {
        return this.protoName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFunction(Function function) {
        this.checkChanging();
        this.function = function;
    }

    @Override
    public Function getFunction() {
        return this.function;
    }

    public Function getGroupFunction() {
        if (this.function == Function.TRANMOS || this.function == Function.TRA4NMOS || this.function == Function.TRAPMOS || this.function == Function.TRA4PMOS || this.function == Function.TRADMOS || this.function == Function.TRA4DMOS || this.function == Function.TRANPN || this.function == Function.TRA4NPN || this.function == Function.TRAPNP || this.function == Function.TRA4PNP || this.function == Function.TRANJFET || this.function == Function.TRA4NJFET || this.function == Function.TRAPJFET || this.function == Function.TRA4PJFET || this.function == Function.TRADMES || this.function == Function.TRA4DMES || this.function == Function.TRAEMES || this.function == Function.TRA4EMES || this.function == Function.TRANS4) {
            return Function.TRANS;
        }
        if (this.function.isResistor() || this.function.isCapacitor() || this.function == Function.DIODE || this.function == Function.DIODEZ || this.function == Function.INDUCT) {
            return Function.INDUCT;
        }
        if (this.function == Function.CCVS || this.function == Function.CCCS || this.function == Function.VCVS || this.function == Function.VCCS || this.function == Function.TLINE) {
            return Function.TLINE;
        }
        if (this.function == Function.BASE || this.function == Function.EMIT || this.function == Function.COLLECT) {
            return Function.COLLECT;
        }
        if (this.function == Function.BUFFER || this.function == Function.GATEAND || this.function == Function.GATEOR || this.function == Function.MUX || this.function == Function.GATEXOR) {
            return Function.GATEXOR;
        }
        if (this.function == Function.CONPOWER || this.function == Function.CONGROUND) {
            return Function.CONGROUND;
        }
        if (this.function == Function.METER || this.function == Function.SOURCE) {
            return Function.SOURCE;
        }
        if (this.function == Function.SUBSTRATE || this.function == Function.WELL) {
            return Function.WELL;
        }
        return this.function;
    }

    public Technology.NodeLayer[] getLayers() {
        return this.layers;
    }

    public void setLayers(Technology.NodeLayer[] layers) {
        this.layers = layers;
    }

    public Iterator<Layer> getLayerIterator() {
        return new NodeLayerIterator(this.layers);
    }

    public Technology.NodeLayer[] getElectricalLayers() {
        return this.electricalLayers;
    }

    public void setElectricalLayers(Technology.NodeLayer[] electricalLayers) {
        this.electricalLayers = electricalLayers;
    }

    public Technology.NodeLayer findNodeLayer(Layer layer, boolean electrical) {
        Technology.NodeLayer[] nodes;
        Technology.NodeLayer[] nodeLayerArray = nodes = electrical ? this.electricalLayers : this.layers;
        if (nodes != null) {
            for (int j = 0; j < nodes.length; ++j) {
                Technology.NodeLayer oneLayer = nodes[j];
                if (oneLayer.getLayer() != layer) continue;
                return oneLayer;
            }
        }
        return null;
    }

    public boolean hasMultiCuts() {
        return this.numMultiCuts > 0;
    }

    public Technology.NodeLayer findMulticut() {
        for (Technology.NodeLayer nl : this.layers) {
            if (nl.getRepresentation() != 3) continue;
            return nl;
        }
        return null;
    }

    public boolean isMulticut() {
        return this.numMultiCuts == 1;
    }

    public int getDefPlacementAngle() {
        int defAngle = User.getNewNodeRotation();
        return defAngle;
    }

    private Pref getNodeProtoExtendXPref(double factoryExtendX) {
        Pref pref = defaultExtendXPrefs.get(this);
        if (pref == null) {
            pref = Pref.makeDoublePref("DefaultExtendXFor" + this.protoName + "IN" + this.tech.getTechName(), Technology.getTechnologyPreferences(), factoryExtendX);
            defaultExtendXPrefs.put(this, pref);
        }
        return pref;
    }

    private Pref getNodeProtoExtendYPref(double factoryExtendY) {
        Pref pref = defaultExtendYPrefs.get(this);
        if (pref == null) {
            pref = Pref.makeDoublePref("DefaultExtendYFor" + this.protoName + "IN" + this.tech.getTechName(), Technology.getTechnologyPreferences(), factoryExtendY);
            defaultExtendYPrefs.put(this, pref);
        }
        return pref;
    }

    protected void setFactoryDefSize(double defWidth, double defHeight) {
        this.getNodeProtoExtendXPref(DBMath.round(0.5 * defWidth + this.sizeCorrector.getLambdaX()));
        this.getNodeProtoExtendYPref(DBMath.round(0.5 * defHeight + this.sizeCorrector.getLambdaY()));
    }

    public void setDefSize(double defWidth, double defHeight) {
        this.getNodeProtoExtendXPref(0.0).setDouble(DBMath.round(0.5 * defWidth + this.sizeCorrector.getLambdaX()));
        this.getNodeProtoExtendYPref(0.0).setDouble(DBMath.round(0.5 * defHeight + this.sizeCorrector.getLambdaY()));
    }

    @Override
    public double getDefWidth() {
        return 2.0 * (this.getNodeProtoExtendXPref(0.0).getDouble() - this.sizeCorrector.getLambdaX());
    }

    @Override
    public double getDefHeight() {
        return 2.0 * (this.getNodeProtoExtendYPref(0.0).getDouble() - this.sizeCorrector.getLambdaY());
    }

    @Override
    public SizeOffset getProtoSizeOffset() {
        return this.offset;
    }

    public NodeSizeRule getMinSizeRule() {
        return this.minNodeSize;
    }

    public void setMinSize(double minWidth, double minHeight, String minSizeRule) {
        this.setSizeCorrector(minWidth, minHeight);
        this.minNodeSize = new NodeSizeRule(minWidth, minHeight, minSizeRule);
    }

    public void setSizeCorrector(double refWidth, double refHeight) {
        this.sizeCorrector = EPoint.fromLambda(-0.5 * refWidth, -0.5 * refHeight);
    }

    public void setSizeOffset(SizeOffset offset) {
        this.offset = offset;
    }

    public void setAutoGrowth(double dX, double dY) {
        this.autoGrowth = new Dimension2D.Double(dX, dY);
    }

    public Dimension2D getAutoGrowth() {
        return this.autoGrowth;
    }

    @Override
    public Technology getTechnology() {
        return this.tech;
    }

    public void addPrimitivePorts(PrimitivePort[] ports) {
        assert (this.primPorts == null) : this + " addPrimitivePorts twice";
        this.primPorts = (PrimitivePort[])ports.clone();
        for (int i = 0; i < this.primPorts.length; ++i) {
            this.primPorts[i].setPortIndex(this, i);
        }
    }

    @Override
    public PortProto findPortProto(String name) {
        if (name == null) {
            return null;
        }
        return this.findPortProto(Name.findName(name));
    }

    @Override
    public PortProto findPortProto(Name name) {
        if (name == null) {
            return null;
        }
        String nameString = name.canonicString();
        for (int i = 0; i < this.primPorts.length; ++i) {
            PrimitivePort pp = this.primPorts[i];
            if (pp.getNameKey().canonicString() != nameString) continue;
            return pp;
        }
        return null;
    }

    @Override
    public Iterator<PortProto> getPorts() {
        return ArrayIterator.iterator((PortProto[])this.primPorts);
    }

    public Iterator<PrimitivePort> getPrimitivePorts() {
        return ArrayIterator.iterator(this.primPorts);
    }

    @Override
    public int getNumPorts() {
        return this.primPorts.length;
    }

    @Override
    public final PrimitivePort getPort(int portIndex) {
        return this.primPorts[portIndex];
    }

    @Override
    public PrimitivePort getPort(PortProtoId portProtoId) {
        if (portProtoId.getParentId() != this) {
            throw new IllegalArgumentException();
        }
        PrimitivePort pp = (PrimitivePort)portProtoId;
        assert (this.primPorts[pp.getPortIndex()] == pp);
        return pp;
    }

    public PrimitivePort connectsTo(ArcProto arc) {
        for (int i = 0; i < this.primPorts.length; ++i) {
            PrimitivePort pp = this.primPorts[i];
            if (!pp.connectsTo(arc)) continue;
            return pp;
        }
        return null;
    }

    public int getSpecialType() {
        return this.specialType;
    }

    public void setSpecialType(int specialType) {
        this.specialType = specialType;
    }

    public static String getSpecialTypeName(int t) {
        if (t == 0) {
            return "normal";
        }
        if (t == 1) {
            return "serp-trans";
        }
        if (t == 2) {
            return "outline";
        }
        return "?";
    }

    public double[] getSpecialValues() {
        return this.specialValues;
    }

    public EPoint getMulticut2Size() {
        Technology.NodeLayer cutLayer = this.findMulticut();
        assert (cutLayer.getLeftEdge().getMultiplier() == -0.5);
        assert (cutLayer.getBottomEdge().getMultiplier() == -0.5);
        assert (cutLayer.getRightEdge().getMultiplier() == 0.5);
        assert (cutLayer.getTopEdge().getMultiplier() == 0.5);
        double x = cutLayer.getMulticutSizeX() + cutLayer.getMulticutSep2D() + cutLayer.getLeftEdge().getAdder() - cutLayer.getRightEdge().getAdder();
        double y = cutLayer.getMulticutSizeY() + cutLayer.getMulticutSep2D() + cutLayer.getBottomEdge().getAdder() - cutLayer.getTopEdge().getAdder();
        return EPoint.fromLambda(x, y);
    }

    public void setSpecialValues(double[] specialValues) {
        if (specialValues.length != 6) {
            throw new IndexOutOfBoundsException("Invalid number of values in setSpecialValues");
        }
        this.specialValues = specialValues;
    }

    public boolean isPin() {
        return this.getFunction() == Function.PIN;
    }

    @Override
    public String describe(boolean withQuotes) {
        String name = "";
        if (this.tech != Technology.getCurrent()) {
            name = name + this.tech.getTechName() + ":";
        }
        name = name + this.protoName;
        return withQuotes ? "'" + name + "'" : name;
    }

    public boolean isNodeBitOn(int bit) {
        assert (bit == 8 || bit == 16 || bit == 32 || bit == 64 || bit == 128 || bit == 256);
        return (this.userBits & bit) != 0;
    }

    public void setNodeBit(int bit) {
        this.checkChanging();
        this.userBits |= bit;
    }

    public void setSkipSizeInPalette() {
        this.checkChanging();
        this.userBits |= 0x40000;
    }

    public boolean isSkipSizeInPalette() {
        return (this.userBits & 0x40000) != 0;
    }

    public void setCanShrink() {
        this.checkChanging();
        this.userBits |= 1;
    }

    public void clearCanShrink() {
        this.checkChanging();
        this.userBits &= 0xFFFFFFFE;
    }

    public boolean canShrink() {
        return (this.userBits & 1) != 0;
    }

    public void setArcsWipe() {
        this.checkChanging();
        this.userBits |= 0x200;
    }

    public void clearArcsWipe() {
        this.checkChanging();
        this.userBits &= 0xFFFFFDFF;
    }

    public boolean isArcsWipe() {
        return (this.userBits & 0x200) != 0;
    }

    public void setSquare() {
        this.checkChanging();
        this.userBits |= 0x400;
    }

    public void clearSquare() {
        this.checkChanging();
        this.userBits &= 0xFFFFFBFF;
    }

    public boolean isSquare() {
        return (this.userBits & 0x400) != 0;
    }

    public void setHoldsOutline() {
        this.checkChanging();
        this.userBits |= 0x800;
    }

    public void clearHoldsOutline() {
        this.checkChanging();
        this.userBits &= 0xFFFFF7FF;
    }

    public boolean isHoldsOutline() {
        return (this.userBits & 0x800) != 0;
    }

    public void setCanBeZeroSize() {
        this.checkChanging();
        this.userBits |= 0x1000;
    }

    public void clearCanBeZeroSize() {
        this.checkChanging();
        this.userBits &= 0xFFFFEFFF;
    }

    public boolean isCanBeZeroSize() {
        return (this.userBits & 0x1000) != 0;
    }

    public void setWipeOn1or2() {
        this.checkChanging();
        this.userBits |= 0x2000;
    }

    public void clearWipeOn1or2() {
        this.checkChanging();
        this.userBits &= 0xFFFFDFFF;
    }

    public boolean isWipeOn1or2() {
        return (this.userBits & 0x2000) != 0;
    }

    public void setLockedPrim() {
        this.checkChanging();
        this.userBits |= 0x4000;
    }

    public void clearLockedPrim() {
        this.checkChanging();
        this.userBits &= 0xFFFFBFFF;
    }

    public boolean isLockedPrim() {
        return (this.userBits & 0x4000) != 0;
    }

    public void setEdgeSelect() {
        this.checkChanging();
        this.userBits |= 0x8000;
    }

    public void clearEdgeSelect() {
        this.checkChanging();
        this.userBits &= 0xFFFF7FFF;
    }

    public boolean isEdgeSelect() {
        return (this.userBits & 0x8000) != 0;
    }

    public void setArcsShrink() {
        this.checkChanging();
        this.userBits |= 0x10000;
    }

    public void clearArcsShrink() {
        this.checkChanging();
        this.userBits &= 0xFFFEFFFF;
    }

    public boolean isArcsShrink() {
        return (this.userBits & 0x10000) != 0;
    }

    public void setNodeInvisible(boolean invisible) {
        this.userBits = invisible ? (this.userBits |= 0x20000) : (this.userBits &= 0xFFFDFFFF);
    }

    public boolean isNodeInvisible() {
        return (this.userBits & 0x20000) != 0;
    }

    public void setNotUsed(boolean set) {
        this.checkChanging();
        this.userBits = set ? (this.userBits |= 0x80000) : (this.userBits &= 0xFFF7FFFF);
    }

    public boolean isNotUsed() {
        return (this.userBits & 0x80000) != 0;
    }

    public boolean isPureWellNode() {
        if (this.function != Function.NODE) {
            return false;
        }
        if (this.layers.length != 1) {
            return false;
        }
        Layer layer = this.layers[0].getLayer();
        return layer.getFunction().isWell();
    }

    public boolean isPureSubstrateNode() {
        if (this.function != Function.NODE) {
            return false;
        }
        if (this.layers.length != 1) {
            return false;
        }
        Layer layer = this.layers[0].getLayer();
        return layer.getFunction().isSubstrate();
    }

    public final int getPrimNodeIndexInTech() {
        return this.techPrimNodeIndex;
    }

    public void setPrimNodeIndexInTech(int index) {
        this.techPrimNodeIndex = index;
    }

    @Override
    public int compareTo(PrimitiveNode that) {
        int cmp;
        if (this.tech != that.tech && (cmp = this.tech.compareTo(that.tech)) != 0) {
            return cmp;
        }
        return this.globalPrimNodeIndex - that.globalPrimNodeIndex;
    }

    public String toString() {
        return "node " + this.describe(true);
    }

    void dump(PrintWriter out) {
        out.print("PrimitiveNode " + this.getName() + " " + (Object)((Object)this.getFunction()));
        Technology.printlnBits(out, nodeBits, this.userBits);
        out.print("\tspecialType=" + this.specialType + " numMultiCuts=" + this.numMultiCuts);
        if (this.specialValues != null) {
            for (double v : this.specialValues) {
                out.print(" " + v);
            }
        }
        out.println();
        if (this.offset != null) {
            out.println("\t" + this.offset);
        }
        out.println("\trefWidth=" + -this.sizeCorrector.getLambdaX() + " refHeight=" + -this.sizeCorrector.getLambdaY());
        if (this.minNodeSize != null) {
            out.println("\tminNodeSize w=" + this.minNodeSize.getWidth() + " h=" + this.minNodeSize.getHeight() + " rule=" + this.minNodeSize.getRuleName());
        }
        if (this.autoGrowth != null) {
            out.println("\tautoGrowth " + this.autoGrowth);
        }
        Technology.printlnPref(out, 1, defaultExtendXPrefs.get(this));
        Technology.printlnPref(out, 1, defaultExtendYPrefs.get(this));
        out.println("\tlayers:");
        boolean isSerp = this.specialType == 1;
        this.dumpNodeLayers(out, this.layers, isSerp);
        if (this.electricalLayers != null) {
            out.println("\telectricalLayers:");
            this.dumpNodeLayers(out, this.electricalLayers, isSerp);
        }
        for (PrimitivePort pp : this.primPorts) {
            pp.dump(out);
        }
    }

    private void dumpNodeLayers(PrintWriter out, Technology.NodeLayer[] layers, boolean isSerp) {
        for (Technology.NodeLayer nl : layers) {
            out.println("\tlayer=" + nl.getLayerOrPseudoLayer().getName() + " port=" + nl.getPortNum() + " style=" + nl.getStyle().name() + " repr=" + nl.getRepresentation());
            if (nl.getMessage() != null) {
                TextDescriptor td = nl.getDescriptor();
                out.println("\t\tmessage=\"" + nl.getMessage() + "\" td=" + Long.toHexString(td.lowLevelGet()) + " colorIndex=" + td.getColorIndex() + " disp=" + td.isDisplay());
            }
            if (nl.getMulticutSizeX() != 0.0 || nl.getMulticutSizeY() != 0.0 || nl.getMulticutSep1D() != 0.0 || nl.getMulticutSep2D() != 0.0) {
                out.println("\t\tmultiSizeX=" + nl.getMulticutSizeX() + " multiSizeY=" + nl.getMulticutSizeY() + " multiSep=" + nl.getMulticutSep1D() + " multiSpe2D=" + nl.getMulticutSep2D());
            }
            if (isSerp) {
                out.println("\t\tLWidth=" + nl.getSerpentineLWidth() + " rWidth=" + nl.getSerpentineRWidth() + " bExtend=" + nl.getSerpentineExtentB() + " tExtend=" + nl.getSerpentineExtentT());
            }
            for (Technology.TechPoint p : nl.getPoints()) {
                out.println("\t\tpoint xm=" + p.getX().getMultiplier() + " xa=" + p.getX().getAdder() + " ym=" + p.getY().getMultiplier() + " ya=" + p.getY().getAdder());
            }
        }
    }

    public void getZValues(double[] array) {
        for (int j = 0; j < this.layers.length; ++j) {
            Layer layer = this.layers[j].getLayer();
            if (layer.getTechnology() instanceof Generic) continue;
            double distance = layer.getDistance();
            double thickness = layer.getThickness();
            double z = distance + thickness;
            array[0] = array[0] > distance ? distance : array[0];
            array[1] = array[1] < z ? z : array[1];
        }
    }

    private void checkChanging() {
    }

    public static class NodeSizeRule {
        private final double sizeX;
        private final double sizeY;
        private final String rule;

        public NodeSizeRule(double sizeX, double sizeY, String rule) {
            this.sizeX = DBMath.round(sizeX);
            this.sizeY = DBMath.round(sizeY);
            this.rule = rule;
        }

        public String getRuleName() {
            return this.rule;
        }

        public double getWidth() {
            return this.sizeX;
        }

        public double getHeight() {
            return this.sizeY;
        }
    }

    private static class NodeLayerIterator
    implements Iterator<Layer> {
        Technology.NodeLayer[] array;
        int pos;

        public NodeLayerIterator(Technology.NodeLayer[] a) {
            this.array = a;
            this.pos = 0;
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.array.length;
        }

        @Override
        public Layer next() throws NoSuchElementException {
            if (this.pos >= this.array.length) {
                throw new NoSuchElementException();
            }
            return this.array[this.pos++].getLayer();
        }

        @Override
        public void remove() throws UnsupportedOperationException, IllegalStateException {
            throw new UnsupportedOperationException();
        }
    }

    public static enum Function {
        UNKNOWN("unknown", "node"),
        PIN("pin", "pin"),
        CONTACT("contact", "contact"),
        NODE("pure-layer-node", "plnode"),
        CONNECT("connection", "conn"),
        TRANMOS("nMOS-transistor", "nmos"),
        TRADMOS("DMOS-transistor", "dmos"),
        TRAPMOS("pMOS-transistor", "pmos"),
        TRANPN("NPN-transistor", "npn"),
        TRAPNP("PNP-transistor", "pnp"),
        TRANJFET("n-type-JFET-transistor", "njfet"),
        TRAPJFET("p-type-JFET-transistor", "pjfet"),
        TRADMES("depletion-mesfet", "dmes"),
        TRAEMES("enhancement-mesfet", "emes"),
        TRANSREF("prototype-defined-transistor", "tref"),
        TRANS("transistor", "trans"),
        TRA4NMOS("4-port-nMOS-transistor", "nmos4p"),
        TRA4DMOS("4-port-DMOS-transistor", "dmos4p"),
        TRA4PMOS("4-port-pMOS-transistor", "pmos4p"),
        TRA4NPN("4-port-NPN-transistor", "npn4p"),
        TRA4PNP("4-port-PNP-transistor", "pnp4p"),
        TRA4NJFET("4-port-n-type-JFET-transistor", "njfet4p"),
        TRA4PJFET("4-port-p-type-JFET-transistor", "pjfet4p"),
        TRA4DMES("4-port-depletion-mesfet", "dmes4p"),
        TRA4EMES("4-port-enhancement-mesfet", "emes4p"),
        TRANS4("4-port-transistor", "trans4p"),
        RESIST("resistor", "res"),
        PRESIST("poly-resistor", "pres"),
        WRESIST("well-resistor", "wres"),
        ESDDEVICE("esd-device", "esdd"),
        CAPAC("capacitor", "cap"),
        ECAPAC("electrolytic-capacitor", "ecap"),
        DIODE("diode", "diode"),
        DIODEZ("zener-diode", "zdiode"),
        INDUCT("inductor", "ind"),
        METER("meter", "meter"),
        BASE("base", "base"),
        EMIT("emitter", "emit"),
        COLLECT("collector", "coll"),
        BUFFER("buffer", "buf"),
        GATEAND("AND-gate", "and"),
        GATEOR("OR-gate", "or"),
        GATEXOR("XOR-gate", "xor"),
        FLIPFLOPRSMS("flip-flop-RS-MS", "ffRSms"),
        FLIPFLOPRSP("flip-flop-RS-P", "ffRSp"),
        FLIPFLOPRSN("flip-flop-RS-N", "ffRSn"),
        FLIPFLOPJKMS("flip-flop-JK-MS", "ffJKms"),
        FLIPFLOPJKP("flip-flop-JK-P", "ffJKp"),
        FLIPFLOPJKN("flip-flop-JK-N", "ffJKn"),
        FLIPFLOPDMS("flip-flop-D-MS", "ffDms"),
        FLIPFLOPDP("flip-flop-D-P", "ffDp"),
        FLIPFLOPDN("flip-flop-D-N", "ffDn"),
        FLIPFLOPTMS("flip-flop-T-MS", "ffTms"),
        FLIPFLOPTP("flip-flop-T-P", "ffTp"),
        FLIPFLOPTN("flip-flop-T-N", "ffTn"),
        MUX("multiplexor", "mux"),
        CONPOWER("power", "pwr"),
        CONGROUND("ground", "gnd"),
        SOURCE("source", "source"),
        SUBSTRATE("substrate", "substr"),
        WELL("well", "well"),
        ART("artwork", "art"),
        ARRAY("array", "array"),
        ALIGN("align", "align"),
        CCVS("ccvs", "ccvs"),
        CCCS("cccs", "cccs"),
        VCVS("vcvs", "vcvs"),
        VCCS("vccs", "vccs"),
        TLINE("transmission-line", "transm");

        private final String name;
        private final String shortName;
        private final Name basename;

        private Function(String name, String shortName) {
            this.name = name;
            this.shortName = shortName;
            this.basename = Name.findName(TextUtils.canonicString(shortName) + "@0").getBasename();
        }

        public static List<Function> getFunctions() {
            return Arrays.asList(Function.class.getEnumConstants());
        }

        public String getName() {
            return this.name;
        }

        public String getConstantName() {
            return this.name();
        }

        public String getShortName() {
            return this.shortName;
        }

        public Name getBasename() {
            return this.basename;
        }

        public boolean isCapacitor() {
            return this == CAPAC || this == ECAPAC;
        }

        public boolean isResistor() {
            return this == RESIST || this == PRESIST || this == WRESIST;
        }

        public boolean isESDDevice() {
            return this == ESDDEVICE;
        }

        public boolean isTransistor() {
            return this == TRANMOS || this == TRAPMOS || this == TRADMOS || this == TRA4NMOS || this == TRA4PMOS || this == TRA4DMOS || this == TRANPN || this == TRAPNP || this == TRANJFET || this == TRAPJFET || this == TRAEMES || this == TRADMES || this == TRA4NPN || this == TRA4PNP || this == TRA4NJFET || this == TRA4PJFET || this == TRA4EMES || this == TRA4DMES || this == TRANSREF || this == TRANS || this == TRANS4;
        }

        public boolean isFlipFlop() {
            return this == FLIPFLOPRSMS || this == FLIPFLOPRSP || this == FLIPFLOPRSN || this == FLIPFLOPJKMS || this == FLIPFLOPJKP || this == FLIPFLOPJKN || this == FLIPFLOPDMS || this == FLIPFLOPDP || this == FLIPFLOPDN || this == FLIPFLOPTMS || this == FLIPFLOPTP || this == FLIPFLOPTN;
        }

        public String toString() {
            return this.name;
        }
    }
}

