/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.project;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.project.Project;
import com.sun.electric.tool.project.ProjectCell;
import com.sun.electric.tool.project.ProjectDB;
import com.sun.electric.tool.project.ProjectLibrary;
import com.sun.electric.tool.project.Users;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

public class DeleteCellJob
extends Job {
    private ProjectDB pdb = Project.projectDB;
    private Cell cell;

    public static void removeThisCell() {
        UserInterface ui = Job.getUserInterface();
        Cell cell = ui.needCurrentCell();
        if (cell == null) {
            return;
        }
        DeleteCellJob.removeCell(cell);
    }

    public static void removeCell(Cell cell) {
        Iterator<ProjectCell> it;
        if (Users.needUserName()) {
            return;
        }
        if (Project.ensureRepository()) {
            return;
        }
        HashSet<Cell> markedCells = new HashSet<Cell>();
        Iterator<NodeInst> it2 = cell.getInstancesOf();
        while (it2.hasNext()) {
            NodeInst ni = it2.next();
            Cell parent = ni.getParent();
            int status = Project.getCellStatus(parent);
            if (status == 0 || status == 4) continue;
            markedCells.add(ni.getParent());
        }
        StringBuffer err = new StringBuffer();
        Iterator<Library> it3 = Library.getLibraries();
        while (it3.hasNext()) {
            Library oLib = it3.next();
            Iterator<Cell> cIt = oLib.getCells();
            while (cIt.hasNext()) {
                Cell oCell = cIt.next();
                if (!markedCells.contains(oCell)) continue;
                if (err.length() > 0) {
                    err.append(", ");
                }
                err.append(oCell.describe(true));
            }
        }
        if (markedCells.size() > 0) {
            Job.getUserInterface().showErrorMessage("Cannot delete " + cell + " because it is still being used by: " + err.toString(), "Delete Cell Error");
            return;
        }
        boolean youOwn = false;
        Library lib = cell.getLibrary();
        ProjectLibrary pl = Project.projectDB.findProjectLibrary(lib);
        Iterator<ProjectCell> it4 = pl.getProjectCells();
        while (it4.hasNext()) {
            ProjectCell pc = it4.next();
            if (!pc.getOwner().equals(Project.getCurrentUserName())) continue;
            youOwn = true;
            break;
        }
        if (youOwn) {
            StringBuffer infstr = new StringBuffer();
            it = pl.getProjectCells();
            while (it.hasNext()) {
                ProjectCell pc = it.next();
                if (!pc.getOwner().equals(Project.getCurrentUserName())) continue;
                if (infstr.length() > 0) {
                    infstr.append(", ");
                }
                infstr.append(pc.describe());
            }
            Job.getUserInterface().showErrorMessage("Before deleting a cell from the repository, you must check-in all of your work. This is because the deletion may be dependent upon changes recently made. These cells are checked out to you: " + infstr.toString(), "Cell Deletion Error");
            return;
        }
        boolean found = false;
        it = pl.getProjectCells();
        while (it.hasNext()) {
            ProjectCell pc = it.next();
            if (!pc.getCellName().equals(cell.getName()) || pc.getView() != cell.getView()) continue;
            found = true;
            break;
        }
        if (!found) {
            Job.getUserInterface().showErrorMessage("This cell is not in the repository", "Cell Deletion Error");
            return;
        }
        new DeleteCellJob(cell);
    }

    private DeleteCellJob(Cell cell) {
        super("Delete cell", Project.getProjectTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
        this.cell = cell;
        this.startJob();
    }

    @Override
    public boolean doIt() throws JobException {
        Library lib = this.cell.getLibrary();
        ProjectLibrary pl = this.pdb.findProjectLibrary(lib);
        pl.lockProjectFile();
        ArrayList<ProjectCell> copyList = new ArrayList<ProjectCell>();
        Iterator<ProjectCell> it = pl.getProjectCells();
        while (it.hasNext()) {
            copyList.add(it.next());
        }
        for (ProjectCell pc : copyList) {
            if (!pc.getCellName().equals(this.cell.getName()) || pc.getView() != this.cell.getView()) continue;
            pl.removeProjectCell(pc);
            Project.setChangeStatus(true);
            Project.markLocked(this.cell, false);
            Project.setChangeStatus(false);
            System.out.println("Cell " + this.cell.describe(true) + " deleted from the repository");
        }
        pl.releaseProjectFileLock(true);
        this.fieldVariableChanged("pdb");
        return true;
    }

    @Override
    public void terminateOK() {
        Project.projectDB = this.pdb;
        WindowFrame.wantToRedoLibraryTree();
    }
}

