/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output.bookshelf;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.io.input.bookshelf.Bookshelf;
import com.sun.electric.tool.io.input.bookshelf.BookshelfNodes;
import com.sun.electric.tool.io.output.bookshelf.BookshelfOutput;
import com.sun.electric.tool.io.output.bookshelf.BookshelfOutputWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;

public class BookshelfOutputNodes
extends BookshelfOutputWriter {
    private static final Bookshelf.BookshelfFiles fileType = Bookshelf.BookshelfFiles.nodes;
    private Cell cell;

    public BookshelfOutputNodes(String genericFileName, Cell cell) {
        super(genericFileName, fileType);
        this.cell = cell;
    }

    @Override
    public void write() throws IOException {
        Job.getUserInterface().setProgressNote("Nodes File: " + this.fileName);
        PrintWriter writer = new PrintWriter(this.fileName);
        writer.println(BookshelfOutput.createBookshelfHeader(fileType));
        Iterator<NodeInst> ini = this.cell.getNodes();
        while (ini.hasNext()) {
            NodeInst ni = ini.next();
            BookshelfNodes.BookshelfNode node = new BookshelfNodes.BookshelfNode(ni.getName(), ni.getProto().getDefWidth(), ni.getProto().getDefHeight(), ni.isLocked());
            writer.println("   " + node.toString());
        }
        writer.flush();
        writer.close();
    }
}

