/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.topology;

import com.sun.electric.database.CellRevision;
import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.constraint.Constraints;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.id.CellUsage;
import com.sun.electric.database.id.PortProtoId;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.topology.RTNode;
import com.sun.electric.technology.BoundsBuilder;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.util.TextUtils;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class Topology {
    final Cell cell;
    private final ArrayList<NodeInst> essenBounds = new ArrayList();
    private final ArrayList<NodeInst> chronNodes = new ArrayList();
    private final ArrayList<NodeInst> nodes = new ArrayList();
    private final HashMap<String, MaxSuffix> maxSuffix = new HashMap();
    private int maxArcSuffix = -1;
    private final ArrayList<ArcInst> chronArcs = new ArrayList();
    private final ArrayList<ArcInst> arcs = new ArrayList();
    boolean validArcBounds;
    private RTNode<Geometric> rTree = RTNode.makeTopLevel();
    private boolean rTreeFresh;

    public Topology(Cell cell, boolean loadBackup) {
        this.cell = cell;
        if (loadBackup) {
            CellRevision cellRevision = cell.backup().cellRevision;
            this.updateNodes(true, cellRevision, null, cell.lowLevelExpandedNodes());
            this.updateArcs(cellRevision);
        }
    }

    public Cell getCell() {
        return this.cell;
    }

    public synchronized Iterator<NodeInst> getNodes() {
        ArrayList<NodeInst> nodesCopy = new ArrayList<NodeInst>(this.nodes);
        return nodesCopy.iterator();
    }

    public synchronized Iterator<Nodable> getNodables() {
        ArrayList<NodeInst> nodesCopy = new ArrayList<NodeInst>(this.nodes);
        return nodesCopy.iterator();
    }

    public int getNumNodes() {
        return this.nodes.size();
    }

    public final NodeInst getNode(int nodeIndex) {
        return this.nodes.get(nodeIndex);
    }

    public NodeInst getNodeById(int nodeId) {
        return nodeId < this.chronNodes.size() ? this.chronNodes.get(nodeId) : null;
    }

    public void updatePortInsts(Cell proto, int[] pattern) {
        for (NodeInst ni : this.nodes) {
            if (ni.getProto() != proto) continue;
            ni.updatePortInsts(pattern);
            ni.check();
        }
    }

    public PortInst getPortInst(int nodeId, PortProtoId portProtoId) {
        NodeInst ni = this.chronNodes.get(nodeId);
        assert (ni.getD().protoId == portProtoId.getParentId());
        NodeProto np = ni.getProto();
        PortProto pp = np.getPort(portProtoId);
        PortInst pi = ni.getPortInst(pp.getPortIndex());
        assert (pi.getNodeInst().getNodeId() == nodeId);
        assert (pi.getPortProto().getId() == portProtoId);
        return pi;
    }

    public NodeInst findNode(String name) {
        int nodeIndex = this.searchNode(name);
        return nodeIndex >= 0 ? this.nodes.get(nodeIndex) : null;
    }

    public void killNodes(Set<NodeInst> killedNodes) {
        if (killedNodes.isEmpty()) {
            return;
        }
        for (NodeInst ni : killedNodes) {
            if (ni.getParent() == this.cell) continue;
            throw new IllegalArgumentException("parent");
        }
        HashSet<ArcInst> arcsToKill = new HashSet<ArcInst>();
        Iterator<ArcInst> it = this.getArcs();
        while (it.hasNext()) {
            ArcInst ai = it.next();
            if (!killedNodes.contains(ai.getTailPortInst().getNodeInst()) && !killedNodes.contains(ai.getHeadPortInst().getNodeInst())) continue;
            arcsToKill.add(ai);
        }
        HashSet<Export> exportsToKill = new HashSet<Export>();
        Iterator<Export> it2 = this.cell.getExports();
        while (it2.hasNext()) {
            Export export = it2.next();
            if (!killedNodes.contains(export.getOriginalPort().getNodeInst())) continue;
            exportsToKill.add(export);
        }
        for (ArcInst ai : arcsToKill) {
            ai.kill();
        }
        this.cell.killExports(exportsToKill);
        for (NodeInst ni : killedNodes) {
            if (!ni.isLinked()) continue;
            this.removeNode(ni);
            Constraints.getCurrent().killObject(ni);
        }
    }

    public ImmutableNodeInst[] backupNodes(ImmutableNodeInst.Iterable oldNodes) {
        ImmutableNodeInst[] newNodes = new ImmutableNodeInst[this.nodes.size()];
        boolean changed = this.nodes.size() != oldNodes.size();
        for (int i = 0; i < this.nodes.size(); ++i) {
            NodeInst ni = this.nodes.get(i);
            ImmutableNodeInst d = ni.getD();
            changed = changed || oldNodes.get(i) != d;
            newNodes[i] = d;
        }
        return changed ? newNodes : null;
    }

    public boolean updateNodes(boolean full, CellRevision newRevision, BitSet exportsModified, BitSet expandedNodes) {
        NodeInst ni;
        boolean expandStatusModified = false;
        this.nodes.clear();
        this.essenBounds.clear();
        this.maxSuffix.clear();
        BitSet newNodeIds = new BitSet();
        for (int i = 0; i < newRevision.nodes.size(); ++i) {
            ImmutableNodeInst d = newRevision.nodes.get(i);
            newNodeIds.set(d.nodeId);
            while (d.nodeId >= this.chronNodes.size()) {
                this.chronNodes.add(null);
            }
            ni = this.chronNodes.get(d.nodeId);
            if (ni != null && ni.getProto().getId().isIcon() == d.protoId.isIcon()) {
                NodeProto oldProto = ni.getProto();
                ni.setDInUndo(d);
                if (ni.getProto() != oldProto) {
                    ni.updatePortInsts(true);
                } else if (ni.isCellInstance()) {
                    int subCellIndex = ((Cell)ni.getProto()).getCellIndex();
                    if (full || exportsModified != null && exportsModified.get(subCellIndex)) {
                        ni.updatePortInsts(full);
                    }
                }
            } else {
                ni = NodeInst.lowLevelNewInstance(this, d);
                this.chronNodes.set(d.nodeId, ni);
                if (ni.isCellInstance()) {
                    Cell subCell = (Cell)ni.getProto();
                    boolean oldEx = expandedNodes.get(d.nodeId);
                    expandedNodes.set(d.nodeId, oldEx || subCell.isWantExpanded());
                    expandStatusModified = true;
                }
            }
            this.nodes.add(ni);
            this.updateMaxSuffix(ni);
            if (!Generic.isEssentialBnd(ni)) continue;
            this.essenBounds.add(ni);
        }
        assert (this.nodes.size() == newRevision.nodes.size());
        int nodeCount = 0;
        for (int nodeId = 0; nodeId < this.chronNodes.size(); ++nodeId) {
            ni = this.chronNodes.get(nodeId);
            if (newNodeIds.get(nodeId)) {
                assert (ni != null);
                ++nodeCount;
                continue;
            }
            if (ni == null) continue;
            this.chronNodes.set(nodeId, null);
        }
        assert (nodeCount == this.nodes.size());
        return expandStatusModified;
    }

    public void updateSubCells(BitSet exportsModified, BitSet boundsModified) {
        this.unfreshRTree();
        for (int i = 0; i < this.nodes.size(); ++i) {
            NodeInst ni = this.nodes.get(i);
            if (!ni.isCellInstance()) continue;
            int subCellIndex = ((Cell)ni.getProto()).getCellIndex();
            if (exportsModified != null && exportsModified.get(subCellIndex)) {
                ni.updatePortInsts(false);
            }
            if (boundsModified == null || !boundsModified.get(subCellIndex)) continue;
            ni.redoGeometric();
        }
    }

    public void addNodes(List<NodeInst> newNodes) {
        this.cell.checkChanging();
        int oldI = this.nodes.size() - 1;
        for (int i = 0; i < newNodes.size(); ++i) {
            this.nodes.add(null);
        }
        int newI = newNodes.size() - 1;
        int outI = this.nodes.size() - 1;
        while (oldI >= 0 && newI >= 0) {
            int cmp = TextUtils.STRING_NUMBER_ORDER.compare(this.nodes.get(oldI).getName(), newNodes.get(newI).getName());
            assert (cmp != 0);
            NodeInst ni = cmp > 0 ? this.nodes.get(oldI--) : newNodes.get(newI--);
            this.nodes.set(outI--, ni);
        }
        while (oldI >= 0) {
            NodeInst ni = this.nodes.get(oldI--);
            this.nodes.set(outI--, ni);
        }
        while (newI >= 0) {
            NodeInst ni = newNodes.get(newI--);
            this.nodes.set(outI--, ni);
        }
        assert (oldI == -1 && newI == -1 && outI == -1);
        for (int i = 1; i < this.nodes.size() - 1; ++i) {
            assert (TextUtils.STRING_NUMBER_ORDER.compare(this.nodes.get(i - 1).getName(), this.nodes.get(i).getName()) < 0);
        }
        for (NodeInst ni : newNodes) {
            int nodeId = ni.getNodeId();
            while (this.chronNodes.size() <= nodeId) {
                this.chronNodes.add(null);
            }
            assert (this.chronNodes.get(nodeId) == null);
            this.chronNodes.set(nodeId, ni);
            this.updateMaxSuffix(ni);
            if (!Generic.isEssentialBnd(ni)) continue;
            this.essenBounds.add(ni);
        }
        this.unfreshRTree();
    }

    public int addNode(NodeInst ni) {
        this.cell.checkChanging();
        this.addNodeName(ni);
        int nodeId = ni.getNodeId();
        while (this.chronNodes.size() <= nodeId) {
            this.chronNodes.add(null);
        }
        assert (this.chronNodes.get(nodeId) == null);
        this.chronNodes.set(nodeId, ni);
        if (Generic.isEssentialBnd(ni)) {
            this.essenBounds.add(ni);
        }
        this.unfreshRTree();
        return nodeId;
    }

    void addNodeName(NodeInst ni) {
        int nodeIndex = this.searchNode(ni.getName());
        assert (nodeIndex < 0);
        nodeIndex = -nodeIndex - 1;
        this.nodes.add(nodeIndex, ni);
        this.updateMaxSuffix(ni);
    }

    private void updateMaxSuffix(NodeInst ni) {
        int numSuffix;
        Name name = ni.getNameKey();
        if (!name.isTempname()) {
            return;
        }
        Name basename = name.getBasename();
        String basenameString = basename.toString();
        MaxSuffix ms = this.maxSuffix.get(basenameString);
        if (ms == null) {
            ms = new MaxSuffix();
            this.maxSuffix.put(basenameString, ms);
        }
        if ((numSuffix = name.getNumSuffix()) > ms.v) {
            ms.v = numSuffix;
        }
    }

    Name getNodeAutoname(Name basename) {
        Name name;
        String basenameString = basename.toString();
        MaxSuffix ms = this.maxSuffix.get(basenameString);
        if (ms == null) {
            ms = new MaxSuffix();
            this.maxSuffix.put(basenameString, ms);
            name = basename.findSuffixed(0);
        } else {
            ++ms.v;
            name = basename.findSuffixed(ms.v);
        }
        assert (this.searchNode(name.toString()) < 0);
        return name;
    }

    public void removeNode(NodeInst ni) {
        assert (ni.topology == this);
        this.essenBounds.remove(ni);
        this.removeNodeName(ni);
        int nodeId = ni.getNodeId();
        assert (this.chronNodes.get(nodeId) == ni);
        this.chronNodes.set(nodeId, null);
        this.unfreshRTree();
    }

    void removeNodeName(NodeInst ni) {
        int nodeIndex = this.searchNode(ni.getName());
        NodeInst removedNi = this.nodes.remove(nodeIndex);
        assert (removedNi == ni);
    }

    private int searchNode(String name) {
        int high;
        int low = 0;
        int pick = high = this.nodes.size() - 1;
        while (low <= high) {
            NodeInst ni = this.nodes.get(pick);
            int cmp = TextUtils.STRING_NUMBER_ORDER.compare(ni.getName(), name);
            if (cmp < 0) {
                low = pick + 1;
            } else if (cmp > 0) {
                high = pick - 1;
            } else {
                return pick;
            }
            pick = low + high >> 1;
        }
        return -(low + 1);
    }

    public Rectangle2D findEssentialBounds() {
        if (this.essenBounds.size() < 2) {
            return null;
        }
        double minX = Double.MAX_VALUE;
        double maxX = -1.7976931348623157E308;
        double minY = Double.MAX_VALUE;
        double maxY = -1.7976931348623157E308;
        for (int i = 0; i < this.essenBounds.size(); ++i) {
            NodeInst ni = this.essenBounds.get(i);
            minX = Math.min(minX, ni.getTrueCenterX());
            maxX = Math.max(maxX, ni.getTrueCenterX());
            minY = Math.min(minY, ni.getTrueCenterY());
            maxY = Math.max(maxY, ni.getTrueCenterY());
        }
        return new Rectangle2D.Double(minX, minY, maxX - minX, maxY - minY);
    }

    public synchronized Iterator<ArcInst> getArcs() {
        ArrayList<ArcInst> arcsCopy = new ArrayList<ArcInst>(this.arcs);
        return arcsCopy.iterator();
    }

    public int getNumArcs() {
        return this.arcs.size();
    }

    public final ArcInst getArc(int arcIndex) {
        return this.arcs.get(arcIndex);
    }

    public ArcInst getArcById(int arcId) {
        return arcId < this.chronArcs.size() ? this.chronArcs.get(arcId) : null;
    }

    public ArcInst findArc(String name) {
        ArcInst ai;
        int arcIndex = this.searchArc(name, 0);
        if (arcIndex >= 0) {
            return this.arcs.get(arcIndex);
        }
        if ((arcIndex = -arcIndex - 1) < this.arcs.size() && (ai = this.arcs.get(arcIndex)).getName().equals(name)) {
            return ai;
        }
        return null;
    }

    void addArc(ArcInst ai) {
        this.cell.setTopologyModified();
        this.validArcBounds = false;
        this.unfreshRTree();
        int arcIndex = this.searchArc(ai);
        assert (arcIndex < 0);
        arcIndex = -arcIndex - 1;
        this.arcs.add(arcIndex, ai);
        int arcId = ai.getArcId();
        while (this.chronArcs.size() <= arcId) {
            this.chronArcs.add(null);
        }
        assert (this.chronArcs.get(arcId) == null);
        this.chronArcs.set(arcId, ai);
        if (ai.isUsernamed()) {
            return;
        }
        Name name = ai.getNameKey();
        assert (name.getBasename() == ImmutableArcInst.BASENAME);
        this.maxArcSuffix = Math.max(this.maxArcSuffix, name.getNumSuffix());
    }

    Name getArcAutoname() {
        if (this.maxArcSuffix < Integer.MAX_VALUE) {
            return ImmutableArcInst.BASENAME.findSuffixed(++this.maxArcSuffix);
        }
        int i = 0;
        Name name;
        while (this.hasTempArcName(name = ImmutableArcInst.BASENAME.findSuffixed(i))) {
            ++i;
        }
        return name;
    }

    boolean hasTempArcName(Name name) {
        return name.isTempname() && this.findArc(name.toString()) != null;
    }

    void removeArc(ArcInst ai) {
        this.cell.checkChanging();
        this.cell.setTopologyModified();
        this.unfreshRTree();
        assert (ai.isLinked());
        int arcIndex = this.searchArc(ai);
        ArcInst removedAi = this.arcs.remove(arcIndex);
        assert (removedAi == ai);
        int arcId = ai.getArcId();
        assert (this.chronArcs.get(arcId) == ai);
        this.chronArcs.set(arcId, null);
    }

    public ImmutableArcInst[] backupArcs(ImmutableArcInst.Iterable oldArcs) {
        ImmutableArcInst[] newArcs = new ImmutableArcInst[this.arcs.size()];
        boolean changed = this.arcs.size() != oldArcs.size();
        for (int i = 0; i < this.arcs.size(); ++i) {
            ArcInst ai = this.arcs.get(i);
            ImmutableArcInst d = ai.getD();
            changed = changed || oldArcs.get(i) != d;
            newArcs[i] = d;
        }
        return changed ? newArcs : null;
    }

    public void updateArcs(CellRevision newRevision) {
        ArcInst ai;
        this.validArcBounds = false;
        this.arcs.clear();
        this.maxArcSuffix = -1;
        for (int i = 0; i < newRevision.arcs.size(); ++i) {
            ImmutableArcInst d = newRevision.arcs.get(i);
            while (d.arcId >= this.chronArcs.size()) {
                this.chronArcs.add(null);
            }
            ai = this.chronArcs.get(d.arcId);
            PortInst headPi = this.getPortInst(d.headNodeId, d.headPortId);
            PortInst tailPi = this.getPortInst(d.tailNodeId, d.tailPortId);
            if (ai != null && ai.getHeadPortInst() == headPi && ai.getTailPortInst() == tailPi) {
                ai.setDInUndo(d);
            } else {
                ai = new ArcInst(this, d, headPi, tailPi);
                this.chronArcs.set(d.arcId, ai);
            }
            this.arcs.add(ai);
            if (ai.isUsernamed()) continue;
            Name name = ai.getNameKey();
            assert (name.getBasename() == ImmutableArcInst.BASENAME);
            this.maxArcSuffix = Math.max(this.maxArcSuffix, name.getNumSuffix());
        }
        int arcCount = 0;
        for (int i = 0; i < this.chronArcs.size(); ++i) {
            ai = this.chronArcs.get(i);
            if (ai == null) continue;
            int arcIndex = this.searchArc(ai);
            if (arcIndex < 0 || arcIndex >= this.arcs.size() || ai != this.arcs.get(arcIndex)) {
                this.chronArcs.set(i, null);
                continue;
            }
            ++arcCount;
        }
        assert (arcCount == this.arcs.size());
    }

    void computeArcBounds() {
        long[] gridCoords = new long[4];
        BoundsBuilder b = new BoundsBuilder(this.cell.getTechPool());
        for (int arcIndex = 0; arcIndex < this.arcs.size(); ++arcIndex) {
            ArcInst ai = this.arcs.get(arcIndex);
            ai.computeBounds(b, gridCoords);
        }
        this.validArcBounds = true;
    }

    private int searchArc(ArcInst ai) {
        return this.searchArc(ai.getName(), ai.getArcId());
    }

    private int searchArc(String name, int arcId) {
        int high;
        int low = 0;
        int pick = high = this.arcs.size() - 1;
        while (low <= high) {
            ArcInst ai = this.arcs.get(pick);
            int cmp = TextUtils.STRING_NUMBER_ORDER.compare(ai.getName(), name);
            if (cmp == 0) {
                cmp = ai.getArcId() - arcId;
            }
            if (cmp < 0) {
                low = pick + 1;
            } else if (cmp > 0) {
                high = pick - 1;
            } else {
                return pick;
            }
            pick = low + high >> 1;
        }
        return -(low + 1);
    }

    public Iterator<Geometric> searchIterator(Rectangle2D bounds, boolean includeEdges) {
        return new RTNode.Search<Geometric>(bounds, this.getRTree(), includeEdges);
    }

    void setArcsDirty() {
        this.cell.setTopologyModified();
        this.validArcBounds = false;
        this.unfreshRTree();
    }

    public void unfreshRTree() {
        this.rTreeFresh = false;
    }

    private RTNode<Geometric> getRTree() {
        if (this.rTreeFresh) {
            return this.rTree;
        }
        this.rebuildRTree();
        this.rTreeFresh = true;
        return this.rTree;
    }

    private void rebuildRTree() {
        if (!this.validArcBounds) {
            this.computeArcBounds();
        }
        CellId cellId = this.cell.getId();
        RTNode<Object> root2 = RTNode.makeTopLevel();
        Iterator<Geometric> it = this.cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = it.next();
            root2 = RTNode.linkGeom(cellId, root2, ni);
        }
        it = this.cell.getArcs();
        while (it.hasNext()) {
            ArcInst ai = (ArcInst)it.next();
            root2 = RTNode.linkGeom(cellId, root2, ai);
        }
        root2.checkRTree(0, cellId);
        this.rTree = root2;
        this.rTreeFresh = true;
    }

    private void rebuildRTree2() {
        long startTime = System.currentTimeMillis();
        BitSet remainingNodes = new BitSet();
        BitSet remainingArcs = new BitSet();
        this.removeRTNodes(remainingNodes, remainingArcs, this.rTree);
        CellId cellId = this.cell.getId();
        Iterator<Geometric> it = this.cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = it.next();
            if (remainingNodes.get(ni.getNodeId())) continue;
            this.rTree = RTNode.linkGeom(cellId, this.rTree, ni);
        }
        it = this.cell.getArcs();
        while (it.hasNext()) {
            ArcInst ai = (ArcInst)it.next();
            if (remainingArcs.get(ai.getArcId())) continue;
            this.rTree = RTNode.linkGeom(cellId, this.rTree, ai);
        }
        this.rTree.checkRTree(0, cellId);
        this.rTreeFresh = true;
        long stopTime = System.currentTimeMillis();
        if (Job.getDebug()) {
            System.out.println("Rebuilding R-Tree in " + this.cell + " took " + (stopTime - startTime) + " msec");
        }
    }

    private void removeRTNodes(BitSet remainingNodes, BitSet remainingArcs, RTNode<Geometric> top) {
        long fixpMinX = Long.MAX_VALUE;
        long fixpMinY = Long.MAX_VALUE;
        long fixpMaxX = Long.MIN_VALUE;
        long fixpMaxY = Long.MIN_VALUE;
        if (top.getFlag()) {
            int j = 0;
            for (int i = 0; i < top.getTotal(); ++i) {
                ERectangle bounds;
                Geometric geom = top.getChildLeaf(j);
                if (geom instanceof NodeInst) {
                    NodeInst ni = (NodeInst)geom;
                    if (ni != this.getNodeById(ni.getNodeId()) || !top.contains(bounds = geom.getBounds())) continue;
                    remainingNodes.set(ni.getNodeId());
                } else {
                    ArcInst ai = (ArcInst)geom;
                    if (ai != this.getArcById(ai.getArcId()) || !top.contains(bounds = geom.getBounds())) continue;
                    remainingArcs.set(ai.getArcId());
                }
                fixpMinX = Math.min(fixpMinX, bounds.getFixpMinX());
                fixpMinY = Math.min(fixpMinY, bounds.getFixpMinY());
                fixpMaxX = Math.max(fixpMaxX, bounds.getFixpMaxX());
                fixpMaxY = Math.max(fixpMaxY, bounds.getFixpMaxY());
                top.setChild(j++, geom);
            }
            top.setTotal(j);
        } else {
            int j = 0;
            for (int i = 0; i < top.getTotal(); ++i) {
                RTNode<Geometric> child = top.getChildTree(i);
                this.removeRTNodes(remainingNodes, remainingArcs, child);
                if (child.getTotal() == 0) continue;
                fixpMinX = Math.min(fixpMinX, child.getFixpMinX());
                fixpMinY = Math.min(fixpMinY, child.getFixpMinY());
                fixpMaxX = Math.max(fixpMaxX, child.getFixpMaxX());
                fixpMaxY = Math.max(fixpMaxY, child.getFixpMaxY());
                top.setChild(j++, child);
            }
            top.setTotal(j);
        }
        if (top.getTotal() == 0) {
            fixpMaxY = 0L;
            fixpMaxX = 0L;
            fixpMinY = 0L;
            fixpMinX = 0L;
        }
        top.setFixpLow(fixpMinX, fixpMinY, fixpMaxX, fixpMaxY);
    }

    public void check(int[] cellUsages) {
        int i;
        NodeInst ni;
        ArcInst ai;
        ArcInst prevAi = null;
        BoundsBuilder b = new BoundsBuilder(this.cell.getTechPool());
        for (int arcIndex = 0; arcIndex < this.arcs.size(); ++arcIndex) {
            ai = this.arcs.get(arcIndex);
            ImmutableArcInst a = ai.getD();
            assert (ai.getParent() == this.cell);
            assert (this.chronArcs.get(a.arcId) == ai);
            if (prevAi != null) {
                int cmp = TextUtils.STRING_NUMBER_ORDER.compare(prevAi.getName(), ai.getName());
                assert (cmp <= 0);
                if (cmp == 0) assert (prevAi.getArcId() < a.arcId);
            }
            assert (ai.getHeadPortInst() == this.cell.getPortInst(a.headNodeId, a.headPortId));
            assert (ai.getTailPortInst() == this.cell.getPortInst(a.tailNodeId, a.tailPortId));
            if (this.validArcBounds) {
                ai.check(b);
            }
            prevAi = ai;
        }
        for (int arcId = 0; arcId < this.chronArcs.size(); ++arcId) {
            ai = this.chronArcs.get(arcId);
            if (ai == null) continue;
            assert (ai.getArcId() == arcId);
            int arcIndex = this.searchArc(ai);
            assert (ai == this.arcs.get(arcIndex));
        }
        NodeInst prevNi = null;
        EDatabase database = this.cell.getDatabase();
        CellId cellId = this.cell.getId();
        int[] usages = new int[cellId.numUsagesIn()];
        for (int nodeIndex = 0; nodeIndex < this.nodes.size(); ++nodeIndex) {
            ni = this.nodes.get(nodeIndex);
            ImmutableNodeInst n = ni.getD();
            assert (ni.getParent() == this.cell);
            assert (this.chronNodes.get(n.nodeId) == ni);
            if (prevNi != null) assert (TextUtils.STRING_NUMBER_ORDER.compare(prevNi.getName(), ni.getName()) < 0);
            if (ni.isCellInstance()) {
                Cell subCell = (Cell)ni.getProto();
                assert (subCell.isLinked());
                assert (subCell.getDatabase() == database);
                CellUsage u = cellId.getUsageIn(subCell.getId());
                int n2 = u.indexInParent;
                usages[n2] = usages[n2] + 1;
            }
            ni.check();
            prevNi = ni;
        }
        for (int nodeId = 0; nodeId < this.chronNodes.size(); ++nodeId) {
            ni = this.chronNodes.get(nodeId);
            if (ni == null) continue;
            assert (ni.getNodeId() == nodeId);
            assert (ni == this.nodes.get(this.searchNode(ni.getName())));
        }
        for (i = 0; i < cellUsages.length; ++i) {
            assert (cellUsages[i] == usages[i]);
        }
        for (i = cellUsages.length; i < usages.length; ++i) {
            assert (usages[i] == 0);
        }
        if (this.rTreeFresh) {
            this.rTree.checkRTree(0, this.cell.getId());
        }
    }

    private class MaxSuffix {
        int v = 0;

        private MaxSuffix() {
        }
    }
}

