/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.menus;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.IdMapper;
import com.sun.electric.database.Snapshot;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.id.LibId;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.text.Setting;
import com.sun.electric.database.variable.EditWindow_;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.cvspm.CVS;
import com.sun.electric.tool.cvspm.CVSLibrary;
import com.sun.electric.tool.cvspm.Commit;
import com.sun.electric.tool.cvspm.Edit;
import com.sun.electric.tool.cvspm.Update;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.io.input.GDSMap;
import com.sun.electric.tool.io.input.Input;
import com.sun.electric.tool.io.input.JELIB2;
import com.sun.electric.tool.io.input.LibraryFiles;
import com.sun.electric.tool.io.output.CellModelPrefs;
import com.sun.electric.tool.io.output.Output;
import com.sun.electric.tool.io.output.PNG;
import com.sun.electric.tool.io.output.PostScript;
import com.sun.electric.tool.io.output.Spice;
import com.sun.electric.tool.io.output.Verilog;
import com.sun.electric.tool.project.AddCellJob;
import com.sun.electric.tool.project.AddLibraryJob;
import com.sun.electric.tool.project.CancelCheckOutJob;
import com.sun.electric.tool.project.CheckInJob;
import com.sun.electric.tool.project.CheckOutJob;
import com.sun.electric.tool.project.DeleteCellJob;
import com.sun.electric.tool.project.HistoryDialog;
import com.sun.electric.tool.project.LibraryDialog;
import com.sun.electric.tool.project.UpdateJob;
import com.sun.electric.tool.simulation.SimulationTool;
import com.sun.electric.tool.user.ActivityLogger;
import com.sun.electric.tool.user.CircuitChangeJobs;
import com.sun.electric.tool.user.CircuitChanges;
import com.sun.electric.tool.user.Clipboard;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.UserInterfaceMain;
import com.sun.electric.tool.user.dialogs.ChangeCurrentLib;
import com.sun.electric.tool.user.dialogs.OpenFile;
import com.sun.electric.tool.user.dialogs.OptionReconcile;
import com.sun.electric.tool.user.menus.EMenu;
import com.sun.electric.tool.user.menus.EMenuItem;
import com.sun.electric.tool.user.projectSettings.ProjSettings;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.ElectricPrinter;
import com.sun.electric.tool.user.ui.ErrorLoggerTree;
import com.sun.electric.tool.user.ui.LayerVisibility;
import com.sun.electric.tool.user.ui.TextWindow;
import com.sun.electric.tool.user.ui.ToolBar;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowContent;
import com.sun.electric.tool.user.ui.WindowFrame;
import com.sun.electric.tool.user.waveform.WaveformWindow;
import com.sun.electric.util.ClientOS;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.math.MutableBoolean;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.prefs.BackingStoreException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;

public class FileMenu {
    private static EMenu openRecentLibs;
    public static final String openJobName = "Read External Library";
    private static PageFormat pageFormat;

    static EMenu makeMenu() {
        openRecentLibs = new EMenu("Open Recent Library", new ArrayList<EMenuItem>());
        return new EMenu("_File", new EMenuItem("_New Library..."){

            @Override
            public void run() {
                FileMenu.newLibraryCommand();
            }
        }, ToolBar.openLibraryCommand, openRecentLibs, new EMenu("_Import", new EMenuItem("_CIF (Caltech Intermediate Format)..."){

            @Override
            public void run() {
                FileMenu.importLibraryCommand(FileType.CIF, false, false, true, false);
            }
        }, new EMenuItem("_GDS II (Stream)..."){

            @Override
            public void run() {
                FileMenu.importLibraryCommand(FileType.GDS, false, false, true, false);
            }
        }, new EMenuItem("_GDS II (Stream) Skeleton..."){

            @Override
            public void run() {
                FileMenu.importLibraryCommand(FileType.GDS, false, false, true, true);
            }
        }, new EMenuItem("GDS _Map File..."){

            @Override
            public void run() {
                GDSMap.importMapFile();
            }
        }, new EMenuItem("_EDIF (Electronic Design Interchange Format)..."){

            @Override
            public void run() {
                FileMenu.importLibraryCommand(FileType.EDIF, false, false, true, false);
            }
        }, new EMenuItem("_LEF (Library Exchange Format)..."){

            @Override
            public void run() {
                FileMenu.importLibraryCommand(FileType.LEF, false, false, true, false);
            }
        }, new EMenuItem("_DEF (Design Exchange Format)..."){

            @Override
            public void run() {
                FileMenu.importLibraryCommand(FileType.DEF, false, true, true, false);
            }
        }, new EMenuItem("D_XF (AutoCAD)..."){

            @Override
            public void run() {
                FileMenu.importLibraryCommand(FileType.DXF, false, false, false, false);
            }
        }, new EMenuItem("Sp_ice Deck (Single file)..."){

            @Override
            public void run() {
                FileMenu.importLibraryCommand(FileType.SPICE, false, false, false, false);
            }
        }, new EMenuItem("Spice Dec_ks (Whole directory)..."){

            @Override
            public void run() {
                FileMenu.importLibraryCommand(FileType.SPICE, true, false, false, false);
            }
        }, new EMenuItem("Ge_rber..."){

            @Override
            public void run() {
                FileMenu.importLibraryCommand(FileType.GERBER, false, false, false, false);
            }
        }, new EMenuItem("S_UE (Schematic User Environment)..."){

            @Override
            public void run() {
                FileMenu.importLibraryCommand(FileType.SUE, false, false, true, false);
            }
        }, new EMenuItem("_Verilog..."){

            @Override
            public void run() {
                FileMenu.importLibraryCommand(FileType.VERILOG, false, false, false, false);
            }
        }, new EMenuItem("_Applicon 860..."){

            @Override
            public void run() {
                FileMenu.importLibraryCommand(FileType.APPLICON860, false, false, true, false);
            }
        }, new EMenuItem("Bookshel_f..."){

            @Override
            public void run() {
                FileMenu.importLibraryCommand(FileType.BOOKSHELF, false, false, false, false);
            }
        }, IOTool.hasDais() ? new EMenuItem("Dais (_Sun CAD)..."){

            @Override
            public void run() {
                FileMenu.importLibraryCommand(FileType.DAIS, true, false, false, false);
            }
        } : null, IOTool.hasCalibreDRV() ? new EMenuItem("Calibre DESIGNrev..."){

            @Override
            public void run() {
                FileMenu.importLibraryCommand(FileType.CALIBREDRV, false, false, true, false);
            }
        } : null, EMenuItem.SEPARATOR, new EMenuItem("ELI_B..."){

            @Override
            public void run() {
                FileMenu.importLibraryCommand(FileType.ELIB, false, false, false, false);
            }
        }, new EMenuItem("_Readable Dump..."){

            @Override
            public void run() {
                FileMenu.importLibraryCommand(FileType.READABLEDUMP, false, false, false, false);
            }
        }, Job.getDebug() ? new EMenuItem("Fast JELIB..."){

            @Override
            public void run() {
                JELIB2.newJelibReader(true, true, false, true, true);
            }
        } : null, new EMenuItem("_Text Cell Contents..."){

            @Override
            public void run() {
                TextWindow.readTextCell();
            }
        }, new EMenuItem("User _Preferences..."){

            @Override
            public void run() {
                FileMenu.importPrefsCommand();
            }
        }, new EMenuItem("Pro_ject Preferences..."){

            @Override
            public void run() {
                ProjSettings.importSettings();
            }
        }, new EMenuItem("XML Error Logger..."){

            @Override
            public void run() {
                ErrorLoggerTree.importLogger();
            }
        }), EMenuItem.SEPARATOR, new EMenuItem("_Close Library"){

            @Override
            public void run() {
                FileMenu.closeLibraryCommand(Library.getCurrent());
            }
        }, ToolBar.saveLibraryCommand, new EMenuItem("Save Library _As..."){

            @Override
            public void run() {
                if (FileMenu.checkInvariants()) {
                    FileMenu.saveAsLibraryCommand(Library.getCurrent());
                }
            }
        }, new EMenuItem("_Save All Libraries", 'S'){

            @Override
            public void run() {
                if (FileMenu.checkInvariants()) {
                    FileMenu.saveAllLibrariesCommand();
                }
            }
        }, new EMenuItem("Save All Libraries in _Format..."){

            @Override
            public void run() {
                if (FileMenu.checkInvariants()) {
                    FileMenu.saveAllLibrariesInFormatCommand();
                }
            }
        }, new EMenu("_Export", new EMenuItem("_CIF (Caltech Intermediate Format)..."){

            @Override
            public void run() {
                FileMenu.exportCommand(FileType.CIF, false);
            }
        }, new EMenuItem("_GDS II (Stream)..."){

            @Override
            public void run() {
                FileMenu.exportCommand(FileType.GDS, false);
            }
        }, new EMenuItem("GDS _Map File..."){

            @Override
            public void run() {
                GDSMap.exportMapFile();
            }
        }, new EMenuItem("E_DIF (Electronic Design Interchange Format)..."){

            @Override
            public void run() {
                FileMenu.exportCommand(FileType.EDIF, false);
            }
        }, new EMenuItem("LE_F (Library Exchange Format)..."){

            @Override
            public void run() {
                FileMenu.exportCommand(FileType.LEF, false);
            }
        }, new EMenuItem("DEF (Design Exchange Format)..."){

            @Override
            public void run() {
                FileMenu.exportCommand(FileType.DEF, false);
            }
        }, new EMenuItem("_L..."){

            @Override
            public void run() {
                FileMenu.exportCommand(FileType.L, false);
            }
        }, new EMenuItem("Boo_kshelf..."){

            @Override
            public void run() {
                FileMenu.exportCommand(FileType.BOOKSHELF, false);
            }
        }, IOTool.hasSkill() ? new EMenuItem("Skill (Cade_nce Commands)..."){

            @Override
            public void run() {
                FileMenu.exportCommand(FileType.SKILL, false);
            }
        } : null, IOTool.hasSkill() ? new EMenuItem("Skill Exports _Only (Cadence Commands)..."){

            @Override
            public void run() {
                FileMenu.exportCommand(FileType.SKILLEXPORTSONLY, false);
            }
        } : null, EMenuItem.SEPARATOR, new EMenuItem("_Eagle..."){

            @Override
            public void run() {
                FileMenu.exportCommand(FileType.EAGLE, false);
            }
        }, new EMenuItem("EC_AD..."){

            @Override
            public void run() {
                FileMenu.exportCommand(FileType.ECAD, false);
            }
        }, new EMenuItem("Ger_ber..."){

            @Override
            public void run() {
                FileMenu.exportCommand(FileType.GERBER, false);
            }
        }, new EMenuItem("Pad_s..."){

            @Override
            public void run() {
                FileMenu.exportCommand(FileType.PADS, false);
            }
        }, new EMenuItem("Teles_is..."){

            @Override
            public void run() {
                FileMenu.exportCommand(FileType.TELESIS, false);
            }
        }, new EMenuItem("DFTM..."){

            @Override
            public void run() {
                FileMenu.exportCommand(FileType.DFTM, false);
            }
        }, EMenuItem.SEPARATOR, new EMenuItem("_Text Cell Contents..."){

            @Override
            public void run() {
                TextWindow.writeTextCell();
            }
        }, new EMenuItem("_PostScript..."){

            @Override
            public void run() {
                FileMenu.exportCommand(FileType.POSTSCRIPT, false);
            }
        }, new EMenuItem("PNG (Portable Net_work Graphics)..."){

            @Override
            public void run() {
                FileMenu.exportCommand(FileType.PNG, false);
            }
        }, new EMenuItem("S_VG..."){

            @Override
            public void run() {
                FileMenu.exportCommand(FileType.SVG, false);
            }
        }, new EMenuItem("_HPGL..."){

            @Override
            public void run() {
                FileMenu.exportCommand(FileType.HPGL, false);
            }
        }, new EMenuItem("D_XF (AutoCAD)..."){

            @Override
            public void run() {
                FileMenu.exportCommand(FileType.DXF, false);
            }
        }, new EMenuItem("STL (Stereolithograph_y)..."){

            @Override
            public void run() {
                FileMenu.exportCommand(FileType.STL, false);
            }
        }, EMenuItem.SEPARATOR, new EMenuItem("ELIB (Ve_rsion 6)..."){

            @Override
            public void run() {
                FileMenu.saveLibraryCommand(Library.getCurrent(), FileType.ELIB, true, false, false);
            }
        }, new EMenuItem("_JELIB (Version 8.03)..."){

            @Override
            public void run() {
                FileMenu.saveOldJelib();
            }
        }, new EMenuItem("_User Preferences..."){

            @Override
            public void run() {
                FileMenu.exportPrefsCommand();
            }
        }, new EMenuItem("Pro_ject Preferences..."){

            @Override
            public void run() {
                ProjSettings.exportSettings();
            }
        }), EMenuItem.SEPARATOR, new EMenuItem("Change Current _Library..."){

            @Override
            public void run() {
                ChangeCurrentLib.showDialog();
            }
        }, new EMenuItem("List Li_braries"){

            @Override
            public void run() {
                CircuitChanges.listLibrariesCommand();
            }
        }, new EMenuItem("Rena_me Library..."){

            @Override
            public void run() {
                CircuitChanges.renameLibrary(Library.getCurrent());
            }
        }, new EMenuItem("Mar_k All Libraries for Saving"){

            @Override
            public void run() {
                CircuitChangeJobs.markAllLibrariesForSavingCommand();
            }
        }, new EMenu("C_heck Libraries", new EMenuItem("_Check"){

            @Override
            public void run() {
                CircuitChanges.checkAndRepairCommand(false);
            }
        }, new EMenuItem("_Repair"){

            @Override
            public void run() {
                CircuitChanges.checkAndRepairCommand(true);
            }
        }, new EMenuItem("_Find Unused Library Files"){

            @Override
            public void run() {
                CircuitChanges.findUnusedLibraryFiles();
            }
        }), EMenuItem.SEPARATOR, new EMenu("P_roject Management", new EMenuItem("_Update"){

            @Override
            public void run() {
                UpdateJob.updateProject();
            }
        }, new EMenuItem("Check _Out This Cell"){

            @Override
            public void run() {
                CheckOutJob.checkOutThisCell();
            }
        }, new EMenuItem("Check _In This Cell..."){

            @Override
            public void run() {
                CheckInJob.checkInThisCell();
            }
        }, EMenuItem.SEPARATOR, new EMenuItem("Roll_back and Release Check-Out"){

            @Override
            public void run() {
                CancelCheckOutJob.cancelCheckOutThisCell();
            }
        }, new EMenuItem("_Add This Cell"){

            @Override
            public void run() {
                AddCellJob.addThisCell();
            }
        }, new EMenuItem("_Remove This Cell"){

            @Override
            public void run() {
                DeleteCellJob.removeThisCell();
            }
        }, new EMenuItem("Show _History of This Cell..."){

            @Override
            public void run() {
                HistoryDialog.examineThisHistory();
            }
        }, EMenuItem.SEPARATOR, new EMenuItem("Get Library From Repository..."){

            @Override
            public void run() {
                LibraryDialog.getALibrary();
            }
        }, new EMenuItem("Add Current _Library To Repository"){

            @Override
            public void run() {
                AddLibraryJob.addThisLibrary();
            }
        }, new EMenuItem("Ad_d All Libraries To Repository"){

            @Override
            public void run() {
                AddLibraryJob.addAllLibraries();
            }
        }), new EMenu("C_VS", new EMenuItem[]{new EMenuItem("Commit All Open Libraries"){

            @Override
            public void run() {
                Commit.commitAllLibraries();
            }
        }, new EMenuItem("Update Open Libraries"){

            @Override
            public void run() {
                Update.updateOpenLibraries(Update.UpdateEnum.UPDATE);
            }
        }, new EMenuItem("Get Status Open Libraries"){

            @Override
            public void run() {
                Update.updateOpenLibraries(Update.UpdateEnum.STATUS);
            }
        }, new EMenuItem("List Editors Open Libraries"){

            @Override
            public void run() {
                Edit.listEditorsOpenLibraries();
            }
        }, EMenuItem.SEPARATOR, new EMenuItem("Update Project Libraries"){

            @Override
            public void run() {
                Update.updateProject(Update.UpdateEnum.UPDATE);
            }
        }, new EMenuItem("Get Status Project Libraries"){

            @Override
            public void run() {
                Update.updateProject(Update.UpdateEnum.STATUS);
            }
        }, new EMenuItem("List Editors Project Libraries"){

            @Override
            public void run() {
                Edit.listEditorsProject();
            }
        }, EMenuItem.SEPARATOR, new EMenuItem("Checkout From Repository"){

            @Override
            public void run() {
                CVS.checkoutFromRepository();
            }
        }}){

            @Override
            public boolean isEnabled() {
                return CVS.isEnabled();
            }

            @Override
            protected void registerItem() {
                super.registerItem();
                this.registerUpdatable();
            }
        }, EMenuItem.SEPARATOR, new EMenuItem("Pa_ge Setup..."){

            @Override
            public void run() {
                FileMenu.pageSetupCommand();
            }
        }, new EMenuItem("_Print..."){

            @Override
            public void run() {
                FileMenu.printCommand();
            }
        }, EMenuItem.SEPARATOR, ToolBar.preferencesCommand, EMenuItem.SEPARATOR, !ClientOS.isOSMac() ? new EMenuItem("_Quit", 'Q'){

            @Override
            public void run() {
                FileMenu.quitCommand();
            }
        } : null, new EMenuItem("Force Q_uit (and Save)"){

            @Override
            public void run() {
                FileMenu.forceQuit();
            }
        });
    }

    public static void newLibraryCommand() {
        String newLibName = JOptionPane.showInputDialog("New Library Name", (Object)"");
        if (newLibName == null) {
            return;
        }
        new NewLibrary(newLibName);
    }

    public static void openLibraryCommand() {
        String fileName = OpenFile.chooseInputFile(FileType.LIBRARYFORMATS, null, null);
        if (fileName != null) {
            URL fileURL = TextUtils.makeURLToFile(fileName);
            String libName = TextUtils.getFileNameWithoutExtension(fileURL);
            Library deleteLib = Library.findLibrary(libName);
            RenameAndSaveLibraryTask saveTask = null;
            if (deleteLib != null) {
                Collection<RenameAndSaveLibraryTask> librariesToSave = FileMenu.preventLoss(deleteLib, 2, null);
                if (librariesToSave == null) {
                    return;
                }
                if (!librariesToSave.isEmpty()) {
                    assert (librariesToSave.size() == 1);
                    saveTask = librariesToSave.iterator().next();
                    assert (saveTask.libId == deleteLib.getId());
                }
                WindowFrame.removeLibraryReferences(deleteLib);
            }
            FileType type = FileMenu.getLibraryFormat(fileName, FileType.DEFAULTLIB);
            new ReadLibrary(fileURL, type, TextUtils.getFilePath(fileURL), deleteLib, saveTask, null);
        }
    }

    public static void openLibraryCommand(URL file) {
        Serializable f;
        String fileName = file.getFile();
        FileType defType = FileMenu.getLibraryFormat(fileName, null);
        if (defType == null && TextUtils.URLExists((URL)(f = TextUtils.makeURLToFile(fileName + "." + FileType.JELIB.getFirstExtension())), null)) {
            defType = FileType.JELIB;
            file = f;
        }
        if (defType == null && TextUtils.URLExists((URL)(f = TextUtils.makeURLToFile(fileName + "." + FileType.ELIB.getFirstExtension())), null)) {
            defType = FileType.ELIB;
            file = f;
        }
        if (defType == null && TextUtils.URLExists((URL)(f = TextUtils.makeURLToFile(fileName + "." + FileType.DELIB.getFirstExtension())), null)) {
            defType = FileType.DELIB;
            file = f;
        }
        if (defType == null && TextUtils.URLExists((URL)(f = TextUtils.makeURLToFile(fileName + "." + FileType.READABLEDUMP.getFirstExtension())), null)) {
            defType = FileType.READABLEDUMP;
            file = f;
        }
        if (defType == null) {
            defType = FileType.DEFAULTLIB;
        }
        f = new File(file.getPath());
        if (defType != FileType.DELIB && ((File)f).isDirectory()) {
            System.out.println("The filename provided is not a valid Electric's library: '" + fileName + "'.");
        } else {
            new ReadLibrary((URL)file, defType, TextUtils.getFilePath(file), null, null, null);
        }
    }

    public static FileType getLibraryFormat(String fileName, FileType defaultType) {
        return FileType.getLibraryFormat(fileName, defaultType);
    }

    private static void convertVarsToModelFiles(Collection<Library> newLibs) {
        for (Library lib : newLibs) {
            Iterator<Cell> it = lib.getCells();
            while (it.hasNext()) {
                String verilogModelFile;
                Cell cell = it.next();
                String spiceModelFile = cell.getVarValue(Spice.SPICE_MODEL_FILE_KEY, String.class);
                if (spiceModelFile != null) {
                    CellModelPrefs.spiceModelPrefs.setModelFile(cell, spiceModelFile, false, false, false);
                }
                if ((verilogModelFile = cell.getVarValue(Verilog.VERILOG_BEHAVE_FILE_KEY, String.class)) == null) continue;
                CellModelPrefs.verilogModelPrefs.setModelFile(cell, verilogModelFile, false, false, false);
            }
        }
    }

    public static void updateRecentlyOpenedLibrariesList() {
        String[] recentLibs = User.getRecentlyOpenedLibraries();
        ArrayList<EMenuItem> list = new ArrayList<EMenuItem>();
        for (int i = 0; i < recentLibs.length; ++i) {
            EMenuItem menu = new EMenuItem(recentLibs[i], null, false){

                @Override
                public void run() {
                    FileMenu.openLibraryCommand(TextUtils.makeURLToFile(this.getText()));
                    File f = new File(this.getText());
                    if (f.exists()) {
                        User.setWorkingDirectory(f.getParent());
                        FileType.LIBRARYFORMATS.setGroupPath(f.getParent());
                    }
                }

                @Override
                protected void updateButtons() {
                }
            };
            list.add(menu);
        }
        if (list.size() == 0) {
            EMenuItem menu = new EMenuItem("<none>"){

                @Override
                public void run() {
                }
            };
            list.add(menu);
        }
        openRecentLibs.setDynamicItems(list);
    }

    private static void doneOpeningLibrary(final Cell cell) {
        if (cell == null) {
            System.out.println("No current cell in this library");
        } else {
            CreateCellWindow creator = new CreateCellWindow(cell);
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(creator);
            } else {
                creator.run();
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WindowFrame.wantToRedoLibraryTree();
                WindowFrame.wantToOpenCurrentLibrary(true, cell);
            }
        });
    }

    public static void importLibraryCommand(FileType type, boolean wholeDirectory, boolean canMerge, boolean techSpecific, boolean skeletonize) {
        String fileName = null;
        fileName = wholeDirectory ? OpenFile.chooseInputFile(type, null, true, User.getWorkingDirectory(), true, null) : OpenFile.chooseInputFile(type, null, null);
        if (fileName == null) {
            return;
        }
        FileMenu.importLibraryCommandNoGUI(fileName, type, canMerge, techSpecific, skeletonize);
    }

    public static void importLibraryCommandNoGUI(String fileName, FileType type, boolean canMerge, boolean techSpecific, boolean skeletonize) {
        URL fileURL = TextUtils.makeURLToFile(fileName);
        String libName = TextUtils.getFileNameWithoutExtension(fileURL);
        Library deleteLib = Library.findLibrary(libName);
        Library libToRead = null;
        RenameAndSaveLibraryTask saveTask = null;
        if (deleteLib != null) {
            Collection<RenameAndSaveLibraryTask> librariesToSave;
            MutableBoolean wantToMerge = null;
            if (canMerge) {
                wantToMerge = new MutableBoolean(false);
            }
            if ((librariesToSave = FileMenu.preventLoss(deleteLib, 2, wantToMerge)) == null) {
                return;
            }
            if (canMerge && wantToMerge.booleanValue()) {
                libToRead = deleteLib;
                deleteLib = null;
            } else {
                if (!librariesToSave.isEmpty()) {
                    assert (librariesToSave.size() == 1);
                    saveTask = librariesToSave.iterator().next();
                    assert (saveTask.libId == deleteLib.getId());
                }
                WindowFrame.removeLibraryReferences(deleteLib);
            }
        }
        Technology tech = null;
        if (techSpecific) {
            ArrayList<Technology> layoutTechnologies = new ArrayList<Technology>();
            String curTech = null;
            Iterator<Technology> it = Technology.getTechnologies();
            while (it.hasNext()) {
                Technology t = it.next();
                if (!t.isLayout()) continue;
                if (t == Technology.getCurrent()) {
                    curTech = t.getTechName();
                }
                layoutTechnologies.add(t);
            }
            if (curTech == null) {
                curTech = User.getSchematicTechnology().getTechName();
            }
            Object[] techArray = new String[layoutTechnologies.size()];
            for (int i = 0; i < layoutTechnologies.size(); ++i) {
                techArray[i] = ((Technology)layoutTechnologies.get(i)).getTechName();
            }
            String chosen = (String)JOptionPane.showInputDialog(TopLevel.getCurrentJFrame(), "Which layout technology should be used to import the file:", "Choose Technology", 3, null, techArray, curTech);
            if (chosen == null) {
                return;
            }
            tech = Technology.findTechnology(chosen);
        }
        if (type == FileType.ELIB || type == FileType.READABLEDUMP) {
            new ReadLibrary(fileURL, type, null, deleteLib, saveTask, null);
        } else {
            new ImportLibrary(fileURL, type, libToRead, deleteLib, tech, saveTask, skeletonize);
        }
    }

    public static void closeLibraryCommand(Library lib) {
        if (lib == null) {
            return;
        }
        Set<Cell> found = Library.findReferenceInCell(lib);
        boolean clearClipboard = false;
        boolean nonClipboard = false;
        for (Cell cell : found) {
            if (cell.getLibrary().isHidden()) {
                clearClipboard = true;
                continue;
            }
            nonClipboard = true;
        }
        if (nonClipboard) {
            System.out.println("Cannot close " + lib + ":");
            System.out.print("\t Cells ");
            for (Cell cell : found) {
                System.out.print("'" + cell.getName() + "'(" + cell.getLibrary().getName() + ") ");
            }
            System.out.println("refer to it.");
            return;
        }
        RenameAndSaveLibraryTask saveTask = null;
        Collection<RenameAndSaveLibraryTask> librariesToSave = FileMenu.preventLoss(lib, 1, null);
        if (librariesToSave == null) {
            return;
        }
        if (!librariesToSave.isEmpty()) {
            assert (librariesToSave.size() == 1);
            saveTask = librariesToSave.iterator().next();
            assert (saveTask.libId == lib.getId());
        }
        WindowFrame.removeLibraryReferences(lib);
        new CloseLibrary(lib, saveTask, clearClipboard);
    }

    public static boolean saveLibraryCommand(Library lib) {
        return lib != null && FileMenu.saveLibraryCommand(lib, FileType.DEFAULTLIB, false, true, false);
    }

    public static boolean saveLibraryCommand(Library lib, FileType type, boolean compatibleWith6, boolean forceToType, boolean saveAs) {
        RenameAndSaveLibraryTask task = FileMenu.saveLibraryRequest(lib, type, compatibleWith6, forceToType, saveAs);
        if (task == null) {
            return false;
        }
        new SaveLibrary(task);
        return true;
    }

    public static RenameAndSaveLibraryTask saveLibraryRequest(Library lib, FileType type, boolean compatibleWith6, boolean forceToType, boolean saveAs) {
        ArrayList<String> dummyCells = new ArrayList<String>();
        dummyCells.add("WARNING: " + lib + " contains the following Dummy cells:");
        Iterator<Cell> it = lib.getCells();
        while (it.hasNext()) {
            Cell c = it.next();
            if (c.getVar(LibraryFiles.IO_DUMMY_OBJECT) == null) continue;
            dummyCells.add("   " + c.noLibDescribe());
        }
        if (dummyCells.size() > 1) {
            dummyCells.add("Do you really want to write this library?");
            String[] options = new String[]{"Continue Writing", "Cancel"};
            String message = ((Object)dummyCells).toString();
            int val = Job.getUserInterface().askForChoice(message, "Dummy Cells Found in " + lib, options, options[1]);
            if (val == 1) {
                return null;
            }
        }
        String extension2 = type.getFirstExtension();
        String fileName = null;
        if (!saveAs && lib.isFromDisk()) {
            File file;
            if (type == FileType.JELIB || type == FileType.DELIB || type == FileType.ELIB && !compatibleWith6) {
                fileName = lib.getLibFile().getPath();
                if (forceToType) {
                    type = OpenFile.getOpenFileType(fileName, FileType.DEFAULTLIB);
                }
            }
            if (fileName != null && (file = new File(fileName)).exists() && !file.canWrite()) {
                fileName = null;
            }
        }
        if (fileName == null) {
            fileName = OpenFile.chooseOutputFile(FileType.libraryTypes, null, lib.getName() + "." + extension2);
            if (fileName == null) {
                return null;
            }
            type = FileMenu.getLibraryFormat(fileName, type);
        }
        return RenameAndSaveLibraryTask.createRenameAndSaveLibraryTask(lib, fileName, type, compatibleWith6, IOTool.getBackupRedundancy());
    }

    private static void saveOldJelib() {
        String currentDir = User.getWorkingDirectory();
        System.out.println("Saving libraries in oldJelib directory under " + currentDir);
        System.out.flush();
        File oldJelibDir = new File(currentDir, "oldJelib");
        if (!oldJelibDir.exists() && !oldJelibDir.mkdir()) {
            JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), new String[]{"Could not create oldJelib directory", oldJelibDir.getAbsolutePath()}, "Error creating oldJelib directory", 0);
            return;
        }
        Output.writePanicSnapshot(EDatabase.clientDatabase().backup(), oldJelibDir, true);
    }

    public static void saveAsLibraryCommand(Library lib) {
        if (lib == null) {
            System.out.println("No library to save");
            return;
        }
        FileMenu.saveLibraryCommand(lib, FileType.DEFAULTLIB, false, true, true);
        WindowFrame.wantToRedoTitleNames();
    }

    public static void saveAllLibrariesCommand() {
        FileMenu.saveAllLibrariesCommand(FileType.DEFAULTLIB, false, true);
    }

    public static void saveAllLibrariesCommand(FileType type, boolean compatibleWith6, boolean forceToType) {
        HashMap<Library, FileType> libsToSave = new HashMap<Library, FileType>();
        Iterator<Library> it = Library.getLibraries();
        while (it.hasNext()) {
            Library lib = it.next();
            if (lib.isHidden() || !lib.isChanged()) continue;
            if (lib.getLibFile() != null) {
                type = FileMenu.getLibraryFormat(lib.getLibFile().getFile(), type);
            }
            libsToSave.put(lib, type);
        }
        boolean justSkip = false;
        Iterator it2 = libsToSave.keySet().iterator();
        while (it2.hasNext()) {
            Library lib = (Library)it2.next();
            if (FileMenu.saveLibraryCommand(lib, type = (FileType)libsToSave.get(lib), compatibleWith6, forceToType, false) || justSkip) continue;
            if (!it2.hasNext()) break;
            Object[] options = new String[]{"Cancel", "Skip this Library"};
            int ret = JOptionPane.showOptionDialog(TopLevel.getCurrentJFrame(), "Cancel all library saving, or just skip saving this library?", "Save Cancelled", -1, 3, null, options, "Cancel");
            if (ret != 1) break;
            justSkip = true;
        }
    }

    public static void saveAllLibrariesInFormatCommand() {
        Object[] formats = new Object[]{FileType.JELIB, FileType.ELIB, FileType.READABLEDUMP, FileType.DELIB};
        Object format2 = JOptionPane.showInputDialog(TopLevel.getCurrentJFrame(), "Output file format for all libraries:", "Save All Libraries In Format...", -1, null, formats, FileType.DEFAULTLIB);
        if (format2 == null) {
            return;
        }
        FileType outType = (FileType)format2;
        new SaveAllLibrariesInFormatJob(outType);
    }

    public static void importPrefsCommand() {
        String fileName = OpenFile.chooseInputFile(FileType.PREFS, "Saved Preferences", null);
        if (fileName == null) {
            return;
        }
        UserInterfaceMain.importPrefs(TextUtils.makeURLToFile(fileName));
    }

    public static void exportPrefsCommand() {
        String fileName = OpenFile.chooseOutputFile(FileType.PREFS, "Saved Preferences", "electricPrefs.xml");
        if (fileName == null) {
            return;
        }
        Pref.exportPrefs(fileName);
    }

    private static boolean checkInvariants() {
        return true;
    }

    public static void exportCommand(FileType type, boolean isNetlist) {
        WindowContent wnd;
        if (type == FileType.POSTSCRIPT && PostScript.syncAll(UserInterfaceMain.getEditingPreferences())) {
            return;
        }
        WindowFrame wf = WindowFrame.getCurrentWindowFrame(false);
        WindowContent windowContent = wnd = wf != null ? wf.getContent() : null;
        if (wnd == null) {
            System.out.println("No current window");
            return;
        }
        Cell cell = wnd.getCell();
        if (cell == null) {
            System.out.println("No cell in this window");
            return;
        }
        VarContext context = wnd instanceof EditWindow ? ((EditWindow)wnd).getVarContext() : null;
        List<PolyBase> override = null;
        if (type == FileType.POSTSCRIPT) {
            if (cell.getView() == View.DOC) {
                String msg = "Document cells can't be exported as postscript.\n";
                System.out.print(msg);
                JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), msg + "Try \"Export -> Text Cell Contents\"", "Exporting PS", 0);
                return;
            }
            if (!(wnd instanceof EditWindow)) {
                String msg = "This type of window can't be exported as postscript.\n";
                System.out.print(msg);
                JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), msg + "Try \"Export -> PNG (Portable Network Graphcs)\"", "Exporting PS", 0);
                return;
            }
            if (IOTool.isPrintEncapsulated()) {
                type = FileType.EPS;
            }
            if (wnd instanceof WaveformWindow) {
                WaveformWindow ww = (WaveformWindow)wnd;
                override = ww.getPolysForPrinting();
            }
        }
        String rootName = type == FileType.GDS && IOTool.isGDSWritesEntireLibrary() ? cell.getLibrary().getName() : cell.getName();
        String filePath = rootName + "." + type.getFirstExtension();
        if (type == FileType.SPICE && !SimulationTool.getSpiceRunChoice().equals("Don't Run")) {
            filePath = SimulationTool.getSpiceUseRunDir() ? SimulationTool.getSpiceRunDir() + File.separator + filePath : User.getWorkingDirectory() + File.separator + filePath;
            if (User.isShowFileSelectionForNetlists() && !SimulationTool.getSpiceOutputOverwrite()) {
                String saveDir = User.getWorkingDirectory();
                filePath = OpenFile.chooseOutputFile(type, null, filePath);
                User.setWorkingDirectory(saveDir);
                if (filePath == null) {
                    return;
                }
            }
            Output.exportCellCommand(cell, context, filePath, type, override);
            return;
        }
        if (type == FileType.TELESIS) {
            filePath = OpenFile.chooseDirectory("Telesis Output");
        } else if (User.isShowFileSelectionForNetlists() || !isNetlist) {
            if ((filePath = OpenFile.chooseOutputFile(type, null, filePath)) == null) {
                return;
            }
        } else {
            filePath = User.getWorkingDirectory() + File.separator + filePath;
        }
        if (type == FileType.PNG) {
            new ExportImage(cell, wnd, filePath, false);
            return;
        }
        Output.exportCellCommand(cell, context, filePath, type, override);
    }

    public static void pageSetupCommand() {
        PrinterJob pj = PrinterJob.getPrinterJob();
        pageFormat = pageFormat == null ? pj.pageDialog(pj.defaultPage()) : pj.pageDialog(pageFormat);
    }

    private static ElectricPrinter getOutputPreferences(WindowContent context, PrinterJob pj) {
        if (pageFormat == null) {
            pageFormat = pj.defaultPage();
            pageFormat.setOrientation(0);
            pageFormat = pj.validatePage(pageFormat);
        }
        ElectricPrinter ep = new ElectricPrinter(context, pageFormat, pj);
        pj.setPrintable(ep, pageFormat);
        return ep;
    }

    public static void printCommand() {
        HashPrintRequestAttributeSet aset;
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            System.out.println("No current window to print");
            return;
        }
        if (!(wf.getContent() instanceof EditWindow)) {
            String message = "Can't print from a non-EditWindow.";
            System.out.println(message);
            JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), message, "Printing Cell", 0);
            return;
        }
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        PrinterJob pj = PrinterJob.getPrinterJob();
        pj.setJobName(wf.getTitle());
        PrintService[] printers = new PrintService[]{};
        try {
            SecurityManager secman = System.getSecurityManager();
            secman.checkPrintJobAccess();
            printers = PrintServiceLookup.lookupPrintServices(null, null);
        }
        catch (Exception e) {
            // empty catch block
        }
        String pName = IOTool.getPrinterName();
        PrintService printerToUse = null;
        for (PrintService printer : printers) {
            if (!pName.equals(printer.getName())) continue;
            printerToUse = printer;
            break;
        }
        if (printerToUse != null) {
            try {
                pj.setPrintService(printerToUse);
            }
            catch (PrinterException e) {
                System.out.println("Printing error " + e);
            }
        }
        if (pj.printDialog(aset = new HashPrintRequestAttributeSet())) {
            JPanel overall = wf.getContent().getPanel();
            RepaintManager currentManager = RepaintManager.currentManager(overall);
            currentManager.setDoubleBufferingEnabled(false);
            ElectricPrinter ep = FileMenu.getOutputPreferences(wf.getContent(), pj);
            Dimension oldSize = overall.getSize();
            ep.setOldSize(oldSize);
            EditWindow_ wnd = null;
            if (wf.getContent() instanceof EditWindow) {
                wnd = (EditWindow_)((Object)wf.getContent());
            }
            Rectangle2D printBounds = Output.getAreaToPrint(cell, false, wnd);
            ep.setRenderArea(printBounds);
            if (!wf.getContent().initializePrinting(ep, pageFormat)) {
                String message = "Problems initializing printers. Check printer setup.";
                System.out.println(message);
                JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), message, "Printing Cell", 0);
                return;
            }
            printerToUse = pj.getPrintService();
            if (printerToUse != null) {
                IOTool.setPrinterName(printerToUse.getName());
            }
            SwingUtilities.invokeLater(new PrintJobAWT(wf, pj, oldSize, aset));
        }
    }

    public static boolean quitCommand() {
        Collection<RenameAndSaveLibraryTask> saveTasks = FileMenu.preventLoss(null, 0, null);
        if (saveTasks == null) {
            return true;
        }
        try {
            new QuitJob(saveTasks);
        }
        catch (NoClassDefFoundError e) {
            return true;
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static Collection<RenameAndSaveLibraryTask> preventLoss(Library desiredLib, int action, MutableBoolean wantToMerge) {
        ArrayList<RenameAndSaveLibraryTask> librariesToSave = new ArrayList<RenameAndSaveLibraryTask>();
        boolean checkedInvariants = false;
        Iterator<Library> it = Library.getLibraries();
        while (it.hasNext()) {
            Object[] options;
            Library lib = it.next();
            if (desiredLib != null && desiredLib != lib || lib.isHidden() || (wantToMerge == null || wantToMerge.booleanValue()) && !lib.isChanged()) continue;
            if (!checkedInvariants) {
                if (!FileMenu.checkInvariants()) {
                    return null;
                }
                checkedInvariants = true;
            }
            String theAction = "Save before quitting?";
            if (action == 1) {
                theAction = "Save before closing?";
            } else if (action == 2) {
                theAction = "Save before replacing?";
            }
            if (wantToMerge != null) {
                theAction = theAction + " (click 'Merge' to combine the new data with the existing library)";
                options = new String[]{"Yes", "No", "Cancel", "No to All", "Merge"};
            } else {
                options = new String[]{"Yes", "No", "Cancel", "No to All"};
            }
            int ret = FileMenu.showFileMenuOptionDialog(TopLevel.getCurrentJFrame(), "Library '" + lib.getName() + "' has changed.  " + theAction, "Save Library?", -1, 2, null, options, options[0], null);
            if (ret == 0) {
                RenameAndSaveLibraryTask saveTask = FileMenu.saveLibraryRequest(lib, FileType.DEFAULTLIB, false, true, false);
                if (saveTask == null) continue;
                librariesToSave.add(saveTask);
                continue;
            }
            if (ret == 1) continue;
            if (ret == 2 || ret == -1) {
                return null;
            }
            if (ret == 3) break;
            if (ret != 4) continue;
            wantToMerge.setValue(true);
        }
        return librariesToSave;
    }

    public static int showFileMenuOptionDialog(Component parentComponent, Object message, String title, int optionType, int messageType, Icon icon, Object[] options, Object initialValue, String toolTipMessage) throws HeadlessException {
        JOptionPane pane = new JOptionPane(message, messageType, optionType, icon, options, initialValue);
        pane.setInitialValue(initialValue);
        pane.setComponentOrientation((parentComponent == null ? JOptionPane.getRootFrame() : parentComponent).getComponentOrientation());
        pane.setMessageType(messageType);
        JDialog dialog = pane.createDialog(parentComponent, title);
        pane.selectInitialValue();
        pane.setToolTipText(toolTipMessage);
        dialog.setVisible(true);
        dialog.dispose();
        Object selectedValue = pane.getValue();
        if (selectedValue == null) {
            return -1;
        }
        if (options == null) {
            if (selectedValue instanceof Integer) {
                return (Integer)selectedValue;
            }
            return -1;
        }
        int maxCounter = options.length;
        for (int counter = 0; counter < maxCounter; ++counter) {
            if (!options[counter].equals(selectedValue)) continue;
            return counter;
        }
        return -1;
    }

    public static void forceQuit() {
        int i;
        boolean dirty = false;
        Iterator<Library> it = Library.getLibraries();
        while (it.hasNext()) {
            Library lib = it.next();
            if (lib.isHidden() || !lib.isChanged()) continue;
            dirty = true;
            break;
        }
        if (dirty) {
            Object[] options = new String[]{"Force Save and Quit", "Cancel", "Quit without Saving"};
            int i2 = JOptionPane.showOptionDialog(TopLevel.getCurrentJFrame(), new String[]{"Warning!  Libraries Changed!  Saving changes now may create bad libraries!"}, "Force Quit", -1, 2, null, options, options[1]);
            if (i2 == 0) {
                if (!FileMenu.forceSave(false)) {
                    JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Error during forced library save, not quiting", "Saving Failed", 0);
                    return;
                }
                ActivityLogger.finished();
                System.exit(1);
            }
            if (i2 == 1) {
                return;
            }
            if (i2 == 2) {
                ActivityLogger.finished();
                System.exit(1);
            }
        }
        if ((i = JOptionPane.showConfirmDialog(TopLevel.getCurrentJFrame(), new String[]{"Warning! You are about to kill Electric!", "Do you really want to force quit?"}, "Force Quit", 0, 2)) == 0) {
            ActivityLogger.finished();
            System.exit(1);
        }
    }

    public static boolean forceSave(boolean confirm) {
        boolean ok;
        if (confirm) {
            Object[] options = new String[]{"Cancel", "Force Save"};
            int i = JOptionPane.showOptionDialog(TopLevel.getCurrentJFrame(), new String[]{"Warning! Saving changes now may create bad libraries!", "Libraries will be saved to \"Panic\" directory in current directory", "Do you really want to force save?"}, "Force Save", -1, 2, null, options, options[0]);
            if (i == 0) {
                return false;
            }
        }
        String currentDir = User.getWorkingDirectory();
        System.out.println("Saving libraries in panic directory under " + currentDir);
        System.out.flush();
        File panicDir = new File(currentDir, "panic");
        if (!panicDir.exists() && !panicDir.mkdir()) {
            JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), new String[]{"Could not create panic directory", panicDir.getAbsolutePath()}, "Error creating panic directory", 0);
            return false;
        }
        Snapshot panicSnapshot = Job.findValidSnapshot();
        boolean bl = ok = !Output.writePanicSnapshot(panicSnapshot, panicDir, false);
        if (ok) {
            JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), new String[]{"Libraries are saved to panic directory", panicDir.getAbsolutePath()}, "Libraries are saved", 1);
        }
        return ok;
    }

    static {
        pageFormat = null;
    }

    static class CellMouseMotionAdapter
    extends MouseMotionAdapter {
        JOptionPane pane;

        CellMouseMotionAdapter(JOptionPane p) {
            this.pane = p;
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            System.out.println(" Point " + this.pane.getToolTipLocation(e));
        }
    }

    public static class QuitJob
    extends Job {
        private Collection<RenameAndSaveLibraryTask> saveTasks;

        public QuitJob(Collection<RenameAndSaveLibraryTask> saveTasks) {
            super("Quitting", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.saveTasks = saveTasks;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            for (RenameAndSaveLibraryTask saveTask : this.saveTasks) {
                saveTask.renameAndSave();
            }
            this.fieldVariableChanged("saveTasks");
            return true;
        }

        @Override
        public void terminateOK() {
            block3: {
                for (RenameAndSaveLibraryTask saveTask : this.saveTasks) {
                    saveTask.librarySaved();
                }
                try {
                    this.getDatabase().saveExpandStatus();
                    Pref.getPrefRoot().flush();
                }
                catch (BackingStoreException e) {
                    int response = JOptionPane.showConfirmDialog(TopLevel.getCurrentJFrame(), "Cannot save cell expand status. Do you still want to quit?", "Cell Status Error", 0, 2);
                    if (response == 0) break block3;
                    return;
                }
            }
            LayerVisibility.preserveVisibility();
            WaveformWindow.preserveSignalOrder();
            ActivityLogger.finished();
            System.exit(0);
        }
    }

    public static class ClearCellDate
    extends Job {
        private String cellName;
        private Cell cell;

        public ClearCellDate(String cellName) {
            super("Clear Cell Dates", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cellName = cellName;
            this.startJob();
        }

        public ClearCellDate(Cell cell) {
            super("Clear Cell Dates", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            if (this.cell == null && this.cellName != null) {
                this.cell = (Cell)Cell.findNodeProto(this.cellName);
            }
            if (this.cell != null) {
                this.cell.lowLevelSetRevisionDate(new Date(0L));
                this.cell.lowLevelSetCreationDate(new Date(0L));
            }
            return true;
        }
    }

    private static class PrintJobAWT
    implements Runnable {
        private WindowFrame wf;
        private PrinterJob pj;
        private Dimension oldSize;
        private PrintRequestAttributeSet aset;

        PrintJobAWT(WindowFrame wf, PrinterJob pj, Dimension oldSize, PrintRequestAttributeSet aset) {
            this.wf = wf;
            this.pj = pj;
            this.oldSize = oldSize;
            this.aset = aset;
        }

        @Override
        public void run() {
            try {
                System.out.println("Printing '" + this.pj.getJobName() + "' ...");
                this.pj.print(this.aset);
            }
            catch (PrinterException pe) {
                System.out.println("Print aborted.");
            }
            JPanel overall = this.wf.getContent().getPanel();
            RepaintManager currentManager = RepaintManager.currentManager(overall);
            currentManager.setDoubleBufferingEnabled(true);
            if (this.oldSize != null) {
                overall.setSize(this.oldSize);
                overall.validate();
            }
        }
    }

    public static class ExportImage
    extends Job {
        private Cell cell;
        private String filePath;
        private WindowContent wc;
        ElectricPrinter ep;

        public ExportImage(Cell cell, WindowContent wc, String filePath, boolean doNow) {
            super("Export " + cell.toString() + " (PNG)", User.getUserTool(), Job.Type.CLIENT_EXAMINE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.wc = wc;
            this.filePath = filePath;
            PrinterJob pj = PrinterJob.getPrinterJob();
            this.ep = FileMenu.getOutputPreferences(wc, pj);
            if (doNow) {
                try {
                    this.doIt();
                }
                catch (JobException e) {}
            } else {
                this.startJob();
            }
        }

        @Override
        public boolean doIt() throws JobException {
            if (this.wc == null) {
                Rectangle2D cellBounds = this.ep.getRenderArea();
                if (cellBounds == null) {
                    cellBounds = this.cell.getBounds();
                }
                LayerVisibility lv = new LayerVisibility(true);
                BufferedImage img = EditWindow.getPrintImageFromData(this.ep, null, cellBounds, this.cell, null, lv);
                PNG.writeImage(img, this.filePath);
            } else {
                this.wc.writeImage(this.ep, this.filePath);
            }
            return true;
        }
    }

    public static class SaveAllLibrariesInFormatJob
    extends Job {
        private FileType outType;

        public SaveAllLibrariesInFormatJob(FileType outType) {
            super("Save All Libraries", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.outType = outType;
            this.startJob();
        }

        @Override
        public boolean doIt() {
            Iterator<Library> it = Library.getLibraries();
            while (it.hasNext()) {
                Library lib = it.next();
                if (lib.isHidden() || !lib.isFromDisk()) continue;
                if (lib.getLibFile() != null) {
                    String fullName = lib.getLibFile().getFile();
                    fullName = fullName.replaceAll("\\.\\w*?$", "." + this.outType.getFirstExtension());
                    lib.setLibFile(TextUtils.makeURLToFile(fullName));
                }
                lib.setChanged();
            }
            FileMenu.saveAllLibrariesCommand(this.outType, false, false);
            return true;
        }
    }

    public static class RenameAndSaveLibraryTask
    implements Serializable {
        private LibId libId;
        private String newName;
        private FileType type;
        private boolean compatibleWith6;
        private int backupScheme;
        private URL libFile;
        private List<String> deletedCellFiles;
        private List<String> writtenCellFiles;

        private RenameAndSaveLibraryTask(Library lib, String newName, FileType type, boolean compatibleWith6, int backupScheme) {
            this.libId = lib.getId();
            this.newName = newName;
            this.type = type;
            this.compatibleWith6 = compatibleWith6;
            this.backupScheme = backupScheme;
        }

        public static RenameAndSaveLibraryTask createRenameAndSaveLibraryTask(Library lib, String newName, FileType type, boolean compatibleWith6, int backupScheme) {
            return new RenameAndSaveLibraryTask(lib, newName, type, compatibleWith6, backupScheme);
        }

        public IdMapper renameAndSave() throws JobException {
            IdMapper idMapper = null;
            boolean success = false;
            try {
                Library lib = EDatabase.serverDatabase().getLib(this.libId);
                if (this.newName != null) {
                    URL libURL = TextUtils.makeURLToFile(this.newName);
                    lib.setLibFile(libURL);
                    idMapper = lib.setName(TextUtils.getFileNameWithoutExtension(libURL));
                    if (idMapper != null) {
                        this.libId = idMapper.get(lib.getId());
                        lib = EDatabase.serverDatabase().getLib(this.libId);
                    }
                }
                this.libFile = lib.getLibFile();
                this.deletedCellFiles = new ArrayList<String>();
                this.writtenCellFiles = new ArrayList<String>();
                Output.writeLibrary(lib, this.type, this.compatibleWith6, false, false, this.backupScheme, this.deletedCellFiles, this.writtenCellFiles);
                success = true;
            }
            catch (Exception e) {
                if (Job.getDebug()) {
                    e.printStackTrace(System.out);
                }
                throw new JobException("Exception caught when saving files: " + e.getMessage() + ". Please check your disk libraries");
            }
            if (!success) {
                throw new JobException("Error saving files.  Please check your disk libraries");
            }
            return idMapper;
        }

        private void librarySaved() {
            if (!CVS.isEnabled()) {
                return;
            }
            CVSLibrary.savedLibrary(this.libId, this.libFile, this.deletedCellFiles, this.writtenCellFiles);
        }
    }

    private static class SaveLibrary
    extends Job {
        private RenameAndSaveLibraryTask task;
        private IdMapper idMapper;

        public SaveLibrary(RenameAndSaveLibraryTask task) {
            super("Write " + ((RenameAndSaveLibraryTask)task).libId.libName, User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.task = task;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            this.idMapper = this.task.renameAndSave();
            this.fieldVariableChanged("task");
            this.fieldVariableChanged("idMapper");
            return true;
        }

        @Override
        public void terminateOK() {
            this.task.librarySaved();
            User.fixStaleCellReferences(this.idMapper);
        }
    }

    private static class CloseLibrary
    extends Job {
        private Library lib;
        private RenameAndSaveLibraryTask saveTask;
        private boolean clearClipboard;

        public CloseLibrary(Library lib, RenameAndSaveLibraryTask saveTask, boolean clearClipboard) {
            super("Close " + lib, User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.lib = lib;
            this.saveTask = saveTask;
            this.clearClipboard = clearClipboard;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            if (this.clearClipboard) {
                Clipboard.clear();
            }
            if (this.saveTask != null) {
                assert (this.lib.getId() == this.saveTask.libId);
                this.saveTask.renameAndSave();
                this.fieldVariableChanged("saveTask");
                this.lib = this.getDatabase().getLib(this.saveTask.libId);
            }
            if (this.lib.kill("delete")) {
                System.out.println("Library '" + this.lib.getName() + "' closed");
            }
            return true;
        }

        @Override
        public void terminateOK() {
            List<Library> remainingLibs;
            if (this.saveTask != null) {
                this.saveTask.librarySaved();
            }
            if (Library.getCurrent() == null && (remainingLibs = Library.getVisibleLibraries()).size() > 0) {
                User.setCurrentLibrary(remainingLibs.get(0));
            }
            WindowFrame.wantToRedoTitleNames();
            EditWindow.repaintAll();
            ToolBar.setSaveLibraryButton();
        }
    }

    public static class CreateCellWindow
    implements Runnable {
        private Cell cell;

        public CreateCellWindow(Cell cell) {
            this.cell = cell;
        }

        @Override
        public void run() {
            Iterator<WindowFrame> it = WindowFrame.getWindows();
            while (it.hasNext()) {
                WindowFrame wf = it.next();
                WindowContent content = wf.getContent();
                Cell c = content.getCell();
                if (c == null) {
                    wf.setCellWindow(this.cell, null);
                    ToolBar.setSaveLibraryButton();
                    return;
                }
                if (!c.getName().equals(this.cell.getName())) continue;
                return;
            }
            WindowFrame.createEditWindow(this.cell);
            ToolBar.setSaveLibraryButton();
        }
    }

    public static class ImportLibrary
    extends Job {
        private URL fileURL;
        private FileType type;
        private Library curLib;
        private Library deleteLib;
        private RenameAndSaveLibraryTask saveTask;
        private boolean skeletonize;
        private Input.InputPreferences prefs;
        private Library createLib;
        private Technology tech;
        private Map<Library, Cell> currentCells = new HashMap<Library, Cell>();
        private Map<CellId, BitSet> nodesToExpand = new HashMap<CellId, BitSet>();

        public ImportLibrary(URL fileURL, FileType type, Library libToRead, Library deleteLib, Technology tech, RenameAndSaveLibraryTask saveTask, boolean skeletonize) {
            super("Import External Library", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            Cell curCell;
            this.fileURL = fileURL;
            this.type = type;
            this.curLib = libToRead;
            this.deleteLib = deleteLib;
            this.tech = tech == null ? Technology.getCurrent() : tech;
            this.saveTask = saveTask;
            this.skeletonize = skeletonize;
            if (this.curLib != null && (curCell = this.curLib.getCurCell()) != null) {
                this.currentCells.put(this.curLib, curCell);
            }
            this.prefs = Input.getInputPreferences(type, false);
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            if (this.deleteLib != null) {
                if (this.saveTask != null) {
                    assert (this.deleteLib.getId() == this.saveTask.libId);
                    this.saveTask.renameAndSave();
                    this.fieldVariableChanged("saveTask");
                    this.deleteLib = this.getDatabase().getLib(this.saveTask.libId);
                }
                if (!this.deleteLib.kill("replace")) {
                    return false;
                }
                this.deleteLib = null;
            }
            this.createLib = Input.importLibrary(this.getEditingPreferences(), this.prefs, this.fileURL, this.type, this.curLib, this.tech, this.currentCells, this.nodesToExpand, this.skeletonize, this);
            if (this.createLib == null) {
                return false;
            }
            Library noname = Library.findLibrary("noname");
            if (noname != null && !noname.getCells().hasNext()) {
                noname.kill("delete");
            }
            this.fieldVariableChanged("createLib");
            this.fieldVariableChanged("currentCells");
            this.fieldVariableChanged("nodesToExpand");
            return true;
        }

        @Override
        public void terminateOK() {
            if (this.saveTask != null) {
                this.saveTask.librarySaved();
            }
            User.setCurrentLibrary(this.createLib);
            for (Map.Entry<Library, Cell> e : this.currentCells.entrySet()) {
                Library lib = e.getKey();
                Cell cell = e.getValue();
                if (cell != null) assert (cell.getLibrary() == lib);
                lib.setCurCell(cell);
            }
            Cell showThisCell = this.createLib.getCurCell();
            this.getDatabase().expandNodes(this.nodesToExpand);
            FileMenu.doneOpeningLibrary(showThisCell);
        }
    }

    public static class ReadLibrary
    extends Job {
        private URL fileURL;
        private FileType type;
        private File projsettings;
        private Library deleteLib;
        private RenameAndSaveLibraryTask saveTask;
        private String cellName;
        private Library lib;
        private HashSet<Library> newLibs;
        private EditingPreferences ep;

        public ReadLibrary(URL fileURL, FileType type, String cellName) {
            this(fileURL, type, null, null, null, cellName);
        }

        public ReadLibrary(URL fURL, FileType type, String settingsDirectory, Library deleteLib, RenameAndSaveLibraryTask saveTask, String cellName) {
            super(FileMenu.openJobName, User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.fileURL = LibraryFiles.fixMissingExtension(fURL, type);
            this.type = type;
            this.deleteLib = deleteLib;
            this.saveTask = saveTask;
            this.cellName = cellName;
            if (settingsDirectory != null) {
                this.projsettings = new File(settingsDirectory, "projsettings.xml");
                if (!this.projsettings.exists()) {
                    this.projsettings = null;
                }
            }
            if (this.projsettings == null) {
                new ReadProjectSettingsFromLibrary(this.fileURL, type, this, this.ep).startJob();
            } else {
                this.startJob();
            }
        }

        @Override
        public boolean doIt() throws JobException {
            if (this.deleteLib != null) {
                if (this.saveTask != null) {
                    assert (this.deleteLib.getId() == this.saveTask.libId);
                    this.saveTask.renameAndSave();
                    this.fieldVariableChanged("saveTask");
                    this.deleteLib = this.getDatabase().getLib(this.saveTask.libId);
                }
                if (!this.deleteLib.kill("replace")) {
                    return false;
                }
                this.deleteLib = null;
            }
            if (this.projsettings != null) {
                ProjSettings.readSettings(this.projsettings, this.getDatabase(), false);
            }
            HashSet<Library> oldLibs = new HashSet<Library>();
            Iterator<Library> it = this.getDatabase().getLibraries();
            while (it.hasNext()) {
                oldLibs.add(it.next());
            }
            HashMap<Setting, Object> projectSettings = new HashMap<Setting, Object>();
            this.lib = LibraryFiles.readLibrary(this.getEditingPreferences(), this.fileURL, null, this.type, false, projectSettings);
            if (this.lib == null) {
                System.out.println("Error reading " + this.fileURL.getFile() + " as " + this.type + " format.");
                return false;
            }
            for (Map.Entry<Setting, Object> e : this.getDatabase().getSettings().entrySet()) {
                Setting setting = e.getKey();
                Object oldVal = e.getValue();
                Object libVal = projectSettings.get(setting);
                if (libVal == null) {
                    libVal = setting.getFactoryValue();
                }
                if (oldVal.equals(libVal) || oldVal instanceof Double && libVal instanceof Double && ((Double)oldVal).floatValue() == ((Double)libVal).floatValue()) continue;
                System.out.println("Warning: Setting \"" + setting.getPrefName() + "\" retains current value of \"" + oldVal + "\", while ignoring library value of \"" + libVal + "\"");
            }
            this.fieldVariableChanged("lib");
            this.newLibs = new HashSet();
            Iterator<Library> it2 = this.getDatabase().getLibraries();
            while (it2.hasNext()) {
                Library lib = it2.next();
                if (oldLibs.contains(lib)) continue;
                this.newLibs.add(lib);
            }
            this.fieldVariableChanged("newLibs");
            Library noname = Library.findLibrary("noname");
            if (noname != null) {
                if (noname == this.lib) {
                    if (this.lib.getLibFile() == null) {
                        this.lib.setLibFile(this.fileURL);
                    }
                } else if (!noname.getCells().hasNext()) {
                    noname.kill("delete");
                }
            }
            return true;
        }

        @Override
        public void terminateOK() {
            if (this.projsettings != null) {
                this.getDatabase().getEnvironment().saveToPreferences();
            }
            User.setCurrentLibrary(this.lib);
            FileMenu.convertVarsToModelFiles(this.newLibs);
            for (Library lib : this.newLibs) {
                Iterator<Cell> it = lib.getCells();
                while (it.hasNext()) {
                    Cell cell = it.next();
                    cell.loadExpandStatus();
                }
            }
            Cell showThisCell = this.cellName != null ? this.lib.findNodeProto(this.cellName) : this.lib.getCurCell();
            FileMenu.doneOpeningLibrary(showThisCell);
            if (CVS.isEnabled()) {
                if (this.saveTask != null) {
                    this.saveTask.librarySaved();
                }
                for (Library lib : this.newLibs) {
                    CVSLibrary.addLibrary(lib);
                }
                Update.updateOpenLibraries(Update.UpdateEnum.STATUS);
            }
            CircuitChanges.checkAndRepairCommand(true);
            User.addRecentlyOpenedLibrary(this.fileURL.getFile());
            FileMenu.updateRecentlyOpenedLibrariesList();
        }
    }

    private static class ReadProjectSettingsFromLibrary
    extends Job {
        private URL fileURL;
        private FileType type;
        private Map<String, Object> projectSettings;
        private transient ReadLibrary readJob;
        private EditingPreferences ep;

        public ReadProjectSettingsFromLibrary(URL fileURL, FileType type, ReadLibrary readJob, EditingPreferences ep) {
            super("ReadProjectSettingsFromLibrary", User.getUserTool(), Job.Type.SERVER_EXAMINE, null, null, Job.Priority.USER);
            this.fileURL = fileURL;
            this.type = type;
            this.readJob = readJob;
            this.ep = ep;
        }

        @Override
        public boolean doIt() throws JobException {
            this.projectSettings = LibraryFiles.readProjectsSettingsFromLibrary(this.fileURL, this.type, this.ep);
            this.fieldVariableChanged("projectSettings");
            return this.projectSettings != null;
        }

        @Override
        public void terminateOK() {
            String libName = TextUtils.getFileNameWithoutExtension(this.fileURL);
            if (this.projectSettings == null || !OptionReconcile.reconcileSettings(this.projectSettings, libName, this.readJob)) {
                this.readJob.startJob();
            }
        }
    }

    private static class NewLibrary
    extends Job {
        private String newLibName;
        private Library lib;

        public NewLibrary(String newLibName) {
            super("New Library", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.newLibName = newLibName;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            this.lib = Library.newInstance(this.newLibName, null);
            if (this.lib == null) {
                return false;
            }
            this.fieldVariableChanged("lib");
            System.out.println("New " + this.lib + " created");
            return true;
        }

        @Override
        public void terminateOK() {
            User.setCurrentLibrary(this.lib);
            EditWindow.repaintAll();
            ToolBar.setSaveLibraryButton();
        }
    }
}

