/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.util.collections;

import com.sun.electric.util.collections.ArrayIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ImmutableList2<T>
implements Iterable<T> {
    private final ImmutableList2<T> next;
    private final T item;
    private static final ImmutableList2<?> NIL = new ImmutableList2(null, (Object)null){

        @Override
        public boolean isEmpty() {
            return true;
        }

        public Object getFirst() {
            throw new NoSuchElementException();
        }

        public ImmutableList2<?> getTail() {
            throw new NoSuchElementException();
        }

        @Override
        public Iterator<?> iterator() {
            return ArrayIterator.emptyIterator();
        }
    };

    private ImmutableList2(ImmutableList2<T> next, T item) {
        this.next = next;
        this.item = item;
    }

    public boolean isEmpty() {
        return false;
    }

    public T getFirst() {
        return this.item;
    }

    public ImmutableList2<T> getTail() {
        return this.next;
    }

    public static <T> ImmutableList2<T> empty() {
        return NIL;
    }

    public ImmutableList2<T> addFirst(T item) {
        return new ImmutableList2<T>(this, item);
    }

    public ImmutableList2<T> remove(T item) {
        int i;
        int count = 0;
        ImmutableList2<Object> r = this;
        while (!r.isEmpty() && !(item != null ? item.equals(r.item) : r.item == null)) {
            r = r.next;
            ++count;
        }
        if (r.isEmpty()) {
            return this;
        }
        r = r.next;
        if (count == 0) {
            return r;
        }
        Object[] firstItems = new Object[count];
        ImmutableList2<T> l = this;
        for (i = 0; i < count; ++i) {
            firstItems[i] = l.item;
            l = l.next;
        }
        for (i = count - 1; i >= 0; --i) {
            r = new ImmutableList2<Object>(r, firstItems[i]);
        }
        return r;
    }

    public ImmutableList2<T> reverse() {
        ImmutableList2<T> l = this;
        ImmutableList2<T> r = ImmutableList2.empty();
        while (!l.isEmpty()) {
            r = new ImmutableList2<T>(r, l.item);
            l = l.next;
        }
        return r;
    }

    @Override
    public Iterator<T> iterator() {
        return new ImmutableList2Iterator(this);
    }

    public static class ImmutableList2Iterator<T>
    implements Iterator<T> {
        private ImmutableList2<T> list;

        public ImmutableList2Iterator(ImmutableList2<T> list) {
            this.list = list;
        }

        @Override
        public boolean hasNext() {
            return !this.list.isEmpty();
        }

        @Override
        public T next() {
            if (!this.list.isEmpty()) {
                Object obj = this.list.item;
                this.list = this.list.next;
                return obj;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

