/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.functions;

import gnu.expr.Language;
import gnu.kawa.functions.Arithmetic;
import gnu.kawa.functions.NumberCompare;
import gnu.lists.FVector;
import gnu.lists.LList;
import gnu.lists.Pair;
import gnu.mapping.Procedure2;
import gnu.mapping.Promise;
import java.lang.reflect.Array;
import java.util.Arrays;

public class IsEqual
extends Procedure2 {
    Language language;

    public IsEqual(Language language, String name) {
        this.language = language;
        this.setName(name);
    }

    public static boolean numberEquals(Number num1, Number num2) {
        boolean exact1 = Arithmetic.isExact(num1);
        boolean exact2 = Arithmetic.isExact(num2);
        if (exact1 && exact2) {
            return NumberCompare.$Eq(num1, num2);
        }
        return exact1 == exact2 && num1.equals(num2);
    }

    public static boolean arrayEquals(Object arg1, Object arg2) {
        String tname2;
        int len2;
        int len1 = Array.getLength(arg1);
        if (len1 != (len2 = Array.getLength(arg2))) {
            return false;
        }
        String tname1 = arg1.getClass().getName();
        if (!tname1.equals(tname2 = arg2.getClass().getName())) {
            return false;
        }
        if (tname1.length() == 2) {
            switch (tname1.charAt(1)) {
                case 'Z': {
                    return Arrays.equals((boolean[])arg1, (boolean[])arg2);
                }
                case 'B': {
                    return Arrays.equals((byte[])arg1, (byte[])arg2);
                }
                case 'C': {
                    return Arrays.equals((char[])arg1, (char[])arg2);
                }
                case 'D': {
                    return Arrays.equals((double[])arg1, (double[])arg2);
                }
                case 'F': {
                    return Arrays.equals((float[])arg1, (float[])arg2);
                }
                case 'I': {
                    return Arrays.equals((int[])arg1, (int[])arg2);
                }
                case 'J': {
                    return Arrays.equals((long[])arg1, (long[])arg2);
                }
                case 'S': {
                    return Arrays.equals((short[])arg1, (short[])arg2);
                }
            }
        }
        int i = len1;
        while (--i >= 0) {
            if (IsEqual.apply(Array.get(arg1, i), Array.get(arg2, i))) continue;
            return false;
        }
        return true;
    }

    public static boolean apply(Object arg1, Object arg2) {
        if ((arg1 = Promise.force(arg1)) == (arg2 = Promise.force(arg2))) {
            return true;
        }
        if (arg1 == null || arg2 == null) {
            return false;
        }
        if (arg1 instanceof Number && arg2 instanceof Number) {
            return IsEqual.numberEquals((Number)arg1, (Number)arg2);
        }
        if (arg1 instanceof CharSequence) {
            int len2;
            if (!(arg2 instanceof CharSequence)) {
                return false;
            }
            CharSequence seq1 = (CharSequence)arg1;
            CharSequence seq2 = (CharSequence)arg2;
            int len1 = seq1.length();
            if (len1 != (len2 = seq2.length())) {
                return false;
            }
            int i = len1;
            while (--i >= 0) {
                if (seq1.charAt(i) == seq2.charAt(i)) continue;
                return false;
            }
            return true;
        }
        if (arg1 instanceof FVector) {
            if (!(arg2 instanceof FVector)) {
                return false;
            }
            FVector vec1 = (FVector)arg1;
            FVector vec2 = (FVector)arg2;
            int n = vec1.size;
            if (vec2.data == null || vec2.size != n) {
                return false;
            }
            Object[] data1 = vec1.data;
            Object[] data2 = vec2.data;
            int i = n;
            while (--i >= 0) {
                if (IsEqual.apply(data1[i], data2[i])) continue;
                return false;
            }
            return true;
        }
        if (arg1 instanceof LList) {
            if (!(arg1 instanceof Pair) || !(arg2 instanceof Pair)) {
                return false;
            }
            Pair pair1 = (Pair)arg1;
            Pair pair2 = (Pair)arg2;
            while (true) {
                Object x2;
                Object x1;
                if (!IsEqual.apply(x1 = pair1.getCar(), x2 = pair2.getCar())) {
                    return false;
                }
                x1 = pair1.getCdr();
                if (x1 == (x2 = pair2.getCdr())) {
                    return true;
                }
                if (x1 == null || x2 == null) {
                    return false;
                }
                if (!(x1 instanceof Pair) || !(x2 instanceof Pair)) {
                    return IsEqual.apply(x1, x2);
                }
                pair1 = (Pair)x1;
                pair2 = (Pair)x2;
            }
        }
        if (arg1.getClass().isArray()) {
            if (!arg2.getClass().isArray()) {
                return false;
            }
            return IsEqual.arrayEquals(arg1, arg2);
        }
        return arg1.equals(arg2);
    }

    public Object apply2(Object arg1, Object arg2) {
        return this.language.booleanObject(IsEqual.apply(arg1, arg2));
    }
}

