/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

import gnu.bytecode.Attribute;
import gnu.bytecode.ClassType;
import gnu.bytecode.ClassTypeWriter;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Method;
import gnu.bytecode.Scope;
import gnu.bytecode.VarEnumerator;
import gnu.bytecode.Variable;
import java.io.DataOutputStream;
import java.io.IOException;

public class LocalVarsAttr
extends Attribute {
    private Method method;
    Variable[] used;
    public Scope current_scope;
    Scope parameter_scope;

    public LocalVarsAttr(CodeAttr codeAttr) {
        super("LocalVariableTable");
        this.addToFrontOf(codeAttr);
        this.method = (Method)codeAttr.getContainer();
        codeAttr.locals = this;
    }

    public LocalVarsAttr(Method method) {
        super("LocalVariableTable");
        CodeAttr codeAttr = method.code;
        this.method = method;
        codeAttr.locals = this;
    }

    public final Method getMethod() {
        return this.method;
    }

    public VarEnumerator allVars() {
        return new VarEnumerator(this.parameter_scope);
    }

    public void enterScope(Scope scope) {
        scope.linkChild(this.current_scope);
        this.current_scope = scope;
        CodeAttr codeAttr = this.method.getCode();
        for (Variable variable = scope.firstVar(); variable != null; variable = variable.nextVar()) {
            if (!variable.isSimple()) continue;
            if (!variable.isAssigned()) {
                variable.allocateLocal(codeAttr);
                continue;
            }
            if (this.used[variable.offset] == null) {
                this.used[variable.offset] = variable;
                continue;
            }
            if (this.used[variable.offset] == variable) continue;
            throw new Error("inconsistent local variable assignments for " + variable + " != " + this.used[variable.offset]);
        }
    }

    public void preserveVariablesUpto(Scope scope) {
        Scope scope2 = this.current_scope;
        while (scope2 != scope) {
            scope2.preserved = true;
            scope2 = scope2.parent;
        }
    }

    public final boolean isEmpty() {
        Variable variable;
        VarEnumerator varEnumerator = this.allVars();
        while ((variable = varEnumerator.nextVar()) != null) {
            if (!variable.isSimple() || variable.name == null) continue;
            return false;
        }
        return true;
    }

    public final int getCount() {
        Variable variable;
        int n = 0;
        VarEnumerator varEnumerator = this.allVars();
        while ((variable = varEnumerator.nextVar()) != null) {
            if (!this.shouldEmit(variable)) continue;
            ++n;
        }
        return n;
    }

    public final int getLength() {
        return 2 + 10 * this.getCount();
    }

    public void assignConstants(ClassType classType) {
        Variable variable;
        super.assignConstants(classType);
        VarEnumerator varEnumerator = this.allVars();
        while ((variable = varEnumerator.nextVar()) != null) {
            if (!variable.isSimple() || variable.name == null) continue;
            if (variable.name_index == 0) {
                variable.name_index = classType.getConstants().addUtf8((String)variable.getName()).index;
            }
            if (variable.signature_index != 0) continue;
            variable.signature_index = classType.getConstants().addUtf8((String)variable.getType().signature).index;
        }
    }

    private boolean shouldEmit(Variable variable) {
        return variable.isSimple() && variable.name != null && variable.start_pc >= 0 && variable.end_pc > variable.start_pc;
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        Variable variable;
        VarEnumerator varEnumerator = this.allVars();
        dataOutputStream.writeShort(this.getCount());
        varEnumerator.reset();
        while ((variable = varEnumerator.nextVar()) != null) {
            if (!this.shouldEmit(variable)) continue;
            dataOutputStream.writeShort(variable.start_pc);
            dataOutputStream.writeShort(variable.end_pc - variable.start_pc);
            dataOutputStream.writeShort(variable.name_index);
            dataOutputStream.writeShort(variable.signature_index);
            dataOutputStream.writeShort(variable.offset);
        }
    }

    public void print(ClassTypeWriter classTypeWriter) {
        Variable variable;
        VarEnumerator varEnumerator = this.allVars();
        classTypeWriter.print("Attribute \"");
        classTypeWriter.print(this.getName());
        classTypeWriter.print("\", length:");
        classTypeWriter.print(this.getLength());
        classTypeWriter.print(", count: ");
        classTypeWriter.println(this.getCount());
        varEnumerator.reset();
        while ((variable = varEnumerator.nextVar()) != null) {
            if (!variable.isSimple() || variable.name == null) continue;
            classTypeWriter.print("  slot#");
            classTypeWriter.print(variable.offset);
            classTypeWriter.print(": name: ");
            classTypeWriter.printOptionalIndex(variable.name_index);
            classTypeWriter.print(variable.getName());
            classTypeWriter.print(", type: ");
            classTypeWriter.printOptionalIndex(variable.signature_index);
            classTypeWriter.printSignature(variable.getType());
            classTypeWriter.print(" (pc: ");
            classTypeWriter.print(variable.start_pc);
            classTypeWriter.print(" length: ");
            classTypeWriter.print(variable.end_pc - variable.start_pc);
            classTypeWriter.println(')');
        }
    }
}

