/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.rssowl.core.persist.IBookMark;
import org.rssowl.core.persist.IEntity;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.INewsBin;
import org.rssowl.core.persist.ISearchMark;
import org.rssowl.core.persist.reference.BookMarkReference;
import org.rssowl.core.persist.reference.FolderReference;
import org.rssowl.core.persist.reference.ModelReference;
import org.rssowl.core.persist.reference.NewsBinReference;
import org.rssowl.core.persist.reference.NewsReference;
import org.rssowl.core.persist.reference.SearchMarkReference;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.core.util.LoggingSafeRunnable;
import org.rssowl.core.util.StringUtils;
import org.rssowl.core.util.URIUtils;
import org.rssowl.ui.internal.Activator;
import org.rssowl.ui.internal.Application;
import org.rssowl.ui.internal.Controller;
import org.rssowl.ui.internal.EntityGroup;
import org.rssowl.ui.internal.EntityGroupItem;
import org.rssowl.ui.internal.FolderNewsMark;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.editors.feed.NewsBrowserLabelProvider;
import org.rssowl.ui.internal.editors.feed.NewsBrowserViewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationServer {
    private static ApplicationServer fgInstance = new ApplicationServer();
    static final String PROTOCOL = "http";
    public static final String DEFAULT_LOCALHOST = "127.0.0.1";
    static final int DEFAULT_SOCKET_PORT = 8795;
    static String LOCALHOST = "127.0.0.1";
    static int SOCKET_PORT = 8795;
    static final String STARTUP_HANDSHAKE = "org.rssowl.ui.internal.StartupHandshake";
    private static final String MULTI_INSTANCE_PROPERTY = "multiInstance";
    private static final String LOCALHOST_PROPERTY = "localhost";
    private static final String PORT_PROPERTY = "port";
    private static final String ID = "id=";
    private static final String CRLF = "\r\n";
    private static Map<String, ContentViewer> fRegistry = new ConcurrentHashMap<String, ContentViewer>();
    private static final String OP_DISPLAY_FOLDER = "displayFolder=";
    private static final String OP_DISPLAY_BOOKMARK = "displayBookMark=";
    private static final String OP_DISPLAY_NEWSBIN = "displayNewsBin=";
    private static final String OP_DISPLAY_SEARCHMARK = "displaySearchMark=";
    private static final String OP_DISPLAY_NEWS = "displayNews=";
    private static final String OP_RESOURCE = "resource=";
    private static final String IE_MOTW = "<!-- saved from url=(0014)about:internet -->";
    private static final DateFormat RFC_1123_DATE = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.ENGLISH);
    private ServerSocket fSocket;
    private Job fServerJob;
    private int fPort;
    private HandshakeHandler fHandshakeHandler;

    public static ApplicationServer getDefault() {
        return fgInstance;
    }

    public void startup() throws IOException {
        String portProperty;
        if (this.isRunning()) {
            return;
        }
        String localhostProperty = System.getProperty(LOCALHOST_PROPERTY);
        if (localhostProperty != null && localhostProperty.length() > 0) {
            LOCALHOST = localhostProperty;
        }
        if ((portProperty = System.getProperty(PORT_PROPERTY)) != null && portProperty.length() > 0) {
            try {
                SOCKET_PORT = Integer.parseInt(portProperty);
            }
            catch (NumberFormatException e) {
                Activator.getDefault().logError(e.getMessage(), e);
            }
        }
        boolean usePortRange = System.getProperty(MULTI_INSTANCE_PROPERTY) != null;
        this.fSocket = this.createServerSocket(usePortRange);
        if (this.fSocket != null) {
            this.listen();
        }
    }

    public void shutdown() {
        block3: {
            this.fServerJob.cancel();
            try {
                if (this.fSocket != null) {
                    this.fSocket.close();
                }
            }
            catch (IOException e) {
                if (Activator.getDefault() == null) break block3;
                Activator.getDefault().logError(e.getMessage(), e);
            }
        }
    }

    public boolean isRunning() {
        return this.fSocket != null;
    }

    void setHandshakeHandler(HandshakeHandler handler) {
        this.fHandshakeHandler = handler;
    }

    private ServerSocket createServerSocket(boolean usePortRange) throws IOException {
        int i;
        ArrayList<Integer> ports = new ArrayList<Integer>();
        ports.add(SOCKET_PORT);
        if (usePortRange) {
            i = 1;
            while (i < 10) {
                ports.add(SOCKET_PORT + i);
                ++i;
            }
        }
        i = 0;
        while (i < ports.size()) {
            try {
                int port;
                this.fPort = port = ((Integer)ports.get(i)).intValue();
                return new ServerSocket(this.fPort, 50, InetAddress.getByName(LOCALHOST));
            }
            catch (UnknownHostException e) {
                throw e;
            }
            catch (BindException e) {
                if (i == ports.size() - 1) {
                    throw e;
                }
                ++i;
            }
        }
        return null;
    }

    public boolean isNewsServerUrl(String url) {
        return url.contains(LOCALHOST) && url.contains(String.valueOf(this.fPort));
    }

    public void register(String id, ContentViewer viewer) {
        fRegistry.put(id, viewer);
    }

    public void unregister(String id) {
        fRegistry.remove(id);
    }

    public boolean isDisplayOperation(String url) {
        if (!StringUtils.isSet((String)url)) {
            return false;
        }
        return url.contains(OP_DISPLAY_FOLDER) || url.contains(OP_DISPLAY_BOOKMARK) || url.contains(OP_DISPLAY_NEWSBIN) || url.contains(OP_DISPLAY_NEWS) || url.contains(OP_DISPLAY_SEARCHMARK) || "about:blank".equals(url);
    }

    public boolean isResourceOperation(String url) {
        if (!StringUtils.isSet((String)url)) {
            return false;
        }
        return url.contains(OP_RESOURCE);
    }

    public String toResourceUrl(String path) {
        StringBuilder url = new StringBuilder();
        url.append(PROTOCOL).append("://").append(LOCALHOST).append(':').append(this.fPort).append("/");
        url.append("?").append(OP_RESOURCE).append(path);
        return url.toString();
    }

    public String toUrl(String id, Object input) {
        if (input == null) {
            return "about:blank";
        }
        StringBuilder url = new StringBuilder();
        url.append(PROTOCOL).append("://").append(LOCALHOST).append(':').append(this.fPort).append("/");
        url.append("?").append(ID).append(id);
        if (!(input instanceof Object[])) {
            input = new Object[]{input};
        }
        ArrayList<Long> news = new ArrayList<Long>();
        ArrayList<Long> bookmarks = new ArrayList<Long>();
        ArrayList<Long> newsbins = new ArrayList<Long>();
        ArrayList<Long> searchmarks = new ArrayList<Long>();
        ArrayList<Long> folders = new ArrayList<Long>();
        Object[] objectArray = input;
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (obj instanceof FolderNewsMark.FolderNewsMarkReference) {
                folders.add(this.getId(obj));
            } else if (obj instanceof IBookMark || obj instanceof BookMarkReference) {
                bookmarks.add(this.getId(obj));
            } else if (obj instanceof INewsBin || obj instanceof NewsBinReference) {
                newsbins.add(this.getId(obj));
            } else if (obj instanceof ISearchMark || obj instanceof SearchMarkReference) {
                searchmarks.add(this.getId(obj));
            } else if (obj instanceof INews || obj instanceof NewsReference) {
                news.add(this.getId(obj));
            } else if (obj instanceof EntityGroup) {
                List<EntityGroupItem> items = ((EntityGroup)obj).getItems();
                for (EntityGroupItem item : items) {
                    IEntity entity = item.getEntity();
                    if (!(entity instanceof INews)) continue;
                    news.add(this.getId(entity));
                }
            }
            ++n2;
        }
        this.appendParameters(url, folders, OP_DISPLAY_FOLDER);
        this.appendParameters(url, bookmarks, OP_DISPLAY_BOOKMARK);
        this.appendParameters(url, newsbins, OP_DISPLAY_NEWSBIN);
        this.appendParameters(url, searchmarks, OP_DISPLAY_SEARCHMARK);
        this.appendParameters(url, news, OP_DISPLAY_NEWS);
        return url.toString();
    }

    private void appendParameters(StringBuilder url, List<Long> ids, String op) {
        if (!ids.isEmpty()) {
            url.append("&").append(op);
            for (Long id : ids) {
                url.append(id).append(',');
            }
            url.deleteCharAt(url.length() - 1);
        }
    }

    private Long getId(Object obj) {
        if (obj instanceof IEntity) {
            return ((IEntity)obj).getId();
        }
        if (obj instanceof ModelReference) {
            return ((ModelReference)obj).getId();
        }
        return null;
    }

    private void listen() {
        this.fServerJob = new Job("Local News Viewer Server"){

            protected IStatus run(IProgressMonitor monitor) {
                while (!monitor.isCanceled()) {
                    BufferedReader buffReader = null;
                    Socket socket = null;
                    try {
                        try {
                            socket = ApplicationServer.this.fSocket.accept();
                            buffReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                            String message = buffReader.readLine();
                            if (StringUtils.isSet((String)message)) {
                                ApplicationServer.this.safeProcess(socket, message);
                            }
                        }
                        catch (IOException iOException) {
                            try {
                                if (buffReader != null) {
                                    buffReader.close();
                                }
                            }
                            catch (Exception exception) {}
                            try {
                                if (socket == null) continue;
                                socket.close();
                            }
                            catch (Exception exception) {}
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            if (buffReader != null) {
                                buffReader.close();
                            }
                        }
                        catch (Exception exception) {}
                        try {
                            if (socket != null) {
                                socket.close();
                            }
                        }
                        catch (Exception exception) {}
                        throw throwable;
                    }
                    try {
                        if (buffReader != null) {
                            buffReader.close();
                        }
                    }
                    catch (Exception exception) {}
                    try {
                        if (socket == null) continue;
                        socket.close();
                    }
                    catch (Exception exception) {}
                }
                return Status.OK_STATUS;
            }
        };
        this.fServerJob.setSystem(true);
        this.fServerJob.schedule();
    }

    private void safeProcess(final Socket socket, final String message) {
        final boolean isDisplayOperation = this.isDisplayOperation(message);
        final boolean isResourceOperation = !isDisplayOperation && this.isResourceOperation(message);
        LoggingSafeRunnable runnable = new LoggingSafeRunnable(){

            public void run() throws Exception {
                if (isDisplayOperation) {
                    ApplicationServer.this.processDisplayOperation(socket, message);
                } else if (isResourceOperation) {
                    ApplicationServer.this.processResourceOperation(socket, message);
                } else {
                    ApplicationServer.this.processHandshake(message);
                }
            }
        };
        if (!isDisplayOperation && !isResourceOperation) {
            try {
                runnable.run();
            }
            catch (Exception e) {
                runnable.handleException((Throwable)e);
            }
        } else {
            SafeRunner.run((ISafeRunnable)runnable);
        }
    }

    private void processHandshake(String message) {
        if (this.fHandshakeHandler != null) {
            this.fHandshakeHandler.handle(message);
        }
    }

    private void processResourceOperation(Socket socket, String message) {
        block14: {
            int start = message.indexOf(OP_RESOURCE) + OP_RESOURCE.length();
            int end = message.indexOf(32, start);
            String parameter = message.substring(start, end);
            BufferedOutputStream outS = null;
            try {
                try {
                    outS = new BufferedOutputStream(socket.getOutputStream());
                    CoreUtils.copy((InputStream)OwlUI.class.getResourceAsStream(parameter), (OutputStream)outS);
                }
                catch (IOException iOException) {
                    if (outS != null) {
                        try {
                            outS.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (outS != null) {
                    try {
                        outS.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (outS != null) {
                try {
                    outS.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void processDisplayOperation(Socket socket, String message) {
        ContentViewer viewer;
        ArrayList<Object> elements = new ArrayList<Object>();
        int start = message.indexOf(47);
        int end = message.indexOf(32, start);
        String parameters = message.substring(start, end);
        String viewerId = null;
        int idIndex = parameters.indexOf(ID);
        if (idIndex >= 0) {
            start = idIndex + ID.length();
            end = parameters.indexOf(38, start);
            if (end < 0) {
                end = parameters.length();
            }
            viewerId = parameters.substring(start, end);
        }
        if ((viewer = fRegistry.get(viewerId)) instanceof NewsBrowserViewer && viewer.getContentProvider() != null) {
            int displayNewsIndex;
            int displaySearchMarkIndex;
            int displayNewsBinsIndex;
            int displayBookMarkIndex;
            IStructuredContentProvider newsContentProvider = (IStructuredContentProvider)viewer.getContentProvider();
            int displayFolderIndex = parameters.indexOf(OP_DISPLAY_FOLDER);
            if (displayFolderIndex >= 0) {
                start = displayFolderIndex + OP_DISPLAY_FOLDER.length();
                end = parameters.indexOf(38, start);
                if (end < 0) {
                    end = parameters.length();
                }
                StringTokenizer tokenizer = new StringTokenizer(parameters.substring(start, end), ",");
                while (tokenizer.hasMoreElements()) {
                    FolderReference ref = new FolderReference(Long.valueOf((String)tokenizer.nextElement()).longValue());
                    elements.addAll(Arrays.asList(newsContentProvider.getElements((Object)ref)));
                }
            }
            if ((displayBookMarkIndex = parameters.indexOf(OP_DISPLAY_BOOKMARK)) >= 0) {
                start = displayBookMarkIndex + OP_DISPLAY_BOOKMARK.length();
                end = parameters.indexOf(38, start);
                if (end < 0) {
                    end = parameters.length();
                }
                StringTokenizer tokenizer = new StringTokenizer(parameters.substring(start, end), ",");
                while (tokenizer.hasMoreElements()) {
                    BookMarkReference ref = new BookMarkReference(Long.valueOf((String)tokenizer.nextElement()).longValue());
                    elements.addAll(Arrays.asList(newsContentProvider.getElements((Object)ref)));
                }
            }
            if ((displayNewsBinsIndex = parameters.indexOf(OP_DISPLAY_NEWSBIN)) >= 0) {
                start = displayNewsBinsIndex + OP_DISPLAY_NEWSBIN.length();
                end = parameters.indexOf(38, start);
                if (end < 0) {
                    end = parameters.length();
                }
                StringTokenizer tokenizer = new StringTokenizer(parameters.substring(start, end), ",");
                while (tokenizer.hasMoreElements()) {
                    NewsBinReference ref = new NewsBinReference(Long.valueOf((String)tokenizer.nextElement()).longValue());
                    elements.addAll(Arrays.asList(newsContentProvider.getElements((Object)ref)));
                }
            }
            if ((displaySearchMarkIndex = parameters.indexOf(OP_DISPLAY_SEARCHMARK)) >= 0) {
                start = displaySearchMarkIndex + OP_DISPLAY_SEARCHMARK.length();
                end = parameters.indexOf(38, start);
                if (end < 0) {
                    end = parameters.length();
                }
                StringTokenizer tokenizer = new StringTokenizer(parameters.substring(start, end), ",");
                while (tokenizer.hasMoreElements()) {
                    SearchMarkReference ref = new SearchMarkReference(Long.valueOf((String)tokenizer.nextElement()).longValue());
                    elements.addAll(Arrays.asList(newsContentProvider.getElements((Object)ref)));
                }
            }
            if ((displayNewsIndex = parameters.indexOf(OP_DISPLAY_NEWS)) >= 0) {
                start = displayNewsIndex + OP_DISPLAY_NEWS.length();
                end = parameters.indexOf(38, start);
                if (end < 0) {
                    end = parameters.length();
                }
                StringTokenizer tokenizer = new StringTokenizer(parameters.substring(start, end), ",");
                while (tokenizer.hasMoreElements()) {
                    NewsReference ref = new NewsReference(Long.valueOf((String)tokenizer.nextElement()).longValue());
                    elements.addAll(Arrays.asList(newsContentProvider.getElements((Object)ref)));
                }
            }
        }
        this.reply(socket, viewerId, elements.toArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reply(Socket socket, String viewerId, Object[] elements) {
        block25: {
            if (viewerId == null) {
                return;
            }
            ContentViewer viewer = fRegistry.get(viewerId);
            if (viewer == null) {
                return;
            }
            NewsBrowserLabelProvider labelProvider = (NewsBrowserLabelProvider)viewer.getLabelProvider();
            Object[] children = new Object[]{};
            if (viewer instanceof NewsBrowserViewer) {
                children = ((NewsBrowserViewer)viewer).getFlattendChildren(elements);
                ((NewsBrowserViewer)viewer).updateViewModel(children);
            }
            BufferedWriter writer = null;
            try {
                try {
                    boolean portable = Controller.getDefault().isPortable();
                    writer = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream()));
                    if (Application.IS_WINDOWS && portable) {
                        writer.append("HTTP/1.1 205 OK").append(CRLF);
                    } else {
                        writer.append("HTTP/1.1 200 OK").append(CRLF);
                    }
                    DateFormat dateFormat = RFC_1123_DATE;
                    synchronized (dateFormat) {
                        writer.append("Date: ").append(RFC_1123_DATE.format(new Date())).append(CRLF);
                    }
                    writer.append("Server: RSSOwl Local Server").append(CRLF);
                    writer.append("Content-Type: text/html; charset=UTF-8").append(CRLF);
                    writer.append("Connection: close").append(CRLF);
                    writer.append("Expires: 0").append(CRLF);
                    writer.write(CRLF);
                    writer.write("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\n");
                    if (Application.IS_WINDOWS) {
                        writer.write(IE_MOTW);
                        writer.write("\n");
                    }
                    writer.write("<html>\n  <head>\n");
                    String base = this.getBase(children);
                    if (base != null) {
                        writer.write("  <base href=\"");
                        writer.write(base);
                        writer.write("\">");
                    }
                    writer.write("\n  <title></title>");
                    writer.write("\n  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n");
                    labelProvider.writeCSS(writer);
                    writer.write("  </head>\n  <body id=\"owlbody\">\n");
                    int i = 0;
                    while (i < children.length) {
                        String html = this.unicodeToEntities(labelProvider.getText(children[i], true, true, i));
                        writer.write(html);
                        ++i;
                    }
                    writer.write("\n  </body>\n</html>");
                }
                catch (IOException iOException) {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block25;
                }
            }
            catch (Throwable throwable) {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private String getBase(Object[] elements) {
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof INews) {
                INews news = (INews)object;
                if (news.getBase() != null) {
                    return URIUtils.toHTTP((URI)news.getBase()).toString();
                }
                return URIUtils.toHTTP((String)news.getFeedLinkAsText());
            }
            ++n2;
        }
        return null;
    }

    private String unicodeToEntities(String str) {
        StringBuilder strBuf = new StringBuilder(str.length());
        int i = 0;
        while (i < str.length()) {
            char ch = str.charAt(i);
            if (!(ch >= ' ' && ch <= '~' || Character.isWhitespace(ch))) {
                strBuf.append("&#x");
                String hex = Integer.toHexString(ch & 0xFFFF);
                if (hex.length() == 2) {
                    strBuf.append("00");
                }
                strBuf.append(hex).append(";");
            } else {
                strBuf.append(ch);
            }
            ++i;
        }
        return strBuf.toString();
    }

    public int getPort() {
        return SOCKET_PORT;
    }

    public String getHost() {
        return LOCALHOST;
    }

    static interface HandshakeHandler {
        public void handle(String var1);
    }
}

