/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.update.ui.UpdateJob;
import org.rssowl.core.IApplicationService;
import org.rssowl.core.Owl;
import org.rssowl.core.connection.AuthenticationRequiredException;
import org.rssowl.core.connection.ConnectionException;
import org.rssowl.core.connection.CredentialsException;
import org.rssowl.core.connection.MonitorCanceledException;
import org.rssowl.core.connection.NotModifiedException;
import org.rssowl.core.connection.SyncConnectionException;
import org.rssowl.core.connection.UnknownProtocolException;
import org.rssowl.core.internal.InternalOwl;
import org.rssowl.core.internal.persist.pref.DefaultPreferences;
import org.rssowl.core.interpreter.ITypeExporter;
import org.rssowl.core.interpreter.InterpreterException;
import org.rssowl.core.interpreter.ParserException;
import org.rssowl.core.persist.IBookMark;
import org.rssowl.core.persist.IConditionalGet;
import org.rssowl.core.persist.IEntity;
import org.rssowl.core.persist.IFeed;
import org.rssowl.core.persist.ILabel;
import org.rssowl.core.persist.IModelFactory;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.INewsMark;
import org.rssowl.core.persist.IPersistable;
import org.rssowl.core.persist.ISearchCondition;
import org.rssowl.core.persist.ISearchMark;
import org.rssowl.core.persist.dao.DynamicDAO;
import org.rssowl.core.persist.dao.IBookMarkDAO;
import org.rssowl.core.persist.dao.IConditionalGetDAO;
import org.rssowl.core.persist.dao.ILabelDAO;
import org.rssowl.core.persist.dao.INewsDAO;
import org.rssowl.core.persist.dao.ISearchMarkDAO;
import org.rssowl.core.persist.event.BookMarkAdapter;
import org.rssowl.core.persist.event.BookMarkEvent;
import org.rssowl.core.persist.event.EntityListener;
import org.rssowl.core.persist.event.LabelEvent;
import org.rssowl.core.persist.event.LabelListener;
import org.rssowl.core.persist.event.runnable.EventType;
import org.rssowl.core.persist.pref.IPreferenceScope;
import org.rssowl.core.persist.service.PersistenceException;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.core.util.DateUtils;
import org.rssowl.core.util.ITask;
import org.rssowl.core.util.JobQueue;
import org.rssowl.core.util.LoggingSafeRunnable;
import org.rssowl.core.util.StringUtils;
import org.rssowl.core.util.SyncUtils;
import org.rssowl.core.util.TaskAdapter;
import org.rssowl.core.util.Triple;
import org.rssowl.core.util.URIUtils;
import org.rssowl.ui.internal.Activator;
import org.rssowl.ui.internal.ApplicationServer;
import org.rssowl.ui.internal.ApplicationWorkbenchAdvisor;
import org.rssowl.ui.internal.FolderNewsMark;
import org.rssowl.ui.internal.LinkTransformer;
import org.rssowl.ui.internal.Messages;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.ShareProvider;
import org.rssowl.ui.internal.actions.FindUpdatesAction;
import org.rssowl.ui.internal.actions.OpenInBrowserAction;
import org.rssowl.ui.internal.actions.SendLinkAction;
import org.rssowl.ui.internal.dialogs.FatalOutOfMemoryErrorDialog;
import org.rssowl.ui.internal.dialogs.LoginDialog;
import org.rssowl.ui.internal.dialogs.properties.EntityPropertyPageWrapper;
import org.rssowl.ui.internal.dialogs.welcome.TutorialWizard;
import org.rssowl.ui.internal.dialogs.welcome.WelcomeWizard;
import org.rssowl.ui.internal.handler.LabelNewsHandler;
import org.rssowl.ui.internal.handler.ShareNewsHandler;
import org.rssowl.ui.internal.notifier.NotificationService;
import org.rssowl.ui.internal.services.CleanUpReminderService;
import org.rssowl.ui.internal.services.ContextService;
import org.rssowl.ui.internal.services.DownloadService;
import org.rssowl.ui.internal.services.FeedReloadService;
import org.rssowl.ui.internal.services.SavedSearchService;
import org.rssowl.ui.internal.services.SyncService;
import org.rssowl.ui.internal.util.ImportUtils;
import org.rssowl.ui.internal.util.JobRunner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Controller {
    public static final String DAILY_BACKUP = "backup.opml";
    public static final String WEEKLY_BACKUP = "backup_weekly.opml";
    private static final String BACKUP_TMP = "backup.tmp";
    private static final String ENTITY_PROPERTY_PAGE_EXTENSION_POINT = "org.rssowl.ui.EntityPropertyPage";
    public static final String BM_REALM_PROPERTY = "org.rssowl.ui.BMRealmProperty";
    public static final String LABEL_ACTION_PREFIX = "org.rssowl.ui.LabelAction";
    public static final String LOAD_ERROR_KEY = "org.rssowl.ui.internal.LoadErrorKey";
    public static final String LOAD_ERROR_LINK_KEY = "org.rssowl.ui.internal.LoadErrorLinkKey";
    private static final String RSSOWL_KEYBINDING_CATEGORY = "org.rssowl.ui.commands.category.RSSOwl";
    private static Controller fInstance;
    private static final int DEFAULT_MAX_CONCURRENT_RELOAD_JOBS = 10;
    private static final String MAX_CONCURRENT_RELOAD_JOBS_PROPERTY = "maxReloadJobs";
    private static final int MAX_CONCURRENT_SAVE_JOBS = 1;
    private static final int MAX_SAVE_QUEUE_SIZE = 1;
    private static final int DEFAULT_FEED_CON_TIMEOUT = 30000;
    private static final String FEED_CON_TIMEOUT_PROPERTY = "conTimeout";
    private static final String IMPORT_PROPERTY = "import";
    private static final String PORTABLE_PROPERTY = "portable";
    private static final String DISABLE_UPDATE_PROPERTY = "disableUpdate";
    private static final AtomicBoolean OOM_EMERGENCY_SHUTDOWN;
    private static final AtomicBoolean IS_OFFLINE;
    private final JobQueue fReloadFeedQueue;
    private final JobQueue fSaveFeedQueue;
    private NotificationService fNotificationService;
    private SavedSearchService fSavedSearchService;
    private DownloadService fDownloadService;
    private FeedReloadService fFeedReloadService;
    private SyncService fSyncService;
    final List<EntityPropertyPageWrapper> fEntityPropertyPages;
    private boolean fIsStarted;
    private boolean fShuttingDown;
    private boolean fRestarting;
    private ContextService fContextService;
    private static final String LINK_TRANSFORMER_EXTENSION_POINT = "org.rssowl.ui.LinkTransformer";
    private static final String SHARE_PROVIDER_EXTENSION_POINT = "org.rssowl.ui.ShareProvider";
    private static final String FEED_SEARCH_EXTENSION_POINT = "org.rssowl.ui.FeedSearch";
    private static final String FEED_SEARCH_KEYWORD_TOKEN = "[K]";
    private static final String LEGACY_PREF_LAYOUT_CLASSIC = "org.rssowl.ui.internal.editors.feed.LayoutVertical";
    private static final String LEGACY_PREF_BROWSER_MAXIMIZED = "org.rssowl.ui.internal.editors.feed.BrowserMaximized";
    private static final String DEFAULT_TRANSFORMER_ID = "org.rssowl.ui.ReadabilityTransformer";
    private static final String DEFAULT_TRANSFORMER_EMBEDDED_PARAMETER = "&embedded";
    private final IApplicationService fAppService;
    private CleanUpReminderService fCleanUpReminderService;
    private final IBookMarkDAO fBookMarkDAO;
    private final ISearchMarkDAO fSearchMarkDAO;
    private final IConditionalGetDAO fConditionalGetDAO;
    private final ILabelDAO fLabelDao;
    private final IModelFactory fFactory;
    private final Lock fLoginDialogLock = new ReentrantLock();
    private final AtomicLong fLastGoogleLoginCancel = new AtomicLong(0L);
    private BookMarkAdapter fBookMarkListener;
    private LabelListener fLabelListener;
    private ListenerList fBookMarkLoadListeners = new ListenerList();
    private final int fConnectionTimeout;
    private List<ShareProvider> fShareProviders = new ArrayList<ShareProvider>();
    private Map<String, LinkTransformer> fLinkTransformers = new HashMap<String, LinkTransformer>();
    private Map<Long, Long> fDeletedBookmarksCache = new ConcurrentHashMap<Long, Long>();
    private String fFeedSearchUrl;
    private boolean fShowWelcome;
    private boolean fPortable;
    private boolean fDisableUpdate;
    private String fNl;

    static {
        OOM_EMERGENCY_SHUTDOWN = new AtomicBoolean(false);
        IS_OFFLINE = new AtomicBoolean(false);
    }

    private Controller() {
        int maxConcurrentReloadJobs = this.getSystemProperty(MAX_CONCURRENT_RELOAD_JOBS_PROPERTY, 0, 10);
        this.fReloadFeedQueue = new JobQueue(Messages.Controller_UPDATING_FEEDS, Messages.Controller_UPDATING, maxConcurrentReloadJobs, Integer.MAX_VALUE, true, 0);
        this.fSaveFeedQueue = new JobQueue(Messages.Controller_UPDATING_FEEDS, 1, 1, false, 0);
        this.fSaveFeedQueue.setUnknownProgress(true);
        this.fEntityPropertyPages = this.loadEntityPropertyPages();
        this.fBookMarkDAO = (IBookMarkDAO)DynamicDAO.getDAO(IBookMarkDAO.class);
        this.fSearchMarkDAO = (ISearchMarkDAO)DynamicDAO.getDAO(ISearchMarkDAO.class);
        this.fConditionalGetDAO = (IConditionalGetDAO)DynamicDAO.getDAO(IConditionalGetDAO.class);
        this.fLabelDao = (ILabelDAO)DynamicDAO.getDAO(ILabelDAO.class);
        this.fAppService = Owl.getApplicationService();
        this.fFactory = Owl.getModelFactory();
        this.fConnectionTimeout = this.getSystemProperty(FEED_CON_TIMEOUT_PROPERTY, 30000, 30000);
        this.fPortable = System.getProperty(PORTABLE_PROPERTY) != null;
        this.fDisableUpdate = Boolean.getBoolean(DISABLE_UPDATE_PROPERTY);
        this.fNl = System.getProperty("line.separator");
        if (!StringUtils.isSet((String)this.fNl)) {
            this.fNl = "\n";
        }
    }

    private int getSystemProperty(String key, int minValue, int defaultValue) {
        String strVal = System.getProperty(key);
        if (strVal != null) {
            int intVal = 0;
            try {
                intVal = Integer.parseInt(strVal);
            }
            catch (NumberFormatException e) {
                Activator.getDefault().logError(e.getMessage(), e);
                return defaultValue;
            }
            if (intVal > minValue) {
                return intVal;
            }
        }
        return defaultValue;
    }

    private void registerListeners() {
        this.fBookMarkListener = new BookMarkAdapter(){

            public void entitiesDeleted(Set<BookMarkEvent> events) {
                if (!Controller.this.fShuttingDown) {
                    for (BookMarkEvent event : events) {
                        Long id = event.getEntity().getId();
                        if (id == null) continue;
                        OwlUI.deleteImage(id);
                        Controller.this.fDeletedBookmarksCache.put(id, id);
                    }
                }
            }
        };
        DynamicDAO.addEntityListener(IBookMark.class, (EntityListener)this.fBookMarkListener);
        this.fLabelListener = new LabelListener(){

            public void entitiesAdded(Set<LabelEvent> events) {
                if (Controller.this.fShuttingDown) {
                    return;
                }
                Controller.this.onLabelsChange(events, EventType.PERSIST);
                if (PlatformUI.isWorkbenchRunning()) {
                    Controller.this.updateLabelCommands();
                }
            }

            public void entitiesUpdated(Set<LabelEvent> events) {
                if (Controller.this.fShuttingDown) {
                    return;
                }
                Controller.this.onLabelsChange(events, EventType.UPDATE);
                if (PlatformUI.isWorkbenchRunning()) {
                    Controller.this.updateLabelCommands();
                    for (LabelEvent event : events) {
                        ILabel oldLabel = event.getOldLabel();
                        ILabel updatedLabel = event.getEntity();
                        if (oldLabel.getName().equals(updatedLabel.getName())) continue;
                        Controller.this.updateLabelConditions(oldLabel.getName(), updatedLabel.getName());
                    }
                }
            }

            public void entitiesDeleted(Set<LabelEvent> events) {
                if (Controller.this.fShuttingDown) {
                    return;
                }
                Controller.this.onLabelsChange(events, EventType.REMOVE);
                if (PlatformUI.isWorkbenchRunning()) {
                    Controller.this.updateLabelCommands();
                }
            }
        };
        DynamicDAO.addEntityListener(ILabel.class, (EntityListener)this.fLabelListener);
    }

    private void onLabelsChange(Set<LabelEvent> events, EventType type) {
        boolean needsSave = false;
        IPreferenceScope preferences = Owl.getPreferenceService().getGlobalScope();
        String[] deletedLabels = preferences.getStrings(DefaultPreferences.DELETED_LABELS);
        HashSet<String> deletedLabelsSet = new HashSet<String>();
        if (deletedLabels != null) {
            String[] stringArray = deletedLabels;
            int n = deletedLabels.length;
            int n2 = 0;
            while (n2 < n) {
                String label = stringArray[n2];
                deletedLabelsSet.add(label);
                ++n2;
            }
        } else if (type == EventType.PERSIST || type == EventType.UPDATE) {
            return;
        }
        switch (type) {
            case PERSIST: {
                for (LabelEvent event : events) {
                    if (!deletedLabelsSet.remove(event.getEntity().getName())) continue;
                    needsSave = true;
                }
                break;
            }
            case REMOVE: {
                for (LabelEvent event : events) {
                    deletedLabelsSet.add(event.getEntity().getName());
                }
                needsSave = true;
                break;
            }
            case UPDATE: {
                for (LabelEvent event : events) {
                    if (event.getOldLabel() == null) continue;
                    String oldName = event.getOldLabel().getName();
                    String newName = event.getEntity().getName();
                    if (newName == null || newName.equals(oldName) || !deletedLabelsSet.remove(newName)) continue;
                    needsSave = true;
                }
                break;
            }
        }
        if (needsSave) {
            if (deletedLabelsSet.isEmpty()) {
                preferences.delete(DefaultPreferences.DELETED_LABELS);
            } else {
                preferences.putStrings(DefaultPreferences.DELETED_LABELS, deletedLabelsSet.toArray(new String[deletedLabelsSet.size()]));
            }
        }
    }

    private void updateLabelConditions(String oldLabelName, String newLabelName) {
        HashSet<ISearchMark> searchMarksToUpdate = new HashSet<ISearchMark>(1);
        for (ISearchMark searchMark : this.fSearchMarkDAO.loadAll()) {
            List conditions = searchMark.getSearchConditions();
            for (ISearchCondition condition : conditions) {
                if (condition.getField().getId() != 15 || !condition.getValue().equals(oldLabelName)) continue;
                condition.setValue((Object)newLabelName);
                searchMarksToUpdate.add(searchMark);
            }
        }
        ((ISearchMarkDAO)DynamicDAO.getDAO(ISearchMarkDAO.class)).saveAll(searchMarksToUpdate);
    }

    private void unregisterListeners() {
        DynamicDAO.removeEntityListener(IBookMark.class, (EntityListener)this.fBookMarkListener);
        DynamicDAO.removeEntityListener(ILabel.class, (EntityListener)this.fLabelListener);
    }

    private List<EntityPropertyPageWrapper> loadEntityPropertyPages() {
        IConfigurationElement[] elements;
        ArrayList<EntityPropertyPageWrapper> pages = new ArrayList<EntityPropertyPageWrapper>();
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = reg.getConfigurationElementsFor(ENTITY_PROPERTY_PAGE_EXTENSION_POINT);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                IConfigurationElement[] entityTargets;
                String id = element.getAttribute("id");
                String name = element.getAttribute("name");
                int order = Integer.valueOf(element.getAttribute("order"));
                boolean handlesMultipleEntities = Boolean.valueOf(element.getAttribute("handlesMultipleEntities"));
                ArrayList targetEntities = new ArrayList();
                IConfigurationElement[] iConfigurationElementArray2 = entityTargets = element.getChildren("targetEntity");
                int n3 = entityTargets.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement entityTarget = iConfigurationElementArray2[n4];
                    targetEntities.add(Class.forName(entityTarget.getAttribute("class")));
                    ++n4;
                }
                pages.add(new EntityPropertyPageWrapper(id, element, targetEntities, name, order, handlesMultipleEntities));
            }
            catch (ClassNotFoundException e) {
                Activator.getDefault().logError(e.getMessage(), e);
            }
            ++n2;
        }
        return pages;
    }

    public static Controller getDefault() {
        if (fInstance == null) {
            fInstance = new Controller();
        }
        return fInstance;
    }

    public static boolean isInitialized() {
        return fInstance != null;
    }

    public Set<EntityPropertyPageWrapper> getEntityPropertyPagesFor(List<IEntity> entities) {
        HashSet<EntityPropertyPageWrapper> pages = new HashSet<EntityPropertyPageWrapper>();
        HashSet<Class<? extends IEntity>> entityClasses = new HashSet<Class<? extends IEntity>>();
        for (IEntity entity : entities) {
            entityClasses.add(entity.getClass());
        }
        for (EntityPropertyPageWrapper pageWrapper : this.fEntityPropertyPages) {
            if (!pageWrapper.isHandlingMultipleEntities() && entities.size() > 1 || !pageWrapper.handles(entityClasses)) continue;
            pages.add(pageWrapper);
        }
        return pages;
    }

    public SavedSearchService getSavedSearchService() {
        return this.fSavedSearchService;
    }

    public DownloadService getDownloadService() {
        return this.fDownloadService;
    }

    public NotificationService getNotificationService() {
        return this.fNotificationService;
    }

    public SyncService getSyncService() {
        return this.fSyncService;
    }

    public ContextService getContextService() {
        if (this.fContextService == null) {
            this.fContextService = new ContextService();
        }
        return this.fContextService;
    }

    public Object getReloadFamily() {
        return this.fReloadFeedQueue;
    }

    public FeedReloadService getReloadService() {
        return this.fFeedReloadService;
    }

    public void reloadQueued(Set<IBookMark> bookmarks, Map<Object, Object> properties, Shell shell) {
        boolean highPrio = bookmarks.size() == 1;
        ArrayList<ReloadTask> tasks = new ArrayList<ReloadTask>();
        for (IBookMark bookmark : bookmarks) {
            ReloadTask task = new ReloadTask(bookmark, properties, shell, highPrio ? ITask.Priority.SHORT : ITask.Priority.DEFAULT);
            if (this.fReloadFeedQueue.isQueued((ITask)task)) continue;
            tasks.add(task);
        }
        this.fReloadFeedQueue.schedule(tasks);
    }

    public void reloadQueued(IBookMark bookmark, Map<Object, Object> properties, Shell shell) {
        ReloadTask task = new ReloadTask(bookmark, properties, shell, ITask.Priority.DEFAULT);
        if (!this.fReloadFeedQueue.isQueued((ITask)task)) {
            this.fReloadFeedQueue.schedule((ITask)task);
        }
    }

    public IStatus reload(IBookMark bookmark, Shell shell, IProgressMonitor monitor) {
        return this.reload(bookmark, null, shell, monitor);
    }

    private IStatus reload(final IBookMark bookmark, Map<Object, Object> properties, Shell shell, final IProgressMonitor monitor) {
        Assert.isNotNull((Object)bookmark);
        CoreException ex = null;
        if (this.isOffline()) {
            return Status.OK_STATUS;
        }
        final URI feedLink = bookmark.getFeedLinkReference().getLink();
        URI feedHomepage = null;
        try {
            boolean deleteConditionalGet;
            if (!this.shouldProceedReloading(monitor, bookmark)) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            this.fireBookMarkAboutToLoad(bookmark);
            IConditionalGet conditionalGet = this.fConditionalGetDAO.load(feedLink);
            if (properties == null) {
                properties = new HashMap<Object, Object>();
            }
            properties.put("CON_TIMEOUT", this.fConnectionTimeout);
            if (SyncUtils.isSynchronized((IBookMark)bookmark)) {
                IPreferenceScope defaultPreferences = Owl.getPreferenceService().getDefaultScope();
                IPreferenceScope preferences = Owl.getPreferenceService().getEntityScope((IEntity)bookmark);
                int itemLimit = preferences.getBoolean(DefaultPreferences.DEL_NEWS_BY_COUNT_STATE) ? preferences.getInteger(DefaultPreferences.DEL_NEWS_BY_COUNT_VALUE) : defaultPreferences.getInteger(DefaultPreferences.DEL_NEWS_BY_COUNT_VALUE);
                properties.put("ITEM_LIMIT", itemLimit);
                long dateLimit = 0L;
                if (preferences.getBoolean(DefaultPreferences.DEL_NEWS_BY_AGE_STATE)) {
                    int days = preferences.getInteger(DefaultPreferences.DEL_NEWS_BY_AGE_VALUE);
                    dateLimit = DateUtils.getToday().getTimeInMillis() - (long)days * 86400000L;
                }
                if (dateLimit != 0L) {
                    properties.put("DATE_LIMIT", dateLimit);
                }
                if (this.fSyncService != null) {
                    properties.put("UNCOMMITTED_ITEMS", this.fSyncService.getUncommittedItems());
                }
            }
            if (conditionalGet != null) {
                String ifNoneMatch;
                String ifModifiedSince = conditionalGet.getIfModifiedSince();
                if (ifModifiedSince != null) {
                    properties.put("IF_MODIFIED_SINCE", ifModifiedSince);
                }
                if ((ifNoneMatch = conditionalGet.getIfNoneMatch()) != null) {
                    properties.put("IF_NONE_MATCH", ifNoneMatch);
                }
            }
            if (!this.shouldProceedReloading(monitor, bookmark)) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            final Triple result = Owl.getConnectionService().reload(feedLink, monitor, properties);
            if (!this.shouldProceedReloading(monitor, bookmark) || result == null) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            feedHomepage = ((IFeed)result.getFirst()).getHomepage();
            boolean conditionalGetIsNull = conditionalGet == null;
            conditionalGet = this.updateConditionalGet(feedLink, conditionalGet, (IConditionalGet)result.getSecond());
            boolean bl = deleteConditionalGet = !conditionalGetIsNull && conditionalGet == null;
            if (!this.shouldProceedReloading(monitor, bookmark)) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            if (!InternalOwl.PERF_TESTING && OwlUI.getFavicon(bookmark) == null) {
                this.loadFavicon(bookmark, monitor, (URI)result.getThird(), feedHomepage);
            }
            if (!this.shouldProceedReloading(monitor, bookmark)) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            try {
                if (!InternalOwl.TESTING) {
                    final IConditionalGet finalConditionalGet = conditionalGet;
                    final boolean finalDeleteConditionalGet = deleteConditionalGet;
                    this.fSaveFeedQueue.schedule((ITask)new TaskAdapter(){

                        public IStatus run(IProgressMonitor otherMonitor) {
                            if (otherMonitor.isCanceled() || !Controller.this.shouldProceedReloading(monitor, bookmark)) {
                                return Status.CANCEL_STATUS;
                            }
                            INewsMark activeFeedViewNewsMark = OwlUI.getActiveFeedViewNewsMark();
                            boolean runRetention = true;
                            if (activeFeedViewNewsMark != null) {
                                if (activeFeedViewNewsMark.equals(bookmark)) {
                                    runRetention = false;
                                } else if (activeFeedViewNewsMark instanceof FolderNewsMark && ((FolderNewsMark)activeFeedViewNewsMark).contains((INewsMark)bookmark)) {
                                    runRetention = false;
                                }
                            }
                            Controller.this.fAppService.handleFeedReload(bookmark, (IFeed)result.getFirst(), finalConditionalGet, finalDeleteConditionalGet, runRetention, otherMonitor);
                            return Status.OK_STATUS;
                        }

                        public String getName() {
                            return Messages.Controller_UPDATING_FEEDS_JOB;
                        }
                    });
                } else {
                    this.fAppService.handleFeedReload(bookmark, (IFeed)result.getFirst(), conditionalGet, deleteConditionalGet, true, (IProgressMonitor)new NullProgressMonitor());
                }
            }
            catch (CoreException e) {
                ex = e;
                final Shell[] shellAr = new Shell[]{shell};
                if (e instanceof AuthenticationRequiredException && this.shouldProceedReloading(monitor, bookmark)) {
                    if (shellAr[0] == null || shellAr[0].isDisposed()) {
                        SafeRunner.run((ISafeRunnable)new LoggingSafeRunnable(){

                            public void run() throws Exception {
                                shellAr[0] = OwlUI.getActiveShell();
                            }
                        });
                    }
                    if (shellAr[0] != null && !shellAr[0].isDisposed()) {
                        final boolean isSynchronizedFeed = SyncUtils.isSynchronized((IBookMark)bookmark);
                        boolean openLoginDialog = false;
                        if (!isSynchronizedFeed) {
                            this.fLoginDialogLock.lock();
                            openLoginDialog = true;
                        } else {
                            openLoginDialog = this.fLoginDialogLock.tryLock();
                        }
                        final AuthenticationRequiredException authEx = (AuthenticationRequiredException)e;
                        if (openLoginDialog) {
                            try {
                                JobRunner.runSyncedInUIThread((Widget)shellAr[0], new Runnable(){

                                    public void run() {
                                        if (!Controller.this.shouldProceedReloading(monitor, bookmark)) {
                                            return;
                                        }
                                        if (!isSynchronizedFeed) {
                                            try {
                                                URI normalizedUri = URIUtils.normalizeUri((URI)feedLink, (boolean)true);
                                                if (Owl.getConnectionService().getAuthCredentials(normalizedUri, authEx.getRealm()) != null) {
                                                    Controller.this.reloadQueued(bookmark, null, shellAr[0]);
                                                    return;
                                                }
                                            }
                                            catch (CredentialsException exe) {
                                                Activator.getDefault().getLog().log(exe.getStatus());
                                            }
                                        }
                                        int status = -1;
                                        status = isSynchronizedFeed ? OwlUI.openSyncLogin(shellAr[0]) : new LoginDialog(shellAr[0], feedLink, authEx.getRealm()).open();
                                        if (status == 1 && isSynchronizedFeed) {
                                            Controller.this.fLastGoogleLoginCancel.set(System.currentTimeMillis());
                                        }
                                        if (status == 0 && Controller.this.shouldProceedReloading(monitor, bookmark)) {
                                            if (StringUtils.isSet((String)authEx.getRealm())) {
                                                bookmark.setProperty(Controller.BM_REALM_PROPERTY, (Serializable)((Object)authEx.getRealm()));
                                                Controller.this.fBookMarkDAO.save((IPersistable)bookmark);
                                            }
                                            Controller.this.reloadQueued(bookmark, null, shellAr[0]);
                                        } else if (Controller.this.shouldProceedReloading(monitor, bookmark) && !bookmark.isErrorLoading()) {
                                            Controller.this.updateErrorLoading(bookmark, authEx);
                                        }
                                    }
                                });
                                IStatus iStatus = Status.OK_STATUS;
                                return iStatus;
                            }
                            finally {
                                this.fLoginDialogLock.unlock();
                            }
                        }
                        if (this.shouldProceedReloading(monitor, bookmark) && !bookmark.isErrorLoading()) {
                            this.updateErrorLoading(bookmark, authEx);
                        }
                    }
                } else if (!InternalOwl.TESTING && (e instanceof NotModifiedException || e instanceof InterpreterException || e instanceof ParserException) && OwlUI.getFavicon(bookmark) == null && this.shouldProceedReloading(monitor, bookmark)) {
                    this.loadFavicon(bookmark, monitor, feedLink, feedHomepage);
                }
                if (e instanceof NotModifiedException) {
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                if (e.getStatus() != null && e.getStatus().getException() instanceof MonitorCanceledException) {
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                IStatus iStatus = this.createInfoStatus(e.getStatus(), bookmark, feedLink);
                return iStatus;
            }
        }
        finally {
            this.updateErrorIndicator(bookmark, monitor, ex);
            this.fireBookMarkDoneLoading(bookmark);
        }
        return Status.OK_STATUS;
    }

    private void updateErrorLoading(IBookMark bookmark, AuthenticationRequiredException authEx) {
        bookmark.setErrorLoading(true);
        if (StringUtils.isSet((String)authEx.getMessage())) {
            bookmark.setProperty(LOAD_ERROR_KEY, (Serializable)((Object)authEx.getMessage()));
        }
        bookmark.removeProperty(LOAD_ERROR_LINK_KEY);
        this.fBookMarkDAO.save((IPersistable)bookmark);
    }

    private void loadFavicon(IBookMark bookmark, IProgressMonitor monitor, URI feedLink, URI feedHomepage) {
        try {
            byte[] faviconBytes = null;
            if (SyncUtils.isSynchronized((IBookMark)bookmark)) {
                String link = bookmark.getFeedLinkReference().getLinkAsText();
                if ("reader://readinglist".equals(link)) {
                    faviconBytes = this.toByte("/icons/obj16/bookmark.gif");
                } else if ("reader://starred".equals(link)) {
                    faviconBytes = this.toByte("/icons/obj16/gr_starred.gif");
                } else if ("reader://shared".equals(link)) {
                    faviconBytes = this.toByte("/icons/obj16/gr_shared.gif");
                } else if ("reader://recommended".equals(link)) {
                    faviconBytes = this.toByte("/icons/obj16/gr_recommended.gif");
                } else if ("reader://notes".equals(link)) {
                    faviconBytes = this.toByte("/icons/obj16/gr_notes.gif");
                }
            }
            if (faviconBytes == null && feedHomepage != null && StringUtils.isSet((String)feedHomepage.toString()) && feedHomepage.isAbsolute()) {
                faviconBytes = Owl.getConnectionService().getFeedIcon(feedHomepage, monitor);
            }
            if (faviconBytes == null) {
                faviconBytes = Owl.getConnectionService().getFeedIcon(feedLink, monitor);
            }
            if (this.shouldProceedReloading(monitor, bookmark)) {
                OwlUI.storeImage(bookmark.getId(), faviconBytes, OwlUI.BOOKMARK, 16, 16);
            }
            if (faviconBytes != null) {
                DynamicDAO.save((IPersistable)bookmark);
            }
        }
        catch (UnknownProtocolException e) {
            Activator.getDefault().getLog().log(e.getStatus());
        }
        catch (ConnectionException e) {
            Activator.getDefault().getLog().log(e.getStatus());
        }
    }

    private byte[] toByte(String file) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        InputStream fileStream = this.getClass().getResourceAsStream(file);
        CoreUtils.copy((InputStream)fileStream, (OutputStream)out);
        return out.toByteArray();
    }

    private void updateErrorIndicator(IBookMark bookmark, IProgressMonitor monitor, CoreException ex) {
        if (!this.shouldProceedReloading(monitor, bookmark)) {
            return;
        }
        if (bookmark.isErrorLoading() && (ex == null || ex instanceof NotModifiedException)) {
            bookmark.setErrorLoading(false);
            bookmark.removeProperty(LOAD_ERROR_KEY);
            bookmark.removeProperty(LOAD_ERROR_LINK_KEY);
            this.fBookMarkDAO.save((IPersistable)bookmark);
        } else if (ex != null && !(ex instanceof NotModifiedException) && !(ex instanceof AuthenticationRequiredException)) {
            boolean wasShowingError = bookmark.isErrorLoading();
            bookmark.setErrorLoading(true);
            Object oldMessage = bookmark.getProperty(LOAD_ERROR_KEY);
            Object oldLink = bookmark.getProperty(LOAD_ERROR_LINK_KEY);
            String message = CoreUtils.toMessage((Throwable)ex);
            if (StringUtils.isSet((String)message)) {
                bookmark.setProperty(LOAD_ERROR_KEY, (Serializable)((Object)message));
            } else {
                bookmark.removeProperty(LOAD_ERROR_KEY);
            }
            String link = null;
            if (ex instanceof SyncConnectionException) {
                link = ((SyncConnectionException)ex).getUserUrl();
            }
            if (StringUtils.isSet(link)) {
                bookmark.setProperty(LOAD_ERROR_LINK_KEY, (Serializable)((Object)link));
            } else {
                bookmark.removeProperty(LOAD_ERROR_LINK_KEY);
            }
            if (!wasShowingError || oldMessage != null && message == null || message != null && !message.equals(oldMessage) || oldLink != null && link == null || link != null && !link.equals(oldLink)) {
                this.fBookMarkDAO.save((IPersistable)bookmark);
            }
        }
    }

    private boolean shouldProceedReloading(IProgressMonitor monitor, IBookMark mark) {
        if (InternalOwl.TESTING) {
            return true;
        }
        if (this.fShuttingDown) {
            return false;
        }
        if (monitor.isCanceled()) {
            return false;
        }
        return !this.isDeleted(mark);
    }

    private boolean isDeleted(IBookMark mark) {
        Long id = mark.getId();
        if (id != null) {
            return this.fDeletedBookmarksCache.containsKey(id);
        }
        return false;
    }

    private IConditionalGet updateConditionalGet(URI feedLink, IConditionalGet oldConditionalGet, IConditionalGet newConditionalGet) {
        if (newConditionalGet == null) {
            return null;
        }
        String ifModifiedSince = newConditionalGet.getIfModifiedSince();
        String ifNoneMatch = newConditionalGet.getIfNoneMatch();
        if (ifModifiedSince != null || ifNoneMatch != null) {
            if (oldConditionalGet == null) {
                return this.fFactory.createConditionalGet(ifModifiedSince, feedLink, ifNoneMatch);
            }
            oldConditionalGet.setHeaders(ifModifiedSince, ifNoneMatch);
            return oldConditionalGet;
        }
        return null;
    }

    public void startup() {
        if (!InternalOwl.TESTING) {
            SafeRunner.run((ISafeRunnable)new LoggingSafeRunnable(){

                public void run() throws Exception {
                    IPreferenceScope preferences = Owl.getPreferenceService().getGlobalScope();
                    boolean isSubsequentStartup = preferences.hasKey(DefaultPreferences.FIRST_START_TOKEN);
                    if (isSubsequentStartup) {
                        if (!preferences.getBoolean(DefaultPreferences.FIRST_START_TOKEN)) {
                            preferences.putBoolean(DefaultPreferences.FIRST_START_TOKEN, true);
                        }
                        Controller.this.onSubsequentStartup();
                        return;
                    }
                    Controller.this.onFirstStartup();
                    preferences.putBoolean(DefaultPreferences.FIRST_START_TOKEN, true);
                }
            });
        }
        SafeRunner.run((ISafeRunnable)new LoggingSafeRunnable(){

            public void run() throws Exception {
                ((INewsDAO)DynamicDAO.getDAO(INewsDAO.class)).setState(EnumSet.of(INews.State.HIDDEN), INews.State.DELETED, false);
            }
        });
        if (!InternalOwl.TESTING) {
            this.fNotificationService = new NotificationService();
        }
        this.fSavedSearchService = new SavedSearchService();
        this.fDownloadService = new DownloadService();
        if (!InternalOwl.TESTING) {
            this.fSyncService = new SyncService();
        }
        this.registerListeners();
        this.loadShareProviders();
        this.fFeedSearchUrl = this.loadFeedSearchUrl();
        this.loadLinkTransformers();
    }

    private void loadShareProviders() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = reg.getConfigurationElementsFor(SHARE_PROVIDER_EXTENSION_POINT);
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            String id = element.getAttribute("id");
            String name = element.getAttribute("name");
            String iconPath = element.getAttribute("icon");
            String url = element.getAttribute("url");
            String maxTitleLength = element.getAttribute("maxTitleLength");
            String enabled = element.getAttribute("enabled");
            boolean isEnabled = enabled != null && Boolean.parseBoolean(enabled);
            this.fShareProviders.add(new ShareProvider(id, element.getNamespaceIdentifier(), i, name, iconPath, url, maxTitleLength, isEnabled));
            ++i;
        }
    }

    private void loadLinkTransformers() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = reg.getConfigurationElementsFor(LINK_TRANSFORMER_EXTENSION_POINT);
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            String id = element.getAttribute("id");
            String name = element.getAttribute("name");
            String url = element.getAttribute("url");
            this.fLinkTransformers.put(id, new LinkTransformer(id, name, url));
            ++i;
        }
    }

    private String loadFeedSearchUrl() {
        IConfigurationElement[] elements;
        String feedSearch = null;
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = reg.getConfigurationElementsFor(FEED_SEARCH_EXTENSION_POINT);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                feedSearch = element.getAttribute("searchUrl");
                String nsId = element.getNamespaceIdentifier();
                if (!nsId.contains("org.rssowl")) {
                    return feedSearch;
                }
            }
            catch (InvalidRegistryObjectException e) {
                Activator.getDefault().logError(e.getMessage(), e);
            }
            ++n2;
        }
        return feedSearch;
    }

    public List<ShareProvider> getShareProviders() {
        IPreferenceScope preferences = Owl.getPreferenceService().getGlobalScope();
        int[] providerState = preferences.getIntegers(DefaultPreferences.SHARE_PROVIDER_STATE);
        if (providerState.length > this.fShareProviders.size()) {
            return this.fShareProviders;
        }
        ArrayList<ShareProvider> sortedProviders = new ArrayList<ShareProvider>();
        int i = 0;
        while (i < providerState.length) {
            boolean enabled;
            int providerIndex = providerState[i];
            boolean bl = enabled = providerIndex > 0;
            if (providerIndex < 0) {
                providerIndex *= -1;
            }
            if (--providerIndex < this.fShareProviders.size()) {
                ShareProvider provider = this.fShareProviders.get(providerIndex);
                provider.setEnabled(enabled);
                sortedProviders.add(provider);
            }
            ++i;
        }
        for (ShareProvider shareProvider : this.fShareProviders) {
            if (sortedProviders.contains(shareProvider)) continue;
            shareProvider.setEnabled(false);
            sortedProviders.add(shareProvider);
        }
        return sortedProviders;
    }

    public void share(IStructuredSelection selection, ShareProvider provider) {
        if ("org.rssowl.ui.SendLinkAction".equals(provider.getId())) {
            SendLinkAction action = new SendLinkAction();
            action.selectionChanged(null, (ISelection)selection);
            action.run(null);
        } else {
            Object obj = selection.getFirstElement();
            if (obj != null && obj instanceof INews) {
                String shareLink = provider.toShareUrl((INews)obj);
                new OpenInBrowserAction((IStructuredSelection)new StructuredSelection((Object)shareLink)).run();
            }
        }
    }

    public List<LinkTransformer> getLinkTransformers() {
        ArrayList<LinkTransformer> transformers = new ArrayList<LinkTransformer>();
        transformers.addAll(this.fLinkTransformers.values());
        Collections.sort(transformers, new Comparator<LinkTransformer>(){

            @Override
            public int compare(LinkTransformer lt1, LinkTransformer lt2) {
                return lt1.getName().compareTo(lt2.getName());
            }
        });
        return transformers;
    }

    public LinkTransformer getLinkTransformer(String id) {
        if (id == null) {
            return null;
        }
        return this.fLinkTransformers.get(id);
    }

    public LinkTransformer getLinkTransformer(IPreferenceScope preferences) {
        LinkTransformer transformer = null;
        String transformerId = preferences.getString(DefaultPreferences.BM_TRANSFORMER_ID);
        if (transformerId != null) {
            transformer = this.getLinkTransformer(transformerId);
        }
        if (transformer != null) {
            return transformer;
        }
        return this.getLinkTransformers().get(0);
    }

    public String getEmbeddedTransformedUrl(String link) {
        LinkTransformer transformer = this.getLinkTransformer(DEFAULT_TRANSFORMER_ID);
        return String.valueOf(transformer.toTransformedUrl(link)) + DEFAULT_TRANSFORMER_EMBEDDED_PARAMETER;
    }

    public void shutdown(boolean emergency) {
        this.fShuttingDown = true;
        if (emergency || OOM_EMERGENCY_SHUTDOWN.get()) {
            this.emergencyShutdown();
        } else {
            this.normalShutdown();
        }
    }

    private void normalShutdown() {
        this.fShuttingDown = true;
        this.unregisterListeners();
        if (!this.fDisableUpdate) {
            Job.getJobManager().cancel(UpdateJob.FAMILY);
        }
        if (this.fDownloadService != null) {
            this.fDownloadService.stopService();
        }
        if (!InternalOwl.TESTING && this.fCleanUpReminderService != null) {
            this.fCleanUpReminderService.stopService();
        }
        if (!InternalOwl.TESTING && this.fFeedReloadService != null) {
            this.fFeedReloadService.stopService();
        }
        if (this.fReloadFeedQueue != null) {
            this.fReloadFeedQueue.cancel(false, true);
        }
        if (this.fSaveFeedQueue != null) {
            this.fSaveFeedQueue.cancel(true, true);
        }
        if (!InternalOwl.TESTING && this.fNotificationService != null) {
            this.fNotificationService.stopService();
        }
        if (this.fSavedSearchService != null) {
            this.fSavedSearchService.stopService();
        }
        if (this.fSyncService != null) {
            this.fSyncService.stopService(false);
        }
        ApplicationServer.getDefault().shutdown();
    }

    private void emergencyShutdown() {
        this.fShuttingDown = true;
        if (this.fReloadFeedQueue != null) {
            this.fReloadFeedQueue.seal();
        }
        if (this.fSaveFeedQueue != null) {
            this.fSaveFeedQueue.cancel(true, true);
        }
    }

    public void postWindowOpen() {
        Shell shell;
        if (!InternalOwl.TESTING) {
            this.fFeedReloadService = new FeedReloadService();
        }
        this.fCleanUpReminderService = new CleanUpReminderService();
        this.defineLabelCommands(CoreUtils.loadSortedLabels());
        this.defineSharingCommands(this.getShareProviders());
        JobRunner.runDelayedInBackgroundThread(new Runnable(){

            public void run() {
                SafeRunner.run((ISafeRunnable)new LoggingSafeRunnable(){

                    public void run() throws Exception {
                        if (!Controller.this.fShuttingDown) {
                            Controller.this.backupSubscriptions();
                        }
                    }
                });
            }
        });
        if (this.fShowWelcome) {
            this.fShowWelcome = false;
            JobRunner.runInUIThread(200, (Widget)OwlUI.getActiveShell(), new Runnable(){

                public void run() {
                    Controller.this.showWelcomeAndTutorial();
                }
            });
        } else if (!this.fDisableUpdate) {
            JobRunner.runInUIThread(5000, (Widget)OwlUI.getActiveShell(), new Runnable(){

                public void run() {
                    if (!Controller.this.fShuttingDown && Owl.getPreferenceService().getGlobalScope().getBoolean(DefaultPreferences.UPDATE_ON_STARTUP)) {
                        FindUpdatesAction action = new FindUpdatesAction(false);
                        action.init(OwlUI.getWindow());
                        action.run();
                    }
                }
            });
        }
        ApplicationServer server = ApplicationServer.getDefault();
        if (!server.isRunning() && (shell = OwlUI.getPrimaryShell()) != null) {
            MessageDialog.openError((Shell)shell, (String)Messages.Controller_ERROR, (String)NLS.bind((String)Messages.Controller_ERROR_STARTING_SERVER, (Object)server.getPort(), (Object)server.getHost()));
        }
        JobRunner.runInBackgroundThread(50, new Runnable(){

            public void run() {
                if (!Controller.this.fShuttingDown) {
                    Controller.this.fSavedSearchService.updateSavedSearches(false);
                }
            }
        });
        this.fIsStarted = true;
    }

    private void showWelcomeAndTutorial() {
        Shell activeShell = OwlUI.getActiveShell();
        WelcomeWizard welcomeWizard = new WelcomeWizard();
        OwlUI.openWizard(activeShell, welcomeWizard, true, true, null);
        if (PlatformUI.isWorkbenchRunning() && !this.fShuttingDown) {
            TutorialWizard tutorialWizard = new TutorialWizard();
            OwlUI.openWizard(activeShell, tutorialWizard, false, false, null);
        }
    }

    private void backupSubscriptions() {
        block8: {
            IPath rootPath = Platform.getLocation();
            File root = rootPath.toFile();
            if (!root.exists()) {
                root.mkdir();
            }
            IPath dailyBackupPath = rootPath.append(DAILY_BACKUP);
            IPath backupTmpPath = rootPath.append(BACKUP_TMP);
            IPath weeklyBackupPath = rootPath.append(WEEKLY_BACKUP);
            File dailyBackupFile = dailyBackupPath.toFile();
            File backupTmpFile = backupTmpPath.toFile();
            backupTmpFile.deleteOnExit();
            File weeklyBackupFile = weeklyBackupPath.toFile();
            if (dailyBackupFile.exists()) {
                long lastModified;
                if (!weeklyBackupFile.exists() || weeklyBackupFile.lastModified() + 604800000L < System.currentTimeMillis()) {
                    weeklyBackupFile.delete();
                    dailyBackupFile.renameTo(weeklyBackupFile);
                }
                if ((lastModified = dailyBackupFile.lastModified()) + 86400000L > System.currentTimeMillis()) {
                    return;
                }
            }
            try {
                Set rootFolders = CoreUtils.loadRootFolders();
                if (!rootFolders.isEmpty() && !this.fShuttingDown) {
                    Owl.getInterpreter().exportTo(backupTmpFile, (Collection)rootFolders, EnumSet.of(ITypeExporter.Options.EXPORT_FILTERS, ITypeExporter.Options.EXPORT_LABELS, ITypeExporter.Options.EXPORT_PREFERENCES));
                    if (!backupTmpFile.renameTo(dailyBackupFile)) {
                        dailyBackupFile.delete();
                        backupTmpFile.renameTo(dailyBackupFile);
                    }
                }
            }
            catch (InterpreterException e) {
                if (this.fShuttingDown) break block8;
                Activator.safeLogError(e.getMessage(), e);
            }
        }
    }

    public boolean isShuttingDown() {
        return this.fShuttingDown;
    }

    public boolean isEmergencyShutdown() {
        return OOM_EMERGENCY_SHUTDOWN.get();
    }

    public boolean isRestarting() {
        return this.fRestarting;
    }

    public boolean isStarted() {
        return this.fIsStarted;
    }

    public boolean isOffline() {
        return IS_OFFLINE.get();
    }

    public void setOffline(boolean offline) {
        IS_OFFLINE.set(offline);
    }

    public boolean preUIShutdown() {
        if (!(this.isRestarting() || this.isShuttingDown() || this.isEmergencyShutdown() || this.fDownloadService == null || !this.fDownloadService.isActive() || this.openWarningConfirm(OwlUI.getActiveShell(), Messages.Controller_EXIT_RSSOWL, Messages.Controller_CANCEL_ACTIVE_DOWNLOADS))) {
            return false;
        }
        this.fShuttingDown = true;
        return true;
    }

    private boolean openWarningConfirm(Shell parent, String title, String message) {
        MessageDialog dialog = new MessageDialog(parent, title, null, message, 4, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        return dialog.open() == 0;
    }

    private void onFirstStartup() {
        boolean isDefaultStartup = true;
        boolean addDefaultLabels = true;
        String importFile = System.getProperty(IMPORT_PROPERTY);
        if (StringUtils.isSet((String)importFile) && new File(importFile).exists()) {
            try {
                List<? extends IEntity> importedEntities = this.initialImportFile(importFile);
                if (importedEntities != null) {
                    for (IEntity iEntity : importedEntities) {
                        if (!(iEntity instanceof ILabel)) continue;
                        addDefaultLabels = false;
                        break;
                    }
                }
                isDefaultStartup = false;
            }
            catch (Exception e) {
                Activator.safeLogError(e.getMessage(), e);
            }
        }
        if (addDefaultLabels) {
            this.addDefaultLabels();
        }
        if (isDefaultStartup) {
            this.fShowWelcome = true;
            IPreferenceScope globalPreferences = Owl.getPreferenceService().getGlobalScope();
            globalPreferences.putBoolean(DefaultPreferences.ALWAYS_REUSE_FEEDVIEW, true);
            DynamicDAO.save((IPersistable)Owl.getModelFactory().createFolder(null, null, Messages.Controller_MY_BOOKMARKS));
        }
    }

    private void onSubsequentStartup() {
        IPreferenceScope pref = Owl.getPreferenceService().getGlobalScope();
        if (pref.hasKey(DefaultPreferences.FV_LAYOUT)) {
            return;
        }
        if (pref.hasKey(LEGACY_PREF_BROWSER_MAXIMIZED) || pref.hasKey(LEGACY_PREF_LAYOUT_CLASSIC)) {
            boolean browserMaximized = pref.getBoolean(LEGACY_PREF_BROWSER_MAXIMIZED);
            boolean layoutClassic = pref.getBoolean(LEGACY_PREF_LAYOUT_CLASSIC);
            pref.delete(LEGACY_PREF_BROWSER_MAXIMIZED);
            pref.delete(LEGACY_PREF_LAYOUT_CLASSIC);
            if (browserMaximized && !layoutClassic) {
                pref.putInteger(DefaultPreferences.FV_LAYOUT, OwlUI.Layout.NEWSPAPER.ordinal());
            } else if (!browserMaximized && !layoutClassic) {
                pref.putInteger(DefaultPreferences.FV_LAYOUT, OwlUI.Layout.VERTICAL.ordinal());
            }
        }
        if (pref.hasKey(DefaultPreferences.BM_LOAD_IMAGES) && !pref.getBoolean(DefaultPreferences.BM_LOAD_IMAGES)) {
            pref.putBoolean(DefaultPreferences.ENABLE_IMAGES, false);
            pref.putBoolean(DefaultPreferences.ENABLE_MEDIA, false);
            pref.delete(DefaultPreferences.BM_LOAD_IMAGES);
        }
    }

    private void addDefaultLabels() throws PersistenceException {
        ILabel label = this.fFactory.createLabel(null, Messages.Controller_IMPORTANT);
        label.setColor("163,21,2");
        label.setOrder(0);
        this.fLabelDao.save((IPersistable)label);
        label = this.fFactory.createLabel(null, Messages.Controller_WORK);
        label.setColor("200,118,10");
        label.setOrder(1);
        this.fLabelDao.save((IPersistable)label);
        label = this.fFactory.createLabel(null, Messages.Controller_PERSONAL);
        label.setColor("82,92,58");
        label.setOrder(2);
        this.fLabelDao.save((IPersistable)label);
        label = this.fFactory.createLabel(null, Messages.Controller_TODO);
        label.setColor("92,101,126");
        label.setOrder(3);
        this.fLabelDao.save((IPersistable)label);
        label = this.fFactory.createLabel(null, Messages.Controller_LATER);
        label.setColor("82,16,0");
        label.setOrder(4);
        this.fLabelDao.save((IPersistable)label);
    }

    private List<? extends IEntity> initialImportFile(String file) throws PersistenceException, InterpreterException, ParserException, FileNotFoundException {
        FileInputStream inS = new FileInputStream(file);
        List types = Owl.getInterpreter().importFrom((InputStream)inS);
        ImportUtils.doImport(null, types, false);
        return types;
    }

    private IStatus createInfoStatus(IStatus status, IBookMark bookmark, URI feedLink) {
        StringBuilder msg = this.createLogEntry(bookmark, feedLink, status.getMessage());
        return new Status(1, status.getPlugin(), status.getCode(), msg.toString(), null);
    }

    StringBuilder createLogEntry(IBookMark bookmark, URI feedLink, String msg) {
        StringBuilder entry = new StringBuilder();
        entry.append(NLS.bind((String)Messages.Controller_ERROR_LOADING, (Object)bookmark.getName()));
        if (StringUtils.isSet((String)msg)) {
            entry.append(this.fNl).append(NLS.bind((String)Messages.Controller_PROBLEM, (Object)msg));
        }
        if (feedLink != null) {
            entry.append(this.fNl).append(NLS.bind((String)Messages.Controller_LINK, (Object)feedLink));
        } else if (bookmark.getFeedLinkReference() != null) {
            entry.append(this.fNl).append(NLS.bind((String)Messages.Controller_LINK, (Object)bookmark.getFeedLinkReference().getLinkAsText()));
        }
        return entry;
    }

    private void defineLabelCommands(Collection<ILabel> labels) {
        if (InternalOwl.TESTING) {
            return;
        }
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        if (commandService == null) {
            return;
        }
        for (ILabel label : labels) {
            Command command = commandService.getCommand(LABEL_ACTION_PREFIX + label.getOrder());
            command.define(NLS.bind((String)Messages.Controller_LABEL, (Object)label.getName()), NLS.bind((String)Messages.Controller_LABEL_MSG, (Object)label.getName()), commandService.getCategory(RSSOWL_KEYBINDING_CATEGORY));
            command.setHandler((IHandler)new LabelNewsHandler(label));
        }
    }

    private void defineSharingCommands(List<ShareProvider> shareProviders) {
        if (InternalOwl.TESTING) {
            return;
        }
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        if (commandService == null) {
            return;
        }
        for (ShareProvider provider : shareProviders) {
            Command command = commandService.getCommand(provider.getId());
            command.define(NLS.bind((String)Messages.Controller_SHARE, (Object)provider.getName()), NLS.bind((String)Messages.Controller_SHARE_MSG, (Object)provider.getName()), commandService.getCategory(RSSOWL_KEYBINDING_CATEGORY));
            command.setHandler((IHandler)new ShareNewsHandler(provider));
        }
    }

    private void updateLabelCommands() {
        Set labels = CoreUtils.loadSortedLabels();
        this.undefineLabelCommands(labels);
        this.defineLabelCommands(labels);
    }

    private void undefineLabelCommands(Collection<ILabel> labels) {
        if (InternalOwl.TESTING) {
            return;
        }
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        if (commandService == null) {
            return;
        }
        for (ILabel label : labels) {
            commandService.getCommand(LABEL_ACTION_PREFIX + label.getOrder()).undefine();
        }
    }

    public void addBookMarkLoadListener(BookMarkLoadListener listener) {
        this.fBookMarkLoadListeners.add((Object)listener);
    }

    public void removeBookMarkLoadListener(BookMarkLoadListener listener) {
        this.fBookMarkLoadListeners.remove((Object)listener);
    }

    public Lock getLoginDialogLock() {
        return this.fLoginDialogLock;
    }

    public String toFeedSearchLink(String keywords) {
        String encodedKeywords = URIUtils.urlEncode((String)keywords.trim());
        return StringUtils.replaceAll((String)this.fFeedSearchUrl, (String)FEED_SEARCH_KEYWORD_TOKEN, (String)encodedKeywords);
    }

    private void fireBookMarkAboutToLoad(final IBookMark bookmark) {
        Object[] listeners;
        Object[] objectArray = listeners = this.fBookMarkLoadListeners.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            final Object listener = objectArray[n2];
            SafeRunner.run((ISafeRunnable)new LoggingSafeRunnable(){

                public void run() throws Exception {
                    ((BookMarkLoadListener)listener).bookMarkAboutToLoad(bookmark);
                }
            });
            ++n2;
        }
    }

    private void fireBookMarkDoneLoading(final IBookMark bookmark) {
        Object[] listeners;
        Object[] objectArray = listeners = this.fBookMarkLoadListeners.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            final Object listener = objectArray[n2];
            SafeRunner.run((ISafeRunnable)new LoggingSafeRunnable(){

                public void run() throws Exception {
                    ((BookMarkLoadListener)listener).bookMarkDoneLoading(bookmark);
                }
            });
            ++n2;
        }
    }

    public void stopUpdate() {
        this.fReloadFeedQueue.cancel(false, false);
    }

    public boolean isPortable() {
        return this.fPortable;
    }

    public boolean isUpdateDisabled() {
        return this.fDisableUpdate;
    }

    public void restart() {
        if (this.fDownloadService.isActive()) {
            MessageDialog.openWarning((Shell)OwlUI.getActiveShell(), (String)Messages.Controller_RESTART_RSSOWL, (String)Messages.Controller_ACTIVE_DOWNLOADS_WARNING);
            return;
        }
        this.fRestarting = true;
        PlatformUI.getWorkbench().restart();
    }

    public void emergencyOutOfMemoryShutdown(final OutOfMemoryError error) {
        this.fShuttingDown = true;
        if (OOM_EMERGENCY_SHUTDOWN.getAndSet(true)) {
            return;
        }
        JobRunner.runInUIThread(null, new Runnable(){

            public void run() {
                try {
                    ApplicationWorkbenchAdvisor.fgPrimaryApplicationWorkbenchWindowAdvisor.getWindowConfigurer().getWorkbenchConfigurer().emergencyClose();
                    Status errorStatus = new Status(4, "org.rssowl.ui", 4, error.getMessage(), (Throwable)error);
                    FatalOutOfMemoryErrorDialog dialog = new FatalOutOfMemoryErrorDialog((IStatus)errorStatus);
                    if (dialog.open() == 17) {
                        Program.launch((String)"http://www.rssowl.org/help#item_6g");
                    }
                }
                catch (Error error2) {
                    System.exit(0);
                }
            }
        });
    }

    public static interface BookMarkLoadListener {
        public void bookMarkAboutToLoad(IBookMark var1);

        public void bookMarkDoneLoading(IBookMark var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ReloadTask
    implements ITask {
        private final Long fId;
        private final IBookMark fBookMark;
        private final Shell fShell;
        private final ITask.Priority fPriority;
        private final Map<Object, Object> fProperties;

        ReloadTask(IBookMark bookmark, Map<Object, Object> properties, Shell shell, ITask.Priority priority) {
            this.fProperties = properties;
            Assert.isNotNull((Object)bookmark);
            Assert.isNotNull((Object)bookmark.getId());
            this.fBookMark = bookmark;
            this.fId = bookmark.getId();
            this.fShell = shell;
            this.fPriority = priority;
        }

        public IStatus run(IProgressMonitor monitor) {
            IStatus status = Controller.this.reload(this.fBookMark, this.fProperties, this.fShell, monitor);
            return status;
        }

        public String getName() {
            return this.fBookMark.getName();
        }

        public ITask.Priority getPriority() {
            return this.fPriority;
        }

        public int hashCode() {
            return this.fId.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ReloadTask other = (ReloadTask)obj;
            return this.fId.equals(other.fId);
        }
    }
}

