/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.spec.PBEKeySpec;
import org.eclipse.equinox.security.storage.EncodingUtils;
import org.eclipse.equinox.security.storage.provider.IPreferencesContainer;
import org.eclipse.equinox.security.storage.provider.PasswordProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.rssowl.ui.internal.Activator;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.dialogs.MasterPasswordDialog;
import org.rssowl.ui.internal.util.JobRunner;

public class DefaultPasswordProvider
extends PasswordProvider {
    private static final String DIGEST_ALGORITHM = "MD5";

    public PBEKeySpec getPassword(IPreferencesContainer container, final int passwordType) {
        if (!PlatformUI.isWorkbenchRunning()) {
            return null;
        }
        final PBEKeySpec[] spec = new PBEKeySpec[1];
        final Shell activeShell = OwlUI.getActiveShell();
        JobRunner.runSyncedInUIThread((Widget)activeShell, new Runnable(){

            public void run() {
                MasterPasswordDialog dialog = new MasterPasswordDialog(activeShell, passwordType);
                if (dialog.open() == 0) {
                    String internalPassword;
                    String masterPassword = dialog.getMasterPassword();
                    try {
                        MessageDigest digest = MessageDigest.getInstance(DefaultPasswordProvider.DIGEST_ALGORITHM);
                        byte[] digested = digest.digest(masterPassword.getBytes());
                        internalPassword = EncodingUtils.encodeBase64((byte[])digested);
                    }
                    catch (NoSuchAlgorithmException e) {
                        Activator.safeLogError(e.getMessage(), e);
                        internalPassword = masterPassword;
                    }
                    spec[0] = new PBEKeySpec(internalPassword.toCharArray());
                }
            }
        });
        return spec[0];
    }
}

