/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.actions;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.update.internal.ui.UpdateUI;
import org.eclipse.update.internal.ui.wizards.InstallWizard2;
import org.eclipse.update.internal.ui.wizards.ResizableInstallWizardDialog;
import org.eclipse.update.search.BackLevelFilter;
import org.eclipse.update.search.EnvironmentFilter;
import org.eclipse.update.search.IUpdateSearchFilter;
import org.eclipse.update.search.UpdateSearchRequest;
import org.eclipse.update.search.UpdateSearchScope;
import org.eclipse.update.ui.UpdateJob;
import org.rssowl.core.util.StringUtils;
import org.rssowl.ui.internal.actions.Messages;

public class FindExtensionsAction
extends Action
implements IWorkbenchWindowActionDelegate {
    private static final String UPDATE_SITE = "http://boreal.rssowl.org/update/addons/";
    private static final String NLS_UPDATE_SITE = "http://boreal.rssowl.org/update/nls/";
    private static final String EXTENSION_SITES_PROPERTY = "addonSites";
    private static final String EXTENSION_SITES_DIVIDER = "\\|";
    private Shell fShell;
    private boolean fFindTranslations;

    public void setFindTranslations(boolean findTranslations) {
        this.fFindTranslations = findTranslations;
    }

    public void run() {
        BusyIndicator.showWhile((Display)this.fShell.getDisplay(), (Runnable)new Runnable(){

            public void run() {
                UpdateJob job = new UpdateJob(Messages.FindExtensionsAction_SEARCHING_EXTENSIONS, FindExtensionsAction.this.getSearchRequest());
                job.setUser(true);
                job.setPriority(10);
                new InstallWizardOperation().run(FindExtensionsAction.this.fShell, job);
            }
        });
    }

    UpdateSearchRequest getSearchRequest() {
        UpdateSearchScope scope = new UpdateSearchScope();
        String extensionSites = System.getProperty(EXTENSION_SITES_PROPERTY);
        if (StringUtils.isSet((String)extensionSites)) {
            String[] sites;
            String[] stringArray = sites = extensionSites.split(EXTENSION_SITES_DIVIDER);
            int n = sites.length;
            int n2 = 0;
            while (n2 < n) {
                String site = stringArray[n2];
                try {
                    URL url = new URL(site);
                    scope.addSearchSite(url.toString(), url, null);
                }
                catch (MalformedURLException malformedURLException) {}
                ++n2;
            }
        }
        if (scope.getSearchSites().length == 0) {
            try {
                URL url = new URL(this.fFindTranslations ? NLS_UPDATE_SITE : UPDATE_SITE);
                scope.addSearchSite("RSSOwl.org", url, null);
            }
            catch (MalformedURLException malformedURLException) {}
        }
        UpdateSearchRequest result = new UpdateSearchRequest(UpdateSearchRequest.createDefaultSiteSearchCategory(), scope);
        result.addFilter((IUpdateSearchFilter)new BackLevelFilter());
        result.addFilter((IUpdateSearchFilter)new EnvironmentFilter());
        return result;
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.fShell = window.getShell();
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    private static class InstallWizardOperation {
        private UpdateJob fJob;
        private IJobChangeListener fJobListener;
        private Shell fShell;
        private Shell fParentShell;

        private InstallWizardOperation() {
        }

        void run(Shell parent, UpdateJob task) {
            this.fShell = parent;
            if (this.fShell.getParent() != null && this.fShell.getParent() instanceof Shell) {
                this.fParentShell = (Shell)this.fShell.getParent();
            }
            if (this.fJobListener != null) {
                Job.getJobManager().removeJobChangeListener(this.fJobListener);
            }
            if (this.fJob != null) {
                Job.getJobManager().cancel((Object)this.fJob);
            }
            this.fJob = task;
            this.fJobListener = new UpdateJobChangeListener();
            Job.getJobManager().addJobChangeListener(this.fJobListener);
            this.fJob.schedule();
        }

        private Shell getValidShell() {
            if (this.fShell.isDisposed()) {
                return this.fParentShell;
            }
            return this.fShell;
        }

        private class UpdateJobChangeListener
        extends JobChangeAdapter {
            private UpdateJobChangeListener() {
            }

            public void done(IJobChangeEvent event) {
                final Shell validShell = InstallWizardOperation.this.getValidShell();
                if (event.getJob() == InstallWizardOperation.this.fJob) {
                    Job.getJobManager().removeJobChangeListener((IJobChangeListener)this);
                    Job.getJobManager().cancel((Object)InstallWizardOperation.this.fJob);
                    if (InstallWizardOperation.this.fJob.getStatus() == Status.CANCEL_STATUS) {
                        return;
                    }
                    if (InstallWizardOperation.this.fJob.getStatus() != Status.OK_STATUS) {
                        InstallWizardOperation.this.getValidShell().getDisplay().syncExec(new Runnable(){

                            public void run() {
                                UpdateUI.log((IStatus)InstallWizardOperation.this.fJob.getStatus(), (boolean)true);
                            }
                        });
                    }
                    validShell.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            validShell.getDisplay().beep();
                            BusyIndicator.showWhile((Display)validShell.getDisplay(), (Runnable)new Runnable(){

                                public void run() {
                                    UpdateJobChangeListener.this.openInstallWizard2();
                                }
                            });
                        }
                    });
                }
            }

            private void openInstallWizard2() {
                Composite container;
                Control[] children;
                Control control;
                if (InstallWizard2.isRunning()) {
                    MessageDialog.openInformation((Shell)InstallWizardOperation.this.getValidShell(), (String)Messages.FindExtensionsAction_FIND_ADDONS, (String)Messages.FindExtensionsAction_UPDATE_IN_PROGRESS);
                    return;
                }
                if (InstallWizardOperation.this.fJob.getUpdates() == null || InstallWizardOperation.this.fJob.getUpdates().length == 0) {
                    if (InstallWizardOperation.this.fJob.isUpdate()) {
                        MessageDialog.openInformation((Shell)InstallWizardOperation.this.getValidShell(), (String)Messages.FindExtensionsAction_FIND_ADDONS, (String)Messages.FindExtensionsAction_NO_UPDATES_FOUND);
                    } else {
                        MessageDialog.openInformation((Shell)InstallWizardOperation.this.getValidShell(), (String)Messages.FindExtensionsAction_FIND_ADDONS, (String)Messages.FindExtensionsAction_NO_ADDONS_FOUND);
                    }
                    return;
                }
                InstallWizard2 wizard = new InstallWizard2(InstallWizardOperation.this.fJob.getSearchRequest(), InstallWizardOperation.this.fJob.getUpdates(), InstallWizardOperation.this.fJob.isUpdate());
                ResizableInstallWizardDialog dialog = new ResizableInstallWizardDialog(InstallWizardOperation.this.getValidShell(), (IWizard)wizard, Messages.FindExtensionsAction_RSSOWL_ADDONS);
                dialog.create();
                if (dialog.getCurrentPage() != null && (control = dialog.getCurrentPage().getControl()) != null && !control.isDisposed() && control instanceof Composite && (children = (container = (Composite)control).getChildren()) != null && children.length == 1 && children[0] instanceof Composite && (children = (container = (Composite)children[0]).getChildren()).length > 2 && children[1] instanceof SashForm) {
                    Tree tree;
                    SashForm form = (SashForm)children[1];
                    form.setWeights(new int[]{70, 30});
                    Control[] formChilds = form.getChildren();
                    if (formChilds.length != 0 && formChilds[0] instanceof Tree && (tree = (Tree)formChilds[0]).getItemCount() != 0) {
                        TreeItem root = tree.getItem(0);
                        root.setExpanded(true);
                    }
                }
                dialog.open();
            }
        }
    }
}

