/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.rssowl.core.persist.IFolder;
import org.rssowl.core.persist.IMark;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.dialogs.bookmark.CreateBookmarkWizard;

public class NewBookMarkAction
implements IWorkbenchWindowActionDelegate,
IObjectActionDelegate {
    private static final String SETTINGS_SECTION = "org.rssowl.ui.internal.dialogs.bookmark.CreateBookmarkWizard";
    private Shell fShell;
    private IFolder fParent;
    private IMark fPosition;
    private String fPreSetLink;

    public NewBookMarkAction() {
        this(null, null, null);
    }

    public NewBookMarkAction(Shell shell, IFolder parent, IMark position) {
        this(shell, parent, position, null);
    }

    public NewBookMarkAction(Shell shell, IFolder parent, IMark position, String preSetLink) {
        this.fShell = shell;
        this.fParent = parent;
        this.fPreSetLink = preSetLink;
        this.fPosition = position;
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.fShell = window.getShell();
    }

    public void run(IAction action) {
        IFolder parent = OwlUI.getSelectedParent(this.fParent);
        CreateBookmarkWizard wizard = new CreateBookmarkWizard(parent, this.fPosition, this.fPreSetLink);
        OwlUI.openWizard(this.fShell, wizard, true, true, SETTINGS_SECTION);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection structSel;
        this.fParent = null;
        this.fPosition = null;
        if (selection instanceof IStructuredSelection && !(structSel = (IStructuredSelection)selection).isEmpty()) {
            Object firstElement = structSel.getFirstElement();
            if (firstElement instanceof IFolder) {
                this.fParent = (IFolder)firstElement;
            } else if (firstElement instanceof IMark) {
                this.fParent = ((IMark)firstElement).getParent();
                this.fPosition = (IMark)firstElement;
            }
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.fShell = targetPart.getSite().getShell();
    }
}

