/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.rssowl.core.persist.IBookMark;
import org.rssowl.core.persist.IFolderChild;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.INewsMark;
import org.rssowl.core.persist.reference.FeedLinkReference;
import org.rssowl.core.persist.reference.NewsBinReference;
import org.rssowl.core.persist.reference.NewsReference;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.ui.internal.FolderNewsMark;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.actions.Messages;
import org.rssowl.ui.internal.editors.feed.FeedView;
import org.rssowl.ui.internal.editors.feed.FeedViewInput;
import org.rssowl.ui.internal.editors.feed.PerformAfterInputSet;
import org.rssowl.ui.internal.util.EditorUtils;
import org.rssowl.ui.internal.views.explorer.BookMarkExplorer;

public class OpenNewsAction
extends Action {
    private IStructuredSelection fSelection;
    private Shell fShellToMinimize;
    private boolean fRestoreWindow;
    private boolean fPreferActiveFeedView;

    public OpenNewsAction(IStructuredSelection selection) {
        this(selection, null);
    }

    public OpenNewsAction(IStructuredSelection selection, Shell shellToMinimize) {
        Assert.isTrue((selection != null && !selection.isEmpty() ? 1 : 0) != 0);
        this.fSelection = selection;
        this.fShellToMinimize = shellToMinimize;
        this.setText(Messages.OpenNewsAction_OPEN);
    }

    public void setRestoreWindow(boolean restoreWindow) {
        this.fRestoreWindow = restoreWindow;
    }

    public void setPreferActiveFeedView() {
        this.fPreferActiveFeedView = true;
    }

    public void run() {
        this.internalRun();
    }

    public void runWithEvent(Event event) {
        this.internalRun();
    }

    private void internalRun() {
        INews news;
        IWorkbenchPage page = OwlUI.getPage();
        if (page == null) {
            return;
        }
        if (this.fRestoreWindow) {
            OwlUI.restoreWindow(page);
        }
        int openedEditors = 0;
        int maxOpenEditors = EditorUtils.getOpenEditorLimit();
        List list = this.fSelection.toList();
        ArrayList<FeedLinkReference> handledFeeds = new ArrayList<FeedLinkReference>(list.size() / 2);
        ArrayList<Long> handledBins = new ArrayList<Long>(list.size() / 2);
        ArrayList<INews> newsToOpen = new ArrayList<INews>(list.size());
        for (Object selection : list) {
            if (!(selection instanceof INews)) continue;
            news = (INews)selection;
            if (news.getParentId() != 0L) {
                if (handledBins.contains(news.getParentId())) continue;
                newsToOpen.add(news);
                handledBins.add(news.getParentId());
                continue;
            }
            FeedLinkReference feedRef = news.getFeedReference();
            if (handledFeeds.contains(feedRef)) continue;
            newsToOpen.add(news);
            handledFeeds.add(feedRef);
        }
        if (newsToOpen.size() > 0 && this.fShellToMinimize != null) {
            this.fShellToMinimize.setMinimized(true);
        }
        if (this.fPreferActiveFeedView && newsToOpen.size() == 1) {
            INews news2 = (INews)newsToOpen.get(0);
            FeedView feedView = OwlUI.getActiveFeedView();
            if (feedView != null && feedView.contains(news2)) {
                feedView.getSite().getPage().activate((IWorkbenchPart)feedView);
                feedView.setSelection((IStructuredSelection)new StructuredSelection((Object)news2));
                INewsMark child = ((FeedViewInput)feedView.getEditorInput()).getMark();
                if (child instanceof FolderNewsMark) {
                    child = ((FolderNewsMark)child).getFolder();
                }
                this.reveal((IFolderChild)child);
                return;
            }
        }
        IBookMark lastOpenedNewsMark = null;
        int i = 0;
        while (i < newsToOpen.size() && openedEditors < maxOpenEditors) {
            news = (INews)newsToOpen.get(i);
            Object newsmark = news.getParentId() != 0L ? new NewsBinReference(news.getParentId()).resolve() : CoreUtils.getBookMark((FeedLinkReference)news.getFeedReference());
            if (newsmark != null) {
                this.openAndSelect(page, news, (INewsMark)newsmark);
                ++openedEditors;
                lastOpenedNewsMark = newsmark;
            }
            ++i;
        }
        this.reveal((IFolderChild)lastOpenedNewsMark);
    }

    private void reveal(IFolderChild child) {
        BookMarkExplorer explorer = OwlUI.getOpenedBookMarkExplorer();
        if (explorer != null && child != null && !explorer.isLinkingEnabled()) {
            explorer.reveal(child, false);
        }
    }

    private void openAndSelect(IWorkbenchPage page, INews news, INewsMark newsmark) {
        PerformAfterInputSet perform = PerformAfterInputSet.selectNews(new NewsReference(news.getId().longValue()));
        perform.setActivate(false);
        FeedViewInput fvInput = new FeedViewInput(newsmark, perform);
        FeedView feedview = null;
        IEditorPart existingEditor = page.findEditor((IEditorInput)fvInput);
        if (existingEditor != null && existingEditor instanceof FeedView) {
            feedview = (FeedView)existingEditor;
            existingEditor.getSite().getPage().activate((IWorkbenchPart)existingEditor);
            feedview.setSelection((IStructuredSelection)new StructuredSelection((Object)news));
        } else {
            OwlUI.openInFeedView(page, (IStructuredSelection)new StructuredSelection((Object)newsmark), true, false, perform);
        }
    }
}

