/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.dialogs.fatal;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.rssowl.core.Owl;
import org.rssowl.core.internal.InternalOwl;
import org.rssowl.core.persist.service.PersistenceException;
import org.rssowl.core.persist.service.ProfileLockedException;
import org.rssowl.core.util.StringUtils;
import org.rssowl.ui.internal.Activator;
import org.rssowl.ui.internal.Application;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.dialogs.fatal.CleanProfilePage;
import org.rssowl.ui.internal.dialogs.fatal.ErrorInfoPage;
import org.rssowl.ui.internal.dialogs.fatal.Messages;
import org.rssowl.ui.internal.dialogs.fatal.RecreateSearchIndexPage;
import org.rssowl.ui.internal.dialogs.fatal.RestoreBackupPage;
import org.rssowl.ui.internal.util.ImportUtils;

public class FatalErrorWizard
extends Wizard {
    private ErrorInfoPage fErrorInfoPage;
    private RestoreBackupPage fRestoreBackupPage;
    private CleanProfilePage fCleanProfilePage;
    private RecreateSearchIndexPage fReindexSearchPage;
    private final IStatus fErrorStatus;
    private int fReturnCode = IApplication.EXIT_OK;
    private final List<File> fProfileBackups = new ArrayList<File>();
    private final List<File> fOPMLBackups = new ArrayList<File>();
    private boolean fOfferRestorePages;

    public FatalErrorWizard(IStatus errorStatus) {
        this(errorStatus, false);
    }

    public FatalErrorWizard(IStatus errorStatus, boolean forceAllowRestore) {
        this.fErrorStatus = errorStatus;
        boolean isOOMError = this.fErrorStatus.getException() instanceof OutOfMemoryError;
        boolean isProfileLockedError = this.fErrorStatus.getException() instanceof ProfileLockedException;
        boolean canUsePersistenceService = InternalOwl.getDefault().getPersistenceService() != null;
        Owl.StartLevel startLevel = InternalOwl.getDefault().getStartLevel();
        boolean bl = this.fOfferRestorePages = !isOOMError && !isProfileLockedError && canUsePersistenceService && startLevel != Owl.StartLevel.STARTED && startLevel != Owl.StartLevel.SEARCH_INDEX_OPENED;
        if (forceAllowRestore) {
            Activator.safeLogInfo("Opening Fatal Error Wizard (forced by user)");
        } else if (!isOOMError && !isProfileLockedError) {
            Activator.safeLogInfo(this.fOfferRestorePages ? "Opening Fatal Error Wizard (offering restore options)" : "Opening Fatal Error Wizard (without restore options)");
        }
        if (!this.fOfferRestorePages && forceAllowRestore && canUsePersistenceService) {
            this.fOfferRestorePages = true;
        }
        if (this.fOfferRestorePages) {
            this.findBackups();
        }
    }

    private void findBackups() {
        IPath backPath;
        File backupDir;
        this.fProfileBackups.addAll(InternalOwl.getDefault().getProfileBackups());
        if (this.fProfileBackups.isEmpty() && (backupDir = (backPath = Platform.getLocation()).toFile()).exists()) {
            File weeklyBackupFile;
            File dailyBackupFile = backPath.append("backup.opml").toFile();
            if (dailyBackupFile.exists()) {
                this.fOPMLBackups.add(dailyBackupFile);
            }
            if ((weeklyBackupFile = backPath.append("backup_weekly.opml").toFile()).exists()) {
                this.fOPMLBackups.add(weeklyBackupFile);
            }
        }
    }

    public void addPages() {
        this.setWindowTitle(this.fErrorStatus.isOK() ? Messages.FatalErrorWizard_PROFILE_RECOVERY : Messages.FatalErrorWizard_CRASH_REPORTER);
        this.setHelpAvailable(false);
        if (!this.fErrorStatus.isOK() || !this.fOfferRestorePages) {
            this.fErrorInfoPage = new ErrorInfoPage(Messages.FatalErrorWizard_WE_ARE_SORRY, this.fErrorStatus, this.fOfferRestorePages);
            this.addPage((IWizardPage)this.fErrorInfoPage);
        }
        if (this.fOfferRestorePages) {
            if (Owl.getStartLevel() == Owl.StartLevel.DB_OPENED) {
                this.fReindexSearchPage = new RecreateSearchIndexPage(Messages.FatalErrorWizard_RECREATE_SEARCH_INDEX);
                this.addPage((IWizardPage)this.fReindexSearchPage);
            } else if (!this.fProfileBackups.isEmpty()) {
                this.fRestoreBackupPage = new RestoreBackupPage(Messages.FatalErrorWizard_RESTORE_BACKUP, this.fErrorStatus, this.fProfileBackups);
                this.addPage((IWizardPage)this.fRestoreBackupPage);
            } else {
                this.fCleanProfilePage = new CleanProfilePage(this.fOPMLBackups.isEmpty() ? Messages.FatalErrorWizard_START_OVER : Messages.FatalErrorWizard_RESTORE_SUBSCRIPTIONS_SETTINGS, this.fErrorStatus, !this.fOPMLBackups.isEmpty());
                this.addPage((IWizardPage)this.fCleanProfilePage);
            }
        }
    }

    public boolean performFinish() {
        try {
            BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    FatalErrorWizard.this.internalPerformFinish();
                }
            });
        }
        catch (Throwable e) {
            Activator.getDefault().logError(e.getMessage(), e);
            String msg = StringUtils.isSet((String)e.getMessage()) ? NLS.bind((String)Messages.FatalErrorWizard_RESTORE_ERROR_N, (Object)e.getMessage()) : Messages.FatalErrorWizard_RESTORE_ERROR;
            ((WizardPage)this.getContainer().getCurrentPage()).setMessage(msg, 3);
            return false;
        }
        if (Application.IS_WINDOWS && !this.fErrorStatus.isOK()) {
            this.fReturnCode = IApplication.EXIT_RESTART;
        }
        return true;
    }

    private void internalPerformFinish() throws PersistenceException {
        if (this.fReindexSearchPage != null) {
            InternalOwl.getDefault().getPersistenceService().getModelSearch().reIndexOnNextStartup();
        } else if (this.fRestoreBackupPage != null && this.fRestoreBackupPage.getSelectedBackup() != null) {
            InternalOwl.getDefault().restoreProfile(this.fRestoreBackupPage.getSelectedBackup());
        } else if (this.fCleanProfilePage != null && this.fCleanProfilePage.doCleanProfile()) {
            boolean needsEmergencyStartup = !this.fOPMLBackups.isEmpty();
            InternalOwl.getDefault().recreateProfile(needsEmergencyStartup);
            if (!this.fOPMLBackups.isEmpty()) {
                List types;
                block12: {
                    types = null;
                    File recentBackup = this.fOPMLBackups.get(0);
                    try {
                        types = Owl.getInterpreter().importFrom((InputStream)new FileInputStream(recentBackup));
                    }
                    catch (Exception e) {
                        if (this.fOPMLBackups.size() != 1) break block12;
                        throw new PersistenceException(e.getMessage(), (Throwable)e);
                    }
                }
                if (types == null && this.fOPMLBackups.size() == 2) {
                    File weeklyBackup = this.fOPMLBackups.get(1);
                    try {
                        types = Owl.getInterpreter().importFrom((InputStream)new FileInputStream(weeklyBackup));
                    }
                    catch (Exception e) {
                        throw new PersistenceException(e.getMessage(), (Throwable)e);
                    }
                }
                if (types != null) {
                    ImportUtils.doImport(null, types, false);
                }
            }
            OwlUI.clearFavicons();
        }
    }

    public boolean canFinish() {
        if (this.fRestoreBackupPage != null && this.getContainer().getCurrentPage() != this.fRestoreBackupPage) {
            return false;
        }
        if (this.fCleanProfilePage != null && this.getContainer().getCurrentPage() != this.fCleanProfilePage) {
            return false;
        }
        if (this.fReindexSearchPage != null && this.getContainer().getCurrentPage() != this.fReindexSearchPage) {
            return false;
        }
        return super.canFinish();
    }

    public boolean needsProgressMonitor() {
        return false;
    }

    public int getReturnCode() {
        return this.fReturnCode;
    }
}

