/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.dialogs.preferences;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.rssowl.core.Owl;
import org.rssowl.core.internal.persist.pref.DefaultPreferences;
import org.rssowl.core.persist.IBookMark;
import org.rssowl.core.persist.IFolder;
import org.rssowl.core.persist.IMark;
import org.rssowl.core.persist.INewsMark;
import org.rssowl.core.persist.pref.IPreferenceScope;
import org.rssowl.core.persist.service.PersistenceException;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.core.util.RetentionStrategy;
import org.rssowl.ui.internal.Controller;
import org.rssowl.ui.internal.FolderNewsMark;
import org.rssowl.ui.internal.LinkTransformer;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.dialogs.preferences.Messages;
import org.rssowl.ui.internal.editors.feed.NewsColumnViewModel;
import org.rssowl.ui.internal.editors.feed.NewsFilter;
import org.rssowl.ui.internal.editors.feed.NewsGrouping;
import org.rssowl.ui.internal.services.FeedReloadService;
import org.rssowl.ui.internal.util.EditorUtils;
import org.rssowl.ui.internal.util.LayoutUtils;
import org.rssowl.ui.internal.util.ModelUtils;
import org.rssowl.ui.internal.util.NewsColumnSelectionControl;

public class FeedsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static String ID = "org.rssowl.ui.FeedsPreferences";
    private static final long DAY_IN_SECONDS = 86400L;
    private static final long HOUR_IN_SECONDS = 3600L;
    private static final long MINUTE_IN_SECONDS = 60L;
    private static final int SECONDS_SCOPE = 0;
    private static final int MINUTES_SCOPE = 1;
    private static final int HOURS_SCOPE = 2;
    private static final int DAYS_SCOPE = 3;
    private IPreferenceScope fGlobalScope = Owl.getPreferenceService().getGlobalScope();
    private FeedReloadService fReloadService = Controller.getDefault().getReloadService();
    private Button fUpdateCheck;
    private Combo fUpdateScopeCombo;
    private Spinner fUpdateValueSpinner;
    private Button fOpenOnStartupCheck;
    private Button fDeleteNewsByCountCheck;
    private Spinner fDeleteNewsByCountValue;
    private Button fDeleteNewsByAgeCheck;
    private Spinner fDeleteNewsByAgeValue;
    private Button fDeleteReadNewsCheck;
    private Button fNeverDeleteUnReadNewsCheck;
    private Button fNeverDeleteLabeledNewsCheck;
    private Button fReloadOnStartupCheck;
    private Combo fFilterCombo;
    private Combo fGroupCombo;
    private Combo fLayoutCombo;
    private Combo fPageSizeCombo;
    private Button fOpenSiteForEmptyNewsCheck;
    private Button fLoadImagesForNewsCheck;
    private Button fLoadMediaForNewsCheck;
    private Button fDisplayContentsOfNewsRadio;
    private Button fOpenLinkOfNewsRadio;
    private Button fUseTransformerCheck;
    private ComboViewer fLinkTransformerViewer;
    private Button fMarkReadStateCheck;
    private Spinner fMarkReadAfterSpinner;
    private Button fMarkReadOnMinimize;
    private Button fMarkReadOnScrolling;
    private Button fMarkReadOnChange;
    private Button fMarkReadDuplicateNews;
    private LocalResourceManager fResources = new LocalResourceManager(JFaceResources.getResources());
    private Button fMarkReadOnTabClose;
    private NewsColumnSelectionControl fColumnSelectionControl;

    public FeedsPreferencePage() {
        this.setImageDescriptor(OwlUI.BOOKMARK);
    }

    public void init(IWorkbench workbench) {
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.updateApplyEnablement(false);
    }

    public void dispose() {
        super.dispose();
        this.fResources.dispose();
    }

    protected Control createContents(Composite parent) {
        Composite container = this.createComposite(parent);
        TabFolder tabFolder = new TabFolder(container, 0);
        tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createGeneralGroup(tabFolder);
        this.createReadingGroup(tabFolder);
        this.createDisplayGroup(tabFolder);
        this.createColumnsGroup(tabFolder);
        this.createCleanUpGroup(tabFolder);
        Composite infoContainer = new Composite(container, 0);
        infoContainer.setLayoutData((Object)new GridData(4, 4, true, false));
        infoContainer.setLayout((Layout)LayoutUtils.createGridLayout(2, 0, 0));
        Label infoImg = new Label(infoContainer, 0);
        infoImg.setImage(OwlUI.getImage((ResourceManager)this.fResources, "icons/obj16/info.gif"));
        infoImg.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        Label infoText = new Label(infoContainer, 64);
        infoText.setText(Messages.FeedsPreferencePage_PROPERTY_INFO);
        infoText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.applyDialogFont(container);
        OwlUI.runOnSelection(new Runnable(){

            public void run() {
                FeedsPreferencePage.this.updateApplyEnablement(true);
            }
        }, new Control[]{container});
        return container;
    }

    private void createGeneralGroup(TabFolder parent) {
        Composite group = new Composite((Composite)parent, 0);
        group.setLayoutData((Object)new GridData(4, 1, true, false));
        group.setLayout((Layout)LayoutUtils.createGridLayout(1, 10, 10));
        TabItem item = new TabItem(parent, 0);
        item.setText(Messages.FeedsPreferencePage_GENERAL);
        item.setControl((Control)group);
        Composite autoReloadContainer = new Composite(group, 0);
        autoReloadContainer.setLayout((Layout)LayoutUtils.createGridLayout(3, 0, 0));
        autoReloadContainer.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fUpdateCheck = new Button(autoReloadContainer, 32);
        this.fUpdateCheck.setText(Messages.FeedsPreferencePage_UPDATE_FEEDS);
        this.fUpdateCheck.setSelection(this.fGlobalScope.getBoolean(DefaultPreferences.BM_UPDATE_INTERVAL_STATE));
        this.fUpdateCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FeedsPreferencePage.this.fUpdateValueSpinner.setEnabled(FeedsPreferencePage.this.fUpdateCheck.getSelection());
                FeedsPreferencePage.this.fUpdateScopeCombo.setEnabled(FeedsPreferencePage.this.fUpdateCheck.getSelection());
            }
        });
        this.fUpdateValueSpinner = new Spinner(autoReloadContainer, 2048);
        this.fUpdateValueSpinner.setMinimum(1);
        this.fUpdateValueSpinner.setMaximum(999);
        this.fUpdateValueSpinner.setEnabled(this.fUpdateCheck.getSelection());
        long updateInterval = this.fGlobalScope.getLong(DefaultPreferences.BM_UPDATE_INTERVAL);
        int updateScope = this.getUpdateIntervalScope();
        if (updateScope == 0) {
            this.fUpdateValueSpinner.setSelection((int)updateInterval);
        } else if (updateScope == 1) {
            this.fUpdateValueSpinner.setSelection((int)(updateInterval / 60L));
        } else if (updateScope == 2) {
            this.fUpdateValueSpinner.setSelection((int)(updateInterval / 3600L));
        } else if (updateScope == 3) {
            this.fUpdateValueSpinner.setSelection((int)(updateInterval / 86400L));
        }
        this.fUpdateScopeCombo = new Combo(autoReloadContainer, 8);
        this.fUpdateScopeCombo.add(Messages.FeedsPreferencePage_INTERVAL_SECONDS);
        this.fUpdateScopeCombo.add(Messages.FeedsPreferencePage_MINUTES);
        this.fUpdateScopeCombo.add(Messages.FeedsPreferencePage_HOURS);
        this.fUpdateScopeCombo.add(Messages.FeedsPreferencePage_DAYS);
        this.fUpdateScopeCombo.select(updateScope);
        this.fUpdateScopeCombo.setEnabled(this.fUpdateCheck.getSelection());
        this.fReloadOnStartupCheck = new Button(group, 32);
        this.fReloadOnStartupCheck.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fReloadOnStartupCheck.setText(Messages.FeedsPreferencePage_UPDATE_ON_STARTUP);
        this.fReloadOnStartupCheck.setSelection(this.fGlobalScope.getBoolean(DefaultPreferences.BM_RELOAD_ON_STARTUP));
        this.fOpenOnStartupCheck = new Button(group, 32);
        this.fOpenOnStartupCheck.setLayoutData((Object)new GridData(4, 1, true, false));
        ((GridData)this.fOpenOnStartupCheck.getLayoutData()).exclude = true;
        this.fOpenOnStartupCheck.setText(Messages.FeedsPreferencePage_DISPLAY_ON_STARTUP);
        this.fOpenOnStartupCheck.setSelection(this.fGlobalScope.getBoolean(DefaultPreferences.BM_OPEN_ON_STARTUP));
    }

    private void createReadingGroup(TabFolder parent) {
        Composite group = new Composite((Composite)parent, 0);
        group.setLayoutData((Object)new GridData(4, 1, true, false));
        group.setLayout((Layout)LayoutUtils.createGridLayout(1, 10, 10));
        TabItem item = new TabItem(parent, 0);
        item.setText(Messages.FeedsPreferencePage_READING);
        item.setControl((Control)group);
        Composite markReadAfterContainer = new Composite(group, 0);
        markReadAfterContainer.setLayout((Layout)LayoutUtils.createGridLayout(3, 0, 0));
        this.fMarkReadStateCheck = new Button(markReadAfterContainer, 32);
        this.fMarkReadStateCheck.setText(Messages.FeedsPreferencePage_MARK_READ_AFTER);
        this.fMarkReadStateCheck.setSelection(this.fGlobalScope.getBoolean(DefaultPreferences.MARK_READ_STATE));
        this.fMarkReadStateCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FeedsPreferencePage.this.fMarkReadAfterSpinner.setEnabled(FeedsPreferencePage.this.fMarkReadStateCheck.getSelection());
            }
        });
        this.fMarkReadAfterSpinner = new Spinner(markReadAfterContainer, 2048);
        this.fMarkReadAfterSpinner.setMinimum(0);
        this.fMarkReadAfterSpinner.setMaximum(100);
        this.fMarkReadAfterSpinner.setSelection(this.fGlobalScope.getInteger(DefaultPreferences.MARK_READ_IN_MILLIS) / 1000);
        this.fMarkReadAfterSpinner.setEnabled(this.fMarkReadStateCheck.getSelection());
        Label label = new Label(markReadAfterContainer, 0);
        label.setText(Messages.FeedsPreferencePage_SECONDS);
        this.fMarkReadOnScrolling = new Button(group, 32);
        this.fMarkReadOnScrolling.setText(Messages.FeedsPreferencePage_MARK_READ_ON_SCROLLING);
        this.fMarkReadOnScrolling.setSelection(this.fGlobalScope.getBoolean(DefaultPreferences.MARK_READ_ON_SCROLLING));
        this.fMarkReadOnChange = new Button(group, 32);
        this.fMarkReadOnChange.setText(Messages.FeedsPreferencePage_MARK_READ_ON_SWITCH);
        this.fMarkReadOnChange.setSelection(this.fGlobalScope.getBoolean(DefaultPreferences.MARK_READ_ON_CHANGE));
        this.fMarkReadOnTabClose = new Button(group, 32);
        this.fMarkReadOnTabClose.setText(Messages.FeedsPreferencePage_MARK_READ_ON_CLOSE);
        this.fMarkReadOnTabClose.setSelection(this.fGlobalScope.getBoolean(DefaultPreferences.MARK_READ_ON_TAB_CLOSE));
        this.fMarkReadOnMinimize = new Button(group, 32);
        this.fMarkReadOnMinimize.setText(Messages.FeedsPreferencePage_MARK_READ_ON_MINIMIZE);
        this.fMarkReadOnMinimize.setSelection(this.fGlobalScope.getBoolean(DefaultPreferences.MARK_READ_ON_MINIMIZE));
        Composite markReadDuplicatesContainer = new Composite(group, 0);
        markReadDuplicatesContainer.setLayoutData((Object)new GridData(4, 1, true, false));
        markReadDuplicatesContainer.setLayout((Layout)LayoutUtils.createGridLayout(1, 0, 0));
        ((GridLayout)markReadDuplicatesContainer.getLayout()).marginTop = 10;
        label = new Label(markReadDuplicatesContainer, 0);
        label.setText(Messages.FeedsPreferencePage_UPDATE_DUPLICATE_LABEL);
        label.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
        Label infoText = new Label(markReadDuplicatesContainer, 64);
        infoText.setLayoutData((Object)new GridData(4, 4, true, true));
        ((GridData)infoText.getLayoutData()).widthHint = 200;
        infoText.setText(Messages.FeedsPreferencePage_UPDATE_DUPLICATES_DESCRIPTION);
        this.fMarkReadDuplicateNews = new Button(markReadDuplicatesContainer, 32);
        this.fMarkReadDuplicateNews.setText(Messages.FeedsPreferencePage_UPDATE_DUPLICATES);
        this.fMarkReadDuplicateNews.setSelection(this.fGlobalScope.getBoolean(DefaultPreferences.MARK_READ_DUPLICATES));
        this.fMarkReadDuplicateNews.setLayoutData((Object)new GridData(1, 1, true, false));
    }

    private void createDisplayGroup(TabFolder parent) {
        NewsGrouping.Type[] groups;
        NewsFilter.Type[] filters;
        Composite group = new Composite((Composite)parent, 0);
        group.setLayoutData((Object)new GridData(4, 1, true, false));
        group.setLayout((Layout)LayoutUtils.createGridLayout(2, 10, 10));
        TabItem item = new TabItem(parent, 0);
        item.setText(Messages.FeedsPreferencePage_DISPLAY);
        item.setControl((Control)group);
        Composite topContainer = new Composite(group, 0);
        topContainer.setLayout((Layout)LayoutUtils.createGridLayout(2, 0, 0, 5, 15, false));
        topContainer.setLayoutData((Object)new GridData(4, 1, false, false, 2, 1));
        Label layoutLabel = new Label(topContainer, 0);
        layoutLabel.setText(Messages.FeedsPreferencePage_LAYOUT);
        Composite layoutContainer = new Composite(topContainer, 0);
        layoutContainer.setLayoutData((Object)new GridData(4, 1, false, false));
        layoutContainer.setLayout((Layout)LayoutUtils.createGridLayout(2, 0, 0, 0, 5, false));
        this.fLayoutCombo = new Combo(layoutContainer, 2056);
        this.fLayoutCombo.setLayoutData((Object)new GridData(4, 1, true, false));
        Enum[] enumArray = OwlUI.Layout.values();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            OwlUI.Layout layout = enumArray[n2];
            this.fLayoutCombo.add(layout.getName());
            ++n2;
        }
        this.fLayoutCombo.select(this.fGlobalScope.getInteger(DefaultPreferences.FV_LAYOUT));
        this.fLayoutCombo.setVisibleItemCount(this.fLayoutCombo.getItemCount());
        this.fLayoutCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FeedsPreferencePage.this.updateDisplayButtons();
            }
        });
        this.fPageSizeCombo = new Combo(layoutContainer, 2056);
        this.fPageSizeCombo.setLayoutData((Object)new GridData(4, 1, false, false));
        enumArray = OwlUI.PageSize.values();
        n = enumArray.length;
        n2 = 0;
        while (n2 < n) {
            Enum pageSize = enumArray[n2];
            this.fPageSizeCombo.add(((OwlUI.PageSize)pageSize).getName());
            ++n2;
        }
        this.fPageSizeCombo.select(OwlUI.PageSize.from(this.fGlobalScope.getInteger(DefaultPreferences.NEWS_BROWSER_PAGE_SIZE)).ordinal());
        this.fPageSizeCombo.setVisibleItemCount(this.fPageSizeCombo.getItemCount());
        Label filterLabel = new Label(topContainer, 0);
        filterLabel.setText(Messages.FeedsPreferencePage_FILTER_NEWS);
        this.fFilterCombo = new Combo(topContainer, 2056);
        this.fFilterCombo.setLayoutData((Object)new GridData(4, 1, false, false));
        NewsFilter.Type[] typeArray = filters = NewsFilter.Type.values();
        int n3 = filters.length;
        int n4 = 0;
        while (n4 < n3) {
            NewsFilter.Type filter = typeArray[n4];
            this.fFilterCombo.add(filter.getName());
            ++n4;
        }
        this.fFilterCombo.select(ModelUtils.loadIntegerValueWithFallback(this.fGlobalScope, DefaultPreferences.BM_NEWS_FILTERING, this.fGlobalScope, DefaultPreferences.FV_FILTER_TYPE));
        this.fFilterCombo.setVisibleItemCount(this.fFilterCombo.getItemCount());
        Label groupLabel = new Label(topContainer, 0);
        groupLabel.setText(Messages.FeedsPreferencePage_GROUP_NEWS);
        this.fGroupCombo = new Combo(topContainer, 2056);
        this.fGroupCombo.setLayoutData((Object)new GridData(4, 1, false, false));
        NewsGrouping.Type[] typeArray2 = groups = NewsGrouping.Type.values();
        int n5 = groups.length;
        int n6 = 0;
        while (n6 < n5) {
            NewsGrouping.Type groupT = typeArray2[n6];
            this.fGroupCombo.add(groupT.getName());
            ++n6;
        }
        this.fGroupCombo.select(ModelUtils.loadIntegerValueWithFallback(this.fGlobalScope, DefaultPreferences.BM_NEWS_GROUPING, this.fGlobalScope, DefaultPreferences.FV_GROUP_TYPE));
        this.fGroupCombo.setVisibleItemCount(this.fGroupCombo.getItemCount());
        Composite bottomContainer = new Composite(group, 0);
        bottomContainer.setLayout((Layout)LayoutUtils.createGridLayout(2, 0, 10));
        bottomContainer.setLayoutData((Object)new GridData(4, 1, false, false, 2, 1));
        this.fDisplayContentsOfNewsRadio = new Button(bottomContainer, 16);
        this.fDisplayContentsOfNewsRadio.setText(Messages.FeedsPreferencePage_DISPLAY_NEWS_CONTENT);
        this.fDisplayContentsOfNewsRadio.setLayoutData((Object)new GridData(4, 1, false, false, 2, 1));
        this.fDisplayContentsOfNewsRadio.setSelection(!this.fGlobalScope.getBoolean(DefaultPreferences.BM_OPEN_SITE_FOR_NEWS));
        Composite bottomSubContainer = new Composite(bottomContainer, 0);
        bottomSubContainer.setLayout((Layout)LayoutUtils.createGridLayout(1, 0, 5));
        bottomSubContainer.setLayoutData((Object)new GridData(4, 1, false, false, 2, 1));
        ((GridLayout)bottomSubContainer.getLayout()).marginLeft = 15;
        this.fLoadImagesForNewsCheck = new Button(bottomSubContainer, 32);
        this.fLoadImagesForNewsCheck.setText(Messages.FeedsPreferencePage_LOAD_IMAGES);
        this.fLoadImagesForNewsCheck.setLayoutData((Object)new GridData(4, 1, false, false));
        this.fLoadImagesForNewsCheck.setSelection(this.fGlobalScope.getBoolean(DefaultPreferences.ENABLE_IMAGES));
        this.fLoadMediaForNewsCheck = new Button(bottomSubContainer, 32);
        this.fLoadMediaForNewsCheck.setText(Messages.FeedsPreferencePage_LOAD_MEDIA);
        this.fLoadMediaForNewsCheck.setLayoutData((Object)new GridData(4, 1, false, false));
        this.fLoadMediaForNewsCheck.setSelection(this.fGlobalScope.getBoolean(DefaultPreferences.ENABLE_MEDIA));
        this.fOpenLinkOfNewsRadio = new Button(bottomContainer, 16);
        this.fOpenLinkOfNewsRadio.setText(Messages.FeedsPreferencePage_OPEN_NEWS_LINK);
        this.fOpenLinkOfNewsRadio.setLayoutData((Object)new GridData(4, 1, false, false, 2, 1));
        this.fOpenLinkOfNewsRadio.setSelection(this.fGlobalScope.getBoolean(DefaultPreferences.BM_OPEN_SITE_FOR_NEWS));
        this.fOpenLinkOfNewsRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FeedsPreferencePage.this.updateDisplayButtons();
            }
        });
        bottomSubContainer = new Composite(bottomContainer, 0);
        bottomSubContainer.setLayout((Layout)LayoutUtils.createGridLayout(2, 0, 5));
        bottomSubContainer.setLayoutData((Object)new GridData(4, 1, false, false, 2, 1));
        ((GridLayout)bottomSubContainer.getLayout()).marginLeft = 15;
        this.fOpenSiteForEmptyNewsCheck = new Button(bottomSubContainer, 32);
        this.fOpenSiteForEmptyNewsCheck.setText(Messages.FeedsPreferencePage_ONLY_WHEN_EMPTY);
        this.fOpenSiteForEmptyNewsCheck.setLayoutData((Object)new GridData(4, 1, false, false, 2, 1));
        this.fOpenSiteForEmptyNewsCheck.setSelection(this.fGlobalScope.getBoolean(DefaultPreferences.BM_OPEN_SITE_FOR_EMPTY_NEWS));
        this.fOpenSiteForEmptyNewsCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FeedsPreferencePage.this.updateDisplayButtons();
            }
        });
        this.fUseTransformerCheck = new Button(bottomSubContainer, 32);
        this.fUseTransformerCheck.setText(Messages.FeedsPreferencePage_USE_TRANSFORMER);
        this.fUseTransformerCheck.setLayoutData((Object)new GridData(4, 0x1000000, false, true, 1, 1));
        this.fUseTransformerCheck.setSelection(this.fGlobalScope.getBoolean(DefaultPreferences.BM_USE_TRANSFORMER));
        this.fUseTransformerCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FeedsPreferencePage.this.updateDisplayButtons();
            }
        });
        Combo linkTransformerCombo = new Combo(bottomSubContainer, 2056);
        linkTransformerCombo.setLayoutData((Object)new GridData(4, 0x1000000, false, true, 1, 1));
        this.fLinkTransformerViewer = new ComboViewer(linkTransformerCombo);
        this.fLinkTransformerViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fLinkTransformerViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((LinkTransformer)element).getName();
            }
        });
        this.fLinkTransformerViewer.setInput(Controller.getDefault().getLinkTransformers());
        this.fLinkTransformerViewer.setSelection((ISelection)new StructuredSelection((Object)Controller.getDefault().getLinkTransformer(this.fGlobalScope)));
        this.updateDisplayButtons(false);
    }

    private void updateDisplayButtons() {
        this.updateDisplayButtons(true);
    }

    private void updateDisplayButtons(boolean layout) {
        boolean isListLayout;
        boolean isNewspaperLayout = this.fLayoutCombo.getSelectionIndex() == OwlUI.Layout.NEWSPAPER.ordinal() || this.fLayoutCombo.getSelectionIndex() == OwlUI.Layout.HEADLINES.ordinal();
        boolean bl = isListLayout = this.fLayoutCombo.getSelectionIndex() == OwlUI.Layout.LIST.ordinal();
        if (isNewspaperLayout && !this.fDisplayContentsOfNewsRadio.getSelection()) {
            this.fDisplayContentsOfNewsRadio.setSelection(true);
            this.fOpenLinkOfNewsRadio.setSelection(false);
        }
        this.fDisplayContentsOfNewsRadio.setEnabled(!isListLayout);
        this.fLoadImagesForNewsCheck.setEnabled(!isListLayout && (this.fDisplayContentsOfNewsRadio.getSelection() || this.fOpenSiteForEmptyNewsCheck.getSelection()));
        this.fLoadMediaForNewsCheck.setEnabled(!isListLayout && (this.fDisplayContentsOfNewsRadio.getSelection() || this.fOpenSiteForEmptyNewsCheck.getSelection()));
        this.fOpenLinkOfNewsRadio.setEnabled(!isListLayout && !isNewspaperLayout);
        this.fOpenSiteForEmptyNewsCheck.setEnabled(!isListLayout && !isNewspaperLayout && this.fOpenLinkOfNewsRadio.getSelection());
        this.fUseTransformerCheck.setEnabled(!isListLayout && !isNewspaperLayout && this.fOpenLinkOfNewsRadio.getSelection());
        this.fLinkTransformerViewer.getCombo().setEnabled(!isListLayout && !isNewspaperLayout && this.fOpenLinkOfNewsRadio.getSelection() && this.fUseTransformerCheck.getSelection());
        GridData data = (GridData)this.fLayoutCombo.getLayoutData();
        data.horizontalSpan = isNewspaperLayout ? 1 : 2;
        data = (GridData)this.fPageSizeCombo.getLayoutData();
        boolean bl2 = data.exclude = !isNewspaperLayout;
        if (layout) {
            this.fPageSizeCombo.getParent().getParent().layout(true, true);
        }
    }

    private void createColumnsGroup(TabFolder parent) {
        Composite group = new Composite((Composite)parent, 0);
        group.setLayoutData((Object)new GridData(4, 1, true, false));
        group.setLayout((Layout)LayoutUtils.createGridLayout(1, 10, 10));
        TabItem item = new TabItem(parent, 0);
        item.setText(Messages.FeedsPreferencePage_COLUMNS);
        item.setControl((Control)group);
        this.fColumnSelectionControl = new NewsColumnSelectionControl(group, 0);
        this.fColumnSelectionControl.setLayoutData(new GridData(4, 1, true, false));
        this.fColumnSelectionControl.setInput(NewsColumnViewModel.loadFrom(this.fGlobalScope));
    }

    private void createCleanUpGroup(TabFolder parent) {
        Composite group = new Composite((Composite)parent, 0);
        group.setLayoutData((Object)new GridData(4, 1, true, false));
        group.setLayout((Layout)LayoutUtils.createGridLayout(2, 10, 10, 5, 5, false));
        TabItem item = new TabItem(parent, 0);
        item.setText(Messages.FeedsPreferencePage_CLEAN_UP);
        item.setControl((Control)group);
        Label explanationLabel = new Label(group, 64);
        explanationLabel.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
        explanationLabel.setText(Messages.FeedsPreferencePage_CLEAN_UP_INFO);
        this.fDeleteNewsByCountCheck = new Button(group, 32);
        this.fDeleteNewsByCountCheck.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.fDeleteNewsByCountCheck.setSelection(this.fGlobalScope.getBoolean(DefaultPreferences.DEL_NEWS_BY_COUNT_STATE));
        this.fDeleteNewsByCountCheck.setText(Messages.FeedsPreferencePage_MAX_NUMBER);
        this.fDeleteNewsByCountCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FeedsPreferencePage.this.fDeleteNewsByCountValue.setEnabled(FeedsPreferencePage.this.fDeleteNewsByCountCheck.getSelection());
            }
        });
        this.fDeleteNewsByCountValue = new Spinner(group, 2048);
        this.fDeleteNewsByCountValue.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.fDeleteNewsByCountValue.setEnabled(this.fDeleteNewsByCountCheck.getSelection());
        this.fDeleteNewsByCountValue.setMinimum(0);
        this.fDeleteNewsByCountValue.setMaximum(99999);
        this.fDeleteNewsByCountValue.setSelection(this.fGlobalScope.getInteger(DefaultPreferences.DEL_NEWS_BY_COUNT_VALUE));
        this.fDeleteNewsByAgeCheck = new Button(group, 32);
        this.fDeleteNewsByAgeCheck.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.fDeleteNewsByAgeCheck.setSelection(this.fGlobalScope.getBoolean(DefaultPreferences.DEL_NEWS_BY_AGE_STATE));
        this.fDeleteNewsByAgeCheck.setText(Messages.FeedsPreferencePage_MAX_AGE);
        this.fDeleteNewsByAgeCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FeedsPreferencePage.this.fDeleteNewsByAgeValue.setEnabled(FeedsPreferencePage.this.fDeleteNewsByAgeCheck.getSelection());
            }
        });
        this.fDeleteNewsByAgeValue = new Spinner(group, 2048);
        this.fDeleteNewsByAgeValue.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.fDeleteNewsByAgeValue.setEnabled(this.fDeleteNewsByAgeCheck.getSelection());
        this.fDeleteNewsByAgeValue.setMinimum(0);
        this.fDeleteNewsByAgeValue.setMaximum(99999);
        this.fDeleteNewsByAgeValue.setSelection(this.fGlobalScope.getInteger(DefaultPreferences.DEL_NEWS_BY_AGE_VALUE));
        this.fDeleteReadNewsCheck = new Button(group, 32);
        this.fDeleteReadNewsCheck.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        this.fDeleteReadNewsCheck.setText(Messages.FeedsPreferencePage_DELETE_READ);
        this.fDeleteReadNewsCheck.setSelection(this.fGlobalScope.getBoolean(DefaultPreferences.DEL_READ_NEWS_STATE));
        this.fNeverDeleteUnReadNewsCheck = new Button(group, 32);
        this.fNeverDeleteUnReadNewsCheck.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        this.fNeverDeleteUnReadNewsCheck.setText(Messages.FeedsPreferencePage_NEVER_DELETE_UNREAD);
        this.fNeverDeleteUnReadNewsCheck.setSelection(this.fGlobalScope.getBoolean(DefaultPreferences.NEVER_DEL_UNREAD_NEWS_STATE));
        this.fNeverDeleteLabeledNewsCheck = new Button(group, 32);
        this.fNeverDeleteLabeledNewsCheck.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        this.fNeverDeleteLabeledNewsCheck.setText(Messages.FeedsPreferencePage_NEVER_DELETE_LABELED);
        this.fNeverDeleteLabeledNewsCheck.setSelection(this.fGlobalScope.getBoolean(DefaultPreferences.NEVER_DEL_LABELED_NEWS_STATE));
        Composite infoContainer = new Composite(group, 0);
        infoContainer.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        infoContainer.setLayout((Layout)LayoutUtils.createGridLayout(2, 0, 0));
        ((GridLayout)infoContainer.getLayout()).marginTop = 5;
        Label infoImg = new Label(infoContainer, 0);
        infoImg.setImage(OwlUI.getImage((ResourceManager)this.fResources, "icons/obj16/info.gif"));
        infoImg.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        Label infoText = new Label(infoContainer, 64);
        infoText.setText(Messages.FeedsPreferencePage_CLEAN_UP_NOTE);
        infoText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
    }

    private Composite createComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(272));
        composite.setFont(parent.getFont());
        return composite;
    }

    public boolean performOk() {
        boolean autoUpdateChange = false;
        boolean displayChange = false;
        boolean layoutChange = false;
        boolean columnChange = false;
        boolean runCleanUp = false;
        int updateScope = this.fUpdateScopeCombo.getSelectionIndex();
        long lVal = updateScope == 0 ? (long)this.fUpdateValueSpinner.getSelection() : (updateScope == 1 ? (long)this.fUpdateValueSpinner.getSelection() * 60L : (updateScope == 2 ? (long)this.fUpdateValueSpinner.getSelection() * 3600L : (long)this.fUpdateValueSpinner.getSelection() * 86400L));
        if (this.fGlobalScope.getBoolean(DefaultPreferences.BM_UPDATE_INTERVAL_STATE) != this.fUpdateCheck.getSelection()) {
            autoUpdateChange = true;
            this.fGlobalScope.putBoolean(DefaultPreferences.BM_UPDATE_INTERVAL_STATE, this.fUpdateCheck.getSelection());
        }
        if (this.fGlobalScope.getLong(DefaultPreferences.BM_UPDATE_INTERVAL) != lVal) {
            autoUpdateChange = true;
            this.fGlobalScope.putLong(DefaultPreferences.BM_UPDATE_INTERVAL, lVal);
        }
        this.fGlobalScope.putBoolean(DefaultPreferences.BM_OPEN_ON_STARTUP, this.fOpenOnStartupCheck.getSelection());
        this.fGlobalScope.putBoolean(DefaultPreferences.BM_RELOAD_ON_STARTUP, this.fReloadOnStartupCheck.getSelection());
        this.fGlobalScope.putBoolean(DefaultPreferences.MARK_READ_ON_SCROLLING, this.fMarkReadOnScrolling.getSelection());
        this.fGlobalScope.putBoolean(DefaultPreferences.MARK_READ_ON_MINIMIZE, this.fMarkReadOnMinimize.getSelection());
        this.fGlobalScope.putBoolean(DefaultPreferences.MARK_READ_ON_CHANGE, this.fMarkReadOnChange.getSelection());
        this.fGlobalScope.putBoolean(DefaultPreferences.MARK_READ_ON_TAB_CLOSE, this.fMarkReadOnTabClose.getSelection());
        this.fGlobalScope.putBoolean(DefaultPreferences.MARK_READ_STATE, this.fMarkReadStateCheck.getSelection());
        this.fGlobalScope.putInteger(DefaultPreferences.MARK_READ_IN_MILLIS, this.fMarkReadAfterSpinner.getSelection() * 1000);
        this.fGlobalScope.putBoolean(DefaultPreferences.MARK_READ_DUPLICATES, this.fMarkReadDuplicateNews.getSelection());
        if (ModelUtils.loadIntegerValueWithFallback(this.fGlobalScope, DefaultPreferences.BM_NEWS_FILTERING, this.fGlobalScope, DefaultPreferences.FV_FILTER_TYPE) != this.fFilterCombo.getSelectionIndex()) {
            this.fGlobalScope.putInteger(DefaultPreferences.BM_NEWS_FILTERING, this.fFilterCombo.getSelectionIndex());
            displayChange = true;
        }
        if (ModelUtils.loadIntegerValueWithFallback(this.fGlobalScope, DefaultPreferences.BM_NEWS_GROUPING, this.fGlobalScope, DefaultPreferences.FV_GROUP_TYPE) != this.fGroupCombo.getSelectionIndex()) {
            this.fGlobalScope.putInteger(DefaultPreferences.BM_NEWS_GROUPING, this.fGroupCombo.getSelectionIndex());
            displayChange = true;
        }
        int iVal = this.fLayoutCombo.getSelectionIndex();
        if (this.fGlobalScope.getInteger(DefaultPreferences.FV_LAYOUT) != iVal) {
            this.fGlobalScope.putInteger(DefaultPreferences.FV_LAYOUT, iVal);
            layoutChange = true;
        }
        iVal = this.fPageSizeCombo.getSelectionIndex();
        OwlUI.PageSize size = OwlUI.PageSize.values()[iVal];
        if (this.fGlobalScope.getInteger(DefaultPreferences.NEWS_BROWSER_PAGE_SIZE) != size.getPageSize()) {
            this.fGlobalScope.putInteger(DefaultPreferences.NEWS_BROWSER_PAGE_SIZE, size.getPageSize());
        }
        this.fGlobalScope.putBoolean(DefaultPreferences.BM_OPEN_SITE_FOR_NEWS, this.fOpenLinkOfNewsRadio.getSelection());
        this.fGlobalScope.putBoolean(DefaultPreferences.BM_OPEN_SITE_FOR_EMPTY_NEWS, this.fOpenSiteForEmptyNewsCheck.getSelection());
        this.fGlobalScope.putBoolean(DefaultPreferences.ENABLE_IMAGES, this.fLoadImagesForNewsCheck.getSelection());
        this.fGlobalScope.putBoolean(DefaultPreferences.ENABLE_MEDIA, this.fLoadMediaForNewsCheck.getSelection());
        this.fGlobalScope.putBoolean(DefaultPreferences.BM_USE_TRANSFORMER, this.fUseTransformerCheck.getSelection());
        IStructuredSelection selection = (IStructuredSelection)this.fLinkTransformerViewer.getSelection();
        if (!selection.isEmpty()) {
            LinkTransformer transformer = (LinkTransformer)selection.getFirstElement();
            this.fGlobalScope.putString(DefaultPreferences.BM_TRANSFORMER_ID, transformer.getId());
        }
        columnChange = this.fColumnSelectionControl.getModel().saveTo(this.fGlobalScope);
        if (this.fGlobalScope.getBoolean(DefaultPreferences.DEL_NEWS_BY_COUNT_STATE) != this.fDeleteNewsByCountCheck.getSelection()) {
            this.fGlobalScope.putBoolean(DefaultPreferences.DEL_NEWS_BY_COUNT_STATE, this.fDeleteNewsByCountCheck.getSelection());
            if (this.fDeleteNewsByCountCheck.getSelection()) {
                runCleanUp = true;
            }
        }
        if (this.fGlobalScope.getInteger(DefaultPreferences.DEL_NEWS_BY_COUNT_VALUE) != this.fDeleteNewsByCountValue.getSelection()) {
            this.fGlobalScope.putInteger(DefaultPreferences.DEL_NEWS_BY_COUNT_VALUE, this.fDeleteNewsByCountValue.getSelection());
            runCleanUp = true;
        }
        if (this.fGlobalScope.getBoolean(DefaultPreferences.DEL_NEWS_BY_AGE_STATE) != this.fDeleteNewsByAgeCheck.getSelection()) {
            this.fGlobalScope.putBoolean(DefaultPreferences.DEL_NEWS_BY_AGE_STATE, this.fDeleteNewsByAgeCheck.getSelection());
            if (this.fDeleteNewsByAgeCheck.getSelection()) {
                runCleanUp = true;
            }
        }
        if (this.fGlobalScope.getInteger(DefaultPreferences.DEL_NEWS_BY_AGE_VALUE) != this.fDeleteNewsByAgeValue.getSelection()) {
            this.fGlobalScope.putInteger(DefaultPreferences.DEL_NEWS_BY_AGE_VALUE, this.fDeleteNewsByAgeValue.getSelection());
            runCleanUp = true;
        }
        if (this.fGlobalScope.getBoolean(DefaultPreferences.DEL_READ_NEWS_STATE) != this.fDeleteReadNewsCheck.getSelection()) {
            this.fGlobalScope.putBoolean(DefaultPreferences.DEL_READ_NEWS_STATE, this.fDeleteReadNewsCheck.getSelection());
            if (this.fDeleteReadNewsCheck.getSelection()) {
                runCleanUp = true;
            }
        }
        this.fGlobalScope.putBoolean(DefaultPreferences.NEVER_DEL_UNREAD_NEWS_STATE, this.fNeverDeleteUnReadNewsCheck.getSelection());
        this.fGlobalScope.putBoolean(DefaultPreferences.NEVER_DEL_LABELED_NEWS_STATE, this.fNeverDeleteLabeledNewsCheck.getSelection());
        this.finish(autoUpdateChange, displayChange, layoutChange, columnChange, runCleanUp);
        return super.performOk();
    }

    protected void performApply() {
        super.performApply();
        this.updateApplyEnablement(false);
    }

    private void finish(boolean autoUpdateChange, boolean displayChange, boolean layoutChange, boolean columnChange, boolean runCleanup) throws PersistenceException {
        final Set rootFolders = CoreUtils.loadRootFolders();
        if (autoUpdateChange) {
            for (IFolder rootFolder : rootFolders) {
                this.updateReloadService(rootFolder);
            }
        }
        if (layoutChange) {
            EditorUtils.updateLayout();
        }
        if (displayChange) {
            EditorUtils.updateFilterAndGrouping();
        }
        if (columnChange) {
            EditorUtils.updateColumns();
        }
        if (runCleanup) {
            final INewsMark activeFeedViewNewsMark = OwlUI.getActiveFeedViewNewsMark();
            Job retentionJob = new Job(Messages.FeedsPreferencePage_PERFORMNG_CLEANUP){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        HashSet bookmarks = new HashSet();
                        CoreUtils.fillBookMarks(bookmarks, (Collection)rootFolders);
                        monitor.beginTask(Messages.FeedsPreferencePage_PERFORMNG_CLEANUP, bookmarks.size());
                        for (IBookMark bookmark : bookmarks) {
                            if (Controller.getDefault().isShuttingDown()) break;
                            if (monitor.isCanceled()) {
                                break;
                            }
                            if (activeFeedViewNewsMark != null && (activeFeedViewNewsMark.equals(bookmark) || activeFeedViewNewsMark instanceof FolderNewsMark && ((FolderNewsMark)activeFeedViewNewsMark).contains((INewsMark)bookmark))) continue;
                            monitor.subTask(bookmark.getName());
                            RetentionStrategy.process((IBookMark)bookmark);
                            monitor.worked(1);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                    return Status.OK_STATUS;
                }
            };
            retentionJob.schedule();
        }
    }

    private void updateReloadService(IFolder folder) {
        List marks = folder.getMarks();
        for (IMark mark : marks) {
            if (!(mark instanceof IBookMark)) continue;
            this.fReloadService.sync((IBookMark)mark);
        }
        List childFolders = folder.getFolders();
        for (IFolder childFolder : childFolders) {
            this.updateReloadService(childFolder);
        }
    }

    protected void performDefaults() {
        super.performDefaults();
        IPreferenceScope defaultScope = Owl.getPreferenceService().getDefaultScope();
        this.fUpdateCheck.setSelection(defaultScope.getBoolean(DefaultPreferences.BM_UPDATE_INTERVAL_STATE));
        this.fUpdateValueSpinner.setEnabled(this.fUpdateCheck.getSelection());
        this.fUpdateScopeCombo.setEnabled(this.fUpdateCheck.getSelection());
        long updateInterval = defaultScope.getLong(DefaultPreferences.BM_UPDATE_INTERVAL);
        int updateScope = this.getUpdateIntervalScope();
        if (updateScope == 0) {
            this.fUpdateValueSpinner.setSelection((int)updateInterval);
        } else if (updateScope == 1) {
            this.fUpdateValueSpinner.setSelection((int)(updateInterval / 60L));
        } else if (updateScope == 2) {
            this.fUpdateValueSpinner.setSelection((int)(updateInterval / 3600L));
        } else if (updateScope == 3) {
            this.fUpdateValueSpinner.setSelection((int)(updateInterval / 86400L));
        }
        this.fUpdateScopeCombo.select(updateScope);
        this.fOpenOnStartupCheck.setSelection(defaultScope.getBoolean(DefaultPreferences.BM_OPEN_ON_STARTUP));
        this.fReloadOnStartupCheck.setSelection(defaultScope.getBoolean(DefaultPreferences.BM_RELOAD_ON_STARTUP));
        this.fMarkReadOnScrolling.setSelection(defaultScope.getBoolean(DefaultPreferences.MARK_READ_ON_SCROLLING));
        this.fMarkReadOnMinimize.setSelection(defaultScope.getBoolean(DefaultPreferences.MARK_READ_ON_MINIMIZE));
        this.fMarkReadOnChange.setSelection(defaultScope.getBoolean(DefaultPreferences.MARK_READ_ON_CHANGE));
        this.fMarkReadOnTabClose.setSelection(defaultScope.getBoolean(DefaultPreferences.MARK_READ_ON_TAB_CLOSE));
        this.fMarkReadStateCheck.setSelection(defaultScope.getBoolean(DefaultPreferences.MARK_READ_STATE));
        this.fMarkReadAfterSpinner.setSelection(defaultScope.getInteger(DefaultPreferences.MARK_READ_IN_MILLIS) / 1000);
        this.fMarkReadAfterSpinner.setEnabled(this.fMarkReadStateCheck.getSelection());
        this.fMarkReadDuplicateNews.setSelection(defaultScope.getBoolean(DefaultPreferences.MARK_READ_DUPLICATES));
        this.fFilterCombo.select(ModelUtils.loadIntegerValueWithFallback(defaultScope, DefaultPreferences.BM_NEWS_FILTERING, defaultScope, DefaultPreferences.FV_FILTER_TYPE));
        this.fGroupCombo.select(ModelUtils.loadIntegerValueWithFallback(defaultScope, DefaultPreferences.BM_NEWS_GROUPING, defaultScope, DefaultPreferences.FV_GROUP_TYPE));
        this.fLayoutCombo.select(defaultScope.getInteger(DefaultPreferences.FV_LAYOUT));
        this.fPageSizeCombo.select(OwlUI.PageSize.from(defaultScope.getInteger(DefaultPreferences.NEWS_BROWSER_PAGE_SIZE)).ordinal());
        this.fDisplayContentsOfNewsRadio.setSelection(!defaultScope.getBoolean(DefaultPreferences.BM_OPEN_SITE_FOR_NEWS));
        this.fOpenLinkOfNewsRadio.setSelection(defaultScope.getBoolean(DefaultPreferences.BM_OPEN_SITE_FOR_NEWS));
        this.fOpenSiteForEmptyNewsCheck.setSelection(defaultScope.getBoolean(DefaultPreferences.BM_OPEN_SITE_FOR_EMPTY_NEWS));
        this.fLoadImagesForNewsCheck.setSelection(defaultScope.getBoolean(DefaultPreferences.ENABLE_IMAGES));
        this.fLoadMediaForNewsCheck.setSelection(defaultScope.getBoolean(DefaultPreferences.ENABLE_MEDIA));
        this.fUseTransformerCheck.setSelection(defaultScope.getBoolean(DefaultPreferences.BM_USE_TRANSFORMER));
        this.fLinkTransformerViewer.setSelection((ISelection)new StructuredSelection((Object)Controller.getDefault().getLinkTransformer(defaultScope)));
        this.updateDisplayButtons();
        this.fColumnSelectionControl.setInput(NewsColumnViewModel.loadFrom(defaultScope));
        this.fDeleteNewsByCountCheck.setSelection(defaultScope.getBoolean(DefaultPreferences.DEL_NEWS_BY_COUNT_STATE));
        this.fDeleteNewsByCountValue.setSelection(defaultScope.getInteger(DefaultPreferences.DEL_NEWS_BY_COUNT_VALUE));
        this.fDeleteNewsByCountValue.setEnabled(this.fDeleteNewsByCountCheck.getSelection());
        this.fDeleteNewsByAgeCheck.setSelection(defaultScope.getBoolean(DefaultPreferences.DEL_NEWS_BY_AGE_STATE));
        this.fDeleteNewsByAgeValue.setSelection(defaultScope.getInteger(DefaultPreferences.DEL_NEWS_BY_AGE_VALUE));
        this.fDeleteNewsByAgeValue.setEnabled(this.fDeleteNewsByAgeCheck.getSelection());
        this.fDeleteReadNewsCheck.setSelection(defaultScope.getBoolean(DefaultPreferences.DEL_READ_NEWS_STATE));
        this.fNeverDeleteUnReadNewsCheck.setSelection(defaultScope.getBoolean(DefaultPreferences.NEVER_DEL_UNREAD_NEWS_STATE));
        this.fNeverDeleteLabeledNewsCheck.setSelection(defaultScope.getBoolean(DefaultPreferences.NEVER_DEL_LABELED_NEWS_STATE));
        this.updateApplyEnablement(true);
    }

    private int getUpdateIntervalScope() {
        long updateInterval = this.fGlobalScope.getLong(DefaultPreferences.BM_UPDATE_INTERVAL);
        if (updateInterval % 86400L == 0L) {
            return 3;
        }
        if (updateInterval % 3600L == 0L) {
            return 2;
        }
        if (updateInterval % 60L == 0L) {
            return 1;
        }
        return 0;
    }

    private void updateApplyEnablement(boolean enable) {
        Button applyButton = this.getApplyButton();
        if (applyButton != null && !applyButton.isDisposed() && applyButton.isEnabled() != enable) {
            applyButton.setEnabled(enable);
        }
    }
}

