/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.editors.browser;

import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.part.EditorPart;
import org.rssowl.core.Owl;
import org.rssowl.core.internal.persist.pref.DefaultPreferences;
import org.rssowl.core.persist.INewsMark;
import org.rssowl.core.persist.pref.IPreferenceScope;
import org.rssowl.core.persist.reference.NewsReference;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.core.util.StringUtils;
import org.rssowl.core.util.URIUtils;
import org.rssowl.ui.internal.Application;
import org.rssowl.ui.internal.ApplicationServer;
import org.rssowl.ui.internal.ContextMenuCreator;
import org.rssowl.ui.internal.Controller;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.ShareProvider;
import org.rssowl.ui.internal.actions.ImportAction;
import org.rssowl.ui.internal.actions.OpenInBrowserAction;
import org.rssowl.ui.internal.actions.SendLinkAction;
import org.rssowl.ui.internal.dialogs.preferences.BrowserPreferencePage;
import org.rssowl.ui.internal.editors.browser.Messages;
import org.rssowl.ui.internal.editors.browser.WebBrowserContext;
import org.rssowl.ui.internal.editors.browser.WebBrowserInput;
import org.rssowl.ui.internal.editors.feed.PerformAfterInputSet;
import org.rssowl.ui.internal.util.BrowserUtils;
import org.rssowl.ui.internal.util.CBrowser;
import org.rssowl.ui.internal.util.LayoutUtils;

public class WebBrowserView
extends EditorPart
implements IReusableEditor {
    public static final String EDITOR_ID = "org.rssowl.ui.WebBrowser";
    private static final String BACK_ACTION = "org.rssowl.ui.internal.editors.feed.BackAction";
    private static final String FORWARD_ACTION = "org.rssowl.ui.internal.editors.feed.ForwardAction";
    private static final String SHARE_ACTION = "org.rssowl.ui.internal.editors.browser.ShareLinkAction";
    private CBrowser fBrowser;
    private WebBrowserInput fInput;
    private IEditorSite fEditorSite;
    private Text fLocationInput;
    private ToolBarManager fNavigationToolBarManager;
    private Action fSelectAllAction;
    private Action fCutAction;
    private Action fCopyAction;
    private Action fPasteAction;
    private Action fPrintAction;
    private boolean fCreated;
    private boolean fLocationSelectAllOnce = true;
    private IPartListener2 fPartListener;
    private Label fJSInfoSeparator;
    private Composite fJSInfoBar;

    public void init(IEditorSite site, IEditorInput input) {
        Assert.isTrue((boolean)(input instanceof WebBrowserInput));
        this.fEditorSite = site;
        this.fInput = (WebBrowserInput)input;
        this.setSite((IWorkbenchPartSite)this.fEditorSite);
        this.setInput(this.fInput);
        this.createGlobalActions();
        this.setGlobalActions();
        this.registerListeners();
    }

    private void registerListeners() {
        this.fPartListener = new IPartListener2(){

            public void partHidden(IWorkbenchPartReference partRef) {
            }

            public void partBroughtToTop(IWorkbenchPartReference partRef) {
                if (((Object)((Object)WebBrowserView.this)).equals(partRef.getPart(false))) {
                    WebBrowserView.this.setGlobalActions();
                    OwlUI.updateWindowTitle(WebBrowserView.this.getPartName());
                }
            }

            public void partClosed(IWorkbenchPartReference partRef) {
                IEditorReference[] editors = partRef.getPage().getEditorReferences();
                boolean equalsThis = ((Object)((Object)WebBrowserView.this)).equals(partRef.getPart(false));
                if (editors.length == 0 && equalsThis) {
                    OwlUI.updateWindowTitle(WebBrowserView.this.getPartName());
                }
            }

            public void partDeactivated(IWorkbenchPartReference partRef) {
            }

            public void partActivated(IWorkbenchPartReference partRef) {
                if (((Object)((Object)WebBrowserView.this)).equals(partRef.getPart(false))) {
                    OwlUI.updateWindowTitle(WebBrowserView.this.getPartName());
                }
            }

            public void partInputChanged(IWorkbenchPartReference partRef) {
                if (((Object)((Object)WebBrowserView.this)).equals(partRef.getPart(false))) {
                    OwlUI.updateWindowTitle(WebBrowserView.this.getPartName());
                }
            }

            public void partOpened(IWorkbenchPartReference partRef) {
                if (((Object)((Object)WebBrowserView.this)).equals(partRef.getPart(false))) {
                    OwlUI.updateWindowTitle(WebBrowserView.this.getPartName());
                }
            }

            public void partVisible(IWorkbenchPartReference partRef) {
                if (((Object)((Object)WebBrowserView.this)).equals(partRef.getPart(false))) {
                    OwlUI.updateWindowTitle(WebBrowserView.this.getPartName());
                }
            }
        };
        this.fEditorSite.getPage().addPartListener(this.fPartListener);
    }

    public CBrowser getBrowser() {
        return this.fBrowser;
    }

    public void setInput(IEditorInput input) {
        super.setInput(input);
        this.fInput = (WebBrowserInput)input;
        if (this.fInput.getContext() != null && StringUtils.isSet((String)this.fInput.getContext().getTitle())) {
            this.setPartName(this.fInput.getContext().getTitle());
        }
        if (this.fCreated) {
            this.firePropertyChange(258);
            WebBrowserInput browserInput = (WebBrowserInput)input;
            if (browserInput.getUrl() != null) {
                this.fBrowser.setUrl(browserInput.getUrl());
            }
            this.fNavigationToolBarManager.find(BACK_ACTION).update("enabled");
            this.fNavigationToolBarManager.find(FORWARD_ACTION).update("enabled");
            if (this.fInput.getUrl() != null) {
                this.fLocationInput.setText(this.fInput.getUrl());
            } else {
                this.fLocationInput.setText("");
            }
        }
    }

    public void dispose() {
        this.unregisterListeners();
        super.dispose();
        this.fCreated = false;
    }

    private void unregisterListeners() {
        this.fEditorSite.getPage().removePartListener(this.fPartListener);
    }

    private void createGlobalActions() {
        this.fSelectAllAction = new Action(){

            public void run() {
                Control focusControl = WebBrowserView.this.fEditorSite.getShell().getDisplay().getFocusControl();
                if (focusControl instanceof Text) {
                    ((Text)focusControl).selectAll();
                }
            }
        };
        this.fCutAction = new Action(){

            public void run() {
                Control focusControl = WebBrowserView.this.fEditorSite.getShell().getDisplay().getFocusControl();
                if (focusControl instanceof Text) {
                    ((Text)focusControl).cut();
                }
            }
        };
        this.fCopyAction = new Action(){

            public void run() {
                Control focusControl = WebBrowserView.this.fEditorSite.getShell().getDisplay().getFocusControl();
                if (focusControl instanceof Text) {
                    ((Text)focusControl).copy();
                }
            }
        };
        this.fPasteAction = new Action(){

            public void run() {
                Control focusControl = WebBrowserView.this.fEditorSite.getShell().getDisplay().getFocusControl();
                if (focusControl instanceof Text) {
                    ((Text)focusControl).paste();
                }
            }
        };
        this.fPrintAction = new Action(){

            public void run() {
                WebBrowserView.this.fBrowser.print();
            }
        };
    }

    private void setGlobalActions() {
        this.fEditorSite.getActionBars().setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)this.fSelectAllAction);
        this.fEditorSite.getActionBars().setGlobalActionHandler(ActionFactory.CUT.getId(), (IAction)this.fCutAction);
        this.fEditorSite.getActionBars().setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.fCopyAction);
        this.fEditorSite.getActionBars().setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.fPasteAction);
        this.fEditorSite.getActionBars().setGlobalActionHandler(ActionFactory.PRINT.getId(), (IAction)this.fPrintAction);
        this.fEditorSite.getActionBars().getGlobalActionHandler(ActionFactory.CUT.getId()).setEnabled(false);
        this.fEditorSite.getActionBars().getGlobalActionHandler(ActionFactory.COPY.getId()).setEnabled(false);
        this.fEditorSite.getActionBars().getGlobalActionHandler(ActionFactory.PASTE.getId()).setEnabled(false);
    }

    public void createPartControl(Composite parent) {
        this.fCreated = true;
        parent.setLayout((Layout)LayoutUtils.createGridLayout(1, 0, 0, 0, 0, false));
        ((GridLayout)parent.getLayout()).marginTop = 5;
        this.createBrowserBar(parent);
        this.createInfobar(parent);
        new Label(parent, 258).setLayoutData((Object)new GridData(4, 1, true, false));
        this.createBrowser(parent);
        if (Application.IS_WINDOWS && !this.fBrowser.isIE()) {
            this.closeJSInfoBar();
        }
        this.hookListeners();
    }

    private void createBrowserBar(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)LayoutUtils.createGridLayout(2, 3, 0, 0, 2, false));
        ((GridLayout)container.getLayout()).marginBottom = 2;
        container.setLayoutData((Object)new GridData(4, 1, true, false));
        this.createNavigationToolBar(container);
        this.createLocationInput(container);
    }

    private void createInfobar(Composite parent) {
        final IPreferenceScope preferences = Owl.getPreferenceService().getGlobalScope();
        if (!preferences.getBoolean(DefaultPreferences.JS_INFOBAR_CLOSED) && preferences.getBoolean(DefaultPreferences.DISABLE_JAVASCRIPT)) {
            this.fJSInfoSeparator = new Label(parent, 258);
            this.fJSInfoSeparator.setLayoutData((Object)new GridData(4, 1, true, false));
            this.fJSInfoBar = new Composite(parent, 0);
            this.fJSInfoBar.setBackground(parent.getDisplay().getSystemColor(29));
            this.fJSInfoBar.setLayoutData((Object)new GridData(4, 1, true, false));
            this.fJSInfoBar.setLayout((Layout)LayoutUtils.createGridLayout(3, 3, 3));
            Label imgLabel = new Label(this.fJSInfoBar, 0);
            imgLabel.setImage(OwlUI.getImage((Control)imgLabel, "icons/obj16/warning.gif"));
            imgLabel.setBackground(this.fJSInfoBar.getBackground());
            imgLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, true));
            Link textLink = new Link(this.fJSInfoBar, 0);
            textLink.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
            textLink.setBackground(this.fJSInfoBar.getBackground());
            textLink.setText(Messages.WebBrowserView_JS_DISABLED_INFO);
            textLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PreferencesUtil.createPreferenceDialogOn((Shell)WebBrowserView.this.fBrowser.getControl().getShell(), (String)BrowserPreferencePage.ID, null, (Object)Boolean.TRUE).open();
                }
            });
            ToolBar bar = new ToolBar(this.fJSInfoBar, 0x800000);
            bar.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, true));
            bar.setBackground(this.fJSInfoBar.getBackground());
            ToolItem closeItem = new ToolItem(bar, 8);
            closeItem.setToolTipText(Messages.WebBrowserView_CLOSE);
            closeItem.setImage(OwlUI.getImage((Control)bar, "icons/etool16/close_normal.png"));
            closeItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    WebBrowserView.this.closeJSInfoBar();
                    preferences.putBoolean(DefaultPreferences.JS_INFOBAR_CLOSED, true);
                }
            });
        }
    }

    private void closeJSInfoBar() {
        if (this.fJSInfoSeparator != null && this.fJSInfoBar != null) {
            ((GridData)this.fJSInfoSeparator.getLayoutData()).exclude = true;
            ((GridData)this.fJSInfoBar.getLayoutData()).exclude = true;
            this.fJSInfoSeparator.setVisible(false);
            this.fJSInfoBar.setVisible(false);
            this.fJSInfoBar.getParent().layout(true, true);
        }
    }

    private void createNavigationToolBar(Composite parent) {
        this.fNavigationToolBarManager = new ToolBarManager(0x800000);
        Action newBrowserTab = new Action(Messages.WebBrowserView_NEW_TAB){

            public void run() {
                BrowserUtils.openLinkInternal("about:blank", null);
            }
        };
        newBrowserTab.setImageDescriptor(OwlUI.getImageDescriptor("icons/etool16/new_browser_tab.gif"));
        this.fNavigationToolBarManager.add((IAction)newBrowserTab);
        this.fNavigationToolBarManager.add((IContributionItem)new Separator());
        Action navBackward = new Action(Messages.WebBrowserView_BACK){

            public void run() {
                if (WebBrowserView.this.fBrowser != null && WebBrowserView.this.fBrowser.getControl().isBackEnabled()) {
                    WebBrowserView.this.fBrowser.back();
                } else if (WebBrowserView.this.fInput.getContext() != null) {
                    WebBrowserView.this.openContext(WebBrowserView.this.fInput.getContext());
                }
            }

            public boolean isEnabled() {
                return WebBrowserView.this.fInput.getContext() != null || WebBrowserView.this.fBrowser != null && WebBrowserView.this.fBrowser.getControl().isBackEnabled();
            }
        };
        navBackward.setId(BACK_ACTION);
        navBackward.setImageDescriptor(OwlUI.getImageDescriptor("icons/etool16/backward.gif"));
        navBackward.setDisabledImageDescriptor(OwlUI.getImageDescriptor("icons/dtool16/backward.gif"));
        this.fNavigationToolBarManager.add((IAction)navBackward);
        Action navForward = new Action(Messages.WebBrowserView_FORWARD){

            public void run() {
                WebBrowserView.this.fBrowser.forward();
            }

            public boolean isEnabled() {
                return WebBrowserView.this.fBrowser != null && WebBrowserView.this.fBrowser.getControl().isForwardEnabled();
            }
        };
        navForward.setId(FORWARD_ACTION);
        navForward.setImageDescriptor(OwlUI.getImageDescriptor("icons/etool16/forward.gif"));
        navForward.setDisabledImageDescriptor(OwlUI.getImageDescriptor("icons/dtool16/forward.gif"));
        this.fNavigationToolBarManager.add((IAction)navForward);
        Action stopNav = new Action(Messages.WebBrowserView_STOP){

            public void run() {
                WebBrowserView.this.fBrowser.getControl().stop();
                WebBrowserView.this.setBusy(false);
            }
        };
        stopNav.setImageDescriptor(OwlUI.getImageDescriptor("icons/etool16/cancel.gif"));
        this.fNavigationToolBarManager.add((IAction)stopNav);
        Action reload = new Action(Messages.WebBrowserView_RELOAD){

            public void run() {
                WebBrowserView.this.fBrowser.refresh();
                WebBrowserView.this.setBusy(true);
            }
        };
        reload.setImageDescriptor(OwlUI.getImageDescriptor("icons/elcl16/reload.gif"));
        this.fNavigationToolBarManager.add((IAction)reload);
        Action navHome = new Action(Messages.WebBrowserView_HOME){

            public void run() {
                if (WebBrowserView.this.fInput.getUrl() != null) {
                    WebBrowserView.this.fBrowser.setUrl(WebBrowserView.this.fInput.getUrl());
                }
            }
        };
        navHome.setImageDescriptor(OwlUI.getImageDescriptor("icons/etool16/home.gif"));
        this.fNavigationToolBarManager.add((IAction)navHome);
        this.fNavigationToolBarManager.add((IContributionItem)new Separator());
        Action openLinkInExternalBrowser = new Action(Messages.WebBrowserView_OPEN_IN_EXTERNAL_BROWSER){

            public void run() {
                String url = WebBrowserView.this.fBrowser.getControl().getUrl();
                if (StringUtils.isSet((String)url) && !"about:blank".equals(url)) {
                    BrowserUtils.openLinkExternal(url);
                }
            }
        };
        openLinkInExternalBrowser.setImageDescriptor(OwlUI.getImageDescriptor("icons/elcl16/browser.gif"));
        this.fNavigationToolBarManager.add((IAction)openLinkInExternalBrowser);
        Action shareLink = new Action(Messages.WebBrowserView_SHARE_LINK, 4){

            public void run() {
                OwlUI.positionDropDownMenu(this, WebBrowserView.this.fNavigationToolBarManager);
            }

            public String getId() {
                return WebBrowserView.SHARE_ACTION;
            }
        };
        this.fNavigationToolBarManager.add((IAction)shareLink);
        shareLink.setImageDescriptor(OwlUI.SHARE);
        shareLink.setMenuCreator((IMenuCreator)new ContextMenuCreator(){

            public Menu createMenu(Control parent) {
                MenuManager shareMenu = new MenuManager();
                String url = WebBrowserView.this.fBrowser.getControl().getUrl();
                StructuredSelection selection = "about:blank".equals(url) ? StructuredSelection.EMPTY : new StructuredSelection((Object)url);
                List<ShareProvider> providers = Controller.getDefault().getShareProviders();
                for (final ShareProvider provider : providers) {
                    if (!provider.isEnabled()) continue;
                    shareMenu.add((IAction)new Action(provider.getName(), (IStructuredSelection)selection){
                        private final /* synthetic */ IStructuredSelection val$selection;
                        {
                            this.val$selection = iStructuredSelection;
                            super($anonymous0);
                        }

                        public void run() {
                            if ("org.rssowl.ui.SendLinkAction".equals(provider.getId())) {
                                SendLinkAction action = new SendLinkAction();
                                action.selectionChanged(null, (ISelection)this.val$selection);
                                action.run(null);
                            } else {
                                Object obj = this.val$selection.getFirstElement();
                                if (StringUtils.isSet((String)((String)obj)) && !"about:blank".equals(obj)) {
                                    String shareLink = provider.toShareUrl((String)obj, null);
                                    new OpenInBrowserAction((IStructuredSelection)new StructuredSelection((Object)shareLink)).run();
                                }
                            }
                        }

                        public ImageDescriptor getImageDescriptor() {
                            if (StringUtils.isSet((String)provider.getIconPath())) {
                                return OwlUI.getImageDescriptor(provider.getPluginId(), provider.getIconPath());
                            }
                            return super.getImageDescriptor();
                        }

                        public boolean isEnabled() {
                            return !this.val$selection.isEmpty();
                        }

                        public String getActionDefinitionId() {
                            return "org.rssowl.ui.SendLinkAction".equals(provider.getId()) ? "org.rssowl.ui.SendLinkAction" : super.getActionDefinitionId();
                        }

                        public String getId() {
                            return "org.rssowl.ui.SendLinkAction".equals(provider.getId()) ? "org.rssowl.ui.SendLinkAction" : super.getId();
                        }
                    });
                }
                shareMenu.add((IContributionItem)new Separator());
                shareMenu.add((IAction)new Action(Messages.WebBrowserView_CONFIGURE){

                    public void run() {
                        PreferencesUtil.createPreferenceDialogOn((Shell)WebBrowserView.this.fBrowser.getControl().getShell(), (String)"org.rssowl.ui.SharingPreferencesPage", null, null).open();
                    }
                });
                return shareMenu.createContextMenu(parent);
            }
        });
        this.fNavigationToolBarManager.add((IContributionItem)new Separator());
        Action discoverFeeds = new Action(Messages.WebBrowserView_FIND_FEEDS){

            public void run() {
                String url = WebBrowserView.this.fBrowser.getControl().getUrl();
                if (StringUtils.isSet((String)url) && !"about:blank".equals(url)) {
                    new ImportAction().openWizardForFeedSearch(WebBrowserView.this.fBrowser.getControl().getShell(), url);
                } else {
                    new ImportAction().openWizardForKeywordSearch(WebBrowserView.this.fBrowser.getControl().getShell());
                }
            }
        };
        this.fNavigationToolBarManager.add((IAction)discoverFeeds);
        discoverFeeds.setImageDescriptor(OwlUI.getImageDescriptor("icons/etool16/new_bkmrk.gif"));
        this.fNavigationToolBarManager.createControl(parent);
    }

    private void openContext(WebBrowserContext context) {
        NewsReference newsReference = context.getNewsReference();
        INewsMark newsMark = context.getNewsMark();
        PerformAfterInputSet perform = null;
        if (newsReference != null) {
            perform = PerformAfterInputSet.selectNews(newsReference);
        }
        if (newsMark != null) {
            OwlUI.openInFeedView(this.fEditorSite.getPage(), (IStructuredSelection)new StructuredSelection((Object)newsMark), true, false, perform);
        }
    }

    private void createLocationInput(Composite parent) {
        this.fLocationInput = Application.IS_WINDOWS || Application.IS_LINUX ? new Text(parent, 2180) : new Text(parent, 2052);
        OwlUI.makeAccessible((Control)this.fLocationInput, Messages.WebBrowserView_ENTER_WEBSITE_PHRASE);
        this.fLocationInput.setMessage(Messages.WebBrowserView_ENTER_WEBSITE_PHRASE);
        this.fLocationInput.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        if (this.fInput.getUrl() != null) {
            this.fLocationInput.setText(this.fInput.getUrl());
        }
        this.fLocationInput.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                if (StringUtils.isSet((String)WebBrowserView.this.fLocationInput.getText())) {
                    String link = URIUtils.getLink((String)WebBrowserView.this.fLocationInput.getText());
                    WebBrowserView.this.fBrowser.setUrl(link);
                    if (WebBrowserView.this.fInput != null) {
                        WebBrowserView.this.fInput.setCurrentUrl(link);
                    }
                    WebBrowserView.this.fBrowser.getControl().setFocus();
                }
            }
        });
        this.fLocationInput.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (WebBrowserView.this.fLocationSelectAllOnce && WebBrowserView.this.fLocationInput.getSelectionCount() == 0) {
                    WebBrowserView.this.fLocationInput.selectAll();
                }
                WebBrowserView.this.fLocationSelectAllOnce = false;
            }
        });
        Controller.getDefault().getContextService().registerInputField((Control)this.fLocationInput);
        this.fLocationInput.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                WebBrowserView.this.fEditorSite.getActionBars().getGlobalActionHandler(ActionFactory.CUT.getId()).setEnabled(true);
                WebBrowserView.this.fEditorSite.getActionBars().getGlobalActionHandler(ActionFactory.COPY.getId()).setEnabled(true);
                WebBrowserView.this.fEditorSite.getActionBars().getGlobalActionHandler(ActionFactory.PASTE.getId()).setEnabled(true);
            }

            public void focusLost(FocusEvent e) {
                WebBrowserView.this.fEditorSite.getActionBars().getGlobalActionHandler(ActionFactory.CUT.getId()).setEnabled(false);
                WebBrowserView.this.fEditorSite.getActionBars().getGlobalActionHandler(ActionFactory.COPY.getId()).setEnabled(false);
                WebBrowserView.this.fEditorSite.getActionBars().getGlobalActionHandler(ActionFactory.PASTE.getId()).setEnabled(false);
                WebBrowserView.this.fLocationSelectAllOnce = true;
            }
        });
    }

    private void createBrowser(Composite parent) {
        this.fBrowser = new CBrowser(parent, 0);
        if (this.fInput.getUrl() != null) {
            this.fBrowser.setUrl(this.fInput.getUrl());
        }
        if (StringUtils.isSet((String)this.fInput.getUrl()) && !"about:blank".equals(this.fInput.getUrl())) {
            this.setBusy(true);
        }
        this.fBrowser.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
    }

    private void hookListeners() {
        this.fBrowser.getControl().addTitleListener(new TitleListener(){

            public void changed(TitleEvent event) {
                if ("about:blank".equals(event.title)) {
                    WebBrowserView.this.setPartName(Messages.WebBrowserView_BLANK_PAGE);
                } else {
                    WebBrowserView.this.setPartName(event.title);
                }
                IWorkbenchPage page = WebBrowserView.this.fEditorSite.getPage();
                IWorkbenchPart part = WebBrowserView.this.fEditorSite.getPart();
                if (page != null && part != null && page.isPartVisible(part)) {
                    OwlUI.updateWindowTitle(WebBrowserView.this.getPartName());
                }
            }
        });
        this.fBrowser.getControl().addStatusTextListener(new StatusTextListener(){

            public void changed(StatusTextEvent event) {
                if (event.text != null && !event.text.contains("rssowl://") && !WebBrowserView.this.fBrowser.getControl().isDisposed() && WebBrowserView.this.fBrowser.getControl().isVisible()) {
                    WebBrowserView.this.fEditorSite.getActionBars().getStatusLineManager().setMessage(event.text);
                }
            }
        });
        this.fBrowser.getControl().addLocationListener((LocationListener)new LocationAdapter(){

            public void changed(LocationEvent event) {
                WebBrowserView.this.fNavigationToolBarManager.find(WebBrowserView.BACK_ACTION).update("enabled");
                WebBrowserView.this.fNavigationToolBarManager.find(WebBrowserView.FORWARD_ACTION).update("enabled");
                WebBrowserView.this.setBusy(false);
            }

            public void changing(LocationEvent event) {
                WebBrowserView.this.setBusy(true);
            }
        });
        this.fBrowser.getControl().addProgressListener(new ProgressListener(){

            public void changed(ProgressEvent event) {
                if (!WebBrowserView.this.fLocationInput.isDisposed()) {
                    String url = ((Browser)event.widget).getUrl();
                    if (ApplicationServer.getDefault().isNewsServerUrl(url)) {
                        WebBrowserView.this.fLocationInput.setText("");
                    }
                }
            }

            public void completed(ProgressEvent event) {
                if (!WebBrowserView.this.fLocationInput.isDisposed()) {
                    String url = ((Browser)event.widget).getUrl();
                    if (ApplicationServer.getDefault().isNewsServerUrl(url)) {
                        WebBrowserView.this.fLocationInput.setText("");
                    } else if (StringUtils.isSet((String)url)) {
                        if ("about:blank".equals(url)) {
                            WebBrowserView.this.fLocationInput.setText("");
                        } else if (!WebBrowserView.this.fLocationInput.isFocusControl()) {
                            WebBrowserView.this.fLocationInput.setText(url);
                        }
                        if (WebBrowserView.this.fInput != null) {
                            WebBrowserView.this.fInput.setCurrentUrl(url);
                        }
                    }
                }
            }
        });
    }

    private void setBusy(boolean busy) {
        if (this.fCreated && this.getSite() instanceof PartSite) {
            ((PartSite)this.getSite()).getPane().setBusy(busy);
        }
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
        if (!this.fCreated || Controller.getDefault().isShuttingDown()) {
            return;
        }
        if ("about:blank".equals(this.fBrowser.getControl().getUrl())) {
            return;
        }
        FileDialog dialog = new FileDialog(this.getSite().getShell(), 8192);
        dialog.setOverwrite(true);
        dialog.setFilterExtensions(new String[]{"*.html"});
        dialog.setFileName("site.html");
        String fileName = dialog.open();
        if (fileName == null) {
            return;
        }
        StringBuilder content = new StringBuilder();
        content.append(this.fBrowser.getControl().getText());
        if (content.length() == 0) {
            return;
        }
        CoreUtils.write((String)fileName, (StringBuilder)content);
    }

    public void setFocus() {
        if (this.fBrowser != null && !this.fBrowser.getControl().isDisposed()) {
            String url = this.fInput.getUrl();
            if ("about:blank".equals(url)) {
                this.fLocationInput.setFocus();
            } else {
                this.fBrowser.getControl().setFocus();
            }
        }
    }
}

