/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.editors.feed;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.rssowl.core.Owl;
import org.rssowl.core.persist.IModelFactory;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.INewsMark;
import org.rssowl.core.persist.ISearchCondition;
import org.rssowl.core.persist.ISearchField;
import org.rssowl.core.persist.ISearchMark;
import org.rssowl.core.persist.SearchSpecifier;
import org.rssowl.core.persist.reference.NewsReference;
import org.rssowl.core.persist.service.PersistenceException;
import org.rssowl.core.util.DateUtils;
import org.rssowl.core.util.SearchHit;
import org.rssowl.core.util.StringUtils;
import org.rssowl.ui.internal.Activator;
import org.rssowl.ui.internal.FolderNewsMark;
import org.rssowl.ui.internal.editors.feed.Messages;
import org.rssowl.ui.internal.util.ModelUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewsFilter
extends ViewerFilter {
    private Type fType = Type.SHOW_ALL;
    private SearchTarget fSearchTarget = SearchTarget.HEADLINE;
    private INewsMark fNewsMark;
    private Set<Long> fCachedPatternMatchingNews;
    private IModelFactory fModelFactory = Owl.getModelFactory();
    private String fPatternString;

    public void setNewsMark(INewsMark newsMark) {
        this.fNewsMark = newsMark;
    }

    public final boolean select(Viewer viewer, Object parentElement, Object element) {
        if (this.fCachedPatternMatchingNews == null && this.fType == Type.SHOW_ALL) {
            return true;
        }
        return this.isElementVisible(viewer, element);
    }

    boolean isElementVisible(Viewer viewer, Object element) {
        return this.isParentMatch(viewer, element) || this.isLeafMatch(viewer, element, false);
    }

    boolean isElementSelectable(Object element) {
        return element != null;
    }

    private boolean isParentMatch(Viewer viewer, Object element) {
        ITreeContentProvider provider;
        Object[] children;
        if (viewer instanceof AbstractTreeViewer && (children = (provider = (ITreeContentProvider)((AbstractTreeViewer)viewer).getContentProvider()).getChildren(element)) != null && children.length > 0) {
            return this.filter(viewer, element, children).length > 0;
        }
        return false;
    }

    boolean select(INews news, boolean ignorePattern) {
        return this.isLeafMatch(null, news, ignorePattern);
    }

    boolean isTextPatternMatch(Long newsId) {
        return this.fCachedPatternMatchingNews == null || this.fCachedPatternMatchingNews.contains(newsId);
    }

    private boolean isLeafMatch(Viewer viewer, Object element, boolean ignorePattern) {
        if ((ignorePattern || this.fCachedPatternMatchingNews == null) && this.fType == Type.SHOW_ALL) {
            return true;
        }
        if (element instanceof INews) {
            INews news = (INews)element;
            INews.State state = news.getState();
            boolean isMatch = false;
            switch (this.fType) {
                case SHOW_ALL: {
                    isMatch = true;
                    break;
                }
                case SHOW_NEW: {
                    isMatch = state == INews.State.NEW;
                    break;
                }
                case SHOW_UNREAD: {
                    isMatch = state == INews.State.UNREAD || state == INews.State.NEW || state == INews.State.UPDATED;
                    break;
                }
                case SHOW_STICKY: {
                    isMatch = news.isFlagged();
                    break;
                }
                case SHOW_LABELED: {
                    isMatch = !news.getLabels().isEmpty();
                    break;
                }
                case SHOW_RECENT: {
                    Date date = DateUtils.getRecentDate((INews)news);
                    isMatch = date.getTime() >= DateUtils.getToday().getTimeInMillis() - 86400000L;
                    break;
                }
                case SHOW_LAST_5_DAYS: {
                    Date date = DateUtils.getRecentDate((INews)news);
                    boolean bl = isMatch = date.getTime() >= DateUtils.getToday().getTimeInMillis() - 432000000L;
                }
            }
            if (isMatch && !ignorePattern && this.fCachedPatternMatchingNews != null) {
                isMatch = this.isTextPatternMatch(news.getId());
            }
            return isMatch;
        }
        return false;
    }

    public boolean isFilterProperty(Object element, String property) {
        return false;
    }

    public void setType(Type type) {
        if (this.fType != type) {
            this.fType = type;
        }
    }

    Type getType() {
        return this.fType;
    }

    SearchTarget getSearchTarget() {
        return this.fSearchTarget;
    }

    String getPatternString() {
        return this.fPatternString;
    }

    public void setSearchTarget(SearchTarget searchTarget) {
        SearchTarget oldTarget = this.fSearchTarget;
        this.fSearchTarget = searchTarget;
        if (oldTarget != this.fSearchTarget) {
            this.setPattern(this.fPatternString);
        }
    }

    public void setPattern(String patternString) {
        this.fPatternString = patternString;
        if (!StringUtils.isSet((String)patternString)) {
            this.fCachedPatternMatchingNews = null;
        } else {
            try {
                this.fCachedPatternMatchingNews = this.cacheMatchingNews(patternString.trim());
            }
            catch (PersistenceException e) {
                Activator.getDefault().logError(e.getMessage(), e);
            }
        }
    }

    private Set<Long> cacheMatchingNews(String pattern) {
        List result;
        ISearchField field;
        ArrayList<ISearchCondition> conditions = new ArrayList<ISearchCondition>(2);
        ISearchCondition locationCondition = null;
        ISearchCondition textCondition = null;
        if (!StringUtils.isSet((String)pattern)) {
            return Collections.emptySet();
        }
        if (StringUtils.supportsTrailingWildcards((String)pattern)) {
            pattern = String.valueOf(pattern) + "*";
        }
        if (this.fNewsMark != null && !(this.fNewsMark instanceof ISearchMark) && !(this.fNewsMark instanceof FolderNewsMark)) {
            field = this.fModelFactory.createSearchField(19, INews.class.getName());
            locationCondition = this.fModelFactory.createSearchCondition(field, SearchSpecifier.IS, (Object)ModelUtils.toPrimitive(Collections.singletonList(this.fNewsMark)));
            conditions.add(locationCondition);
        }
        field = null;
        SearchSpecifier specifier = SearchSpecifier.CONTAINS_ALL;
        switch (this.fSearchTarget) {
            case ALL: {
                field = this.fModelFactory.createSearchField(-1, INews.class.getName());
                break;
            }
            case ATTACHMENTS: {
                field = this.fModelFactory.createSearchField(11, INews.class.getName());
                break;
            }
            case AUTHOR: {
                field = this.fModelFactory.createSearchField(3, INews.class.getName());
                break;
            }
            case CATEGORY: {
                field = this.fModelFactory.createSearchField(12, INews.class.getName());
                specifier = SearchSpecifier.IS;
                break;
            }
            case HEADLINE: {
                field = this.fModelFactory.createSearchField(0, INews.class.getName());
                break;
            }
            case SOURCE: {
                field = this.fModelFactory.createSearchField(9, INews.class.getName());
                specifier = SearchSpecifier.IS;
                break;
            }
            case LABELS: {
                field = this.fModelFactory.createSearchField(15, INews.class.getName());
                specifier = SearchSpecifier.IS;
            }
        }
        textCondition = this.fModelFactory.createSearchCondition(field, specifier, (Object)pattern);
        conditions.add(textCondition);
        if (this.fNewsMark != null && this.fNewsMark instanceof ISearchMark) {
            ISearchMark searchMark = (ISearchMark)this.fNewsMark;
            result = Owl.getPersistenceService().getModelSearch().searchNews((Collection)searchMark.getSearchConditions(), textCondition, searchMark.matchAllConditions());
        } else {
            result = Owl.getPersistenceService().getModelSearch().searchNews(conditions, true);
        }
        HashSet<Long> resultSet = new HashSet<Long>(result.size());
        for (SearchHit hit : result) {
            resultSet.add(((NewsReference)hit.getResult()).getId());
        }
        return resultSet;
    }

    boolean isPatternSet() {
        return this.fCachedPatternMatchingNews != null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SearchTarget {
        HEADLINE(Messages.NewsFilter_HEADLINE),
        ALL(Messages.NewsFilter_ENTIRE_NEWS),
        AUTHOR(Messages.NewsFilter_AUTHOR),
        CATEGORY(Messages.NewsFilter_CATEGORY),
        SOURCE(Messages.NewsFilter_SOURCE),
        ATTACHMENTS(Messages.NewsFilter_ATTACHMENTS),
        LABELS(Messages.NewsFilter_LABELS);

        String fName;

        private SearchTarget(String name) {
            this.fName = name;
        }

        public String getName() {
            return this.fName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        SHOW_ALL(Messages.NewsFilter_SHOW_ALL, Messages.NewsFilter_ALL_NEWS),
        SHOW_NEW(Messages.NewsFilter_SHOW_NEW, Messages.NewsFilter_NEW_NEWS),
        SHOW_UNREAD(Messages.NewsFilter_SHOW_UNREAD, Messages.NewsFilter_UNREAD_NEWS),
        SHOW_RECENT(Messages.NewsFilter_SHOW_RECENT, Messages.NewsFilter_RECENT_NEWS),
        SHOW_STICKY(Messages.NewsFilter_SHOW_STICKY, Messages.NewsFilter_STICKY_NEWS),
        SHOW_LAST_5_DAYS(Messages.NewsFilter_SHOW_LAST_DAYS, Messages.NewsFilter_LAST_DAYS),
        SHOW_LABELED(Messages.NewsFilter_SHOW_LABELED_NEWS, Messages.NewsFilter_LABELED_NEWS);

        String fName;
        String fDisplayName;

        private Type(String actionName, String displayName) {
            this.fName = actionName;
            this.fDisplayName = displayName;
        }

        public String getName() {
            return this.fName;
        }

        public String getDisplayName() {
            return this.fDisplayName;
        }
    }
}

