/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.filter;

import java.io.File;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.rssowl.core.Owl;
import org.rssowl.core.internal.persist.pref.DefaultPreferences;
import org.rssowl.core.persist.pref.IPreferenceScope;
import org.rssowl.core.util.StringUtils;
import org.rssowl.ui.filter.INewsActionPresentation;
import org.rssowl.ui.internal.filter.Messages;
import org.rssowl.ui.internal.util.LayoutUtils;

public class DownloadAttachmentsNewsActionPresentation
implements INewsActionPresentation {
    private Link fFolderPathLink;
    private Composite fContainer;

    public void create(Composite parent, Object data) {
        this.fContainer = new Composite(parent, 0);
        this.fContainer.setLayout((Layout)LayoutUtils.createGridLayout(1, 0, 0, 0, 0, false));
        ((GridLayout)this.fContainer.getLayout()).marginLeft = 5;
        this.fContainer.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        this.fFolderPathLink = new Link(this.fContainer, 64);
        this.fFolderPathLink.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        ((GridData)this.fFolderPathLink.getLayoutData()).widthHint = 100;
        this.updateLink(data);
        this.fFolderPathLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DownloadAttachmentsNewsActionPresentation.this.onSelect();
            }
        });
    }

    private void onSelect() {
        String folderPath;
        String downloadFolder;
        File file;
        IPreferenceScope preferences = Owl.getPreferenceService().getGlobalScope();
        DirectoryDialog dialog = new DirectoryDialog(this.fFolderPathLink.getShell(), 0);
        dialog.setText(Messages.DownloadAttachmentsNewsActionPresentation_SELECT_FOLDER);
        if (this.fFolderPathLink.getData() != null && (file = new File(this.fFolderPathLink.getData().toString())).exists()) {
            dialog.setFilterPath(file.toString());
        }
        if (!StringUtils.isSet((String)dialog.getFilterPath()) && StringUtils.isSet((String)(downloadFolder = preferences.getString(DefaultPreferences.DOWNLOAD_FOLDER))) && new File(downloadFolder).exists()) {
            dialog.setFilterPath(downloadFolder);
        }
        if (StringUtils.isSet((String)(folderPath = dialog.open()))) {
            this.updateLink(folderPath);
            this.fFolderPathLink.getShell().layout(true, true);
            preferences.putString(DefaultPreferences.DOWNLOAD_FOLDER, folderPath);
        }
    }

    private void updateLink(Object data) {
        if (data == null) {
            this.resetLink();
        } else {
            File file = new File(data.toString());
            if (file.exists()) {
                this.fFolderPathLink.setText(NLS.bind((String)Messages.DownloadAttachmentsNewsActionPresentation_TO_N, (Object)file.getAbsolutePath()));
                this.fFolderPathLink.setData(data);
            } else {
                this.resetLink();
            }
        }
    }

    private void resetLink() {
        this.fFolderPathLink.setText(Messages.DownloadAttachmentsNewsActionPresentation_TO_SELECT_FOLDER);
        this.fFolderPathLink.setData(null);
    }

    public void dispose() {
        this.fContainer.dispose();
    }

    public Object getData() {
        return this.fFolderPathLink.getData();
    }
}

