/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.services;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.rssowl.core.Owl;
import org.rssowl.core.connection.AuthenticationRequiredException;
import org.rssowl.core.connection.ConnectionException;
import org.rssowl.core.connection.ICredentials;
import org.rssowl.core.connection.ICredentialsProvider;
import org.rssowl.core.connection.IProtocolHandler;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.ISearchFilter;
import org.rssowl.core.persist.dao.DynamicDAO;
import org.rssowl.core.persist.event.EntityListener;
import org.rssowl.core.persist.event.NewsAdapter;
import org.rssowl.core.persist.event.NewsEvent;
import org.rssowl.core.persist.event.NewsListener;
import org.rssowl.core.persist.event.SearchFilterAdapter;
import org.rssowl.core.util.BatchedBuffer;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.core.util.SyncItem;
import org.rssowl.core.util.SyncUtils;
import org.rssowl.ui.internal.Activator;
import org.rssowl.ui.internal.Controller;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.services.SyncItemsManager;
import org.rssowl.ui.internal.util.JobRunner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyncService
implements BatchedBuffer.Receiver<SyncItem> {
    private static final int SYNC_DELAY = 15000;
    private static final int SYNC_SCHEDULER = 300000;
    private static final int SYNC_PAGE_SIZE = 100;
    private static final String REQUEST_HEADER_CONTENT_TYPE = "Content-Type";
    private static final String REQUEST_HEADER_AUTHORIZATION = "Authorization";
    private static final String CONTENT_TYPE_FORM_ENCODED = "application/x-www-form-urlencoded";
    private final BatchedBuffer<SyncItem> fSynchronizer;
    private final SyncItemsManager fSyncItemsManager;
    private final AtomicInteger fTotalSyncItemCount = new AtomicInteger();
    private Job fSyncScheduler;
    private NewsListener fNewsListener;
    private SearchFilterAdapter fSearchFilterListener;
    private SyncStatus fStatus;

    public SyncService() {
        this.fSynchronizer = new BatchedBuffer((BatchedBuffer.Receiver)this, 15000);
        this.fSyncItemsManager = new SyncItemsManager();
        this.init();
    }

    private void init() {
        this.registerListeners();
        try {
            this.fSyncItemsManager.startup();
        }
        catch (IOException e) {
            Activator.getDefault().logError(e.getMessage(), e);
        }
        catch (ClassNotFoundException e) {
            Activator.getDefault().logError(e.getMessage(), e);
        }
        if (this.fSyncItemsManager.hasUncommittedItems()) {
            this.addAllAsync(this.fSyncItemsManager.getUncommittedItems().values());
        }
        this.fSyncScheduler = new Job(""){

            protected IStatus run(IProgressMonitor monitor) {
                if (!Controller.getDefault().isShuttingDown() && !monitor.isCanceled()) {
                    if (SyncService.this.fSyncItemsManager.hasUncommittedItems() && !SyncService.this.fSynchronizer.isScheduled()) {
                        SyncService.this.fSynchronizer.addAll(SyncService.this.fSyncItemsManager.getUncommittedItems().values());
                    }
                    this.schedule(300000L);
                }
                return Status.OK_STATUS;
            }
        };
        this.fSyncScheduler.setSystem(true);
        this.fSyncScheduler.setUser(false);
        this.fSyncScheduler.schedule(300000L);
    }

    private void registerListeners() {
        this.fNewsListener = new NewsAdapter(){

            public void entitiesUpdated(Set<NewsEvent> events) {
                Collection items = SyncService.this.filter(events);
                SyncService.this.synchronize(items);
            }
        };
        DynamicDAO.addEntityListener(INews.class, (EntityListener)this.fNewsListener);
        this.fSearchFilterListener = new SearchFilterAdapter(){

            public void filterApplied(ISearchFilter filter, Collection<INews> news) {
                Collection items = SyncService.this.filter(filter, news);
                SyncService.this.synchronize(items);
            }
        };
        DynamicDAO.addEntityListener(ISearchFilter.class, (EntityListener)this.fSearchFilterListener);
    }

    private void addAllAsync(final Collection<SyncItem> items) {
        JobRunner.runInBackgroundThread(new Runnable(){

            public void run() {
                SyncService.this.fSynchronizer.addAll(items);
            }
        });
    }

    private Collection<SyncItem> filter(ISearchFilter filter, Collection<INews> news) {
        ArrayList<SyncItem> filteredEvents = new ArrayList<SyncItem>();
        for (INews item : news) {
            SyncItem syncItem;
            if (!SyncUtils.isSynchronized((INews)item) || (syncItem = SyncItem.toSyncItem((ISearchFilter)filter, (INews)item)) == null) continue;
            filteredEvents.add(syncItem);
        }
        return filteredEvents;
    }

    private Collection<SyncItem> filter(Set<NewsEvent> events) {
        ArrayList<SyncItem> filteredEvents = new ArrayList<SyncItem>();
        for (NewsEvent event : events) {
            SyncItem syncItem;
            if (event.isMerged() || event.getOldNews() == null || !SyncUtils.isSynchronized((INews)event.getEntity()) || (syncItem = SyncItem.toSyncItem((NewsEvent)event)) == null) continue;
            filteredEvents.add(syncItem);
        }
        return filteredEvents;
    }

    private void unregisterListeners() {
        DynamicDAO.removeEntityListener(INews.class, (EntityListener)this.fNewsListener);
        DynamicDAO.removeEntityListener(ISearchFilter.class, (EntityListener)this.fSearchFilterListener);
    }

    public void synchronize() {
        JobRunner.runInBackgroundThread(new Runnable(){

            public void run() {
                if (!Controller.getDefault().isShuttingDown() && SyncService.this.fSyncItemsManager.hasUncommittedItems() && !SyncService.this.fSynchronizer.isScheduled()) {
                    SyncService.this.fSynchronizer.addAll(SyncService.this.fSyncItemsManager.getUncommittedItems().values());
                }
            }
        });
    }

    public void synchronize(Collection<SyncItem> items) {
        if (!items.isEmpty()) {
            this.fSyncItemsManager.addUncommitted(items);
            this.addAllAsync(items);
        }
    }

    public SyncStatus getStatus() {
        return this.fStatus;
    }

    public Map<String, SyncItem> getUncommittedItems() {
        return this.fSyncItemsManager.getUncommittedItems();
    }

    public void stopService(boolean emergency) {
        this.unregisterListeners();
        this.fSyncScheduler.cancel();
        this.fSynchronizer.cancel(!emergency);
        if (!emergency) {
            try {
                this.fSyncItemsManager.shutdown();
            }
            catch (FileNotFoundException e) {
                Activator.getDefault().logError(e.getMessage(), e);
            }
            catch (IOException e) {
                Activator.getDefault().logError(e.getMessage(), e);
            }
        }
    }

    public IStatus receive(Collection<SyncItem> items, Job job, IProgressMonitor monitor) {
        try {
            int itemCount = this.sync(this.fSyncItemsManager.getUncommittedItems().values(), monitor);
            int totalItemCount = this.fTotalSyncItemCount.addAndGet(itemCount);
            if (itemCount > 0) {
                this.fStatus = new SyncStatus(itemCount, totalItemCount);
            }
        }
        catch (AuthenticationRequiredException e) {
            this.fStatus = new SyncStatus(e.getMessage(), e);
            this.handleAuthenticationRequired(monitor);
        }
        catch (ConnectionException e) {
            Activator.getDefault().logError(e.getMessage(), e);
            this.fStatus = new SyncStatus(e.getMessage(), e);
        }
        return Status.OK_STATUS;
    }

    private void handleAuthenticationRequired(final IProgressMonitor monitor) {
        if (!Controller.getDefault().isShuttingDown() && !monitor.isCanceled()) {
            JobRunner.runInBackgroundThread(new Runnable(){

                public void run() {
                    Lock loginLock = Controller.getDefault().getLoginDialogLock();
                    if (!Controller.getDefault().isShuttingDown() && !monitor.isCanceled() && loginLock.tryLock()) {
                        try {
                            JobRunner.runSyncedInUIThread(new Runnable(){

                                public void run() {
                                    if (!Controller.getDefault().isShuttingDown() && !monitor.isCanceled()) {
                                        OwlUI.openSyncLogin(null);
                                    }
                                }
                            });
                        }
                        finally {
                            loginLock.unlock();
                        }
                    }
                }
            });
        }
    }

    private int sync(Collection<SyncItem> items, IProgressMonitor monitor) throws ConnectionException {
        if (this.isCanceled(monitor)) {
            return 0;
        }
        Map<String, Map<String, SyncItem>> mapFeedToSyncItems = this.groupByStream(items);
        if (this.isCanceled(monitor)) {
            return 0;
        }
        String token = this.getGoogleApiToken(monitor);
        String authToken = SyncUtils.getGoogleAuthToken(null, null, (boolean)false, (IProgressMonitor)monitor);
        if (token == null || authToken == null) {
            throw new ConnectionException(Activator.getDefault().createErrorStatus("Unable to obtain a token for Google API access."));
        }
        if (this.isCanceled(monitor)) {
            return 0;
        }
        int itemCount = 0;
        Set<Map.Entry<String, Map<String, SyncItem>>> entries = mapFeedToSyncItems.entrySet();
        for (Map.Entry<String, Map<String, SyncItem>> entry : entries) {
            if (entry.getValue() == null) continue;
            Collection<SyncItem> syncItems = entry.getValue().values();
            List<List<SyncItem>> equivalentItemLists = this.findEquivalents(syncItems);
            for (List<SyncItem> equivalentItems : equivalentItemLists) {
                if (equivalentItems.isEmpty()) continue;
                List chunks = CoreUtils.toChunks(equivalentItems, (int)100);
                for (List chunk : chunks) {
                    itemCount += this.doSync(chunk, token, authToken, monitor);
                }
                if (!this.isCanceled(monitor)) continue;
                return itemCount;
            }
        }
        return itemCount;
    }

    private int doSync(List<SyncItem> equivalentItems, String token, String authToken, IProgressMonitor monitor) throws ConnectionException {
        int itemCount = 0;
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(REQUEST_HEADER_CONTENT_TYPE, CONTENT_TYPE_FORM_ENCODED);
        headers.put(REQUEST_HEADER_AUTHORIZATION, SyncUtils.getGoogleAuthorizationHeader((String)authToken));
        HashMap<String, String[]> parameters = new HashMap<String, String[]>();
        parameters.put("T", new String[]{token});
        ArrayList<String> identifiers = new ArrayList<String>();
        ArrayList<String> streamIds = new ArrayList<String>();
        HashSet<String> tagsToAdd = new HashSet<String>();
        HashSet<String> tagsToRemove = new HashSet<String>();
        for (SyncItem item : equivalentItems) {
            List removedLabels;
            List addedLabels;
            identifiers.add(item.getId());
            streamIds.add(item.getStreamId());
            if (item.isMarkedRead()) {
                tagsToAdd.add("user/-/state/com.google/read");
                tagsToRemove.add("user/-/state/com.google/kept-unread");
            }
            if (item.isMarkedUnread()) {
                tagsToAdd.add("user/-/state/com.google/kept-unread");
                tagsToAdd.add("user/-/state/com.google/tracking-kept-unread ");
                tagsToRemove.add("user/-/state/com.google/read");
            }
            if (item.isStarred()) {
                tagsToAdd.add("user/-/state/com.google/starred");
            }
            if (item.isUnStarred()) {
                tagsToRemove.add("user/-/state/com.google/starred");
            }
            if ((addedLabels = item.getAddedLabels()) != null) {
                for (String label : addedLabels) {
                    tagsToAdd.add("user/-/label/" + label);
                }
            }
            if ((removedLabels = item.getRemovedLabels()) == null) continue;
            for (String label : removedLabels) {
                tagsToRemove.add("user/-/label/" + label);
            }
        }
        parameters.put("i", identifiers.toArray(new String[identifiers.size()]));
        parameters.put("s", streamIds.toArray(new String[streamIds.size()]));
        if (!tagsToAdd.isEmpty()) {
            parameters.put("a", tagsToAdd.toArray(new String[tagsToAdd.size()]));
        }
        if (!tagsToRemove.isEmpty()) {
            parameters.put("r", tagsToRemove.toArray(new String[tagsToRemove.size()]));
        }
        HashMap<String, Serializable> properties = new HashMap<String, Serializable>();
        properties.put("HEADERS", headers);
        properties.put("POST", Boolean.TRUE);
        properties.put("PARAMETERS", parameters);
        properties.put("CON_TIMEOUT", Integer.valueOf(this.getConnectionTimeout()));
        if (this.isCanceled(monitor)) {
            return itemCount;
        }
        URI uri = URI.create("http://www.google.com/reader/api/0/edit-tag?client=scroll");
        IProtocolHandler handler = Owl.getConnectionService().getHandler(uri);
        InputStream inS = null;
        try {
            inS = handler.openStream(uri, (IProgressMonitor)new NullProgressMonitor(), properties);
            this.fSyncItemsManager.removeUncommitted(equivalentItems);
        }
        finally {
            if (inS != null) {
                try {
                    inS.close();
                }
                catch (IOException e) {
                    throw new ConnectionException(Activator.getDefault().createErrorStatus(e.getMessage(), e));
                }
            }
        }
        return itemCount += equivalentItems.size();
    }

    private Map<String, Map<String, SyncItem>> groupByStream(Collection<SyncItem> items) {
        HashMap<String, Map<String, SyncItem>> mapFeedToSyncItems = new HashMap<String, Map<String, SyncItem>>();
        for (SyncItem item : items) {
            HashMap<String, SyncItem> streamItems = (HashMap<String, SyncItem>)mapFeedToSyncItems.get(item.getStreamId());
            if (streamItems == null) {
                streamItems = new HashMap<String, SyncItem>();
                mapFeedToSyncItems.put(item.getStreamId(), streamItems);
            }
            streamItems.put(item.getId(), item);
        }
        return mapFeedToSyncItems;
    }

    private List<List<SyncItem>> findEquivalents(Collection<SyncItem> syncItems) {
        ArrayList<List<SyncItem>> equivalentItemLists = new ArrayList<List<SyncItem>>();
        ArrayList<SyncItem> currentItemList = new ArrayList<SyncItem>();
        equivalentItemLists.add(currentItemList);
        for (SyncItem item : syncItems) {
            if (currentItemList.isEmpty()) {
                currentItemList.add(item);
                continue;
            }
            if (item.isEquivalent((SyncItem)currentItemList.get(0))) {
                currentItemList.add(item);
                continue;
            }
            currentItemList = new ArrayList();
            currentItemList.add(item);
            equivalentItemLists.add(currentItemList);
        }
        return equivalentItemLists;
    }

    private String getGoogleApiToken(IProgressMonitor monitor) throws ConnectionException {
        ICredentialsProvider provider = Owl.getConnectionService().getCredentialsProvider(URI.create("https://www.google.com/accounts/ClientLogin"));
        ICredentials creds = provider.getAuthCredentials(URI.create("https://www.google.com/accounts/ClientLogin"), null);
        if (creds == null) {
            throw new AuthenticationRequiredException(null, Status.CANCEL_STATUS);
        }
        return SyncUtils.getGoogleApiToken((String)creds.getUsername(), (String)creds.getPassword(), (IProgressMonitor)monitor);
    }

    private boolean isCanceled(IProgressMonitor monitor) {
        return monitor != null && monitor.isCanceled();
    }

    private int getConnectionTimeout() {
        return Controller.getDefault().isShuttingDown() ? 5000 : 30000;
    }

    public void testSync(Collection<SyncItem> items) throws ConnectionException {
        int itemCount = this.sync(items, (IProgressMonitor)new NullProgressMonitor());
        int totalItemCount = this.fTotalSyncItemCount.addAndGet(itemCount);
        if (itemCount > 0) {
            this.fStatus = new SyncStatus(itemCount, totalItemCount);
        }
    }

    public static class SyncStatus
    extends Status {
        private final long fTime = System.currentTimeMillis();
        private final int fItemCount;
        private final int fTotalItemCount;

        public SyncStatus(int itemCount, int totalItemCount) {
            super(0, "org.rssowl.ui", null, null);
            this.fItemCount = itemCount;
            this.fTotalItemCount = totalItemCount;
        }

        public SyncStatus(String message, Throwable exception) {
            super(4, "org.rssowl.ui", message, exception);
            this.fItemCount = 0;
            this.fTotalItemCount = 0;
        }

        public long getTime() {
            return this.fTime;
        }

        public int getItemCount() {
            return this.fItemCount;
        }

        public int getTotalItemCount() {
            return this.fTotalItemCount;
        }
    }
}

