/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.util;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.ui.PlatformUI;
import org.rssowl.core.Owl;
import org.rssowl.core.internal.InternalOwl;
import org.rssowl.core.persist.IBookMark;
import org.rssowl.core.persist.IEntity;
import org.rssowl.core.persist.IFeed;
import org.rssowl.core.persist.IFilterAction;
import org.rssowl.core.persist.IFolder;
import org.rssowl.core.persist.IFolderChild;
import org.rssowl.core.persist.ILabel;
import org.rssowl.core.persist.IMark;
import org.rssowl.core.persist.INewsMark;
import org.rssowl.core.persist.IPersistable;
import org.rssowl.core.persist.IPreference;
import org.rssowl.core.persist.ISearch;
import org.rssowl.core.persist.ISearchCondition;
import org.rssowl.core.persist.ISearchFilter;
import org.rssowl.core.persist.ISearchMark;
import org.rssowl.core.persist.dao.DynamicDAO;
import org.rssowl.core.persist.dao.IFeedDAO;
import org.rssowl.core.persist.dao.ISearchMarkDAO;
import org.rssowl.core.persist.pref.IPreferenceScope;
import org.rssowl.core.persist.pref.IPreferenceType;
import org.rssowl.core.persist.reference.FeedLinkReference;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.core.util.URIUtils;
import org.rssowl.ui.internal.Controller;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.util.ModelUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportUtils {
    public static void doImport(IFolder target, List<? extends IEntity> elements, boolean checkExistingFeeds) {
        ArrayList<IFolderChild> folderChilds = new ArrayList<IFolderChild>();
        ArrayList<ILabel> labels = new ArrayList<ILabel>();
        ArrayList<ISearchFilter> filters = new ArrayList<ISearchFilter>();
        ArrayList<IPreference> preferences = new ArrayList<IPreference>();
        if (elements != null) {
            for (IEntity iEntity : elements) {
                if (iEntity instanceof IFolderChild) {
                    folderChilds.add((IFolderChild)iEntity);
                    continue;
                }
                if (iEntity instanceof ILabel) {
                    labels.add((ILabel)iEntity);
                    continue;
                }
                if (iEntity instanceof ISearchFilter) {
                    filters.add((ISearchFilter)iEntity);
                    continue;
                }
                if (!(iEntity instanceof IPreference)) continue;
                preferences.add((IPreference)iEntity);
            }
        }
        ImportUtils.doImport(target, folderChilds, labels, filters, preferences, checkExistingFeeds);
    }

    public static void doImport(IFolder target, List<IFolderChild> elements, List<ILabel> labels, List<ISearchFilter> filters, List<IPreference> preferences, boolean checkExistingFeeds) {
        Map<Long, IFolderChild> mapOldIdToFolderChild = ImportUtils.createOldIdToEntityMap(elements);
        List<ISearchMark> locationConditionSavedSearches = ImportUtils.getLocationConditionSavedSearches(elements);
        IFeedDAO feedDao = (IFeedDAO)DynamicDAO.getDAO(IFeedDAO.class);
        ArrayList<URI> feedsCreated = new ArrayList<URI>();
        for (IFolderChild element : elements) {
            ImportUtils.saveFeedsOfBookmarks(feedsCreated, element, feedDao, checkExistingFeeds);
        }
        if (target == null) {
            ImportUtils.doDirectImport(elements, mapOldIdToFolderChild);
        } else {
            ImportUtils.doImportToTarget(target, elements, mapOldIdToFolderChild);
        }
        if (!locationConditionSavedSearches.isEmpty()) {
            ImportUtils.updateLocationConditions(mapOldIdToFolderChild, locationConditionSavedSearches);
            ((ISearchMarkDAO)DynamicDAO.getDAO(ISearchMarkDAO.class)).saveAll(locationConditionSavedSearches);
        }
        boolean fixLabelOrder = false;
        HashMap<String, ILabel> mapExistingLabelToName = new HashMap<String, ILabel>();
        HashMap<Long, ILabel> mapOldIdToImportedLabel = new HashMap<Long, ILabel>();
        if (labels != null && !labels.isEmpty()) {
            Collection existingLabels = DynamicDAO.loadAll(ILabel.class);
            for (ILabel existingLabel : existingLabels) {
                mapExistingLabelToName.put(existingLabel.getName(), existingLabel);
            }
            for (ILabel importedLabel : labels) {
                Object oldIdValue = importedLabel.getProperty("org.rssowl.core.interpreter.typeimporter.EntityId");
                if (oldIdValue == null || !(oldIdValue instanceof Long)) continue;
                mapOldIdToImportedLabel.put((Long)oldIdValue, importedLabel);
            }
            for (ILabel importedLabel : labels) {
                ILabel existingLabel = (ILabel)mapExistingLabelToName.get(importedLabel.getName());
                if (existingLabel != null) {
                    existingLabel.setColor(importedLabel.getColor());
                    if (existingLabel.getOrder() != importedLabel.getOrder()) {
                        fixLabelOrder = true;
                    }
                    existingLabel.setOrder(importedLabel.getOrder());
                    DynamicDAO.save((IPersistable)existingLabel);
                    continue;
                }
                importedLabel.removeProperty("org.rssowl.core.interpreter.typeimporter.EntityId");
                DynamicDAO.save((IPersistable)importedLabel);
                fixLabelOrder = true;
            }
            if (fixLabelOrder && !existingLabels.isEmpty()) {
                Set sortedLabels = CoreUtils.loadSortedLabels();
                int index = 0;
                for (ILabel label : sortedLabels) {
                    label.setOrder(index);
                    ++index;
                }
                DynamicDAO.saveAll((Collection)sortedLabels);
            }
        }
        if (filters != null && !filters.isEmpty()) {
            Object data;
            List actions;
            int existingFiltersCount = DynamicDAO.loadAll(ISearchFilter.class).size();
            List<ISearch> locationConditionSearches = ImportUtils.getLocationConditionSearchesFromFilters(filters);
            if (!locationConditionSearches.isEmpty()) {
                ImportUtils.updateLocationConditions(mapOldIdToFolderChild, locationConditionSearches);
            }
            for (ISearchFilter filter : filters) {
                actions = filter.getActions();
                for (IFilterAction action : actions) {
                    if (!"org.rssowl.core.MoveNewsAction".equals(action.getActionId()) && !"org.rssowl.core.CopyNewsAction".equals(action.getActionId()) || (data = action.getData()) == null || !(data instanceof Long[])) continue;
                    Long[] oldBinLocations = (Long[])data;
                    ArrayList<Long> newBinLocations = new ArrayList<Long>(oldBinLocations.length);
                    int i = 0;
                    while (i < oldBinLocations.length) {
                        Long oldLocation = oldBinLocations[i];
                        if (mapOldIdToFolderChild.containsKey(oldLocation)) {
                            IFolderChild location = mapOldIdToFolderChild.get(oldLocation);
                            newBinLocations.add(location.getId());
                        }
                        ++i;
                    }
                    action.setData((Object)newBinLocations.toArray(new Long[newBinLocations.size()]));
                }
            }
            for (ISearchFilter filter : filters) {
                actions = filter.getActions();
                for (IFilterAction action : actions) {
                    ILabel label;
                    if (!"org.rssowl.core.LabelNewsAction".equals(action.getActionId()) || (data = action.getData()) == null || !(data instanceof Long) || (label = (ILabel)mapOldIdToImportedLabel.get(data)) == null) continue;
                    String name = label.getName();
                    ILabel existingLabel = (ILabel)mapExistingLabelToName.get(name);
                    if (existingLabel != null) {
                        action.setData((Object)existingLabel.getId());
                        continue;
                    }
                    action.setData((Object)label.getId());
                }
            }
            for (ISearchFilter filter : filters) {
                filter.setOrder(filter.getOrder() + existingFiltersCount);
                if (!filter.isEnabled() || !CoreUtils.isOrphaned((ISearchFilter)filter)) continue;
                filter.setEnabled(false);
            }
            DynamicDAO.saveAll(filters);
        }
        if (preferences != null && !preferences.isEmpty()) {
            IPreferenceScope globalPreferences = Owl.getPreferenceService().getGlobalScope();
            IPreferenceScope eclipsePreferences = Owl.getPreferenceService().getEclipseScope();
            boolean flushEclipsePreferences = false;
            for (IPreference preference : preferences) {
                IPreferenceScope scope;
                Object data = preference.getProperty("org.rssowl.core.interpreter.typeimporter.DataId");
                if (data == null || !(data instanceof Object[]) || ((Object[])data).length != 2) continue;
                IPreferenceScope.Kind kind = (IPreferenceScope.Kind)((Object[])data)[0];
                IPreferenceType type = (IPreferenceType)((Object[])data)[1];
                IPreferenceScope iPreferenceScope = scope = kind == IPreferenceScope.Kind.GLOBAL ? globalPreferences : eclipsePreferences;
                if (kind == IPreferenceScope.Kind.ECLIPSE) {
                    flushEclipsePreferences = true;
                }
                switch (type) {
                    case BOOLEAN: {
                        scope.putBoolean(preference.getKey(), preference.getBoolean().booleanValue());
                        break;
                    }
                    case INTEGER: {
                        scope.putInteger(preference.getKey(), preference.getInteger().intValue());
                        break;
                    }
                    case INTEGERS: {
                        scope.putIntegers(preference.getKey(), preference.getIntegers());
                        break;
                    }
                    case LONG: {
                        scope.putLong(preference.getKey(), preference.getLong().longValue());
                        break;
                    }
                    case LONGS: {
                        scope.putLongs(preference.getKey(), preference.getLongs());
                        break;
                    }
                    case STRING: {
                        scope.putString(preference.getKey(), preference.getString());
                        break;
                    }
                    case STRINGS: {
                        scope.putStrings(preference.getKey(), preference.getStrings());
                    }
                }
            }
            if (flushEclipsePreferences) {
                eclipsePreferences.flush();
            }
        }
    }

    private static void saveFeedsOfBookmarks(List<URI> feedsCreated, IFolderChild element, IFeedDAO feedDao, boolean checkExistingFeeds) {
        if (element instanceof IBookMark) {
            IBookMark bm = (IBookMark)element;
            FeedLinkReference feedReference = bm.getFeedLinkReference();
            boolean feedExists = feedsCreated.contains(feedReference.getLink());
            if (!feedExists && checkExistingFeeds) {
                feedExists = feedDao.exists(feedReference.getLink());
            }
            if (!feedExists) {
                Object description;
                IFeed feed = Owl.getModelFactory().createFeed(null, feedReference.getLink());
                Object homepage = bm.getProperty("org.rssowl.core.interpreter.typeimporter.Homepage");
                if (homepage != null && homepage instanceof String) {
                    feed.setHomepage(URIUtils.createURI((String)((String)homepage)));
                }
                if ((description = bm.getProperty("org.rssowl.core.interpreter.typeimporter.Description")) != null && description instanceof String) {
                    feed.setDescription((String)description);
                }
                feedDao.save((IPersistable)feed);
                feedsCreated.add(feedReference.getLink());
            }
            bm.removeProperty("org.rssowl.core.interpreter.typeimporter.Description");
            bm.removeProperty("org.rssowl.core.interpreter.typeimporter.Homepage");
        } else if (element instanceof IFolder) {
            IFolder folder = (IFolder)element;
            List children = folder.getChildren();
            for (IFolderChild child : children) {
                ImportUtils.saveFeedsOfBookmarks(feedsCreated, child, feedDao, checkExistingFeeds);
            }
        }
    }

    private static void doDirectImport(List<IFolderChild> elements, Map<Long, IFolderChild> mapOldIdToFolderChild) {
        List<IFolder> foldersToSave = new ArrayList();
        Set rootFolders = CoreUtils.loadRootFolders();
        IFolder selectedSet = null;
        if (!rootFolders.isEmpty()) {
            selectedSet = !InternalOwl.TESTING && PlatformUI.isWorkbenchRunning() && Controller.getDefault().isStarted() ? OwlUI.getSelectedBookMarkSet() : (IFolder)rootFolders.iterator().next();
        }
        for (IFolderChild element : elements) {
            if (element instanceof IFolder) {
                IFolder folder = (IFolder)element;
                if (folder.getParent() == null) {
                    if (folder.getProperty("org.rssowl.core.interpreter.typeimporter.TemporaryFolder") != null && selectedSet != null) {
                        ImportUtils.reparent(folder, selectedSet);
                        foldersToSave.add(selectedSet);
                        if (folder.getProperty("org.rssowl.core.interpreter.typeimporter.EntityId") == null) continue;
                        mapOldIdToFolderChild.put((Long)folder.getProperty("org.rssowl.core.interpreter.typeimporter.EntityId"), (IFolderChild)selectedSet);
                        continue;
                    }
                    IFolder existingSetFolder = null;
                    for (IFolder rootFolder : rootFolders) {
                        if (!rootFolder.getName().equals(folder.getName())) continue;
                        existingSetFolder = rootFolder;
                        break;
                    }
                    if (existingSetFolder != null) {
                        ImportUtils.reparent(folder, existingSetFolder);
                        foldersToSave.add(existingSetFolder);
                        if (folder.getProperty("org.rssowl.core.interpreter.typeimporter.EntityId") == null) continue;
                        mapOldIdToFolderChild.put((Long)folder.getProperty("org.rssowl.core.interpreter.typeimporter.EntityId"), (IFolderChild)existingSetFolder);
                        continue;
                    }
                    foldersToSave.add(folder);
                    continue;
                }
                if (selectedSet == null) continue;
                folder.setParent(selectedSet);
                selectedSet.addFolder(folder, null, null);
                foldersToSave.add(selectedSet);
                continue;
            }
            if (!(element instanceof INewsMark) || selectedSet == null) continue;
            INewsMark mark = (INewsMark)element;
            mark.setParent(selectedSet);
            selectedSet.addMark((IMark)mark, null, null);
            foldersToSave.add(selectedSet);
        }
        foldersToSave = CoreUtils.removeIdentityDuplicates(foldersToSave);
        for (IFolder folderToSave : foldersToSave) {
            ImportUtils.unsetIdProperty((IEntity)folderToSave);
        }
        DynamicDAO.saveAll(foldersToSave);
    }

    private static void doImportToTarget(IFolder target, List<IFolderChild> elements, Map<Long, IFolderChild> mapOldIdToFolderChild) {
        List<IFolder> foldersToSave = new ArrayList();
        for (IFolderChild element : elements) {
            if (element instanceof IFolder) {
                IFolder folder = (IFolder)element;
                if (folder.getParent() == null) {
                    if (folder.getProperty("org.rssowl.core.interpreter.typeimporter.TemporaryFolder") != null) {
                        ImportUtils.reparent(folder, target);
                        foldersToSave.add(target);
                        if (folder.getProperty("org.rssowl.core.interpreter.typeimporter.EntityId") == null) continue;
                        mapOldIdToFolderChild.put((Long)folder.getProperty("org.rssowl.core.interpreter.typeimporter.EntityId"), (IFolderChild)target);
                        continue;
                    }
                    folder.setParent(target);
                    target.addFolder(folder, null, null);
                    foldersToSave.add(target);
                    continue;
                }
                folder.setParent(target);
                target.addFolder(folder, null, null);
                foldersToSave.add(target);
                continue;
            }
            if (!(element instanceof INewsMark)) continue;
            INewsMark mark = (INewsMark)element;
            mark.setParent(target);
            target.addMark((IMark)mark, null, null);
            foldersToSave.add(target);
        }
        foldersToSave = CoreUtils.removeIdentityDuplicates(foldersToSave);
        for (IFolder folderToSave : foldersToSave) {
            ImportUtils.unsetIdProperty((IEntity)folderToSave);
        }
        DynamicDAO.saveAll(foldersToSave);
    }

    private static void reparent(IFolder from, IFolder to) {
        List children = from.getChildren();
        for (IFolderChild child : children) {
            if (child instanceof IFolder) {
                IFolder folder = (IFolder)child;
                folder.setParent(to);
                to.addFolder(folder, null, null);
                continue;
            }
            if (!(child instanceof IMark)) continue;
            IMark mark = (IMark)child;
            mark.setParent(to);
            to.addMark(mark, null, null);
        }
    }

    private static void updateLocationConditions(Map<Long, IFolderChild> oldIdToFolderChildMap, List<? extends ISearch> searches) {
        for (ISearch iSearch : searches) {
            List conditions = iSearch.getSearchConditions();
            for (ISearchCondition condition : conditions) {
                Long id;
                if (condition.getField().getId() != 19 || condition.getValue() == null) continue;
                Long[][] value = (Long[][])condition.getValue();
                ArrayList<IFolderChild> newLocations = new ArrayList<IFolderChild>();
                int i = 0;
                while (value[0] != null && i < value[0].length) {
                    if (value[0][i] != null && value[0][i] != 0L && oldIdToFolderChildMap.containsKey(id = value[0][i])) {
                        newLocations.add(oldIdToFolderChildMap.get(id));
                    }
                    ++i;
                }
                i = 0;
                while (value[1] != null && i < value[1].length) {
                    if (value[1][i] != null && value[1][i] != 0L && oldIdToFolderChildMap.containsKey(id = value[1][i])) {
                        newLocations.add(oldIdToFolderChildMap.get(id));
                    }
                    ++i;
                }
                if (value.length == 3) {
                    i = 0;
                    while (value[2] != null && i < value[2].length) {
                        if (value[2][i] != null && value[2][i] != 0L && oldIdToFolderChildMap.containsKey(id = value[2][i])) {
                            newLocations.add(oldIdToFolderChildMap.get(id));
                        }
                        ++i;
                    }
                }
                condition.setValue((Object)ModelUtils.toPrimitive(newLocations));
            }
        }
    }

    private static void unsetIdProperty(IEntity entity) {
        entity.removeProperty("org.rssowl.core.interpreter.typeimporter.EntityId");
        if (entity instanceof IFolder) {
            IFolder folder = (IFolder)entity;
            List children = folder.getChildren();
            for (IFolderChild child : children) {
                ImportUtils.unsetIdProperty((IEntity)child);
            }
        }
    }

    private static List<ISearchMark> getLocationConditionSavedSearches(List<? extends IEntity> types) {
        ArrayList<ISearchMark> locationConditionSavedSearches = new ArrayList<ISearchMark>();
        for (IEntity iEntity : types) {
            ImportUtils.fillLocationConditionSavedSearches(locationConditionSavedSearches, iEntity);
        }
        return locationConditionSavedSearches;
    }

    private static List<ISearch> getLocationConditionSearchesFromFilters(List<ISearchFilter> filters) {
        ArrayList<ISearch> locationConditionSearches = new ArrayList<ISearch>();
        for (ISearchFilter filter : filters) {
            ISearch search = filter.getSearch();
            if (search == null || !ImportUtils.containsLocationCondition(search)) continue;
            locationConditionSearches.add(search);
        }
        return locationConditionSearches;
    }

    private static void fillLocationConditionSavedSearches(List<ISearchMark> searchmarks, IEntity entity) {
        if (entity instanceof ISearchMark && ImportUtils.containsLocationCondition((ISearch)((ISearchMark)entity))) {
            searchmarks.add((ISearchMark)entity);
        } else if (entity instanceof IFolder) {
            IFolder folder = (IFolder)entity;
            List children = folder.getChildren();
            for (IFolderChild child : children) {
                ImportUtils.fillLocationConditionSavedSearches(searchmarks, (IEntity)child);
            }
        }
    }

    private static boolean containsLocationCondition(ISearch search) {
        List searchConditions = search.getSearchConditions();
        for (ISearchCondition condition : searchConditions) {
            if (condition.getField().getId() != 19) continue;
            return true;
        }
        return false;
    }

    private static Map<Long, IFolderChild> createOldIdToEntityMap(List<? extends IEntity> types) {
        HashMap<Long, IFolderChild> oldIdToEntityMap = new HashMap<Long, IFolderChild>();
        for (IEntity iEntity : types) {
            if (!(iEntity instanceof IFolderChild)) continue;
            ImportUtils.fillOldIdToEntityMap(oldIdToEntityMap, (IFolderChild)iEntity);
        }
        return oldIdToEntityMap;
    }

    private static void fillOldIdToEntityMap(Map<Long, IFolderChild> oldIdToEntityMap, IFolderChild folderChild) {
        Long oldId = (Long)folderChild.getProperty("org.rssowl.core.interpreter.typeimporter.EntityId");
        if (oldId != null) {
            oldIdToEntityMap.put(oldId, folderChild);
        }
        if (folderChild instanceof IFolder) {
            IFolder folder = (IFolder)folderChild;
            List children = folder.getChildren();
            for (IFolderChild child : children) {
                ImportUtils.fillOldIdToEntityMap(oldIdToEntityMap, child);
            }
        }
    }
}

