/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.util;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Shell;

public class LayoutUtils {
    public static FillLayout createFillLayout(boolean horizontal, int marginWidth, int marginHeight) {
        FillLayout f = new FillLayout(horizontal ? 256 : 512);
        f.marginHeight = marginHeight;
        f.marginWidth = marginWidth;
        return f;
    }

    public static GridLayout createGridLayout(int cols) {
        return LayoutUtils.createGridLayout(cols, 5, 5, 5, 5, false);
    }

    public static GridLayout createGridLayout(int cols, int marginWidth) {
        return LayoutUtils.createGridLayout(cols, marginWidth, 5, 5, 5, false);
    }

    public static GridLayout createGridLayout(int cols, int marginWidth, int marginHeight) {
        return LayoutUtils.createGridLayout(cols, marginWidth, marginHeight, 5, 5, false);
    }

    public static GridLayout createGridLayout(int cols, int marginWidth, int marginHeight, boolean makeColumnsEqualWidth) {
        return LayoutUtils.createGridLayout(cols, marginWidth, marginHeight, 5, 5, makeColumnsEqualWidth);
    }

    public static GridLayout createGridLayout(int cols, int marginWidth, int marginHeight, int verticalSpacing) {
        return LayoutUtils.createGridLayout(cols, marginWidth, marginHeight, verticalSpacing, 5, false);
    }

    public static GridLayout createGridLayout(int cols, int marginWidth, int marginHeight, int verticalSpacing, int horizontalSpacing, boolean makeColumnsEqualWidth) {
        GridLayout g = new GridLayout(cols, makeColumnsEqualWidth);
        g.marginHeight = marginHeight;
        g.marginWidth = marginWidth;
        g.verticalSpacing = verticalSpacing;
        g.horizontalSpacing = horizontalSpacing;
        return g;
    }

    public static void positionShell(Shell shell) {
        Rectangle containerBounds = shell.getParent().getBounds();
        Point initialSize = shell.getSize();
        int x = Math.max(0, containerBounds.x + (containerBounds.width - initialSize.x) / 2);
        int y = Math.max(0, containerBounds.y + (containerBounds.height - initialSize.y) / 3);
        shell.setLocation(x, y);
    }
}

