/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.ext.StoredClass;
import com.db4o.foundation.ArrayIterator4;
import com.db4o.foundation.Collection4;
import com.db4o.foundation.Hashtable4;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.MappingIterator;
import com.db4o.foundation.Queue4;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.Buffer;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.ClassMetadataIterator;
import com.db4o.internal.FieldMetadata;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.PendingClassInits;
import com.db4o.internal.PersistentBase;
import com.db4o.internal.ReaderPair;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.SystemData;
import com.db4o.internal.Transaction;
import com.db4o.reflect.ReflectClass;

public final class ClassMetadataRepository
extends PersistentBase {
    private Collection4 i_classes;
    private Hashtable4 i_creating;
    private final Transaction _systemTransaction;
    private Hashtable4 i_yapClassByBytes;
    private Hashtable4 i_yapClassByClass;
    private Hashtable4 i_yapClassByID;
    private int i_yapClassCreationDepth;
    private Queue4 i_initYapClassesOnUp;
    private final PendingClassInits _classInits;

    ClassMetadataRepository(Transaction transaction) {
        this._systemTransaction = transaction;
        this.i_initYapClassesOnUp = new Queue4();
        this._classInits = new PendingClassInits(this._systemTransaction);
    }

    public void addYapClass(ClassMetadata classMetadata) {
        this.stream().setDirtyInSystemTransaction(this);
        this.i_classes.add(classMetadata);
        if (classMetadata.stateUnread()) {
            this.i_yapClassByBytes.put(classMetadata.i_nameBytes, (Object)classMetadata);
        } else {
            this.i_yapClassByClass.put(classMetadata.classReflector(), (Object)classMetadata);
        }
        if (classMetadata.getID() == 0) {
            classMetadata.write(this._systemTransaction);
        }
        this.i_yapClassByID.put(classMetadata.getID(), (Object)classMetadata);
    }

    private byte[] asBytes(String string) {
        return this.stream().stringIO().write(string);
    }

    public void attachQueryNode(final String string, final Visitor4 visitor4) {
        ClassMetadataIterator classMetadataIterator = this.iterator();
        while (classMetadataIterator.moveNext()) {
            final ClassMetadata classMetadata = classMetadataIterator.currentClass();
            if (classMetadata.isInternal()) continue;
            classMetadata.forEachYapField(new Visitor4(){

                public void visit(Object object) {
                    FieldMetadata fieldMetadata = (FieldMetadata)object;
                    if (fieldMetadata.canAddToQuery(string)) {
                        visitor4.visit(new Object[]{classMetadata, fieldMetadata});
                    }
                }
            });
        }
    }

    void checkChanges() {
        Iterator4 iterator4 = this.i_classes.iterator();
        while (iterator4.moveNext()) {
            ((ClassMetadata)iterator4.current()).checkChanges();
        }
    }

    final boolean createYapClass(ClassMetadata classMetadata, ReflectClass reflectClass) {
        ++this.i_yapClassCreationDepth;
        ReflectClass reflectClass2 = reflectClass.getSuperclass();
        ClassMetadata classMetadata2 = null;
        if (reflectClass2 != null && !reflectClass2.equals(this.stream().i_handlers.ICLASS_OBJECT)) {
            classMetadata2 = this.produceYapClass(reflectClass2);
        }
        boolean bl = this.stream().createYapClass(classMetadata, reflectClass, classMetadata2);
        --this.i_yapClassCreationDepth;
        this.initYapClassesOnUp();
        return bl;
    }

    public static void defrag(ReaderPair readerPair) {
        int n = readerPair.readInt();
        for (int i = 0; i < n; ++i) {
            readerPair.copyID();
        }
    }

    private void ensureAllClassesRead() {
        boolean bl = false;
        while (!bl) {
            Object object;
            Collection4 collection4 = new Collection4();
            int n = this.i_classes.size();
            Iterator4 iterator4 = this.i_classes.iterator();
            while (iterator4.moveNext()) {
                object = (ClassMetadata)iterator4.current();
                if (!((ClassMetadata)object).stateUnread()) continue;
                collection4.add(object);
            }
            object = collection4.iterator();
            while (object.moveNext()) {
                ClassMetadata classMetadata = (ClassMetadata)object.current();
                this.readYapClass(classMetadata, null);
                if (classMetadata.classReflector() != null) continue;
                classMetadata.forceRead();
            }
            bl = this.i_classes.size() == n;
        }
        this.applyReadAs();
    }

    boolean fieldExists(String string) {
        ClassMetadataIterator classMetadataIterator = this.iterator();
        while (classMetadataIterator.moveNext()) {
            if (classMetadataIterator.currentClass().getYapField(string) == null) continue;
            return true;
        }
        return false;
    }

    public Collection4 forInterface(ReflectClass reflectClass) {
        Collection4 collection4 = new Collection4();
        ClassMetadataIterator classMetadataIterator = this.iterator();
        while (classMetadataIterator.moveNext()) {
            ClassMetadata classMetadata = classMetadataIterator.currentClass();
            ReflectClass reflectClass2 = classMetadata.classReflector();
            if (reflectClass2.isInterface() || !reflectClass.isAssignableFrom(reflectClass2)) continue;
            collection4.add(classMetadata);
            Iterator4 iterator4 = new Collection4(collection4).iterator();
            while (iterator4.moveNext()) {
                ClassMetadata classMetadata2;
                ClassMetadata classMetadata3 = (ClassMetadata)iterator4.current();
                if (classMetadata3 == classMetadata || (classMetadata2 = classMetadata.getHigherHierarchy(classMetadata3)) == null) continue;
                if (classMetadata2 == classMetadata) {
                    collection4.remove(classMetadata3);
                    continue;
                }
                collection4.remove(classMetadata);
            }
        }
        return collection4;
    }

    public byte getIdentifier() {
        return 65;
    }

    ClassMetadata getActiveYapClass(ReflectClass reflectClass) {
        return (ClassMetadata)this.i_yapClassByClass.get(reflectClass);
    }

    ClassMetadata getYapClass(ReflectClass reflectClass) {
        ClassMetadata classMetadata = (ClassMetadata)this.i_yapClassByClass.get(reflectClass);
        if (classMetadata != null) {
            return classMetadata;
        }
        classMetadata = (ClassMetadata)this.i_yapClassByBytes.remove(this.getNameBytes(reflectClass.getName()));
        this.readYapClass(classMetadata, reflectClass);
        return classMetadata;
    }

    ClassMetadata produceYapClass(ReflectClass reflectClass) {
        int n;
        ClassMetadata classMetadata = this.getYapClass(reflectClass);
        if (classMetadata != null) {
            return classMetadata;
        }
        classMetadata = (ClassMetadata)this.i_creating.get(reflectClass);
        if (classMetadata != null) {
            return classMetadata;
        }
        classMetadata = new ClassMetadata(this.stream(), reflectClass);
        this.i_creating.put(reflectClass, (Object)classMetadata);
        if (!this.createYapClass(classMetadata, reflectClass)) {
            this.i_creating.remove(reflectClass);
            return null;
        }
        boolean bl = false;
        if (this.i_yapClassByClass.get(reflectClass) == null) {
            this.addYapClass(classMetadata);
            bl = true;
        }
        if ((n = classMetadata.getID()) == 0) {
            classMetadata.write(this.stream().getSystemTransaction());
            n = classMetadata.getID();
        }
        if (this.i_yapClassByID.get(n) == null) {
            this.i_yapClassByID.put(n, (Object)classMetadata);
            bl = true;
        }
        if (bl || classMetadata.i_fields == null) {
            this._classInits.process(classMetadata);
        }
        this.i_creating.remove(reflectClass);
        this.stream().setDirtyInSystemTransaction(this);
        return classMetadata;
    }

    ClassMetadata getYapClass(int n) {
        return this.readYapClass((ClassMetadata)this.i_yapClassByID.get(n), null);
    }

    public ClassMetadata getYapClass(String string) {
        ClassMetadata classMetadata = (ClassMetadata)this.i_yapClassByBytes.remove(this.getNameBytes(string));
        this.readYapClass(classMetadata, null);
        if (classMetadata == null) {
            ClassMetadataIterator classMetadataIterator = this.iterator();
            while (classMetadataIterator.moveNext()) {
                classMetadata = (ClassMetadata)classMetadataIterator.current();
                if (!string.equals(classMetadata.getName())) continue;
                this.readYapClass(classMetadata, null);
                return classMetadata;
            }
            return null;
        }
        return classMetadata;
    }

    public int getYapClassID(String string) {
        ClassMetadata classMetadata = (ClassMetadata)this.i_yapClassByBytes.get(this.getNameBytes(string));
        if (classMetadata != null) {
            return classMetadata.getID();
        }
        return 0;
    }

    byte[] getNameBytes(String string) {
        return this.asBytes(this.resolveAliasRuntimeName(string));
    }

    private String resolveAliasRuntimeName(String string) {
        return this.stream().configImpl().resolveAliasRuntimeName(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initOnUp(Transaction transaction) {
        ++this.i_yapClassCreationDepth;
        transaction.stream().showInternalClasses(true);
        try {
            Iterator4 iterator4 = this.i_classes.iterator();
            while (iterator4.moveNext()) {
                ((ClassMetadata)iterator4.current()).initOnUp(transaction);
            }
        }
        finally {
            transaction.stream().showInternalClasses(false);
        }
        --this.i_yapClassCreationDepth;
        this.initYapClassesOnUp();
    }

    void initTables(int n) {
        this.i_classes = new Collection4();
        this.i_yapClassByBytes = new Hashtable4(n);
        if (n < 16) {
            n = 16;
        }
        this.i_yapClassByClass = new Hashtable4(n);
        this.i_yapClassByID = new Hashtable4(n);
        this.i_creating = new Hashtable4(1);
    }

    private void initYapClassesOnUp() {
        if (this.i_yapClassCreationDepth == 0) {
            ClassMetadata classMetadata = (ClassMetadata)this.i_initYapClassesOnUp.next();
            while (classMetadata != null) {
                classMetadata.initOnUp(this._systemTransaction);
                classMetadata = (ClassMetadata)this.i_initYapClassesOnUp.next();
            }
        }
    }

    public ClassMetadataIterator iterator() {
        return new ClassMetadataIterator(this, new ArrayIterator4(this.i_classes.toArray()));
    }

    public Iterator4 ids() {
        return new ClassIDIterator(this.i_classes);
    }

    public int ownLength() {
        return 4 + this.i_classes.size() * 4;
    }

    void purge() {
        Iterator4 iterator4 = this.i_classes.iterator();
        while (iterator4.moveNext()) {
            ((ClassMetadata)iterator4.current()).purge();
        }
    }

    public final void readThis(Transaction transaction, Buffer buffer) {
        int n = buffer.readInt();
        this.initTables(n);
        ObjectContainerBase objectContainerBase = this.stream();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = buffer.readInt();
        }
        StatefulBuffer[] statefulBufferArray = objectContainerBase.readWritersByIDs(transaction, nArray);
        for (int i = 0; i < n; ++i) {
            ClassMetadata classMetadata = new ClassMetadata(objectContainerBase, null);
            classMetadata.setID(nArray[i]);
            this.i_classes.add(classMetadata);
            this.i_yapClassByID.put(nArray[i], (Object)classMetadata);
            byte[] byArray = classMetadata.readName1(transaction, statefulBufferArray[i]);
            this.i_yapClassByBytes.put(byArray, (Object)classMetadata);
        }
        this.applyReadAs();
    }

    Hashtable4 classByBytes() {
        return this.i_yapClassByBytes;
    }

    private void applyReadAs() {
        final Hashtable4 hashtable4 = this.stream().configImpl().readAs();
        hashtable4.forEachKey(new Visitor4(){

            public void visit(Object object) {
                ClassMetadata classMetadata;
                String string = (String)object;
                byte[] byArray = ClassMetadataRepository.this.getNameBytes(string);
                String string2 = (String)hashtable4.get(string);
                byte[] byArray2 = ClassMetadataRepository.this.getNameBytes(string2);
                if (ClassMetadataRepository.this.classByBytes().get(byArray2) == null && (classMetadata = (ClassMetadata)ClassMetadataRepository.this.classByBytes().get(byArray)) != null) {
                    classMetadata.i_nameBytes = byArray2;
                    classMetadata.setConfig(ClassMetadataRepository.this.stream().configImpl().configClass(string));
                    ClassMetadataRepository.this.classByBytes().put(byArray, (Object)null);
                    ClassMetadataRepository.this.classByBytes().put(byArray2, (Object)classMetadata);
                }
            }
        });
    }

    public ClassMetadata readYapClass(ClassMetadata classMetadata, ReflectClass reflectClass) {
        if (classMetadata == null) {
            return null;
        }
        if (!classMetadata.stateUnread()) {
            return classMetadata;
        }
        ++this.i_yapClassCreationDepth;
        classMetadata.createConfigAndConstructor(this.i_yapClassByBytes, this.stream(), reflectClass);
        ReflectClass reflectClass2 = classMetadata.classReflector();
        if (reflectClass2 != null) {
            this.i_yapClassByClass.put(reflectClass2, (Object)classMetadata);
            classMetadata.readThis();
            classMetadata.checkChanges();
            this.i_initYapClassesOnUp.add(classMetadata);
        }
        --this.i_yapClassCreationDepth;
        this.initYapClassesOnUp();
        return classMetadata;
    }

    public void refreshClasses() {
        ClassMetadata classMetadata;
        ClassMetadataRepository classMetadataRepository = new ClassMetadataRepository(this._systemTransaction);
        classMetadataRepository.i_id = this.i_id;
        classMetadataRepository.read(this.stream().getSystemTransaction());
        Iterator4 iterator4 = classMetadataRepository.i_classes.iterator();
        while (iterator4.moveNext()) {
            classMetadata = (ClassMetadata)iterator4.current();
            if (this.i_yapClassByID.get(classMetadata.getID()) != null) continue;
            this.i_classes.add(classMetadata);
            this.i_yapClassByID.put(classMetadata.getID(), (Object)classMetadata);
            if (classMetadata.stateUnread()) {
                this.i_yapClassByBytes.put(classMetadata.readName(this._systemTransaction), (Object)classMetadata);
                continue;
            }
            this.i_yapClassByClass.put(classMetadata.classReflector(), (Object)classMetadata);
        }
        iterator4 = this.i_classes.iterator();
        while (iterator4.moveNext()) {
            classMetadata = (ClassMetadata)iterator4.current();
            classMetadata.refresh();
        }
    }

    void reReadYapClass(ClassMetadata classMetadata) {
        if (classMetadata != null) {
            this.reReadYapClass(classMetadata.i_ancestor);
            classMetadata.readName(this._systemTransaction);
            classMetadata.forceRead();
            classMetadata.setStateClean();
            classMetadata.bitFalse(6);
            classMetadata.bitFalse(8);
            classMetadata.bitFalse(4);
            classMetadata.bitFalse(7);
            classMetadata.checkChanges();
        }
    }

    public StoredClass[] storedClasses() {
        this.ensureAllClassesRead();
        Object[] objectArray = new StoredClass[this.i_classes.size()];
        this.i_classes.toArray(objectArray);
        return objectArray;
    }

    public void writeAllClasses() {
        ClassMetadata classMetadata;
        int n;
        StoredClass[] storedClassArray = this.storedClasses();
        for (n = 0; n < storedClassArray.length; ++n) {
            classMetadata = (ClassMetadata)storedClassArray[n];
            classMetadata.setStateDirty();
        }
        for (n = 0; n < storedClassArray.length; ++n) {
            classMetadata = (ClassMetadata)storedClassArray[n];
            classMetadata.write(this._systemTransaction);
        }
    }

    public void writeThis(Transaction transaction, Buffer buffer) {
        buffer.writeInt(this.i_classes.size());
        Iterator4 iterator4 = this.i_classes.iterator();
        while (iterator4.moveNext()) {
            buffer.writeIDOf(transaction, iterator4.current());
        }
    }

    public String toString() {
        return super.toString();
    }

    ObjectContainerBase stream() {
        return this._systemTransaction.stream();
    }

    public void setID(int n) {
        if (this.stream().isClient()) {
            super.setID(n);
            return;
        }
        if (this.i_id == 0) {
            this.systemData().classCollectionID(n);
        }
        super.setID(n);
    }

    private SystemData systemData() {
        return this._systemTransaction.i_file.systemData();
    }

    private static class ClassIDIterator
    extends MappingIterator {
        public ClassIDIterator(Collection4 collection4) {
            super(collection4.iterator());
        }

        protected Object map(Object object) {
            return new Integer(((ClassMetadata)object).getID());
        }
    }
}

