/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.config.Configuration;
import com.db4o.config.QueryEvaluationMode;
import com.db4o.ext.Db4oDatabase;
import com.db4o.ext.SystemInfo;
import com.db4o.foundation.Collection4;
import com.db4o.foundation.Hashtable4;
import com.db4o.foundation.IntArrayList;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.Tree;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.Buffer;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.Const4;
import com.db4o.internal.Exceptions4;
import com.db4o.internal.IDHandler;
import com.db4o.internal.LocalTransaction;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.ObjectReference;
import com.db4o.internal.PersistentBase;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.SystemData;
import com.db4o.internal.SystemInfoFileImpl;
import com.db4o.internal.Transaction;
import com.db4o.internal.TreeInt;
import com.db4o.internal.TreeIntObject;
import com.db4o.internal.btree.BTree;
import com.db4o.internal.convert.ConversionStage;
import com.db4o.internal.convert.Converter;
import com.db4o.internal.fileheader.FileHeader;
import com.db4o.internal.fileheader.FileHeader1;
import com.db4o.internal.freespace.FreespaceManager;
import com.db4o.internal.query.processor.QQuery;
import com.db4o.internal.query.result.AbstractQueryResult;
import com.db4o.internal.query.result.HybridQueryResult;
import com.db4o.internal.query.result.IdListQueryResult;
import com.db4o.internal.query.result.QueryResult;
import com.db4o.internal.slots.Pointer4;
import com.db4o.internal.slots.ReferencedSlot;
import com.db4o.internal.slots.Slot;
import java.io.IOException;

public abstract class LocalObjectContainer
extends ObjectContainerBase {
    protected FileHeader _fileHeader;
    private Collection4 i_dirty;
    private FreespaceManager _freespaceManager;
    private FreespaceManager _fmChecker;
    private boolean i_isServer = false;
    private Tree i_prefetchedIDs;
    private Hashtable4 i_semaphores;
    private int _blockEndAddress;
    private Tree _freeOnCommit;
    private SystemData _systemData;

    LocalObjectContainer(Configuration configuration, ObjectContainerBase objectContainerBase) {
        super(configuration, objectContainerBase);
    }

    public Transaction newTransaction(Transaction transaction) {
        return new LocalTransaction(this, transaction);
    }

    public FreespaceManager freespaceManager() {
        return this._freespaceManager;
    }

    public abstract void blockSize(int var1);

    public void blockSizeReadFromFile(int n) {
        this.blockSize(n);
        this.setRegularEndAddress(this.fileLength());
    }

    public void setRegularEndAddress(long l) {
        this._blockEndAddress = this.blocksFor(l);
    }

    protected boolean close2() {
        boolean bl = super.close2();
        this.i_dirty = null;
        return bl;
    }

    public void commit1() {
        try {
            this.write(false);
        }
        catch (Throwable throwable) {
            this.fatalException(throwable);
        }
    }

    void configureNewFile() throws IOException {
        this.newSystemData(this.configImpl().freespaceSystem());
        this.systemData().converterVersion(6);
        this.createStringIO(this._systemData.stringEncoding());
        this.generateNewIdentity();
        this._freespaceManager = FreespaceManager.createNew(this);
        this.blockSize(this.configImpl().blockSize());
        this._fileHeader = new FileHeader1();
        this.setRegularEndAddress(this._fileHeader.length());
        this.initNewClassCollection();
        this.initializeEssentialClasses();
        this._fileHeader.initNew(this);
        this._freespaceManager.onNew(this);
        this._freespaceManager.start(this._systemData.freespaceAddress());
    }

    private void newSystemData(byte by) {
        this._systemData = new SystemData();
        this._systemData.stringEncoding(this.configImpl().encoding());
        this._systemData.freespaceSystem(by);
    }

    public int converterVersion() {
        return this._systemData.converterVersion();
    }

    public abstract void copy(int var1, int var2, int var3, int var4, int var5);

    public long currentVersion() {
        return this._timeStampIdGenerator.lastTimeStampId();
    }

    void initNewClassCollection() {
        this.classCollection().initTables(1);
    }

    public final BTree createBTreeClassIndex(int n) {
        return new BTree(this.i_trans, n, new IDHandler(this));
    }

    public final AbstractQueryResult newQueryResult(Transaction transaction) {
        return this.newQueryResult(transaction, this.config().queryEvaluationMode());
    }

    public final AbstractQueryResult newQueryResult(Transaction transaction, QueryEvaluationMode queryEvaluationMode) {
        if (queryEvaluationMode == QueryEvaluationMode.IMMEDIATE) {
            return new IdListQueryResult(transaction);
        }
        return new HybridQueryResult(transaction, queryEvaluationMode);
    }

    public final boolean delete4(Transaction transaction, ObjectReference objectReference, int n, boolean bl) {
        int n2 = objectReference.getID();
        StatefulBuffer statefulBuffer = this.readWriterByID(transaction, n2);
        if (statefulBuffer != null) {
            Object object = objectReference.getObject();
            if (object != null && !this.showInternalClasses() && Const4.CLASS_INTERNAL.isAssignableFrom(object.getClass())) {
                return false;
            }
            statefulBuffer.setCascadeDeletes(n);
            statefulBuffer.slotDelete();
            ClassMetadata classMetadata = objectReference.getYapClass();
            classMetadata.delete(statefulBuffer, object);
            return true;
        }
        return false;
    }

    public abstract long fileLength();

    public abstract String fileName();

    public void free(Slot slot) {
        if (slot == null) {
            return;
        }
        if (slot._address == 0) {
            return;
        }
        this.free(slot._address, slot._length);
    }

    public void free(int n, int n2) {
        if (this._freespaceManager == null) {
            return;
        }
        this._freespaceManager.free(n, n2);
    }

    final void freePrefetchedPointers() {
        if (this.i_prefetchedIDs != null) {
            this.i_prefetchedIDs.traverse(new Visitor4(){

                public void visit(Object object) {
                    LocalObjectContainer.this.free(((TreeInt)object)._key, 8);
                }
            });
        }
        this.i_prefetchedIDs = null;
    }

    final void freeSpaceBeginCommit() {
        if (this._freespaceManager == null) {
            return;
        }
        this._freespaceManager.beginCommit();
    }

    final void freeSpaceEndCommit() {
        if (this._freespaceManager == null) {
            return;
        }
        this._freespaceManager.endCommit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateNewIdentity() {
        Object object = this.i_lock;
        synchronized (object) {
            this.setIdentity(Db4oDatabase.generate());
        }
    }

    public AbstractQueryResult getAll(Transaction transaction) {
        return this.getAll(transaction, this.config().queryEvaluationMode());
    }

    public AbstractQueryResult getAll(Transaction transaction, QueryEvaluationMode queryEvaluationMode) {
        AbstractQueryResult abstractQueryResult = this.newQueryResult(transaction, queryEvaluationMode);
        abstractQueryResult.loadFromClassIndexes(this.classCollection().iterator());
        return abstractQueryResult;
    }

    final int getPointerSlot() {
        int n = this.getSlot(8);
        this.i_systemTrans.writePointer(n, 0, 0);
        if (this.i_handlers.isSystemHandler(n)) {
            return this.getPointerSlot();
        }
        return n;
    }

    public int getSlot(int n) {
        return this.getSlot1(n);
    }

    private final int getSlot1(int n) {
        int n2;
        if (this._freespaceManager != null && (n2 = this._freespaceManager.getSlot(n)) > 0) {
            return n2;
        }
        n2 = this.blocksFor(n);
        return this.appendBlocks(n2);
    }

    protected int appendBlocks(int n) {
        int n2 = this._blockEndAddress;
        int n3 = this._blockEndAddress + n;
        this.checkBlockedAddress(n3);
        this._blockEndAddress = n3;
        return n2;
    }

    private void checkBlockedAddress(int n) {
        if (n < 0) {
            this.rollback1();
            this.switchToReadOnlyMode();
            Exceptions4.throwRuntimeException(69);
        }
    }

    private void switchToReadOnlyMode() {
        this.i_config.readOnly(true);
    }

    void ensureLastSlotWritten() {
        if (this._blockEndAddress > this.blocksFor(this.fileLength())) {
            StatefulBuffer statefulBuffer = this.getWriter(this.i_systemTrans, this._blockEndAddress - 1, this.blockSize());
            statefulBuffer.write();
        }
    }

    public Db4oDatabase identity() {
        return this._systemData.identity();
    }

    public void setIdentity(Db4oDatabase db4oDatabase) {
        this._systemData.identity(db4oDatabase);
        this._timeStampIdGenerator.next();
    }

    void initialize2() {
        this.i_dirty = new Collection4();
        super.initialize2();
    }

    boolean isServer() {
        return this.i_isServer;
    }

    public final Pointer4 newSlot(Transaction transaction, int n) {
        int n2 = this.getPointerSlot();
        int n3 = this.getSlot(n);
        transaction.setPointer(n2, n3, n);
        return new Pointer4(n2, n3);
    }

    public final int newUserObject() {
        return this.getPointerSlot();
    }

    public void prefetchedIDConsumed(int n) {
        this.i_prefetchedIDs = this.i_prefetchedIDs.removeLike(new TreeIntObject(n));
    }

    public int prefetchID() {
        int n = this.getPointerSlot();
        this.i_prefetchedIDs = Tree.add(this.i_prefetchedIDs, new TreeInt(n));
        return n;
    }

    public ReferencedSlot produceFreeOnCommitEntry(int n) {
        TreeInt treeInt = TreeInt.find(this._freeOnCommit, n);
        if (treeInt != null) {
            return (ReferencedSlot)treeInt;
        }
        ReferencedSlot referencedSlot = new ReferencedSlot(n);
        this._freeOnCommit = Tree.add(this._freeOnCommit, referencedSlot);
        return referencedSlot;
    }

    public void reduceFreeOnCommitReferences(ReferencedSlot referencedSlot) {
        if (referencedSlot.removeReferenceIsLast()) {
            this._freeOnCommit = this._freeOnCommit.removeNode(referencedSlot);
        }
    }

    public void freeDuringCommit(ReferencedSlot referencedSlot, Slot slot) {
        this._freeOnCommit = referencedSlot.free(this, this._freeOnCommit, slot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void raiseVersion(long l) {
        Object object = this.lock();
        synchronized (object) {
            this._timeStampIdGenerator.setMinimumNext(l);
        }
    }

    public StatefulBuffer readWriterByID(Transaction transaction, int n) {
        return (StatefulBuffer)this.readReaderOrWriterByID(transaction, n, false);
    }

    public StatefulBuffer[] readWritersByIDs(Transaction transaction, int[] nArray) {
        StatefulBuffer[] statefulBufferArray = new StatefulBuffer[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            statefulBufferArray[i] = (StatefulBuffer)this.readReaderOrWriterByID(transaction, nArray[i], false);
        }
        return statefulBufferArray;
    }

    public Buffer readReaderByID(Transaction transaction, int n) {
        return this.readReaderOrWriterByID(transaction, n, true);
    }

    private final Buffer readReaderOrWriterByID(Transaction transaction, int n, boolean bl) {
        if (n == 0) {
            return null;
        }
        try {
            Slot slot = ((LocalTransaction)transaction).getCurrentSlotOfID(n);
            if (slot == null) {
                return null;
            }
            if (slot._address == 0) {
                return null;
            }
            Buffer buffer = null;
            if (bl) {
                buffer = new Buffer(slot._length);
            } else {
                buffer = this.getWriter(transaction, slot._address, slot._length);
                ((StatefulBuffer)buffer).setID(n);
            }
            buffer.readEncrypt(this, slot._address);
            return buffer;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected boolean doFinalize() {
        return this._fileHeader != null;
    }

    void readThis() throws IOException {
        Object object;
        this.newSystemData((byte)1);
        this.blockSizeReadFromFile(1);
        this._fileHeader = FileHeader.readFixedPart(this);
        this.createStringIO(this._systemData.stringEncoding());
        this.classCollection().setID(this._systemData.classCollectionID());
        this.classCollection().read(this.i_systemTrans);
        Converter.convert(new ConversionStage.ClassCollectionAvailableStage(this));
        this.readHeaderVariablePart();
        this._freespaceManager = FreespaceManager.createNew(this, this._systemData.freespaceSystem());
        this._freespaceManager.read(this._systemData.freespaceID());
        this._freespaceManager.start(this._systemData.freespaceAddress());
        if (this._freespaceManager.requiresMigration(this.configImpl().freespaceSystem(), this._systemData.freespaceSystem())) {
            object = this._freespaceManager;
            this._freespaceManager = FreespaceManager.createNew(this, this._systemData.freespaceSystem());
            this._freespaceManager.start(this.newFreespaceSlot(this._systemData.freespaceSystem()));
            FreespaceManager.migrate((FreespaceManager)object, this._freespaceManager);
            this._fileHeader.writeVariablePart(this, 1);
        }
        this.writeHeader(true, false);
        object = (LocalTransaction)this._fileHeader.interruptedTransaction();
        if (object != null && !this.configImpl().commitRecoveryDisabled()) {
            ((LocalTransaction)object).writeOld();
        }
        if (Converter.convert(new ConversionStage.SystemUpStage(this))) {
            this._systemData.converterVersion(6);
            this._fileHeader.writeVariablePart(this, 1);
            this.getTransaction().commit();
        }
    }

    private void readHeaderVariablePart() {
        this._fileHeader.readVariablePart(this);
        this.setNextTimeStampId(this.systemData().lastTimeStampID());
    }

    public int newFreespaceSlot(byte by) {
        this._systemData.freespaceAddress(FreespaceManager.initSlot(this));
        this._systemData.freespaceSystem(by);
        return this._systemData.freespaceAddress();
    }

    public void ensureFreespaceSlot() {
        if (this.systemData().freespaceAddress() == 0) {
            this.newFreespaceSlot(this.systemData().freespaceSystem());
        }
    }

    public void releaseSemaphore(String string) {
        this.releaseSemaphore(this.checkTransaction(null), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseSemaphore(Transaction transaction, String string) {
        if (this.i_semaphores != null) {
            Hashtable4 hashtable4 = this.i_semaphores;
            synchronized (hashtable4) {
                if (this.i_semaphores != null && transaction == this.i_semaphores.get(string)) {
                    this.i_semaphores.remove(string);
                    this.i_semaphores.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseSemaphores(Transaction transaction) {
        if (this.i_semaphores != null) {
            Hashtable4 hashtable4;
            Hashtable4 hashtable42 = hashtable4 = this.i_semaphores;
            synchronized (hashtable42) {
                hashtable4.forEachKeyForIdentity(new Visitor4(){

                    public void visit(Object object) {
                        hashtable4.remove(object);
                    }
                }, transaction);
                hashtable4.notifyAll();
            }
        }
    }

    public final void rollback1() {
        this.getTransaction().rollback();
    }

    public final void setDirtyInSystemTransaction(PersistentBase persistentBase) {
        persistentBase.setStateDirty();
        persistentBase.cacheDirty(this.i_dirty);
    }

    public boolean setSemaphore(String string, int n) {
        return this.setSemaphore(this.checkTransaction(null), string, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setSemaphore(Transaction transaction, String string, int n) {
        if (string == null) {
            throw new NullPointerException();
        }
        Object object = this.i_lock;
        synchronized (object) {
            if (this.i_semaphores == null) {
                this.i_semaphores = new Hashtable4(10);
            }
        }
        object = this.i_semaphores;
        synchronized (object) {
            Object object2 = this.i_semaphores.get(string);
            if (object2 == null) {
                this.i_semaphores.put(string, (Object)transaction);
                return true;
            }
            if (transaction == object2) {
                return true;
            }
            long l = System.currentTimeMillis() + (long)n;
            long l2 = n;
            while (l2 > 0L) {
                try {
                    this.i_semaphores.wait(l2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.classCollection() == null) {
                    return false;
                }
                object2 = this.i_semaphores.get(string);
                if (object2 == null) {
                    this.i_semaphores.put(string, (Object)transaction);
                    return true;
                }
                l2 = l - System.currentTimeMillis();
            }
            return false;
        }
    }

    public void setServer(boolean bl) {
        this.i_isServer = bl;
    }

    public abstract void syncFiles();

    public String toString() {
        return this.fileName();
    }

    public void write(boolean bl) {
        if (this.i_config.isReadOnly()) {
            return;
        }
        this.i_trans.commit();
        if (bl) {
            this.writeHeader(false, true);
        }
    }

    public abstract void writeBytes(Buffer var1, int var2, int var3);

    public final void writeDirty() {
        this.writeCachedDirty();
        this.writeVariableHeader();
    }

    private void writeCachedDirty() {
        Iterator4 iterator4 = this.i_dirty.iterator();
        while (iterator4.moveNext()) {
            PersistentBase persistentBase = (PersistentBase)iterator4.current();
            persistentBase.write(this.i_systemTrans);
            persistentBase.notCachedDirty();
        }
        this.i_dirty.clear();
    }

    protected void writeVariableHeader() {
        if (!this._timeStampIdGenerator.isDirty()) {
            return;
        }
        this._systemData.lastTimeStampID(this._timeStampIdGenerator.lastTimeStampId());
        this._fileHeader.writeVariablePart(this, 2);
        this._timeStampIdGenerator.setClean();
    }

    public final void writeEmbedded(StatefulBuffer statefulBuffer, StatefulBuffer statefulBuffer2) {
        int n = statefulBuffer2.getLength();
        int n2 = this.getSlot(n);
        statefulBuffer2.getTransaction().slotFreeOnRollback(n2, n2, n);
        statefulBuffer2.address(n2);
        statefulBuffer2.writeEncrypt();
        int n3 = statefulBuffer._offset;
        statefulBuffer._offset = statefulBuffer2.getID();
        statefulBuffer.writeInt(n2);
        statefulBuffer._offset = n3;
    }

    void writeHeader(boolean bl, boolean bl2) {
        int n = this._freespaceManager.write(bl2);
        if (bl2) {
            this._freespaceManager = null;
        }
        StatefulBuffer statefulBuffer = this.getWriter(this.i_systemTrans, 0, this._fileHeader.length());
        this._fileHeader.writeFixedPart(this, bl, bl2, statefulBuffer, this.blockSize(), n);
        if (bl2) {
            this.ensureLastSlotWritten();
        }
        this.syncFiles();
    }

    public final void writeNew(ClassMetadata classMetadata, StatefulBuffer statefulBuffer) {
        statefulBuffer.writeEncrypt(this, statefulBuffer.getAddress(), 0);
        if (classMetadata == null) {
            return;
        }
        if (this.maintainsIndices()) {
            classMetadata.addToIndex(this, statefulBuffer.getTransaction(), statefulBuffer.getID());
        }
    }

    public abstract void overwriteDeletedBytes(int var1, int var2);

    public final void writeTransactionPointer(int n) {
        this._fileHeader.writeTransactionPointer(this.getSystemTransaction(), n);
    }

    public final void getSlotForUpdate(StatefulBuffer statefulBuffer) {
        Transaction transaction = statefulBuffer.getTransaction();
        int n = statefulBuffer.getID();
        int n2 = statefulBuffer.getLength();
        int n3 = this.getSlot(n2);
        statefulBuffer.address(n3);
        transaction.slotFreeOnRollbackSetPointer(n, n3, n2);
    }

    public final void writeUpdate(ClassMetadata classMetadata, StatefulBuffer statefulBuffer) {
        if (statefulBuffer.getAddress() == 0) {
            this.getSlotForUpdate(statefulBuffer);
        }
        statefulBuffer.writeEncrypt();
    }

    public void setNextTimeStampId(long l) {
        this._timeStampIdGenerator.setMinimumNext(l);
        this._timeStampIdGenerator.setClean();
    }

    public SystemInfo systemInfo() {
        return new SystemInfoFileImpl(this);
    }

    public FileHeader getFileHeader() {
        return this._fileHeader;
    }

    public void installDebugFreespaceManager(FreespaceManager freespaceManager) {
        this._freespaceManager = freespaceManager;
    }

    public SystemData systemData() {
        return this._systemData;
    }

    public long[] getIDsForClass(Transaction transaction, ClassMetadata classMetadata) {
        final IntArrayList intArrayList = new IntArrayList();
        classMetadata.index().traverseAll(transaction, new Visitor4(){

            public void visit(Object object) {
                intArrayList.add((Integer)object);
            }
        });
        return intArrayList.asLong();
    }

    public QueryResult classOnlyQuery(Transaction transaction, ClassMetadata classMetadata) {
        if (!classMetadata.hasIndex()) {
            return null;
        }
        AbstractQueryResult abstractQueryResult = this.newQueryResult(transaction);
        abstractQueryResult.loadFromClassIndex(classMetadata);
        return abstractQueryResult;
    }

    public QueryResult executeQuery(QQuery qQuery) {
        AbstractQueryResult abstractQueryResult = this.newQueryResult(qQuery.getTransaction());
        abstractQueryResult.loadFromQuery(qQuery);
        return abstractQueryResult;
    }
}

