/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.cs;

import com.db4o.foundation.Closure4;
import com.db4o.foundation.Lock4;
import com.db4o.foundation.Queue4;
import com.db4o.foundation.network.Socket4;
import com.db4o.internal.cs.ClientObjectContainer;
import com.db4o.internal.cs.messages.Msg;

class ClientMessageDispatcher
extends Thread {
    private ClientObjectContainer i_stream;
    private Socket4 i_socket;
    final Queue4 messageQueue;
    final Lock4 messageQueueLock;

    ClientMessageDispatcher(ClientObjectContainer clientObjectContainer, Socket4 socket4, Queue4 queue4, Lock4 lock4) {
        this.i_stream = clientObjectContainer;
        this.messageQueue = queue4;
        this.i_socket = socket4;
        this.messageQueueLock = lock4;
    }

    synchronized boolean isClosed() {
        return this.i_socket == null;
    }

    synchronized void close() {
        this.i_stream = null;
        this.i_socket = null;
    }

    public void run() {
        while (this.i_socket != null) {
            try {
                Msg msg;
                if (this.i_stream == null) {
                    return;
                }
                try {
                    msg = Msg.readMessage(this.i_stream.getTransaction(), this.i_socket);
                }
                catch (Exception exception) {
                    this.messageQueueLock.run(new Closure4(){

                        public Object run() {
                            ClientMessageDispatcher.this.messageQueue.add(Msg.ERROR);
                            ClientMessageDispatcher.this.close();
                            ClientMessageDispatcher.this.messageQueueLock.awake();
                            return null;
                        }
                    });
                    this.close();
                    return;
                }
                if (Msg.PING.equals(msg)) {
                    this.i_stream.writeMsg(Msg.OK);
                    continue;
                }
                if (Msg.CLOSE.equals(msg)) {
                    this.i_stream.logMsg(35, this.i_stream.toString());
                    this.i_stream = null;
                    this.i_socket = null;
                    continue;
                }
                this.messageQueueLock.run(new Closure4(){

                    public Object run() {
                        ClientMessageDispatcher.this.messageQueue.add(msg);
                        ClientMessageDispatcher.this.messageQueueLock.awake();
                        return null;
                    }
                });
            }
            catch (Exception exception) {
                this.close();
                return;
            }
        }
    }
}

