/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.marshall;

import com.db4o.CorruptionException;
import com.db4o.internal.Buffer;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.Config4Class;
import com.db4o.internal.Db4oTypeImpl;
import com.db4o.internal.FieldMetadata;
import com.db4o.internal.ObjectReference;
import com.db4o.internal.PrimitiveFieldHandler;
import com.db4o.internal.ReaderPair;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.Transaction;
import com.db4o.internal.TreeInt;
import com.db4o.internal.marshall.MarshallerFamily;
import com.db4o.internal.marshall.ObjectHeader;
import com.db4o.internal.marshall.ObjectHeaderAttributes;
import com.db4o.internal.marshall.ObjectMarshaller;
import com.db4o.internal.slots.Slot;

class ObjectMarshaller0
extends ObjectMarshaller {
    ObjectMarshaller0() {
    }

    public void addFieldIndices(final ClassMetadata classMetadata, ObjectHeaderAttributes objectHeaderAttributes, final StatefulBuffer statefulBuffer, final Slot slot) {
        ObjectMarshaller.TraverseFieldCommand traverseFieldCommand = new ObjectMarshaller.TraverseFieldCommand(){

            public void processField(FieldMetadata fieldMetadata, boolean bl, ClassMetadata classMetadata2) {
                fieldMetadata.addFieldIndex(ObjectMarshaller0.this._family, classMetadata, statefulBuffer, slot);
            }
        };
        this.traverseFields(classMetadata, statefulBuffer, objectHeaderAttributes, traverseFieldCommand);
    }

    public TreeInt collectFieldIDs(TreeInt treeInt, ClassMetadata classMetadata, ObjectHeaderAttributes objectHeaderAttributes, final StatefulBuffer statefulBuffer, final String string) {
        final TreeInt[] treeIntArray = new TreeInt[]{treeInt};
        ObjectMarshaller.TraverseFieldCommand traverseFieldCommand = new ObjectMarshaller.TraverseFieldCommand(){

            public void processField(FieldMetadata fieldMetadata, boolean bl, ClassMetadata classMetadata) {
                if (string.equals(fieldMetadata.getName())) {
                    treeIntArray[0] = fieldMetadata.collectIDs(ObjectMarshaller0.this._family, treeIntArray[0], statefulBuffer);
                } else {
                    fieldMetadata.incrementOffset(statefulBuffer);
                }
            }
        };
        this.traverseFields(classMetadata, statefulBuffer, objectHeaderAttributes, traverseFieldCommand);
        return treeIntArray[0];
    }

    public void deleteMembers(ClassMetadata classMetadata, ObjectHeaderAttributes objectHeaderAttributes, final StatefulBuffer statefulBuffer, int n, final boolean bl) {
        ObjectMarshaller.TraverseFieldCommand traverseFieldCommand = new ObjectMarshaller.TraverseFieldCommand(){

            public void processField(FieldMetadata fieldMetadata, boolean bl2, ClassMetadata classMetadata) {
                fieldMetadata.delete(ObjectMarshaller0.this._family, statefulBuffer, bl);
            }
        };
        this.traverseFields(classMetadata, statefulBuffer, objectHeaderAttributes, traverseFieldCommand);
    }

    public boolean findOffset(ClassMetadata classMetadata, ObjectHeaderAttributes objectHeaderAttributes, final Buffer buffer, final FieldMetadata fieldMetadata) {
        final boolean[] blArray = new boolean[]{false};
        ObjectMarshaller.TraverseFieldCommand traverseFieldCommand = new ObjectMarshaller.TraverseFieldCommand(){

            public void processField(FieldMetadata fieldMetadata2, boolean bl, ClassMetadata classMetadata) {
                if (fieldMetadata2 == fieldMetadata) {
                    blArray[0] = true;
                    this.cancel();
                    return;
                }
                buffer.incrementOffset(fieldMetadata2.linkLength());
            }
        };
        this.traverseFields(classMetadata, buffer, objectHeaderAttributes, traverseFieldCommand);
        return blArray[0];
    }

    protected final int headerLength() {
        return 4;
    }

    public void instantiateFields(ClassMetadata classMetadata, ObjectHeaderAttributes objectHeaderAttributes, final ObjectReference objectReference, final Object object, final StatefulBuffer statefulBuffer) {
        ObjectMarshaller.TraverseFieldCommand traverseFieldCommand = new ObjectMarshaller.TraverseFieldCommand(){

            public void processField(FieldMetadata fieldMetadata, boolean bl, ClassMetadata classMetadata) {
                try {
                    fieldMetadata.instantiate(ObjectMarshaller0.this._family, objectReference, object, statefulBuffer);
                }
                catch (CorruptionException corruptionException) {
                    this.cancel();
                }
            }
        };
        this.traverseFields(classMetadata, statefulBuffer, objectHeaderAttributes, traverseFieldCommand);
    }

    private int linkLength(ClassMetadata classMetadata, ObjectReference objectReference) {
        int n = 4;
        if (classMetadata.i_fields != null) {
            for (int i = 0; i < classMetadata.i_fields.length; ++i) {
                n += this.linkLength(classMetadata.i_fields[i], objectReference);
            }
        }
        if (classMetadata.i_ancestor != null) {
            n += this.linkLength(classMetadata.i_ancestor, objectReference);
        }
        return n;
    }

    protected int linkLength(FieldMetadata fieldMetadata, ObjectReference objectReference) {
        return fieldMetadata.linkLength();
    }

    private void marshall(ClassMetadata classMetadata, ObjectReference objectReference, Object object, StatefulBuffer statefulBuffer, boolean bl) {
        this.marshallDeclaredFields(classMetadata, objectReference, object, statefulBuffer, bl);
    }

    private void marshallDeclaredFields(ClassMetadata classMetadata, final ObjectReference objectReference, final Object object, final StatefulBuffer statefulBuffer, final boolean bl) {
        final Config4Class config4Class = classMetadata.configOrAncestorConfig();
        final Transaction transaction = statefulBuffer.getTransaction();
        ObjectMarshaller.TraverseFieldCommand traverseFieldCommand = new ObjectMarshaller.TraverseFieldCommand(){

            public int fieldCount(ClassMetadata classMetadata, Buffer buffer) {
                statefulBuffer.writeInt(classMetadata.i_fields.length);
                return classMetadata.i_fields.length;
            }

            public void processField(FieldMetadata fieldMetadata, boolean bl2, ClassMetadata classMetadata) {
                Object object2 = fieldMetadata.getOrCreate(transaction, object);
                if (object2 instanceof Db4oTypeImpl) {
                    object2 = ((Db4oTypeImpl)object2).storedTo(transaction);
                }
                fieldMetadata.marshall(objectReference, object2, ObjectMarshaller0.this._family, statefulBuffer, config4Class, bl);
            }
        };
        this.traverseFields(classMetadata, statefulBuffer, this.readHeaderAttributes(statefulBuffer), traverseFieldCommand);
    }

    protected int marshalledLength(FieldMetadata fieldMetadata, ObjectReference objectReference) {
        return 0;
    }

    public StatefulBuffer marshallNew(Transaction transaction, ObjectReference objectReference, int n) {
        StatefulBuffer statefulBuffer = this.createWriterForNew(transaction, objectReference, n, this.objectLength(objectReference));
        ClassMetadata classMetadata = objectReference.getYapClass();
        Object object = objectReference.getObject();
        if (classMetadata.isPrimitive()) {
            ((PrimitiveFieldHandler)classMetadata).i_handler.writeNew(MarshallerFamily.current(), object, false, statefulBuffer, true, false);
        } else {
            this.writeObjectClassID(statefulBuffer, classMetadata.getID());
            classMetadata.checkUpdateDepth(statefulBuffer);
            this.marshall(classMetadata, objectReference, object, statefulBuffer, true);
        }
        return statefulBuffer;
    }

    public void marshallUpdate(Transaction transaction, int n, ObjectReference objectReference, Object object) {
        StatefulBuffer statefulBuffer = this.createWriterForUpdate(transaction, n, objectReference.getID(), 0, this.objectLength(objectReference));
        ClassMetadata classMetadata = objectReference.getYapClass();
        classMetadata.checkUpdateDepth(statefulBuffer);
        statefulBuffer.writeInt(classMetadata.getID());
        this.marshall(classMetadata, objectReference, object, statefulBuffer, false);
        this.marshallUpdateWrite(transaction, objectReference, object, statefulBuffer);
    }

    private int objectLength(ObjectReference objectReference) {
        return this.headerLength() + this.linkLength(objectReference.getYapClass(), objectReference);
    }

    public ObjectHeaderAttributes readHeaderAttributes(Buffer buffer) {
        return null;
    }

    public Object readIndexEntry(ClassMetadata classMetadata, ObjectHeaderAttributes objectHeaderAttributes, FieldMetadata fieldMetadata, StatefulBuffer statefulBuffer) {
        if (classMetadata == null) {
            return null;
        }
        if (!this.findOffset(classMetadata, objectHeaderAttributes, statefulBuffer, fieldMetadata)) {
            return null;
        }
        return fieldMetadata.readIndexEntry(this._family, statefulBuffer);
    }

    public void readVirtualAttributes(final Transaction transaction, ClassMetadata classMetadata, final ObjectReference objectReference, ObjectHeaderAttributes objectHeaderAttributes, final Buffer buffer) {
        ObjectMarshaller.TraverseFieldCommand traverseFieldCommand = new ObjectMarshaller.TraverseFieldCommand(){

            public void processField(FieldMetadata fieldMetadata, boolean bl, ClassMetadata classMetadata) {
                fieldMetadata.readVirtualAttribute(transaction, buffer, objectReference);
            }
        };
        this.traverseFields(classMetadata, buffer, objectHeaderAttributes, traverseFieldCommand);
    }

    protected boolean isNull(ObjectHeaderAttributes objectHeaderAttributes, int n) {
        return false;
    }

    public void defragFields(ClassMetadata classMetadata, ObjectHeader objectHeader, ReaderPair readerPair) {
    }

    public void writeObjectClassID(Buffer buffer, int n) {
        buffer.writeInt(n);
    }

    public void skipMarshallerInfo(Buffer buffer) {
    }
}

