/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.marshall;

import com.db4o.internal.Buffer;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.Platform4;
import com.db4o.internal.PrimitiveFieldHandler;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.Transaction;
import com.db4o.internal.TypeHandler4;
import com.db4o.internal.marshall.PrimitiveMarshaller;
import java.util.Date;

public class PrimitiveMarshaller0
extends PrimitiveMarshaller {
    public boolean useNormalClassRead() {
        return true;
    }

    public int writeNew(Transaction transaction, PrimitiveFieldHandler primitiveFieldHandler, Object object, boolean bl, StatefulBuffer statefulBuffer, boolean bl2, boolean bl3) {
        int n = 0;
        if (object != null) {
            TypeHandler4 typeHandler4 = primitiveFieldHandler.i_handler;
            ObjectContainerBase objectContainerBase = transaction.stream();
            n = objectContainerBase.newUserObject();
            int n2 = -1;
            int n3 = this.objectLength(typeHandler4);
            if (!objectContainerBase.isClient()) {
                n2 = transaction.i_file.getSlot(n3);
            }
            transaction.setPointer(n, n2, n3);
            StatefulBuffer statefulBuffer2 = new StatefulBuffer(transaction, n3);
            statefulBuffer2.useSlot(n, n2, n3);
            statefulBuffer2.writeInt(primitiveFieldHandler.getID());
            typeHandler4.writeNew(this._family, object, false, statefulBuffer2, true, false);
            statefulBuffer2.writeEnd();
            objectContainerBase.writeNew(primitiveFieldHandler, statefulBuffer2);
        }
        if (statefulBuffer != null) {
            statefulBuffer.writeInt(n);
        }
        return n;
    }

    public Date readDate(Buffer buffer) {
        long l = buffer.readLong();
        if (l == Long.MAX_VALUE) {
            return null;
        }
        return new Date(l);
    }

    public Object readInteger(Buffer buffer) {
        int n = buffer.readInt();
        if (n == Integer.MAX_VALUE) {
            return null;
        }
        return new Integer(n);
    }

    public Object readFloat(Buffer buffer) {
        Float f = PrimitiveMarshaller0.unmarshallFloat(buffer);
        if (f.isNaN()) {
            return null;
        }
        return f;
    }

    public Object readDouble(Buffer buffer) {
        Double d = PrimitiveMarshaller0.unmarshalDouble(buffer);
        if (d.isNaN()) {
            return null;
        }
        return d;
    }

    public Object readLong(Buffer buffer) {
        long l = buffer.readLong();
        if (l == Long.MAX_VALUE) {
            return null;
        }
        return new Long(l);
    }

    public Object readShort(Buffer buffer) {
        short s = PrimitiveMarshaller0.unmarshallShort(buffer);
        if (s == Short.MAX_VALUE) {
            return null;
        }
        return new Short(s);
    }

    public static Double unmarshalDouble(Buffer buffer) {
        return new Double(Platform4.longToDouble(buffer.readLong()));
    }

    public static Float unmarshallFloat(Buffer buffer) {
        return new Float(Float.intBitsToFloat(buffer.readInt()));
    }

    public static short unmarshallShort(Buffer buffer) {
        int n = 0;
        for (int i = 0; i < 2; ++i) {
            n = (n << 8) + (buffer._buffer[buffer._offset++] & 0xFF);
        }
        return (short)n;
    }
}

