/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.connection;

import java.net.URI;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.osgi.service.url.URLStreamHandlerService;
import org.rssowl.core.Owl;
import org.rssowl.core.connection.ConnectionException;
import org.rssowl.core.connection.CredentialsException;
import org.rssowl.core.connection.IConnectionService;
import org.rssowl.core.connection.ICredentials;
import org.rssowl.core.connection.ICredentialsProvider;
import org.rssowl.core.connection.IProtocolHandler;
import org.rssowl.core.connection.IProxyCredentials;
import org.rssowl.core.connection.UnknownProtocolException;
import org.rssowl.core.internal.Activator;
import org.rssowl.core.internal.InternalOwl;
import org.rssowl.core.internal.connection.Messages;
import org.rssowl.core.persist.IConditionalGet;
import org.rssowl.core.persist.IFeed;
import org.rssowl.core.persist.dao.DynamicDAO;
import org.rssowl.core.persist.event.FeedAdapter;
import org.rssowl.core.persist.event.FeedEvent;
import org.rssowl.core.persist.event.FeedListener;
import org.rssowl.core.util.ExtensionUtils;
import org.rssowl.core.util.StringUtils;
import org.rssowl.core.util.Triple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionServiceImpl
implements IConnectionService {
    private static final String PROTHANDLER_EXTENSION_POINT = "org.rssowl.core.ProtocolHandler";
    private static final String CREDPROVIDER_EXTENSION_POINT = "org.rssowl.core.CredentialsProvider";
    private static final String SSL_HANDLER_EXTENSION_POINT = "org.rssowl.core.SSLHandler";
    private final Map<String, IProtocolHandler> fProtocolHandler = new HashMap<String, IProtocolHandler>();
    private final Map<String, ICredentialsProvider> fCredentialsProvider = new HashMap<String, ICredentialsProvider>();
    private final SecureProtocolSocketFactory fSecureProtocolSocketFactory;
    private final FeedListener fFeedListener = this.createFeedListener();

    public ConnectionServiceImpl() {
        this.startup();
        this.fSecureProtocolSocketFactory = this.loadSSLHandler();
    }

    private void startup() {
        this.loadProtocolHandlers();
        this.loadCredentialsProvider();
        this.registerURLStreamHandlers();
        this.registerListeners();
    }

    private FeedListener createFeedListener() {
        return new FeedAdapter(){

            @Override
            public void entitiesDeleted(Set<FeedEvent> events) {
                for (FeedEvent feedEvent : events) {
                    URI feedLink = feedEvent.getEntity().getLink();
                    try {
                        ICredentialsProvider credentialsProvider;
                        String protocol = feedLink.getScheme();
                        if (protocol == null || (credentialsProvider = (ICredentialsProvider)ConnectionServiceImpl.this.fCredentialsProvider.get(protocol)) == null || credentialsProvider.getAuthCredentials(feedLink, null) == null) continue;
                        credentialsProvider.deleteAuthCredentials(feedLink, null);
                    }
                    catch (CredentialsException e) {
                        Activator.getDefault().getLog().log(e.getStatus());
                    }
                }
            }
        };
    }

    private void registerListeners() {
        InternalOwl.getDefault().getPersistenceService().getDAOService().getFeedDAO().addEntityListener(this.fFeedListener);
    }

    @Override
    public void shutdown() {
        this.unregisterListeners();
    }

    private void unregisterListeners() {
        if (Owl.isStarted()) {
            DynamicDAO.removeEntityListener(IFeed.class, this.fFeedListener);
        }
    }

    @Override
    public IProtocolHandler getHandler(URI link) throws ConnectionException {
        String protocol = link.getScheme();
        IProtocolHandler handler = this.fProtocolHandler.get(protocol);
        if (handler != null) {
            return handler;
        }
        throw new UnknownProtocolException(Activator.getDefault().createErrorStatus(NLS.bind((String)Messages.ConnectionServiceImpl_ERROR_NO_PROTOCOL_HANDLER, (Object)protocol), null), protocol);
    }

    @Override
    public String getLabel(URI link, IProgressMonitor monitor) throws ConnectionException {
        String protocol = link.getScheme();
        IProtocolHandler handler = this.fProtocolHandler.get(protocol);
        if (handler != null) {
            return handler.getLabel(link, monitor);
        }
        throw new UnknownProtocolException(Activator.getDefault().createErrorStatus(NLS.bind((String)Messages.ConnectionServiceImpl_ERROR_NO_PROTOCOL_HANDLER, (Object)protocol), null), protocol);
    }

    @Override
    public Triple<IFeed, IConditionalGet, URI> reload(URI link, IProgressMonitor monitor, Map<Object, Object> properties) throws CoreException {
        String protocol = link.getScheme();
        IProtocolHandler handler = this.fProtocolHandler.get(protocol);
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (handler != null) {
            return handler.reload(link, monitor, properties);
        }
        throw new UnknownProtocolException(Activator.getDefault().createErrorStatus(NLS.bind((String)Messages.ConnectionServiceImpl_ERROR_NO_PROTOCOL_HANDLER, (Object)protocol), null), protocol);
    }

    @Override
    public byte[] getFeedIcon(URI link, IProgressMonitor monitor) throws ConnectionException {
        String protocol = link.getScheme();
        IProtocolHandler handler = this.fProtocolHandler.get(protocol);
        if (handler != null) {
            return handler.getFeedIcon(link, monitor);
        }
        throw new UnknownProtocolException(Activator.getDefault().createErrorStatus(NLS.bind((String)Messages.ConnectionServiceImpl_ERROR_NO_PROTOCOL_HANDLER, (Object)protocol), null), protocol);
    }

    @Override
    public URI getFeed(URI link, IProgressMonitor monitor) throws ConnectionException {
        String protocol = link.getScheme();
        IProtocolHandler handler = this.fProtocolHandler.get(protocol);
        if (handler != null) {
            return handler.getFeed(link, monitor);
        }
        throw new UnknownProtocolException(Activator.getDefault().createErrorStatus(NLS.bind((String)Messages.ConnectionServiceImpl_ERROR_NO_PROTOCOL_HANDLER, (Object)protocol), null), protocol);
    }

    @Override
    public ICredentialsProvider getCredentialsProvider(URI link) {
        return this.fCredentialsProvider.get(link.getScheme());
    }

    @Override
    public SecureProtocolSocketFactory getSecureProtocolSocketFactory() {
        return this.fSecureProtocolSocketFactory;
    }

    @Override
    public ICredentials getAuthCredentials(URI link, String realm) throws CredentialsException {
        ICredentialsProvider credentialsProvider = this.internalGetCredentialsProvider(link);
        ICredentials credentials = credentialsProvider.getAuthCredentials(link, realm);
        return credentials;
    }

    @Override
    public IProxyCredentials getProxyCredentials(URI link) throws CredentialsException {
        ICredentialsProvider credentialsProvider = this.internalGetCredentialsProvider(link);
        IProxyCredentials credentials = credentialsProvider.getProxyCredentials(link);
        return credentials;
    }

    private ICredentialsProvider internalGetCredentialsProvider(URI link) throws CredentialsException {
        String protocol = link.getScheme();
        if (!StringUtils.isSet(protocol)) {
            throw new CredentialsException(Activator.getDefault().createErrorStatus(Messages.ConnectionServiceImpl_ERROR_UNKNOWN_PROTOCOL, null));
        }
        ICredentialsProvider credentialsProvider = this.fCredentialsProvider.get(protocol);
        if (credentialsProvider == null) {
            throw new CredentialsException(Activator.getDefault().createErrorStatus(NLS.bind((String)Messages.ConnectionServiceImpl_ERROR_NO_CREDENTIAL_PROVIDER, (Object)protocol), null));
        }
        return credentialsProvider;
    }

    private void loadProtocolHandlers() {
        IConfigurationElement[] elements;
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = reg.getConfigurationElementsFor(PROTHANDLER_EXTENSION_POINT);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                String protocol = element.getAttribute("protocol");
                if (!this.fProtocolHandler.containsKey(protocol) || !element.getNamespaceIdentifier().contains("org.rssowl")) {
                    this.fProtocolHandler.put(protocol, (IProtocolHandler)element.createExecutableExtension("class"));
                }
            }
            catch (InvalidRegistryObjectException e) {
                Activator.getDefault().logError(e.getMessage(), e);
            }
            catch (CoreException e) {
                Activator.getDefault().getLog().log(e.getStatus());
            }
            ++n2;
        }
    }

    private void loadCredentialsProvider() {
        IConfigurationElement[] elements;
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = reg.getConfigurationElementsFor(CREDPROVIDER_EXTENSION_POINT);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                String protocol = element.getAttribute("protocol");
                String nsId = element.getNamespaceIdentifier();
                if (!this.fCredentialsProvider.containsKey(protocol) || !nsId.contains("org.rssowl") || nsId.contains("org.rssowl.core.tests")) {
                    this.fCredentialsProvider.put(protocol, (ICredentialsProvider)element.createExecutableExtension("class"));
                }
            }
            catch (InvalidRegistryObjectException e) {
                Activator.getDefault().logError(e.getMessage(), e);
            }
            catch (CoreException e) {
                Activator.getDefault().getLog().log(e.getStatus());
            }
            ++n2;
        }
    }

    private SecureProtocolSocketFactory loadSSLHandler() {
        return (SecureProtocolSocketFactory)ExtensionUtils.loadSingletonExecutableExtension(SSL_HANDLER_EXTENSION_POINT);
    }

    private void registerURLStreamHandlers() {
        for (String protocol : this.fProtocolHandler.keySet()) {
            IProtocolHandler protocolHandler = this.fProtocolHandler.get(protocol);
            try {
                if (protocolHandler.getURLStreamHandler() == null) continue;
                Hashtable<String, String[]> properties = new Hashtable<String, String[]>(1);
                properties.put("url.handler.protocol", new String[]{protocol});
                Activator.getDefault().getContext().registerService(URLStreamHandlerService.class.getName(), (Object)protocolHandler.getURLStreamHandler(), properties);
            }
            catch (ConnectionException e) {
                Activator.getDefault().getLog().log(e.getStatus());
            }
        }
    }
}

