/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.interpreter;

import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.osgi.util.NLS;
import org.jdom.Document;
import org.jdom.input.DOMBuilder;
import org.rssowl.core.internal.Activator;
import org.rssowl.core.internal.interpreter.DefaultSaxParserImpl;
import org.rssowl.core.internal.interpreter.Messages;
import org.rssowl.core.internal.interpreter.OPMLExporter;
import org.rssowl.core.internal.interpreter.json.JSONInterpreter;
import org.rssowl.core.internal.interpreter.json.JSONObject;
import org.rssowl.core.interpreter.IElementHandler;
import org.rssowl.core.interpreter.IFormatInterpreter;
import org.rssowl.core.interpreter.IInterpreterService;
import org.rssowl.core.interpreter.INamespaceHandler;
import org.rssowl.core.interpreter.ITypeExporter;
import org.rssowl.core.interpreter.ITypeImporter;
import org.rssowl.core.interpreter.IXMLParser;
import org.rssowl.core.interpreter.InterpreterException;
import org.rssowl.core.interpreter.ParserException;
import org.rssowl.core.interpreter.UnknownFormatException;
import org.rssowl.core.persist.IEntity;
import org.rssowl.core.persist.IFeed;
import org.rssowl.core.persist.IFolderChild;
import org.rssowl.core.util.ExtensionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterpreterServiceImpl
implements IInterpreterService {
    private static final String SAXPARSER_EXTENSION_POINT = "org.rssowl.core.XMLParser";
    private static final String FORMATINTERPRETER_EXTENSION_POINT = "org.rssowl.core.FormatInterpreter";
    private static final String TYPEIMPORTER_EXTENSION_POINT = "org.rssowl.core.TypeImporter";
    private static final String TYPEEXPORTER_EXTENSION_POINT = "org.rssowl.core.TypeExporter";
    private static final String NSHANDLER_EXTENSION_POINT = "org.rssowl.core.NamespaceHandler";
    private static final String ELHANDLER_EXTENSION_POINT = "org.rssowl.core.ElementHandler";
    private volatile Map<String, IFormatInterpreter> fFormatInterpreters;
    private volatile Map<String, ITypeImporter> fTypeImporters;
    private volatile Map<String, ITypeExporter> fTypeExporters;
    private volatile Map<String, INamespaceHandler> fNamespaceHandlers;
    private volatile Map<String, IElementHandler> fElementHandlers;
    private volatile IXMLParser fXMLParserImpl;
    private ITypeExporter fDefaultExporter = new OPMLExporter();

    public InterpreterServiceImpl() {
        this.startup();
    }

    @Override
    public void interpret(InputStream inS, IFeed feed, Map<Object, Object> properties) throws ParserException, InterpreterException {
        Document document = this.fXMLParserImpl.parse(inS, properties);
        if (document != null) {
            this.interpretJDomDocument(document, feed);
        }
    }

    @Override
    public void interpretW3CDocument(org.w3c.dom.Document w3cDocument, IFeed feed) throws InterpreterException {
        DOMBuilder domBuilder = new DOMBuilder();
        Document jDomDocument = domBuilder.build(w3cDocument);
        if (jDomDocument != null) {
            this.interpretJDomDocument(jDomDocument, feed);
        }
    }

    @Override
    public void interpretJDomDocument(Document document, IFeed feed) throws InterpreterException {
        if (!document.hasRootElement()) {
            throw new InterpreterException(Activator.getDefault().createErrorStatus(Messages.InterpreterServiceImpl_ERROR_NO_ROOT_ELEMENT, null));
        }
        String format = document.getRootElement().getName().toLowerCase();
        if (!this.fFormatInterpreters.containsKey(format)) {
            throw new UnknownFormatException(Activator.getDefault().createErrorStatus(NLS.bind((String)Messages.InterpreterServiceImpl_ERROR_NO_INTERPRETER_FOUND, (Object)format), null), format);
        }
        this.fFormatInterpreters.get(format).interpret(document, feed);
    }

    @Override
    public void interpretJSONObject(JSONObject json, IFeed feed) throws InterpreterException {
        new JSONInterpreter().interpret(json, feed);
    }

    @Override
    public List<IEntity> importFrom(InputStream inS) throws InterpreterException, ParserException {
        Document document = this.fXMLParserImpl.parse(inS, null);
        if (!document.hasRootElement()) {
            throw new InterpreterException(Activator.getDefault().createErrorStatus(Messages.InterpreterServiceImpl_ERROR_NO_ROOT_ELEMENT, null));
        }
        String format = document.getRootElement().getName().toLowerCase();
        if (!this.fTypeImporters.containsKey(format)) {
            throw new UnknownFormatException(Activator.getDefault().createErrorStatus(NLS.bind((String)Messages.InterpreterServiceImpl_ERROR_NO_IMPORTER_FOUND, (Object)format), null), format);
        }
        return this.fTypeImporters.get(format).importFrom(document);
    }

    @Override
    public void exportTo(File destination, Collection<? extends IFolderChild> elements, Set<ITypeExporter.Options> options) throws InterpreterException {
        ITypeExporter exporter = null;
        String fileName = destination.getName();
        int i = fileName.lastIndexOf(".");
        if (i != -1 && !fileName.endsWith(".")) {
            String formatName = fileName.substring(i + 1);
            exporter = this.fTypeExporters.get(formatName);
        }
        if (exporter == null) {
            exporter = this.fDefaultExporter;
        }
        exporter.exportTo(destination, elements, options);
    }

    @Override
    public Collection<String> getExportFormats() {
        return this.fTypeExporters.keySet();
    }

    @Override
    public INamespaceHandler getNamespaceHandler(String namespaceUri) {
        return this.fNamespaceHandlers.get(namespaceUri);
    }

    @Override
    public IElementHandler getElementHandler(String elementName, String rootName) {
        if (this.fElementHandlers != null) {
            return this.fElementHandlers.get(String.valueOf(elementName.toLowerCase()) + rootName.toLowerCase());
        }
        return null;
    }

    private void startup() {
        this.fXMLParserImpl = this.loadXMLParserImpl();
        Assert.isNotNull((Object)this.fXMLParserImpl);
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void handleException(Throwable exception) {
                InterpreterServiceImpl.this.fXMLParserImpl = new DefaultSaxParserImpl();
                try {
                    InterpreterServiceImpl.this.fXMLParserImpl.init();
                }
                catch (ParserException e) {
                    Activator.getDefault().getLog().log(e.getStatus());
                }
            }

            public void run() throws Exception {
                InterpreterServiceImpl.this.fXMLParserImpl.init();
            }
        });
        this.fFormatInterpreters = new HashMap<String, IFormatInterpreter>();
        this.loadFormatInterpreters();
        this.fTypeImporters = new HashMap<String, ITypeImporter>();
        this.loadTypeImporters();
        this.fTypeExporters = new HashMap<String, ITypeExporter>();
        this.loadTypeExporters();
        this.fNamespaceHandlers = new HashMap<String, INamespaceHandler>();
        this.loadNamespaceHandlers();
        this.loadElementHandlers();
    }

    private void loadNamespaceHandlers() {
        IConfigurationElement[] elements;
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = reg.getConfigurationElementsFor(NSHANDLER_EXTENSION_POINT);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                String namespaceUri = element.getAttribute("namespaceURI");
                if (!this.fNamespaceHandlers.containsKey(namespaceUri) || !element.getNamespaceIdentifier().contains("org.rssowl")) {
                    this.fNamespaceHandlers.put(namespaceUri, (INamespaceHandler)element.createExecutableExtension("class"));
                }
            }
            catch (InvalidRegistryObjectException e) {
                Activator.getDefault().logError(e.getMessage(), e);
            }
            catch (CoreException e) {
                Activator.getDefault().getLog().log(e.getStatus());
            }
            ++n2;
        }
    }

    private void loadElementHandlers() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = reg.getConfigurationElementsFor(ELHANDLER_EXTENSION_POINT);
        if (elements.length > 0) {
            this.fElementHandlers = new HashMap<String, IElementHandler>();
        }
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            String elementName = element.getAttribute("elementName").toLowerCase();
            String rootName = element.getAttribute("rootElement").toLowerCase();
            if (!this.fElementHandlers.containsKey(String.valueOf(elementName) + rootName) || !element.getNamespaceIdentifier().contains("org.rssowl")) {
                try {
                    this.fElementHandlers.put(String.valueOf(elementName) + rootName, (IElementHandler)element.createExecutableExtension("class"));
                }
                catch (CoreException e) {
                    Activator.getDefault().getLog().log(e.getStatus());
                }
            }
            ++n2;
        }
    }

    private void loadFormatInterpreters() {
        IConfigurationElement[] elements;
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = reg.getConfigurationElementsFor(FORMATINTERPRETER_EXTENSION_POINT);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                String format = element.getAttribute("rootElement").toLowerCase();
                if (!this.fFormatInterpreters.containsKey(format) || !element.getNamespaceIdentifier().contains("org.rssowl")) {
                    this.fFormatInterpreters.put(format, (IFormatInterpreter)element.createExecutableExtension("class"));
                }
            }
            catch (InvalidRegistryObjectException e) {
                Activator.getDefault().logError(e.getMessage(), e);
            }
            catch (CoreException e) {
                Activator.getDefault().getLog().log(e.getStatus());
            }
            ++n2;
        }
    }

    private void loadTypeImporters() {
        IConfigurationElement[] elements;
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = reg.getConfigurationElementsFor(TYPEIMPORTER_EXTENSION_POINT);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                String format = element.getAttribute("rootElement").toLowerCase();
                if (!this.fTypeImporters.containsKey(format) || !element.getNamespaceIdentifier().contains("org.rssowl")) {
                    this.fTypeImporters.put(format, (ITypeImporter)element.createExecutableExtension("class"));
                }
            }
            catch (InvalidRegistryObjectException e) {
                Activator.getDefault().logError(e.getMessage(), e);
            }
            catch (CoreException e) {
                Activator.getDefault().getLog().log(e.getStatus());
            }
            ++n2;
        }
    }

    private void loadTypeExporters() {
        IConfigurationElement[] elements;
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = reg.getConfigurationElementsFor(TYPEEXPORTER_EXTENSION_POINT);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                IConfigurationElement[] formats;
                IConfigurationElement[] iConfigurationElementArray2 = formats = element.getChildren("format");
                int n3 = formats.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement format = iConfigurationElementArray2[n4];
                    String formatName = format.getAttribute("name").toLowerCase();
                    if (!this.fTypeExporters.containsKey(formatName) || !element.getNamespaceIdentifier().contains("org.rssowl")) {
                        this.fTypeExporters.put(formatName, (ITypeExporter)element.createExecutableExtension("class"));
                    }
                    ++n4;
                }
            }
            catch (InvalidRegistryObjectException e) {
                Activator.getDefault().logError(e.getMessage(), e);
            }
            catch (CoreException e) {
                Activator.getDefault().getLog().log(e.getStatus());
            }
            ++n2;
        }
    }

    private IXMLParser loadXMLParserImpl() {
        return (IXMLParser)ExtensionUtils.loadSingletonExecutableExtension(SAXPARSER_EXTENSION_POINT);
    }
}

