/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.persist;

import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.rssowl.core.internal.persist.Mark;
import org.rssowl.core.persist.IBookMark;
import org.rssowl.core.persist.IFolder;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.NewsCounter;
import org.rssowl.core.persist.dao.DynamicDAO;
import org.rssowl.core.persist.dao.INewsDAO;
import org.rssowl.core.persist.reference.BookMarkReference;
import org.rssowl.core.persist.reference.FeedLinkReference;
import org.rssowl.core.persist.reference.NewsReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BookMark
extends Mark
implements IBookMark {
    private String fFeedLink;
    private transient FeedLinkReference fFeedLinkReference;
    private boolean fIsErrorLoading;
    private transient NewsCounter fNewsCounter;
    private long fMostRecentNewsDate = -1L;

    public BookMark(Long id, IFolder folder, FeedLinkReference feedRef, String name) {
        super(id, folder, name);
        Assert.isNotNull((Object)feedRef, (String)"feedRef cannot be null");
        this.fFeedLinkReference = feedRef;
        this.fFeedLink = feedRef.getLinkAsText();
    }

    protected BookMark() {
    }

    @Override
    public synchronized Date getMostRecentNewsDate() {
        if (this.fMostRecentNewsDate < 0L) {
            return null;
        }
        return new Date(this.fMostRecentNewsDate);
    }

    @Override
    public synchronized void setMostRecentNewsDate(Date date) {
        Assert.isNotNull((Object)date, (String)"date");
        this.fMostRecentNewsDate = date.getTime();
    }

    public synchronized void setNewsCounter(NewsCounter newsCounter) {
        this.fNewsCounter = newsCounter;
    }

    @Override
    public synchronized boolean isErrorLoading() {
        return this.fIsErrorLoading;
    }

    @Override
    public synchronized void setErrorLoading(boolean isErrorLoading) {
        this.fIsErrorLoading = isErrorLoading;
    }

    @Override
    public synchronized FeedLinkReference getFeedLinkReference() {
        if (this.fFeedLinkReference == null) {
            this.fFeedLinkReference = new FeedLinkReference(this.createURI(this.fFeedLink));
        }
        return this.fFeedLinkReference;
    }

    @Override
    public synchronized void setFeedLinkReference(FeedLinkReference feedLinkRef) {
        Assert.isNotNull((Object)feedLinkRef, (String)"link cannot be null");
        this.fFeedLinkReference = feedLinkRef;
        this.fFeedLink = feedLinkRef.getLinkAsText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean isIdentical(IBookMark bookMark) {
        if (this == bookMark) {
            return true;
        }
        if (!(bookMark instanceof BookMark)) {
            return false;
        }
        IBookMark iBookMark = bookMark;
        synchronized (iBookMark) {
            BookMark b = (BookMark)bookMark;
            return (this.getId() == null ? b.getId() == null : this.getId().equals(b.getId())) && (this.getParent() == null ? b.getParent() == null : this.getParent().equals(b.getParent())) && (this.getCreationDate() == null ? b.getCreationDate() == null : this.getCreationDate().equals(b.getCreationDate())) && (this.getName() == null ? b.getName() == null : this.getName().equals(b.getName())) && (this.getLastVisitDate() == null ? b.getLastVisitDate() == null : this.getLastVisitDate().equals(b.getLastVisitDate())) && this.getPopularity() == b.getPopularity() && this.fIsErrorLoading == b.fIsErrorLoading && (this.getProperties() == null ? b.getProperties() == null : this.getProperties().equals(b.getProperties()));
        }
    }

    @Override
    public BookMarkReference toReference() {
        return new BookMarkReference(this.getIdAsPrimitive());
    }

    @Override
    public synchronized List<INews> getNews() {
        return this.getFeedLinkReference().resolve().getNews();
    }

    @Override
    public List<INews> getNews(Set<INews.State> states) {
        if (states.equals(EnumSet.of(INews.State.NEW))) {
            return (List)DynamicDAO.getDAO(INewsDAO.class).loadAll(this.getFeedLinkReference(), states);
        }
        if (states.equals(EnumSet.of(INews.State.NEW, INews.State.UNREAD, INews.State.UPDATED))) {
            return (List)DynamicDAO.getDAO(INewsDAO.class).loadAll(this.getFeedLinkReference(), states);
        }
        return this.getFeedLinkReference().resolve().getNewsByStates(states);
    }

    @Override
    public synchronized int getNewsCount(Set<INews.State> states) {
        if (this.fNewsCounter != null) {
            if (states.equals(EnumSet.of(INews.State.NEW))) {
                return this.fNewsCounter.getNewCount(this.fFeedLink);
            }
            if (states.equals(EnumSet.of(INews.State.NEW, INews.State.UNREAD, INews.State.UPDATED))) {
                return this.fNewsCounter.getUnreadCount(this.fFeedLink);
            }
        }
        return this.getNews(states).size();
    }

    @Override
    public List<NewsReference> getNewsRefs() {
        return this.getNewsRefs(EnumSet.allOf(INews.State.class));
    }

    @Override
    public List<NewsReference> getNewsRefs(Set<INews.State> states) {
        List<INews> news = this.getNews(states);
        ArrayList<NewsReference> newsRefs = new ArrayList<NewsReference>();
        for (INews newsItem : news) {
            newsRefs.add(new NewsReference(newsItem.getId()));
        }
        return newsRefs;
    }

    @Override
    public boolean isGetNewsRefsEfficient() {
        return false;
    }

    @Override
    public boolean containsNews(INews news) {
        return news.getParentId() == 0L && news.getFeedLinkAsText().equals(this.fFeedLink);
    }

    @Override
    public synchronized int getStickyNewsCount() {
        if (this.fNewsCounter != null) {
            return this.fNewsCounter.getStickyCount(this.fFeedLink);
        }
        int stickyCount = 0;
        for (INews news : this.getNews()) {
            if (!news.isFlagged()) continue;
            ++stickyCount;
        }
        return stickyCount;
    }

    @Override
    public synchronized String toLongString() {
        return String.valueOf(super.toString()) + ", Is Error Loading: " + this.fIsErrorLoading + ", Belongs " + "to Feed = " + this.fFeedLink + ")";
    }

    @Override
    public synchronized String toString() {
        return String.valueOf(super.toString()) + "Belongs to Feed = " + this.fFeedLink + ")";
    }
}

