/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.persist;

import java.net.URI;
import org.eclipse.core.runtime.Assert;
import org.rssowl.core.internal.persist.MergeResult;
import org.rssowl.core.internal.persist.Persistable;
import org.rssowl.core.persist.IImage;
import org.rssowl.core.util.MergeUtils;

public class Image
extends Persistable
implements IImage {
    private String fLink;
    private String fTitle;
    private String fHomepage;
    private int fWidth;
    private int fHeight;
    private String fDescription;

    public Image() {
    }

    public Image(URI link) {
        if (link != null) {
            this.fLink = link.toString();
        }
    }

    public synchronized void setLink(URI link) {
        if (link != null) {
            this.fLink = link.toString();
        }
    }

    public synchronized void setTitle(String title) {
        this.fTitle = title;
    }

    public synchronized void setHomepage(URI homepage) {
        this.fHomepage = this.getURIText(homepage);
    }

    public synchronized void setWidth(int width) {
        this.fWidth = width;
    }

    public synchronized void setHeight(int height) {
        this.fHeight = height;
    }

    public synchronized void setDescription(String description) {
        this.fDescription = description;
    }

    public synchronized String getDescription() {
        return this.fDescription;
    }

    public synchronized int getHeight() {
        return this.fHeight;
    }

    public synchronized URI getHomepage() {
        return this.createURI(this.fHomepage);
    }

    public synchronized String getTitle() {
        return this.fTitle;
    }

    public synchronized URI getLink() {
        return this.createURI(this.fLink);
    }

    public synchronized int getWidth() {
        return this.fWidth;
    }

    public synchronized int hashCode() {
        int result = 1;
        result = 31 * result + (this.fDescription == null ? 0 : this.fDescription.hashCode());
        result = 31 * result + this.fHeight;
        result = 31 * result + (this.fHomepage == null ? 0 : this.fHomepage.hashCode());
        result = 31 * result + (this.fTitle == null ? 0 : this.fTitle.hashCode());
        result = 31 * result + (this.fLink == null ? 0 : this.fLink.hashCode());
        result = 31 * result + this.fWidth;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean equals(Object image) {
        if (this == image) {
            return true;
        }
        if (!(image instanceof Image)) {
            return false;
        }
        Object object = image;
        synchronized (object) {
            Image i = (Image)image;
            return (this.fLink == null ? i.fLink == null : this.fLink.equals(i.fLink)) && (this.fDescription == null ? i.fDescription == null : this.fDescription.equals(i.fDescription)) && this.fHeight == i.fHeight && this.fWidth == i.fWidth && (this.fHomepage == null ? i.fHomepage == null : this.fHomepage.equals(i.fHomepage)) && (this.fTitle == null ? i.fTitle == null : this.fTitle.equals(i.fTitle));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized MergeResult merge(IImage objectToMerge) {
        Assert.isNotNull((Object)objectToMerge);
        IImage iImage = objectToMerge;
        synchronized (iImage) {
            boolean updated = !this.simpleFieldsEqual(objectToMerge);
            this.fHeight = objectToMerge.getHeight();
            this.setHomepage(objectToMerge.getHomepage());
            this.fTitle = objectToMerge.getTitle();
            this.setLink(objectToMerge.getLink());
            this.fWidth = objectToMerge.getWidth();
            this.fDescription = objectToMerge.getDescription();
            MergeResult mergeResult = new MergeResult();
            if (updated) {
                mergeResult.addUpdatedObject(this);
            }
            return mergeResult;
        }
    }

    private boolean simpleFieldsEqual(IImage image) {
        return this.fHeight == image.getHeight() && MergeUtils.equals(this.getHomepage(), image.getHomepage()) && MergeUtils.equals(this.fTitle, image.getTitle()) && MergeUtils.equals(this.getLink(), image.getLink()) && MergeUtils.equals(this.fWidth, image.getWidth()) && MergeUtils.equals(this.fDescription, image.getDescription());
    }

    public synchronized String toString() {
        return String.valueOf(super.toString()) + "Link = " + this.fLink + ")";
    }

    public synchronized String toLongString() {
        return String.valueOf(super.toString()) + "Link = " + this.fLink + ", Title = " + this.fTitle + ", Homepage = " + this.fHomepage + ", Width = " + this.fWidth + ", Height = " + this.fHeight + ", Description = " + this.fDescription + ")";
    }
}

