/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.persist;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.rssowl.core.internal.persist.AbstractEntity;
import org.rssowl.core.persist.IFolder;
import org.rssowl.core.persist.IMark;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.reference.NewsReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Mark
extends AbstractEntity
implements IMark {
    private String fName;
    private Date fCreationDate;
    private Date fLastVisitDate;
    private int fPopularity;
    private IFolder fParent;

    protected Mark(Long id, IFolder parent, String name) {
        super(id);
        Assert.isNotNull((Object)parent, (String)"The type Mark requires a Folder that is not NULL");
        this.fParent = parent;
        Assert.isNotNull((Object)name, (String)"The type Mark requires a Name that is not NULL");
        this.fName = name;
        this.fCreationDate = new Date();
    }

    protected Mark() {
    }

    @Override
    public synchronized Date getLastVisitDate() {
        return this.fLastVisitDate;
    }

    @Override
    public synchronized void setLastVisitDate(Date lastVisitDate) {
        this.fLastVisitDate = lastVisitDate;
    }

    @Override
    public synchronized int getPopularity() {
        return this.fPopularity;
    }

    @Override
    public synchronized void setPopularity(int popularity) {
        this.fPopularity = popularity;
    }

    @Override
    public synchronized Date getCreationDate() {
        return this.fCreationDate;
    }

    @Override
    public synchronized void setCreationDate(Date creationDate) {
        this.fCreationDate = creationDate;
    }

    @Override
    public synchronized String getName() {
        return this.fName;
    }

    @Override
    public synchronized void setName(String name) {
        Assert.isNotNull((Object)name, (String)"The type Mark requires a Name that is not NULL");
        this.fName = name;
    }

    @Override
    public synchronized IFolder getParent() {
        return this.fParent;
    }

    @Override
    public synchronized void setParent(IFolder parent) {
        Assert.isNotNull((Object)parent, (String)"parent");
        this.fParent = parent;
    }

    protected static List<INews> getNews(List<NewsReference> newsRefs) {
        ArrayList<INews> news = new ArrayList<INews>(newsRefs.size());
        for (NewsReference newsRef : newsRefs) {
            INews newsItem = newsRef.resolve();
            if (newsItem == null) continue;
            news.add(newsItem);
        }
        return news;
    }

    @Override
    public synchronized String toString() {
        return String.valueOf(super.toString()) + "Name = " + this.fName + ", ";
    }

    public synchronized String toLongString() {
        String retValue = String.valueOf(super.toString()) + "Name = " + this.fName + ", Creation Date = " + this.fCreationDate + ", Popularity: " + this.getPopularity();
        if (this.getLastVisitDate() != null) {
            retValue = String.valueOf(retValue) + DateFormat.getDateTimeInstance().format(this.getLastVisitDate());
        }
        return String.valueOf(retValue) + ", Belongs to Folder = " + this.fParent.getId() + ", ";
    }
}

