/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.persist;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.rssowl.core.persist.IEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeResult {
    private Set<Object> fRemovedObjects;
    private Set<Object> fUpdatedObjects;

    public final Set<Object> getRemovedObjects() {
        if (this.fRemovedObjects == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.fRemovedObjects);
    }

    public final Set<Object> getUpdatedObjects() {
        if (this.fUpdatedObjects == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.fUpdatedObjects);
    }

    public final void addAll(MergeResult mergeResult) {
        Assert.isNotNull((Object)mergeResult, (String)"mergeResult");
        this.fRemovedObjects = this.addAll(this.fRemovedObjects, mergeResult.getRemovedObjects());
        this.fUpdatedObjects = this.addAll(this.fUpdatedObjects, mergeResult.getUpdatedObjects());
    }

    private Set<Object> addAll(Set<Object> entities, Set<Object> entitiesToAdd) {
        if (entities == null) {
            entities = new HashSet<Object>(entitiesToAdd);
        } else {
            entities.addAll(entitiesToAdd);
        }
        return entities;
    }

    public final void addUpdatedObject(Object object) {
        if (this.getRemovedObjects().contains(object)) {
            return;
        }
        if (this.fUpdatedObjects == null) {
            this.fUpdatedObjects = new HashSet<Object>(3);
        }
        this.fUpdatedObjects.add(object);
    }

    private void checkArgument(Object entity) {
        if (entity instanceof IEntity) {
            Assert.isNotNull((Object)((IEntity)entity).getId(), (String)"entity.getId()");
        }
    }

    public final void addRemovedObject(Object object) {
        this.checkArgument(object);
        if (this.fRemovedObjects == null) {
            this.fRemovedObjects = new HashSet<Object>(3);
        }
        if (this.getUpdatedObjects().contains(object)) {
            this.fUpdatedObjects.remove(object);
        }
        this.fRemovedObjects.add(object);
    }

    public final boolean isEmpty() {
        return this.getRemovedObjects().isEmpty() && this.getUpdatedObjects().isEmpty();
    }
}

