/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.persist;

import java.io.Serializable;
import java.net.URI;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.core.runtime.Assert;
import org.rssowl.core.internal.persist.AbstractEntity;
import org.rssowl.core.internal.persist.Attachment;
import org.rssowl.core.internal.persist.Category;
import org.rssowl.core.internal.persist.ComplexMergeResult;
import org.rssowl.core.internal.persist.Description;
import org.rssowl.core.internal.persist.DescriptionReference;
import org.rssowl.core.internal.persist.Guid;
import org.rssowl.core.internal.persist.MergeResult;
import org.rssowl.core.internal.persist.Person;
import org.rssowl.core.internal.persist.Source;
import org.rssowl.core.persist.IAttachment;
import org.rssowl.core.persist.ICategory;
import org.rssowl.core.persist.IFeed;
import org.rssowl.core.persist.IGuid;
import org.rssowl.core.persist.ILabel;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.IPerson;
import org.rssowl.core.persist.ISource;
import org.rssowl.core.persist.reference.FeedLinkReference;
import org.rssowl.core.persist.reference.NewsReference;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.core.util.MergeUtils;
import org.rssowl.core.util.StringUtils;
import org.rssowl.core.util.SyncUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class News
extends AbstractEntity
implements INews {
    private String fTitle;
    private String fLinkText;
    private String fBaseUri;
    private Date fReceiveDate;
    private Date fPublishDate;
    private Date fModifiedDate;
    private String fComments;
    private String fInReplyTo;
    private boolean fIsFlagged;
    private int fRating;
    private int fStateOrdinal = INews.State.NEW.ordinal();
    private String fGuidValue;
    private transient IGuid fGuid;
    private boolean fGuidIsPermaLink;
    private ISource fSource;
    private String fFeedLink;
    private IPerson fAuthor;
    private List<IAttachment> fAttachments;
    private List<ICategory> fCategories;
    private Set<ILabel> fLabels;
    private long fParentId;
    private transient String fTransientDescription;
    private transient boolean fTransientDescriptionSet;
    private final transient Lock fLock = new Lock();

    public News(IFeed feed) {
        super(null);
        Assert.isNotNull((Object)feed, (String)"The type News requires a Feed that is not NULL");
        this.fFeedLink = feed.getLink().toString();
        this.fReceiveDate = new Date();
        this.init();
    }

    public News(Long id, IFeed feed, Date receiveDate) {
        super(id);
        Assert.isNotNull((Object)feed, (String)"The type News requires a Feed that is not NULL");
        this.fFeedLink = feed.getLink().toString();
        Assert.isNotNull((Object)receiveDate, (String)"The type News requires a ReceiveDate that is not NULL");
        this.fReceiveDate = receiveDate;
        this.init();
    }

    public News(News news, long parentId) {
        super(null, news);
        this.fParentId = parentId;
        news.fLock.acquireReadLock();
        try {
            for (IAttachment attachment : news.getAttachments()) {
                this.addAttachment(new Attachment(attachment, (INews)this));
            }
            if (news.getAuthor() != null) {
                this.fAuthor = new Person(news.getAuthor());
            }
            this.fBaseUri = news.fBaseUri;
            for (ICategory category : news.getCategories()) {
                this.addCategory(new Category(category));
            }
            this.setDescription(news.getDescription());
            this.fComments = news.fComments;
            this.fFeedLink = news.fFeedLink;
            this.setGuid(news.getGuid());
            this.fInReplyTo = news.fInReplyTo;
            this.fIsFlagged = news.fIsFlagged;
            this.fLabels = news.fLabels == null ? null : new HashSet<ILabel>(news.fLabels);
            this.fLinkText = news.fLinkText;
            if (news.fModifiedDate != null) {
                this.fModifiedDate = new Date(news.fModifiedDate.getTime());
            }
            if (news.fPublishDate != null) {
                this.fPublishDate = new Date(news.fPublishDate.getTime());
            }
            this.fRating = news.fRating;
            if (news.fReceiveDate != null) {
                this.fReceiveDate = new Date(news.fReceiveDate.getTime());
            }
            if (news.getSource() != null) {
                this.fSource = new Source(news.getSource());
            }
            this.fStateOrdinal = news.fStateOrdinal;
            this.fTitle = news.fTitle;
        }
        finally {
            news.fLock.releaseReadLock();
        }
        this.init();
    }

    protected News() {
    }

    public final void init() {
        this.fLock.acquireWriteLock();
        try {
            if (this.fGuidValue != null) {
                this.fGuid = new Guid(this.fGuidValue, this.fGuidIsPermaLink);
            }
        }
        finally {
            this.fLock.releaseWriteLock();
        }
    }

    public final void acquireReadLockSpecial() {
        this.fLock.acquireReadLockSpecial();
    }

    public final void releaseReadLockSpecial() {
        this.fLock.releaseReadLockSpecial();
    }

    private <T> Boolean isEquivalentCompare(T o1, T o2) {
        if (o1 == null && o2 == null) {
            return null;
        }
        return this.equals(o1, o2);
    }

    @Override
    public Map<String, Serializable> getProperties() {
        this.fLock.acquireReadLock();
        try {
            Map<String, Serializable> map = super.getProperties();
            return map;
        }
        finally {
            this.fLock.releaseReadLock();
        }
    }

    @Override
    public Object getProperty(String key) {
        this.fLock.acquireReadLock();
        try {
            Object object = super.getProperty(key);
            return object;
        }
        finally {
            this.fLock.releaseReadLock();
        }
    }

    @Override
    public Object removeProperty(String key) {
        this.fLock.acquireWriteLock();
        try {
            Object object = super.removeProperty(key);
            return object;
        }
        finally {
            this.fLock.releaseWriteLock();
        }
    }

    @Override
    public void setProperty(String key, Serializable value) {
        this.fLock.acquireWriteLock();
        try {
            super.setProperty(key, value);
        }
        finally {
            this.fLock.releaseWriteLock();
        }
    }

    private boolean equals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    @Override
    public boolean isEquivalent(INews o) {
        News other = (News)o;
        this.fLock.acquireReadLock();
        other.fLock.acquireReadLock();
        try {
            Assert.isNotNull((Object)other, (String)"other cannot be null");
            Boolean guidMatch = this.isEquivalentCompare(this.slashTrim(this.fGuidValue), this.slashTrim(other.fGuidValue));
            if (guidMatch != null && guidMatch.equals(Boolean.FALSE) && (this.fGuidValue == null || this.fGuidIsPermaLink) && (other.fGuidValue == null || other.fGuidIsPermaLink)) {
                return false;
            }
            if (guidMatch != null && guidMatch.equals(Boolean.TRUE)) {
                return true;
            }
            Boolean linkMatch = this.isEquivalentCompare(this.slashTrim(this.fLinkText), this.slashTrim(other.fLinkText));
            if (linkMatch != null) {
                return linkMatch.equals(Boolean.TRUE);
                {
                }
            }
            if (!this.fFeedLink.equals(other.fFeedLink)) {
                return false;
            }
            Boolean titleMatch = this.isEquivalentCompare(this.fTitle, other.fTitle);
            return titleMatch != null && titleMatch.equals(Boolean.TRUE);
            {
            }
        }
        finally {
            this.fLock.releaseReadLock();
            other.fLock.releaseReadLock();
        }
    }

    private String slashTrim(String str) {
        if (StringUtils.isSet(str) && str.length() > 1 && str.charAt(str.length() - 1) == '/') {
            return str.substring(0, str.length() - 1);
        }
        return str;
    }

    @Override
    public void addAttachment(IAttachment attachment) {
        Assert.isNotNull((Object)attachment, (String)"Exception adding NULL as Attachment into News");
        this.fLock.acquireWriteLock();
        try {
            if (this.fAttachments == null) {
                this.fAttachments = new ArrayList<IAttachment>(1);
            }
            Assert.isTrue((boolean)this.equals(attachment.getNews()), (String)"The Attachment has a different News set!");
            this.fAttachments.add(attachment);
        }
        finally {
            this.fLock.releaseWriteLock();
        }
    }

    @Override
    public Set<ILabel> getLabels() {
        this.fLock.acquireReadLock();
        try {
            if (this.fLabels == null) {
                HashSet<ILabel> hashSet = new HashSet<ILabel>(0);
                return hashSet;
            }
            HashSet<ILabel> labels = new HashSet<ILabel>(this.fLabels.size());
            for (ILabel label : this.fLabels) {
                if (label == null) continue;
                labels.add(label);
            }
            HashSet<ILabel> hashSet = labels;
            return hashSet;
        }
        finally {
            this.fLock.releaseReadLock();
        }
    }

    @Override
    public boolean addLabel(ILabel label) {
        Assert.isNotNull((Object)label, (String)"label");
        this.fLock.acquireWriteLock();
        try {
            if (this.fLabels == null) {
                this.fLabels = new HashSet<ILabel>(1);
            }
            boolean bl = this.fLabels.add(label);
            return bl;
        }
        finally {
            this.fLock.releaseWriteLock();
        }
    }

    void clearLabels() {
        this.fLock.acquireWriteLock();
        try {
            if (this.fLabels == null) {
                return;
            }
            this.fLabels.clear();
        }
        finally {
            this.fLock.releaseWriteLock();
        }
    }

    @Override
    public boolean removeLabel(ILabel label) {
        Assert.isNotNull((Object)label, (String)"label");
        this.fLock.acquireWriteLock();
        try {
            if (this.fLabels == null) {
                return false;
            }
            boolean bl = this.fLabels.remove(label);
            return bl;
        }
        finally {
            this.fLock.releaseWriteLock();
        }
    }

    @Override
    public List<IAttachment> getAttachments() {
        this.fLock.acquireReadLock();
        try {
            if (this.fAttachments == null) {
                ArrayList<IAttachment> arrayList = new ArrayList<IAttachment>(0);
                return arrayList;
            }
            ArrayList<IAttachment> arrayList = new ArrayList<IAttachment>(this.fAttachments);
            return arrayList;
        }
        finally {
            this.fLock.releaseReadLock();
        }
    }

    @Override
    public IPerson getAuthor() {
        this.fLock.acquireReadLock();
        try {
            IPerson iPerson = this.fAuthor;
            return iPerson;
        }
        finally {
            this.fLock.releaseReadLock();
        }
    }

    @Override
    public void setAuthor(IPerson author) {
        this.fLock.acquireWriteLock();
        try {
            this.fAuthor = author;
        }
        finally {
            this.fLock.releaseWriteLock();
        }
    }

    @Override
    public String getDescription() {
        this.fLock.acquireReadLock();
        try {
            if (this.fTransientDescriptionSet) {
                String string = this.fTransientDescription;
                return string;
            }
        }
        finally {
            this.fLock.releaseReadLock();
        }
        if (this.getId() == null) {
            return null;
        }
        Description description = this.loadDescription();
        return description == null ? null : description.getValue();
    }

    @Override
    public void setDescription(String description) {
        this.fLock.acquireWriteLock();
        try {
            this.fTransientDescription = description;
            this.fTransientDescriptionSet = true;
        }
        finally {
            this.fLock.releaseWriteLock();
        }
    }

    @Override
    public URI getLink() {
        this.fLock.acquireReadLock();
        try {
            URI uRI = this.fLinkText == null ? null : this.createURI(this.fLinkText);
            return uRI;
        }
        finally {
            this.fLock.releaseReadLock();
        }
    }

    @Override
    public void setLink(URI link) {
        this.fLock.acquireWriteLock();
        try {
            this.fLinkText = link == null ? null : link.toString();
        }
        finally {
            this.fLock.releaseWriteLock();
        }
    }

    @Override
    public Date getPublishDate() {
        this.fLock.acquireReadLock();
        try {
            Date date = this.fPublishDate;
            return date;
        }
        finally {
            this.fLock.releaseReadLock();
        }
    }

    @Override
    public void setPublishDate(Date publishDate) {
        this.fLock.acquireWriteLock();
        try {
            this.fPublishDate = publishDate;
        }
        finally {
            this.fLock.releaseWriteLock();
        }
    }

    @Override
    public String getTitle() {
        this.fLock.acquireReadLock();
        try {
            String string = this.fTitle;
            return string;
        }
        finally {
            this.fLock.releaseReadLock();
        }
    }

    @Override
    public void setTitle(String title) {
        this.fLock.acquireWriteLock();
        try {
            this.fTitle = title;
        }
        finally {
            this.fLock.releaseWriteLock();
        }
    }

    @Override
    public FeedLinkReference getFeedReference() {
        this.fLock.acquireReadLock();
        try {
            FeedLinkReference feedLinkReference = this.fFeedLink == null ? null : new FeedLinkReference(this.createURI(this.fFeedLink));
            return feedLinkReference;
        }
        finally {
            this.fLock.releaseReadLock();
        }
    }

    @Override
    public void setReceiveDate(Date receiveDate) {
        this.fLock.acquireWriteLock();
        try {
            this.fReceiveDate = receiveDate;
        }
        finally {
            this.fLock.releaseWriteLock();
        }
    }

    @Override
    public Date getReceiveDate() {
        this.fLock.acquireReadLock();
        try {
            Date date = this.fReceiveDate;
            return date;
        }
        finally {
            this.fLock.releaseReadLock();
        }
    }

    @Override
    public void setComments(String comments) {
        this.fLock.acquireWriteLock();
        try {
            this.fComments = comments;
        }
        finally {
            this.fLock.releaseWriteLock();
        }
    }

    @Override
    public void setGuid(IGuid guid) {
        this.fLock.acquireWriteLock();
        try {
            this.fGuid = guid;
            this.fGuidValue = guid == null ? null : guid.getValue();
            this.fGuidIsPermaLink = guid == null ? false : guid.isPermaLink();
        }
        finally {
            this.fLock.releaseWriteLock();
        }
    }

    @Override
    public void setSource(ISource source) {
        this.fLock.acquireWriteLock();
        try {
            this.fSource = source;
        }
        finally {
            this.fLock.releaseWriteLock();
        }
    }

    @Override
    public void setInReplyTo(String guid) {
        this.fLock.acquireWriteLock();
        try {
            this.fInReplyTo = guid;
        }
        finally {
            this.fLock.releaseWriteLock();
        }
    }

    @Override
    public void setModifiedDate(Date modifiedDate) {
        this.fLock.acquireWriteLock();
        try {
            this.fModifiedDate = modifiedDate;
        }
        finally {
            this.fLock.releaseWriteLock();
        }
    }

    @Override
    public Date getModifiedDate() {
        this.fLock.acquireReadLock();
        try {
            Date date = this.fModifiedDate;
            return date;
        }
        finally {
            this.fLock.releaseReadLock();
        }
    }

    public Date fastGetRecentDate() {
        if (this.fModifiedDate != null) {
            return this.fModifiedDate;
        }
        if (this.fPublishDate != null) {
            return this.fPublishDate;
        }
        return this.fReceiveDate;
    }

    @Override
    public void addCategory(ICategory category) {
        this.fLock.acquireWriteLock();
        try {
            if (this.fCategories == null) {
                this.fCategories = new ArrayList<ICategory>(1);
            }
            this.fCategories.add(category);
        }
        finally {
            this.fLock.releaseWriteLock();
        }
    }

    @Override
    public String getComments() {
        this.fLock.acquireReadLock();
        try {
            String string = this.fComments;
            return string;
        }
        finally {
            this.fLock.releaseReadLock();
        }
    }

    @Override
    public boolean isFlagged() {
        this.fLock.acquireReadLock();
        try {
            boolean bl = this.fIsFlagged;
            return bl;
        }
        finally {
            this.fLock.releaseReadLock();
        }
    }

    @Override
    public void setFlagged(boolean isFlagged) {
        this.fLock.acquireWriteLock();
        try {
            this.fIsFlagged = isFlagged;
        }
        finally {
            this.fLock.releaseWriteLock();
        }
    }

    @Override
    public IGuid getGuid() {
        this.fLock.acquireReadLock();
        try {
            IGuid iGuid = this.fGuid;
            return iGuid;
        }
        finally {
            this.fLock.releaseReadLock();
        }
    }

    @Override
    public void setBase(URI baseUri) {
        this.fLock.acquireWriteLock();
        try {
            this.fBaseUri = this.getURIText(baseUri);
        }
        finally {
            this.fLock.releaseWriteLock();
        }
    }

    @Override
    public URI getBase() {
        this.fLock.acquireReadLock();
        try {
            URI uRI = this.createURI(this.fBaseUri);
            return uRI;
        }
        finally {
            this.fLock.releaseReadLock();
        }
    }

    @Override
    public List<ICategory> getCategories() {
        this.fLock.acquireReadLock();
        try {
            if (this.fCategories == null) {
                ArrayList<ICategory> arrayList = new ArrayList<ICategory>(0);
                return arrayList;
            }
            ArrayList<ICategory> arrayList = new ArrayList<ICategory>(this.fCategories);
            return arrayList;
        }
        finally {
            this.fLock.releaseReadLock();
        }
    }

    @Override
    public void setState(INews.State state) {
        Assert.isNotNull((Object)((Object)state), (String)"state cannot be null");
        this.fLock.acquireWriteLock();
        try {
            this.fStateOrdinal = state.ordinal();
        }
        finally {
            this.fLock.releaseWriteLock();
        }
    }

    @Override
    public INews.State getState() {
        this.fLock.acquireReadLock();
        try {
            INews.State state = INews.State.getState(this.fStateOrdinal);
            return state;
        }
        finally {
            this.fLock.releaseReadLock();
        }
    }

    @Override
    public void setRating(int rating) {
        this.fLock.acquireWriteLock();
        try {
            this.fRating = rating;
        }
        finally {
            this.fLock.releaseWriteLock();
        }
    }

    @Override
    public int getRating() {
        this.fLock.acquireReadLock();
        try {
            int n = this.fRating;
            return n;
        }
        finally {
            this.fLock.releaseReadLock();
        }
    }

    @Override
    public ISource getSource() {
        this.fLock.acquireReadLock();
        try {
            ISource iSource = this.fSource;
            return iSource;
        }
        finally {
            this.fLock.releaseReadLock();
        }
    }

    @Override
    public String getInReplyTo() {
        this.fLock.acquireReadLock();
        try {
            String string = this.fInReplyTo;
            return string;
        }
        finally {
            this.fLock.releaseReadLock();
        }
    }

    @Override
    public boolean isVisible() {
        INews.State state = this.getState();
        return INews.State.getVisible().contains((Object)state);
    }

    @Override
    public void setParent(IFeed feed) {
        Assert.isNotNull((Object)feed, (String)"feed");
        this.fLock.acquireWriteLock();
        try {
            this.fFeedLink = feed.getLink().toString();
        }
        finally {
            this.fLock.releaseWriteLock();
        }
    }

    @Override
    public void removeAttachment(IAttachment attachment) {
        this.fLock.acquireWriteLock();
        try {
            if (this.fAttachments != null) {
                this.fAttachments.remove(attachment);
            }
        }
        finally {
            this.fLock.releaseWriteLock();
        }
    }

    @Override
    public long getParentId() {
        this.fLock.acquireReadLock();
        try {
            long l = this.fParentId;
            return l;
        }
        finally {
            this.fLock.releaseReadLock();
        }
    }

    public Description loadDescription() {
        return new DescriptionReference(this.getIdAsPrimitive()).resolve();
    }

    public String getTransientDescription() {
        this.fLock.acquireReadLock();
        try {
            String string = this.fTransientDescription;
            return string;
        }
        finally {
            this.fLock.releaseReadLock();
        }
    }

    public void clearTransientDescription() {
        this.fLock.acquireWriteLock();
        try {
            this.fTransientDescription = null;
            this.fTransientDescriptionSet = false;
        }
        finally {
            this.fLock.releaseWriteLock();
        }
    }

    public boolean isTransientDescriptionSet() {
        return this.fTransientDescriptionSet;
    }

    @Override
    public String getFeedLinkAsText() {
        return this.fFeedLink;
    }

    @Override
    public String getLinkAsText() {
        return this.fLinkText;
    }

    public boolean isIdentical(INews news) {
        if (this == news) {
            return true;
        }
        if (!(news instanceof News)) {
            return false;
        }
        News n = (News)news;
        this.fLock.acquireReadLock();
        n.fLock.acquireReadLock();
        try {
            boolean bl = (this.getId() == null ? n.getId() == null : this.getId().equals(n.getId())) && this.fFeedLink.equals(n.fFeedLink) && this.simpleFieldsEqual(n) && (this.fReceiveDate == null ? n.fReceiveDate == null : this.fReceiveDate.equals(n.fReceiveDate)) && (this.getGuid() == null ? n.getGuid() == null : this.getGuid().equals(n.getGuid())) && (this.fSource == null ? n.fSource == null : this.fSource.equals(n.fSource)) && (this.fInReplyTo == null ? n.fInReplyTo == null : this.fInReplyTo.equals(n.fInReplyTo)) && this.getLabels().equals(n.getLabels()) && (this.getAuthor() == null ? n.getAuthor() == null : this.getAuthor().equals(n.getAuthor())) && this.getAttachments().equals(n.getAttachments()) && this.getCategories().equals(n.getCategories()) && this.getState() == n.getState() && this.fIsFlagged == n.fIsFlagged && this.fRating == n.fRating && (this.getProperties() == null ? n.getProperties() == null : this.getProperties().equals(n.getProperties()));
            return bl;
        }
        finally {
            this.fLock.releaseReadLock();
            n.fLock.releaseReadLock();
        }
    }

    private boolean simpleFieldsEqual(News news) {
        return MergeUtils.equals(this.fBaseUri, news.fBaseUri) && MergeUtils.equals(this.fComments, news.fComments) && MergeUtils.equals(this.fLinkText, news.fLinkText) && MergeUtils.equals(this.fModifiedDate, news.fModifiedDate) && MergeUtils.equals(this.fPublishDate, news.fPublishDate) && MergeUtils.equals(this.fInReplyTo, news.fInReplyTo) && MergeUtils.equals(this.fTitle, news.fTitle);
    }

    @Override
    public MergeResult merge(INews news) {
        Assert.isNotNull((Object)news, (String)"news cannot be null");
        if (this == news) {
            Assert.isLegal((this != news ? 1 : 0) != 0, (String)("Trying to merge the same news, this is most likely a mistake, news: " + news));
        }
        News n = (News)news;
        n.fLock.acquireReadLock();
        try {
            this.fLock.acquireWriteLock();
            try {
                boolean isSynchronized = SyncUtils.isSynchronized(this);
                boolean wasModified = !MergeUtils.equals(this.fModifiedDate, n.fModifiedDate) || !MergeUtils.equals(this.fPublishDate, n.fPublishDate) || !MergeUtils.equals(this.fTitle, n.fTitle);
                boolean onlyMergeUserState = isSynchronized && !wasModified;
                boolean updated = this.mergeState(news);
                if (this.isVisible() && isSynchronized) {
                    updated |= this.mergeLabels(n);
                    updated |= this.fIsFlagged ^ n.fIsFlagged;
                    this.fIsFlagged = n.fIsFlagged;
                }
                MergeResult newsMergeResult = new MergeResult();
                ComplexMergeResult<?> propertiesMergeResult = null;
                if (!onlyMergeUserState) {
                    updated |= this.processListMergeResult(newsMergeResult, this.mergeAttachments(n.fAttachments));
                    updated |= this.processListMergeResult(newsMergeResult, this.mergeCategories(n.fCategories));
                    updated |= this.processListMergeResult(newsMergeResult, this.mergeAuthor(n.fAuthor));
                    updated |= this.mergeGuid(n.fGuid);
                    if (wasModified) {
                        this.mergeDescription(newsMergeResult, n);
                    }
                    updated |= this.processListMergeResult(newsMergeResult, this.mergeSource(n.fSource));
                    updated |= !this.simpleFieldsEqual(n);
                    this.fBaseUri = n.fBaseUri;
                    this.fComments = n.fComments;
                    this.fLinkText = n.fLinkText;
                    this.fModifiedDate = n.fModifiedDate;
                    this.fPublishDate = n.fPublishDate;
                    this.fTitle = n.fTitle;
                    this.fInReplyTo = n.fInReplyTo;
                    propertiesMergeResult = MergeUtils.mergeProperties(this, news);
                }
                if (updated || propertiesMergeResult != null && propertiesMergeResult.isStructuralChange()) {
                    newsMergeResult.addUpdatedObject(this);
                    if (propertiesMergeResult != null) {
                        newsMergeResult.addAll(propertiesMergeResult);
                    }
                }
                MergeResult mergeResult = newsMergeResult;
                this.fLock.releaseWriteLock();
                return mergeResult;
            }
            catch (Throwable throwable) {
                this.fLock.releaseWriteLock();
                throw throwable;
            }
        }
        finally {
            n.fLock.releaseReadLock();
        }
    }

    private boolean areEqual(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    private void mergeDescription(MergeResult result, News news) {
        String newsDescription = null;
        newsDescription = news.getId() == null ? news.fTransientDescription : news.getDescription();
        Description description = this.loadDescription();
        boolean descriptionUpdated = false;
        if (description == null) {
            description = new Description(this, null);
        }
        if (this.fTransientDescriptionSet && !this.areEqual(description.getValue(), this.fTransientDescription)) {
            description.setDescription(this.fTransientDescription);
            descriptionUpdated = true;
        }
        if (!this.areEqual(description.getValue(), newsDescription)) {
            this.setDescription(newsDescription);
            description.setDescription(newsDescription);
            descriptionUpdated = true;
        }
        if (descriptionUpdated) {
            if (description.getValue() == null) {
                result.addRemovedObject(description);
            } else {
                result.addUpdatedObject(description);
            }
        }
    }

    private boolean mergeState(INews news) {
        INews.State otherState;
        INews.State thisState = this.getState();
        if (thisState != (otherState = this.getState(news)) && otherState != INews.State.NEW) {
            this.setState(otherState);
            return true;
        }
        if (this.isUpdated(news)) {
            this.setState(INews.State.UPDATED);
            return true;
        }
        return false;
    }

    private INews.State getState(INews news) {
        if (this.isVisible() && SyncUtils.isSynchronized(news)) {
            if (news.getProperty("org.rssowl.pref.GoogleMarkedRead") != null) {
                return INews.State.READ;
            }
            if (news.getProperty("org.rssowl.pref.GoogleMarkedUnRead") != null) {
                return INews.State.UNREAD;
            }
        }
        return news.getState();
    }

    private boolean isUpdated(INews news) {
        INews.State thisState = this.getState();
        if (thisState != INews.State.READ && thisState != INews.State.UNREAD) {
            return false;
        }
        if (SyncUtils.isSynchronized(this)) {
            return false;
        }
        String title = news.getTitle();
        return this.fTitle == null ? title != null : !this.fTitle.equals(title);
    }

    private boolean mergeGuid(IGuid guid) {
        if (this.fGuid == null && guid == null) {
            return false;
        }
        if (this.fGuid == null || guid == null || !this.areGuidsIdentical(this.fGuid, guid)) {
            this.setGuid(guid);
            return true;
        }
        return false;
    }

    private boolean areGuidsIdentical(IGuid g0, IGuid g1) {
        return g0.getValue().equals(g1.getValue()) && g0.isPermaLink() == g1.isPermaLink();
    }

    private ComplexMergeResult<ISource> mergeSource(ISource source) {
        ComplexMergeResult<ISource> mergeResult = MergeUtils.merge(this.fSource, source);
        this.fSource = mergeResult.getMergedObject();
        return mergeResult;
    }

    private ComplexMergeResult<IPerson> mergeAuthor(IPerson author) {
        ComplexMergeResult<IPerson> mergeResult = MergeUtils.merge(this.fAuthor, author);
        this.fAuthor = mergeResult.getMergedObject();
        return mergeResult;
    }

    private ComplexMergeResult<List<ICategory>> mergeCategories(List<ICategory> categories) {
        if (categories == null) {
            categories = Collections.emptyList();
        }
        Comparator<ICategory> comparator = new Comparator<ICategory>(){

            @Override
            public int compare(ICategory o1, ICategory o2) {
                if (o1.getName() == null ? o2.getName() == null : o1.getName().equals(o2.getName())) {
                    return 0;
                }
                return -1;
            }
        };
        ComplexMergeResult<List<ICategory>> mergeResult = MergeUtils.merge(this.fCategories, categories, comparator, null);
        this.fCategories = mergeResult.getMergedObject();
        return mergeResult;
    }

    private ComplexMergeResult<List<IAttachment>> mergeAttachments(List<IAttachment> attachments) {
        if (attachments == null) {
            attachments = Collections.emptyList();
        }
        Comparator<IAttachment> comparator = new Comparator<IAttachment>(){

            @Override
            public int compare(IAttachment o1, IAttachment o2) {
                if (o1.getLink() == null ? o2.getLink() == null : o1.getLink().equals(o2.getLink())) {
                    return 0;
                }
                return -1;
            }
        };
        ComplexMergeResult<List<IAttachment>> mergeResult = MergeUtils.merge(this.fAttachments, attachments, comparator, this);
        this.fAttachments = mergeResult.getMergedObject();
        return mergeResult;
    }

    private boolean mergeLabels(INews news) {
        Set<ILabel> thisLabels = CoreUtils.getSortedLabels(this);
        Set<ILabel> otherLabels = CoreUtils.getSortedLabels(news);
        if (Arrays.equals(thisLabels.toArray(), otherLabels.toArray())) {
            return false;
        }
        if (otherLabels.isEmpty()) {
            this.clearLabels();
            return true;
        }
        for (ILabel otherLabel : otherLabels) {
            if (thisLabels.contains(otherLabel)) continue;
            this.addLabel(otherLabel);
        }
        for (ILabel thisLabel : thisLabels) {
            if (otherLabels.contains(thisLabel)) continue;
            this.removeLabel(thisLabel);
        }
        return true;
    }

    @Override
    public NewsReference toReference() {
        return new NewsReference(this.getIdAsPrimitive());
    }

    @Override
    public synchronized String toString() {
        StringBuilder str = new StringBuilder();
        str.append("\n\n****************************** News ******************************\n");
        this.fLock.acquireReadLock();
        try {
            str.append("\nNews ID: ").append(this.getId());
            if (this.getTitle() != null) {
                str.append("\nTitle: ").append(this.getTitle());
            }
            if (this.getLinkAsText() != null) {
                str.append("\nLink: ").append(this.getLinkAsText());
            }
        }
        finally {
            this.fLock.releaseReadLock();
        }
        return str.toString();
    }

    public String toLongString() {
        StringBuilder str = new StringBuilder();
        str.append("\n\n****************************** News ******************************\n");
        this.fLock.acquireReadLock();
        try {
            str.append("\nNews ID: ").append(this.getId());
            if (this.fFeedLink != null) {
                str.append("\nFeed Link: ").append(this.fFeedLink);
            }
            str.append("\nState: ").append((Object)this.getState());
            if (this.getTitle() != null) {
                str.append("\nTitle: ").append(this.getTitle());
            }
            if (this.getLinkAsText() != null) {
                str.append("\nLink: ").append(this.getLinkAsText());
            }
            if (this.getBase() != null) {
                str.append("\nBase URI: ").append(this.getBase());
            }
            if (this.getDescription() != null) {
                str.append("\nDescription: ").append(this.getDescription());
            }
            str.append("\nRating: ").append(this.getRating());
            if (this.getPublishDate() != null) {
                str.append("\nPublish Date: ").append(DateFormat.getDateTimeInstance().format(this.getPublishDate()));
            }
            if (this.getReceiveDate() != null) {
                str.append("\nReceive Date: ").append(DateFormat.getDateTimeInstance().format(this.getReceiveDate()));
            }
            if (this.getModifiedDate() != null) {
                str.append("\nModified Date: ").append(DateFormat.getDateTimeInstance().format(this.getModifiedDate()));
            }
            if (this.getAuthor() != null) {
                str.append("\nAuthor: ").append(this.getAuthor());
            }
            if (this.getComments() != null) {
                str.append("\nComments: ").append(this.getComments());
            }
            if (this.getGuid() != null) {
                str.append("\nGUID: ").append(this.getGuid());
            }
            if (this.getSource() != null) {
                str.append("\nSource: ").append(this.getSource());
            }
            if (this.getInReplyTo() != null) {
                str.append("\nIn Reply To: ").append(this.getInReplyTo());
            }
            str.append("\nLabesl: ").append(this.getLabels());
            str.append("\nAttachments: ").append(this.getAttachments());
            str.append("\nCategories: ").append(this.getCategories());
            str.append("\nIs Flagged: ").append(this.fIsFlagged);
            str.append("\nProperties: ").append(this.getProperties());
        }
        finally {
            this.fLock.releaseReadLock();
        }
        return str.toString();
    }

    static final class Lock {
        private final transient ReentrantReadWriteLock fLock = new ReentrantReadWriteLock();
        private volatile transient Thread fReadLockThread;

        Lock() {
        }

        void acquireWriteLock() {
            if (this.fReadLockThread == Thread.currentThread()) {
                throw new IllegalStateException("Cannot acquire the write lock from the same thread as the read lock.");
            }
            this.fLock.writeLock().lock();
        }

        void releaseWriteLock() {
            this.fLock.writeLock().unlock();
        }

        void acquireReadLock() {
            this.fLock.readLock().lock();
        }

        void acquireReadLockSpecial() {
            this.fLock.readLock().lock();
            this.fReadLockThread = Thread.currentThread();
        }

        void releaseReadLock() {
            this.fLock.readLock().unlock();
        }

        void releaseReadLockSpecial() {
            this.fReadLockThread = null;
            this.fLock.readLock().unlock();
        }
    }
}

