/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.persist.dao;

import com.db4o.ext.Db4oException;
import com.db4o.query.Query;
import java.util.Date;
import java.util.Set;
import org.rssowl.core.internal.persist.SearchMark;
import org.rssowl.core.internal.persist.dao.AbstractEntityDAO;
import org.rssowl.core.internal.persist.service.DBHelper;
import org.rssowl.core.persist.ISearchCondition;
import org.rssowl.core.persist.ISearchMark;
import org.rssowl.core.persist.dao.ISearchMarkDAO;
import org.rssowl.core.persist.event.SearchMarkEvent;
import org.rssowl.core.persist.event.SearchMarkListener;
import org.rssowl.core.persist.service.PersistenceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SearchMarkDAOImpl
extends AbstractEntityDAO<ISearchMark, SearchMarkListener, SearchMarkEvent>
implements ISearchMarkDAO {
    public SearchMarkDAOImpl() {
        super(SearchMark.class, true);
    }

    @Override
    protected final SearchMarkEvent createDeleteEventTemplate(ISearchMark entity) {
        return this.createSaveEventTemplate(entity);
    }

    @Override
    protected final SearchMarkEvent createSaveEventTemplate(ISearchMark entity) {
        return new SearchMarkEvent(entity, null, true);
    }

    @Override
    public void fireNewsChanged(Set<SearchMarkEvent> events) {
        for (SearchMarkListener listener : this.fEntityListeners) {
            listener.newsChanged(events);
        }
    }

    @Override
    public ISearchMark load(ISearchCondition searchCondition) {
        Query query = this.fDb.query();
        query.constrain((Object)this.fEntityClass);
        query.descend("fSearchConditions").constrain((Object)searchCondition);
        return (ISearchMark)this.getSingleResult(query);
    }

    @Override
    public void visited(ISearchMark mark) {
        this.fWriteLock.lock();
        try {
            try {
                mark.setLastVisitDate(new Date());
                mark.setPopularity(mark.getPopularity() + 1);
                this.preSave(mark);
                this.fDb.ext().set((Object)mark, 1);
                this.fDb.commit();
            }
            catch (Db4oException e) {
                throw new PersistenceException(e);
            }
        }
        finally {
            this.fWriteLock.unlock();
        }
        DBHelper.cleanUpAndFireEvents();
    }
}

