/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.persist.service;

import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import com.db4o.ext.Db4oException;
import com.db4o.query.Query;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.rssowl.core.Owl;
import org.rssowl.core.internal.Activator;
import org.rssowl.core.internal.InternalOwl;
import org.rssowl.core.internal.persist.BookMark;
import org.rssowl.core.internal.persist.Description;
import org.rssowl.core.internal.persist.Feed;
import org.rssowl.core.internal.persist.LazyList;
import org.rssowl.core.internal.persist.News;
import org.rssowl.core.internal.persist.dao.DAOServiceImpl;
import org.rssowl.core.internal.persist.dao.EntitiesToBeIndexedDAOImpl;
import org.rssowl.core.internal.persist.dao.IDescriptionDAO;
import org.rssowl.core.internal.persist.service.EntityIdsByEventType;
import org.rssowl.core.internal.persist.service.EventManager;
import org.rssowl.core.internal.persist.service.EventsMap;
import org.rssowl.core.internal.persist.service.NewsCounterService;
import org.rssowl.core.persist.IBookMark;
import org.rssowl.core.persist.IEntity;
import org.rssowl.core.persist.IFeed;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.INewsBin;
import org.rssowl.core.persist.IPersistable;
import org.rssowl.core.persist.NewsCounter;
import org.rssowl.core.persist.dao.DAOService;
import org.rssowl.core.persist.dao.DynamicDAO;
import org.rssowl.core.persist.dao.INewsBinDAO;
import org.rssowl.core.persist.dao.INewsCounterDAO;
import org.rssowl.core.persist.event.FeedEvent;
import org.rssowl.core.persist.event.ModelEvent;
import org.rssowl.core.persist.event.NewsBinEvent;
import org.rssowl.core.persist.event.NewsEvent;
import org.rssowl.core.persist.event.runnable.EventRunnable;
import org.rssowl.core.persist.event.runnable.FeedEventRunnable;
import org.rssowl.core.persist.event.runnable.NewsEventRunnable;
import org.rssowl.core.persist.reference.FeedLinkReference;
import org.rssowl.core.persist.reference.NewsReference;
import org.rssowl.core.persist.service.PersistenceException;
import org.rssowl.core.persist.service.UniqueConstraintException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DBHelper {
    static final int BUFFER = 32768;

    private DBHelper() {
    }

    public static void rename(File origin, File destination) throws PersistenceException {
        if (!origin.renameTo(destination)) {
            destination.delete();
            if (!origin.renameTo(destination)) {
                throw new PersistenceException("Failed to rename: " + origin + " to: " + destination);
            }
        }
    }

    public static String readFirstLineFromFile(File file) {
        String string;
        BufferedReader reader = null;
        try {
            String text;
            try {
                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                reader = new BufferedReader(new FileReader(file));
            }
            string = text = reader.readLine();
        }
        catch (IOException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                DBHelper.closeQuietly(reader);
                throw throwable;
            }
        }
        DBHelper.closeQuietly(reader);
        return string;
    }

    public static final void copyFileNIO(File originFile, File destinationFile) {
        block7: {
            FileInputStream inputStream = null;
            FileOutputStream outputStream = null;
            try {
                try {
                    inputStream = new FileInputStream(originFile);
                    FileChannel srcChannel = inputStream.getChannel();
                    if (!destinationFile.exists()) {
                        destinationFile.createNewFile();
                    }
                    outputStream = new FileOutputStream(destinationFile);
                    FileChannel dstChannel = outputStream.getChannel();
                    long bytesToTransfer = srcChannel.size();
                    long position = 0L;
                    while (bytesToTransfer > 0L) {
                        long bytesTransferred = dstChannel.transferFrom(srcChannel, position, bytesToTransfer);
                        position += bytesTransferred;
                        bytesToTransfer -= bytesTransferred;
                    }
                }
                catch (IOException e) {
                    Activator.getDefault().logError("Failed to copy file using NIO. Falling back to traditional IO", e);
                    DBHelper.copyFileIO(originFile, destinationFile, (IProgressMonitor)new NullProgressMonitor());
                    DBHelper.closeQuietly(inputStream);
                    DBHelper.closeQuietly(outputStream);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DBHelper.closeQuietly(inputStream);
                DBHelper.closeQuietly(outputStream);
                throw throwable;
            }
            DBHelper.closeQuietly(inputStream);
            DBHelper.closeQuietly(outputStream);
        }
    }

    public static void copyFileIO(File originFile, File destinationFile, IProgressMonitor monitor) {
        FileInputStream inputStream = null;
        FileOutputStream outputStream = null;
        try {
            try {
                inputStream = new FileInputStream(originFile);
                if (!destinationFile.exists()) {
                    destinationFile.createNewFile();
                }
                outputStream = new FileOutputStream(destinationFile);
                int i = 0;
                byte[] buf = new byte[32768];
                while ((i = inputStream.read(buf)) != -1 && !monitor.isCanceled()) {
                    outputStream.write(buf, 0, i);
                    monitor.worked(1);
                }
            }
            catch (IOException e) {
                throw new PersistenceException(e);
            }
        }
        catch (Throwable throwable) {
            DBHelper.closeQuietly(inputStream);
            DBHelper.closeQuietly(outputStream);
            throw throwable;
        }
        DBHelper.closeQuietly(inputStream);
        DBHelper.closeQuietly(outputStream);
    }

    public static void writeToFile(File file, String text) {
        BufferedWriter writer = null;
        try {
            try {
                try {
                    writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    writer = new BufferedWriter(new FileWriter(file));
                }
                writer.write(text);
                writer.flush();
            }
            catch (IOException e) {
                throw new PersistenceException(e);
            }
        }
        catch (Throwable throwable) {
            DBHelper.closeQuietly(writer);
            throw throwable;
        }
        DBHelper.closeQuietly(writer);
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                Activator.getDefault().logError("Failed to close stream.", e);
            }
        }
    }

    public static final List<EventRunnable<?>> cleanUpEvents() {
        List<EventRunnable<?>> eventNotifiers = EventsMap.getInstance().removeEventRunnables();
        EventsMap.getInstance().removeEventTemplatesMap();
        EventManager.getInstance().clear();
        return eventNotifiers;
    }

    public static final void cleanUpAndFireEvents() {
        DBHelper.fireEvents(DBHelper.cleanUpEvents());
    }

    public static final void fireEvents(List<EventRunnable<?>> eventNotifiers) {
        if (eventNotifiers == null) {
            return;
        }
        for (EventRunnable<?> runnable : eventNotifiers) {
            runnable.run();
        }
    }

    public static final PersistenceException rollbackAndPE(ObjectContainer db, Exception e) {
        DBHelper.cleanUpEvents();
        db.rollback();
        return new PersistenceException(e);
    }

    public static final void putEventTemplate(ModelEvent modelEvent) {
        EventsMap.getInstance().putEventTemplate(modelEvent);
    }

    public static final void saveFeed(ObjectContainer db, IFeed feed) {
        if (feed.getId() == null && DBHelper.feedExists(db, feed.getLink())) {
            throw new UniqueConstraintException("link", feed);
        }
        FeedEvent feedEventTemplate = new FeedEvent(feed, true);
        DBHelper.putEventTemplate(feedEventTemplate);
        DBHelper.saveAndCascadeAllNews(db, feed.getNews(), false);
        DBHelper.saveEntities(db, feed.getCategories());
        DBHelper.saveEntity(db, feed.getAuthor());
        DBHelper.saveEntity(db, feed.getImage());
        db.ext().set((Object)feed, 2);
    }

    private static void saveEntity(ObjectContainer db, IPersistable entity) {
        if (entity != null) {
            db.set((Object)entity);
        }
    }

    private static void saveEntities(ObjectContainer db, List<? extends IEntity> entities) {
        for (IEntity iEntity : entities) {
            db.ext().set((Object)iEntity, 1);
        }
    }

    /*
     * Unable to fully structure code
     */
    static void saveAndCascadeAllNews(ObjectContainer db, Collection<INews> newsCollection, boolean root) {
        for (INews news : newsCollection) {
            ((News)news).acquireReadLockSpecial();
        }
        try {
            for (INews news : newsCollection) {
                DBHelper.saveAndCascadeNews(db, news, root);
            }
        }
        finally {
            ** for (news : newsCollection)
        }
lbl-1000:
        // 1 sources

        {
            n = (News)news;
            n.releaseReadLockSpecial();
            n.clearTransientDescription();
            continue;
        }
lbl15:
        // 1 sources

    }

    public static final INews peekPersistedNews(ObjectContainer db, INews news) {
        INews oldNews = (INews)db.ext().peekPersisted((Object)news, 2, true);
        if (oldNews instanceof News) {
            ((News)oldNews).init();
        }
        return oldNews;
    }

    public static final void saveUpdatedNews(ObjectContainer db, INews news) {
        INews oldNews = DBHelper.peekPersistedNews(db, news);
        if (oldNews != null) {
            NewsEvent newsEventTemplate = new NewsEvent(oldNews, news, false, true);
            DBHelper.putEventTemplate(newsEventTemplate);
        }
        db.ext().set((Object)news, 2);
    }

    static final boolean feedExists(ObjectContainer db, URI link) {
        return !DBHelper.getFeeds(db, link).isEmpty();
    }

    private static List<Feed> getFeeds(ObjectContainer db, URI link) {
        Query query = db.query();
        query.constrain(Feed.class);
        query.descend("fLinkText").constrain((Object)link.toString());
        ObjectSet set = query.execute();
        return set;
    }

    public static final Feed loadFeed(ObjectContainer db, URI link, Integer activationDepth) {
        try {
            List<Feed> feeds = DBHelper.getFeeds(db, link);
            if (!feeds.isEmpty()) {
                Feed feed = feeds.iterator().next();
                if (activationDepth != null) {
                    db.ext().activate((Object)feed, activationDepth.intValue());
                }
                return feed;
            }
            return null;
        }
        catch (Db4oException e) {
            throw new PersistenceException(e);
        }
    }

    public static final boolean existsFeed(ObjectContainer db, URI link) {
        try {
            List<Feed> feeds = DBHelper.getFeeds(db, link);
            return !feeds.isEmpty();
        }
        catch (Db4oException e) {
            throw new PersistenceException(e);
        }
    }

    public static final void saveAndCascadeNews(ObjectContainer db, INews news, boolean root) {
        INews oldNews = DBHelper.peekPersistedNews(db, news);
        if (oldNews != null || root) {
            NewsEvent event = new NewsEvent(oldNews, news, root);
            DBHelper.putEventTemplate(event);
        }
        DBHelper.saveEntities(db, news.getCategories());
        DBHelper.saveEntity(db, news.getAuthor());
        DBHelper.saveEntities(db, news.getAttachments());
        DBHelper.saveEntity(db, news.getSource());
        db.ext().set((Object)news, 2);
        DBHelper.saveDescription(db, news);
    }

    private static void saveDescription(ObjectContainer db, INews news) {
        News n = (News)news;
        if (!n.isTransientDescriptionSet()) {
            return;
        }
        Description dbDescription = null;
        String dbDescriptionValue = null;
        dbDescription = DBHelper.getDescriptionDAO().load(news.getId());
        if (dbDescription != null) {
            dbDescriptionValue = dbDescription.getValue();
        }
        String newsDescriptionValue = n.getTransientDescription();
        if (dbDescriptionValue == null && newsDescriptionValue == null) {
            return;
        }
        if (dbDescriptionValue == null && newsDescriptionValue != null) {
            db.set((Object)new Description(news, newsDescriptionValue));
        } else if (dbDescriptionValue != null && newsDescriptionValue == null) {
            db.delete((Object)dbDescription);
        } else if (dbDescriptionValue != null && !dbDescriptionValue.equals(newsDescriptionValue) && dbDescription != null) {
            dbDescription.setDescription(newsDescriptionValue);
            db.set((Object)dbDescription);
        }
    }

    public static IDescriptionDAO getDescriptionDAO() {
        DAOService daoService = InternalOwl.getDefault().getPersistenceService().getDAOService();
        if (daoService instanceof DAOServiceImpl) {
            return ((DAOServiceImpl)daoService).getDescriptionDAO();
        }
        throw new IllegalStateException("This method should only be called if DAOService is of type " + DAOServiceImpl.class + ", but it is of type: " + daoService.getClass());
    }

    public static void preCommit(ObjectContainer db) {
        DBHelper.updateNewsCounter(db);
        DBHelper.updateNewsToBeIndexed(db);
        DBHelper.updateNewsBins(db);
    }

    public static EntitiesToBeIndexedDAOImpl getEntitiesToBeIndexedDAO() {
        DAOService service = InternalOwl.getDefault().getPersistenceService().getDAOService();
        if (service instanceof DAOServiceImpl) {
            EntitiesToBeIndexedDAOImpl entitiesToBeIndexedDAO = ((DAOServiceImpl)service).getEntitiesToBeIndexedDAO();
            return entitiesToBeIndexedDAO;
        }
        return null;
    }

    private static void updateNewsToBeIndexed(ObjectContainer db) {
        NewsEventRunnable newsEventRunnables = DBHelper.getNewsEventRunnables(EventsMap.getInstance().getEventRunnables());
        if (newsEventRunnables == null) {
            return;
        }
        EntitiesToBeIndexedDAOImpl dao = DBHelper.getEntitiesToBeIndexedDAO();
        EntityIdsByEventType newsToBeIndexed = dao.load();
        HashSet<NewsEvent> updateEvents = new HashSet<NewsEvent>(newsEventRunnables.getUpdateEvents().size());
        HashSet<NewsEvent> deleteEvents = new HashSet<NewsEvent>(newsEventRunnables.getRemoveEvents());
        Set<NewsEvent> persistEvents = DBHelper.filterPersistedNewsForIndexing(newsEventRunnables.getPersistEvents());
        for (NewsEvent event : newsEventRunnables.getUpdateEvents()) {
            DBHelper.indexTypeForNewsUpdate(event, persistEvents, updateEvents, deleteEvents);
        }
        NewsEventRunnable copy = new NewsEventRunnable();
        for (NewsEvent persistEvent : persistEvents) {
            copy.addCheckedPersistEvent(persistEvent);
        }
        for (NewsEvent updateEvent : updateEvents) {
            copy.addCheckedUpdateEvent(updateEvent);
        }
        for (NewsEvent deleteEvent : deleteEvents) {
            copy.addCheckedRemoveEvent(deleteEvent);
        }
        newsToBeIndexed.addAllEntities(copy.getPersistEvents(), copy.getUpdateEvents(), copy.getRemoveEvents());
        newsToBeIndexed.compact();
        db.ext().set((Object)newsToBeIndexed, Integer.MAX_VALUE);
    }

    public static Set<NewsEvent> filterPersistedNewsForIndexing(Collection<NewsEvent> events) {
        HashSet<NewsEvent> result = new HashSet<NewsEvent>(events.size());
        for (NewsEvent event : events) {
            if (!event.getEntity().isVisible()) continue;
            result.add(event);
        }
        return result;
    }

    public static void indexTypeForNewsUpdate(NewsEvent event, Collection<NewsEvent> newsToRestore, Collection<NewsEvent> newsToUpdate, Collection<NewsEvent> newsToDelete) {
        boolean wasVisible = event.getOldNews().isVisible();
        boolean isVisible = event.getEntity().isVisible();
        if (wasVisible && !isVisible) {
            newsToDelete.add(event);
        } else if (!wasVisible && isVisible) {
            newsToRestore.add(event);
        } else if (wasVisible && isVisible) {
            newsToUpdate.add(event);
        }
    }

    public static NewsEventRunnable getNewsEventRunnables(List<EventRunnable<?>> eventRunnables) {
        for (EventRunnable<?> eventRunnable : eventRunnables) {
            if (!(eventRunnable instanceof NewsEventRunnable)) continue;
            return (NewsEventRunnable)eventRunnable;
        }
        return null;
    }

    private static void updateNewsBins(ObjectContainer db) {
        List<INewsBin.StatesUpdateInfo> list;
        INews news;
        NewsEventRunnable newsEventRunnable = DBHelper.getNewsEventRunnables(EventsMap.getInstance().getEventRunnables());
        if (newsEventRunnable == null) {
            return;
        }
        HashMap<Long, ArrayList<INewsBin.StatesUpdateInfo>> statesUpdateInfos = new HashMap<Long, ArrayList<INewsBin.StatesUpdateInfo>>(5);
        for (NewsEvent newsEvent : newsEventRunnable.getUpdateEvents()) {
            news = newsEvent.getEntity();
            if (news.getParentId() == 0L || newsEvent.getOldNews().getState() == news.getState()) continue;
            list = (ArrayList<INewsBin.StatesUpdateInfo>)statesUpdateInfos.get(news.getParentId());
            if (list == null) {
                list = new ArrayList<INewsBin.StatesUpdateInfo>();
                statesUpdateInfos.put(news.getParentId(), (ArrayList<INewsBin.StatesUpdateInfo>)list);
            }
            list.add(new INewsBin.StatesUpdateInfo(newsEvent.getOldNews().getState(), news.getState(), news.toReference()));
        }
        for (NewsEvent newsEvent : newsEventRunnable.getPersistEvents()) {
            news = newsEvent.getEntity();
            if (news.getParentId() == 0L) continue;
            list = (List)statesUpdateInfos.get(news.getParentId());
            if (list == null) {
                list = new ArrayList();
                statesUpdateInfos.put(news.getParentId(), (ArrayList<INewsBin.StatesUpdateInfo>)list);
            }
            list.add(new INewsBin.StatesUpdateInfo(null, news.getState(), news.toReference()));
        }
        if (!statesUpdateInfos.isEmpty()) {
            HashSet<FeedLinkReference> removedFeedRefs = new HashSet<FeedLinkReference>();
            INewsBinDAO newsBinDAO = DynamicDAO.getDAO(INewsBinDAO.class);
            for (Map.Entry mapEntry : statesUpdateInfos.entrySet()) {
                INewsBin newsBin = (INewsBin)newsBinDAO.load((Long)mapEntry.getKey());
                if (!newsBin.updateNewsStates((Collection)mapEntry.getValue())) continue;
                DBHelper.removeNews(db, removedFeedRefs, newsBin.removeNews(EnumSet.of(INews.State.DELETED)));
                DBHelper.putEventTemplate(new NewsBinEvent(newsBin, null, true));
                db.ext().set((Object)newsBin, Integer.MAX_VALUE);
            }
            DBHelper.removeFeedsAfterNewsBinUpdate(db, removedFeedRefs);
        }
    }

    static void removeNews(ObjectContainer db, Set<FeedLinkReference> feedRefs, Collection<NewsReference> newsRefs) {
        for (NewsReference newsRef : newsRefs) {
            INews news = newsRef.resolve();
            if (news == null) continue;
            feedRefs.add(news.getFeedReference());
            db.delete((Object)news);
        }
    }

    static void removeFeedsAfterNewsBinUpdate(ObjectContainer db, Set<FeedLinkReference> removedFeedRefs) {
        NewsCounter newsCounter = DynamicDAO.getDAO(INewsCounterDAO.class).load();
        boolean changed = false;
        for (FeedLinkReference feedRef : removedFeedRefs) {
            if (DBHelper.countBookMarkReference(db, feedRef) != 0 || DBHelper.feedHasNewsWithCopies(db, feedRef)) continue;
            db.delete((Object)feedRef.resolve());
            changed = true;
        }
        if (changed) {
            db.ext().set((Object)newsCounter, Integer.MAX_VALUE);
        }
    }

    static int countBookMarkReference(ObjectContainer db, FeedLinkReference feedRef) {
        Collection<IBookMark> marks = DBHelper.loadAllBookMarks(db, feedRef);
        return marks.size();
    }

    public static Collection<IBookMark> loadAllBookMarks(ObjectContainer db, FeedLinkReference feedRef) {
        Query query = db.query();
        query.constrain(BookMark.class);
        query.descend("fFeedLink").constrain((Object)feedRef.getLink().toString());
        return query.execute();
    }

    static boolean feedHasNewsWithCopies(ObjectContainer db, FeedLinkReference feedRef) {
        Query query = db.query();
        query.constrain(News.class);
        query.descend("fFeedLink").constrain((Object)feedRef.getLink().toString());
        query.descend("fParentId").constrain((Object)0).not();
        return !query.execute().isEmpty();
    }

    public static void updateNewsCounter(ObjectContainer db) {
        List<EventRunnable<?>> eventRunnables = EventsMap.getInstance().getEventRunnables();
        NewsCounterService newsCounterService = new NewsCounterService(Owl.getPersistenceService().getDAOService().getNewsCounterDAO(), db);
        NewsEventRunnable newsEventRunnable = DBHelper.getNewsEventRunnables(eventRunnables);
        if (newsEventRunnable != null) {
            newsCounterService.onNewsAdded(newsEventRunnable.getPersistEvents());
            newsCounterService.onNewsRemoved(newsEventRunnable.getRemoveEvents());
            newsCounterService.onNewsUpdated(newsEventRunnable.getUpdateEvents());
        }
        for (EventRunnable<?> eventRunnable : eventRunnables) {
            if (!(eventRunnable instanceof FeedEventRunnable)) continue;
            FeedEventRunnable feedEventRunnable = (FeedEventRunnable)eventRunnable;
            newsCounterService.onFeedRemoved(feedEventRunnable.getRemoveEvents());
            break;
        }
    }

    public static Collection<IFeed> loadAllFeeds(ObjectContainer db) {
        ObjectSet entities = db.query(Feed.class);
        return new LazyList<IFeed>(entities, db);
    }
}

