/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.persist.event.runnable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.rssowl.core.Owl;
import org.rssowl.core.persist.dao.DAOService;
import org.rssowl.core.persist.dao.IEntityDAO;
import org.rssowl.core.persist.event.ModelEvent;
import org.rssowl.core.persist.event.runnable.EventType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EventRunnable<T extends ModelEvent>
implements Runnable {
    private Set<T> fPersistEvents;
    private Set<T> fRemoveEvents;
    private Set<T> fUpdateEvents;
    private final Class<T> fEventClass;
    private final IEntityDAO<?, ?, T> fEntityDAO;

    protected EventRunnable(Class<T> eventClass, IEntityDAO<?, ?, T> entityDAO) {
        Assert.isNotNull(eventClass, (String)"eventClass");
        Assert.isNotNull(entityDAO, (String)"entityDAO");
        this.fEventClass = eventClass;
        this.fEntityDAO = entityDAO;
    }

    protected static final DAOService getDAOService() {
        return Owl.getPersistenceService().getDAOService();
    }

    public boolean isEmpty() {
        return this.isEmpty(this.fPersistEvents) && this.isEmpty(this.fRemoveEvents) && this.isEmpty(this.fUpdateEvents);
    }

    private boolean isEmpty(Set<?> set) {
        return set == null || set.isEmpty();
    }

    @Override
    public final void run() {
        if (this.shouldFirePersistEvents()) {
            this.fireEvents(this.fPersistEvents, EventType.PERSIST);
        }
        if (this.shouldFireRemoveEvents()) {
            this.fireEvents(this.fRemoveEvents, EventType.REMOVE);
        }
        if (this.shouldFireUpdateEvents()) {
            this.fireEvents(this.fUpdateEvents, EventType.UPDATE);
        }
    }

    private void fireEvents(Set<T> persistEvents, EventType eventType) {
        this.fEntityDAO.fireEvents(Collections.unmodifiableSet(persistEvents), eventType);
    }

    public final void addCheckedPersistEvent(ModelEvent event) {
        this.checkEventType(this.getEventClass(), event);
        this.addPersistEvent(event);
    }

    private Class<? extends ModelEvent> getEventClass() {
        return this.fEventClass;
    }

    private void checkEventType(Class<?> expectedClass, ModelEvent eventReceived) {
        if (!expectedClass.isInstance(eventReceived)) {
            throw new IllegalArgumentException("event must be of type: " + expectedClass + ", but it is of type: " + eventReceived.getClass());
        }
    }

    public final void addCheckedRemoveEvent(ModelEvent event) {
        this.checkEventType(this.getEventClass(), event);
        this.addRemoveEvent(event);
    }

    public final void addCheckedUpdateEvent(ModelEvent event) {
        this.checkEventType(this.getEventClass(), event);
        this.addUpdateEvent(event);
    }

    public final void addPersistEvent(T event) {
        if (this.fPersistEvents == null) {
            this.fPersistEvents = new HashSet<T>(3);
        }
        if (this.removeEventsContains((ModelEvent)event)) {
            return;
        }
        this.fPersistEvents.add(event);
    }

    private boolean removeEventsContains(ModelEvent event) {
        return this.fRemoveEvents != null && this.fRemoveEvents.contains(event);
    }

    private boolean persistEventsContains(ModelEvent event) {
        return this.fPersistEvents != null && this.fPersistEvents.contains(event);
    }

    public final void addRemoveEvent(T event) {
        if (this.fRemoveEvents == null) {
            this.fRemoveEvents = new HashSet<T>(3);
        }
        if (this.fUpdateEvents != null) {
            this.fUpdateEvents.remove(event);
        }
        if (this.fPersistEvents != null) {
            this.fPersistEvents.remove(event);
        }
        this.fRemoveEvents.add(event);
    }

    public final void addUpdateEvent(T event) {
        if (this.fUpdateEvents == null) {
            this.fUpdateEvents = new HashSet<T>(3);
        }
        if (this.removeEventsContains((ModelEvent)event) || this.persistEventsContains((ModelEvent)event)) {
            return;
        }
        this.fUpdateEvents.add(event);
    }

    public final List<T> getAllEvents() {
        ArrayList<T> allEvents = new ArrayList<T>(this.getPersistEvents().size() + this.getRemoveEvents().size() + this.getUpdateEvents().size());
        allEvents.addAll(this.getPersistEvents());
        allEvents.addAll(this.getRemoveEvents());
        allEvents.addAll(this.getUpdateEvents());
        return allEvents;
    }

    private boolean shouldFirePersistEvents() {
        return this.fPersistEvents != null && this.fPersistEvents.size() > 0;
    }

    private boolean shouldFireUpdateEvents() {
        return this.fUpdateEvents != null && this.fUpdateEvents.size() > 0;
    }

    private boolean shouldFireRemoveEvents() {
        return this.fRemoveEvents != null && this.fRemoveEvents.size() > 0;
    }

    public final Set<T> getPersistEvents() {
        if (this.fPersistEvents == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.fPersistEvents);
    }

    public final Set<T> getRemoveEvents() {
        if (this.fRemoveEvents == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.fRemoveEvents);
    }

    public final Set<T> getUpdateEvents() {
        if (this.fUpdateEvents == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.fUpdateEvents);
    }
}

