/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.util;

import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.rssowl.core.Owl;
import org.rssowl.core.connection.ConnectionException;
import org.rssowl.core.connection.MonitorCanceledException;
import org.rssowl.core.connection.UnknownProtocolException;
import org.rssowl.core.internal.Activator;
import org.rssowl.core.internal.persist.pref.DefaultPreferences;
import org.rssowl.core.interpreter.InterpreterException;
import org.rssowl.core.interpreter.ParserException;
import org.rssowl.core.interpreter.UnknownFormatException;
import org.rssowl.core.persist.IAttachment;
import org.rssowl.core.persist.IBookMark;
import org.rssowl.core.persist.ICategory;
import org.rssowl.core.persist.IEntity;
import org.rssowl.core.persist.IFilterAction;
import org.rssowl.core.persist.IFolder;
import org.rssowl.core.persist.IFolderChild;
import org.rssowl.core.persist.IGuid;
import org.rssowl.core.persist.ILabel;
import org.rssowl.core.persist.IMark;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.INewsBin;
import org.rssowl.core.persist.IPerson;
import org.rssowl.core.persist.ISearch;
import org.rssowl.core.persist.ISearchCondition;
import org.rssowl.core.persist.ISearchFilter;
import org.rssowl.core.persist.ISearchMark;
import org.rssowl.core.persist.SearchSpecifier;
import org.rssowl.core.persist.dao.DynamicDAO;
import org.rssowl.core.persist.dao.IBookMarkDAO;
import org.rssowl.core.persist.dao.IFolderDAO;
import org.rssowl.core.persist.event.ModelEvent;
import org.rssowl.core.persist.event.NewsEvent;
import org.rssowl.core.persist.pref.IPreferenceScope;
import org.rssowl.core.persist.reference.BookMarkReference;
import org.rssowl.core.persist.reference.FeedLinkReference;
import org.rssowl.core.persist.reference.FolderReference;
import org.rssowl.core.persist.reference.NewsBinReference;
import org.rssowl.core.persist.reference.NewsReference;
import org.rssowl.core.persist.service.PersistenceException;
import org.rssowl.core.util.DateUtils;
import org.rssowl.core.util.Messages;
import org.rssowl.core.util.Pair;
import org.rssowl.core.util.ReparentInfo;
import org.rssowl.core.util.StringUtils;
import org.rssowl.core.util.URIUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoreUtils {
    public static final int FOLDER = 0;
    public static final int BOOKMARK = 1;
    public static final int NEWSBIN = 2;
    public static final String[] FEED_MIME_TYPES = new String[]{"application/rss+xml", "application/atom+xml", "application/rdf+xml"};
    private static final Set<String> STOP_WORDS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(StringUtils.ENGLISH_STOP_WORDS)));
    private static final StringBuffer fgLogBuffer = new StringBuffer();
    private static final AtomicBoolean fgReportedIndexIssue = new AtomicBoolean(false);
    private static List<String> STRUCTURAL_ACTIONS = Arrays.asList("org.rssowl.core.MoveNewsAction", "org.rssowl.core.CopyNewsAction");
    private static List<String> DISPLAY_ACTIONS = Arrays.asList("org.rssowl.ui.ShowNotifierNewsAction");
    private static final String[] FAVICON_MARKERS = new String[]{"shortcut icon", ".ico"};
    private static final String[] HREF_VARIANTS = new String[]{"href = ", "href= ", "href=", "HREF=", "href ="};
    private static final String[] RESERVED_FILENAME_CHARACTERS_WINDOWS = new String[]{"<", ">", ":", "\"", "/", "\\", "|", "?", "*"};
    private static final String NON_CHAR_DIGIT_DELIMS = " \t\n\r\f!\u00c2\u00a7$%&/\\\u00c2\u00b4`^\u00c2\u00b0()=+~\"'#-_.:,;<>|@[]{}";

    private CoreUtils() {
    }

    public static Collection<IFilterAction> getActions(ISearchFilter filter) {
        TreeSet<IFilterAction> actions = new TreeSet<IFilterAction>(new Comparator<IFilterAction>(){

            @Override
            public int compare(IFilterAction o1, IFilterAction o2) {
                if (o1.equals(o2)) {
                    return 0;
                }
                if (DISPLAY_ACTIONS.contains(o1.getActionId())) {
                    return 1;
                }
                if (DISPLAY_ACTIONS.contains(o2.getActionId())) {
                    return -1;
                }
                if (STRUCTURAL_ACTIONS.contains(o1.getActionId())) {
                    return 1;
                }
                if (STRUCTURAL_ACTIONS.contains(o2.getActionId())) {
                    return -1;
                }
                return 1;
            }
        });
        actions.addAll(filter.getActions());
        return actions;
    }

    public static String getName(List<ISearchCondition> conditions, boolean matchAllConditions) {
        StringBuilder name = new StringBuilder();
        ArrayList<ISearchCondition> locationConditions = new ArrayList<ISearchCondition>(conditions.size());
        HashMap<String, ArrayList<ISearchCondition>> mapFieldNameToConditions = new HashMap<String, ArrayList<ISearchCondition>>();
        for (ISearchCondition condition : conditions) {
            if (condition.getField().getId() == 19) {
                locationConditions.add(condition);
                continue;
            }
            String fieldName = condition.getField().getName();
            String condValue = condition.getValue().toString();
            if (condValue.length() <= 0) continue;
            ArrayList<ISearchCondition> fieldConditions = (ArrayList<ISearchCondition>)mapFieldNameToConditions.get(fieldName);
            if (fieldConditions == null) {
                fieldConditions = new ArrayList<ISearchCondition>();
                mapFieldNameToConditions.put(fieldName, fieldConditions);
            }
            fieldConditions.add(condition);
        }
        Set entries = mapFieldNameToConditions.entrySet();
        DateFormat dateFormat = DateFormat.getDateInstance();
        for (Map.Entry entry : entries) {
            String prevSpecName = null;
            String fieldName = (String)entry.getKey();
            List fieldConditions = (List)entry.getValue();
            StringBuilder fieldExpression = new StringBuilder();
            fieldExpression.append(fieldName).append(" ");
            for (ISearchCondition fieldCondition : fieldConditions) {
                String condValue = fieldCondition.getValue().toString();
                String specName = fieldCondition.getSpecifier().getName();
                int typeId = fieldCondition.getField().getSearchValueType().getId();
                int fieldId = fieldCondition.getField().getId();
                if (condValue.length() <= 0) continue;
                if (prevSpecName == null || !prevSpecName.equals(specName)) {
                    fieldExpression.append(specName).append(" ");
                    prevSpecName = specName;
                }
                if (fieldId == 18 || fieldId == 21) {
                    Integer value = Integer.valueOf(condValue);
                    if (value >= 0) {
                        fieldExpression.append(value == 1 ? NLS.bind((String)Messages.CoreUtils_N_DAY, (Object)value) : NLS.bind((String)Messages.CoreUtils_N_DAYS, (Object)value));
                    } else if (value % 60 == 0) {
                        fieldExpression.append(value == -60 ? NLS.bind((String)Messages.CoreUtils_N_HOUR, (Object)(Math.abs(value) / 60)) : NLS.bind((String)Messages.CoreUtils_N_HOURS, (Object)(Math.abs(value) / 60)));
                    } else {
                        fieldExpression.append(value == -1 ? NLS.bind((String)Messages.CoreUtils_N_MINUTE, (Object)Math.abs(value)) : NLS.bind((String)Messages.CoreUtils_N_MINUTES, (Object)Math.abs(value)));
                    }
                } else if (fieldId == 15 && condValue.equals("*") && (fieldCondition.getSpecifier() == SearchSpecifier.IS || fieldCondition.getSpecifier() == SearchSpecifier.IS_NOT)) {
                    fieldExpression.append(Messages.CoreUtils_LABEL_ASSIGNED);
                } else {
                    switch (typeId) {
                        case 0: {
                            fieldExpression.append("'").append(condValue).append("'");
                            break;
                        }
                        case 8: {
                            fieldExpression.append("'").append(condValue).append("'");
                            break;
                        }
                        case 7: {
                            condValue = condValue.toLowerCase();
                            condValue = condValue.replace("[", "");
                            condValue = condValue.replace("]", "");
                            fieldExpression.append(condValue.toLowerCase());
                            break;
                        }
                        case 1: {
                            fieldExpression.append(dateFormat.format(fieldCondition.getValue()));
                            break;
                        }
                        case 2: {
                            fieldExpression.append(dateFormat.format(fieldCondition.getValue()));
                            break;
                        }
                        case 3: {
                            fieldExpression.append(dateFormat.format(fieldCondition.getValue()));
                            break;
                        }
                        default: {
                            fieldExpression.append(condValue);
                        }
                    }
                }
                fieldExpression.append(" ").append(matchAllConditions ? Messages.CoreUtils_AND : Messages.CoreUtils_OR).append(" ");
            }
            if (fieldExpression.length() > 0) {
                fieldExpression.delete(fieldExpression.length() - (matchAllConditions ? (" " + Messages.CoreUtils_AND + " ").length() : (" " + Messages.CoreUtils_OR + " ").length()), fieldExpression.length());
            }
            name.append((CharSequence)fieldExpression).append(" ").append(matchAllConditions ? Messages.CoreUtils_AND : Messages.CoreUtils_OR).append(" ");
        }
        if (name.length() > 0) {
            name.delete(name.length() - (matchAllConditions ? (" " + Messages.CoreUtils_AND + " ").length() : (" " + Messages.CoreUtils_OR + " ").length()), name.length());
        }
        if (!locationConditions.isEmpty()) {
            StringBuilder locationsValue = new StringBuilder();
            for (ISearchCondition locationCondition : locationConditions) {
                List<IFolderChild> locations = CoreUtils.toEntities((Long[][])locationCondition.getValue());
                for (IFolderChild location : locations) {
                    locationsValue.append("'").append(location.getName()).append("', ");
                }
            }
            locationsValue.delete(locationsValue.length() - 2, locationsValue.length());
            if (name.length() == 0) {
                name.append(NLS.bind((String)Messages.CoreUtils_ALL_IN_N, (Object)locationsValue.toString()));
            } else {
                name.append(" ").append(NLS.bind((String)Messages.CoreUtils_IN_N, (Object)locationsValue.toString()));
            }
        }
        return name.toString();
    }

    public static List<INewsBin> toBins(Long[] primitives) {
        ArrayList<INewsBin> bins = new ArrayList<INewsBin>(primitives.length);
        Long[] longArray = primitives;
        int n = primitives.length;
        int n2 = 0;
        while (n2 < n) {
            Long id = longArray[n2];
            INewsBin bin = DynamicDAO.load(INewsBin.class, id);
            if (bin != null) {
                bins.add(bin);
            }
            ++n2;
        }
        return bins;
    }

    public static List<IFolderChild> toEntities(Long[][] primitives) {
        if (primitives == null) {
            return Collections.emptyList();
        }
        ArrayList<IFolderChild> childs = new ArrayList<IFolderChild>();
        int i = 0;
        while (primitives[0] != null && i < primitives[0].length) {
            try {
                IFolder folder;
                if (primitives[0][i] != null && primitives[0][i] != 0L && (folder = new FolderReference(primitives[0][i]).resolve()) != null) {
                    childs.add(folder);
                }
            }
            catch (PersistenceException persistenceException) {}
            ++i;
        }
        i = 0;
        while (primitives[1] != null && i < primitives[1].length) {
            try {
                IBookMark bookmark;
                if (primitives[1][i] != null && primitives[1][i] != 0L && (bookmark = new BookMarkReference(primitives[1][i]).resolve()) != null) {
                    childs.add(bookmark);
                }
            }
            catch (PersistenceException persistenceException) {}
            ++i;
        }
        if (primitives.length == 3) {
            i = 0;
            while (primitives[2] != null && i < primitives[2].length) {
                try {
                    INewsBin newsbin;
                    if (primitives[2][i] != null && primitives[2][i] != 0L && (newsbin = new NewsBinReference(primitives[2][i]).resolve()) != null) {
                        childs.add(newsbin);
                    }
                }
                catch (PersistenceException persistenceException) {}
                ++i;
            }
        }
        return childs;
    }

    public static void normalize(List<? extends IEntity> entities) {
        if (entities == null) {
            return;
        }
        ArrayList<IFolder> folders = null;
        for (IEntity iEntity : entities) {
            if (!(iEntity instanceof IFolder)) continue;
            if (folders == null) {
                folders = new ArrayList<IFolder>();
            }
            folders.add((IFolder)iEntity);
        }
        if (folders != null) {
            for (IFolder iFolder : folders) {
                CoreUtils.normalize(iFolder, entities);
            }
        }
    }

    public static void normalize(IFolder folder, List<? extends IEntity> entities) {
        List<IMark> marks = folder.getMarks();
        for (IMark mark : marks) {
            entities.remove(mark);
        }
        List<IFolder> subFolders = folder.getFolders();
        for (IFolder subFolder : subFolders) {
            entities.remove(subFolder);
            CoreUtils.normalize(subFolder, entities);
        }
    }

    public static String getHeadline(INews news, boolean replaceEntities) {
        String title = news.getTitle();
        if (CoreUtils.shouldStripTags(title, replaceEntities)) {
            title = StringUtils.stripTags(title, replaceEntities);
        }
        if (StringUtils.isSet(title = StringUtils.normalizeString(title))) {
            return title;
        }
        String content = news.getDescription();
        if (StringUtils.isSet(content)) {
            if (CoreUtils.shouldStripTags(content, replaceEntities)) {
                content = StringUtils.stripTags(content, replaceEntities);
            }
            content = StringUtils.normalizeString(content);
            if (StringUtils.isSet(content = StringUtils.smartTrim(content, 50))) {
                return content;
            }
        }
        return Messages.CoreUtils_NO_HEADLINE;
    }

    private static boolean shouldStripTags(String str, boolean replaceEntities) {
        if (StringUtils.isSet(str)) {
            return str.contains("<") || replaceEntities && str.contains("&");
        }
        return false;
    }

    public static String getLink(INews news) {
        String linkAsStr = CoreUtils.getLinkAsString(news);
        if (linkAsStr != null) {
            if (linkAsStr.contains("://")) {
                return linkAsStr;
            }
            if (linkAsStr.startsWith("www.")) {
                return "http://" + linkAsStr;
            }
            URI base = URIUtils.toHTTP(news.getBase());
            if (base != null) {
                try {
                    return URIUtils.resolve(base, new URI(linkAsStr)).toString();
                }
                catch (URISyntaxException uRISyntaxException) {
                    return linkAsStr;
                }
            }
            try {
                return URIUtils.resolve(new URI(URIUtils.toHTTP(news.getFeedLinkAsText())), new URI(linkAsStr)).toString();
            }
            catch (URISyntaxException uRISyntaxException) {
                return linkAsStr;
            }
        }
        return null;
    }

    private static String getLinkAsString(INews news) {
        String value;
        String link = news.getLinkAsText();
        if (StringUtils.isSet(link)) {
            return link;
        }
        IGuid guid = news.getGuid();
        if (guid != null && URIUtils.looksLikeLink(value = guid.getValue())) {
            return value;
        }
        return null;
    }

    public static String normalizeTitle(String title) {
        if (!StringUtils.isSet(title)) {
            return title;
        }
        String normalizedTitle = null;
        int start = 0;
        int len = title.length();
        boolean done = false;
        while (!done) {
            done = true;
            while (start < len && title.charAt(start) == ' ') {
                ++start;
            }
            if (start < len - 2) {
                char c1 = title.charAt(start);
                char c2 = title.charAt(start + 1);
                char c3 = title.charAt(start + 2);
                if (!(c1 != 'r' && c1 != 'R' || c2 != 'e' && c2 != 'E')) {
                    if (c3 == ':') {
                        start += 3;
                        done = false;
                    } else if (start < len - 2 && (c3 == '[' || c3 == '(')) {
                        int i = start + 3;
                        while (i < len && title.charAt(i) >= '0' && title.charAt(i) <= '9') {
                            ++i;
                        }
                        char ci1 = title.charAt(i);
                        char ci2 = title.charAt(i + 1);
                        if (i < len - 1 && (ci1 == ']' || ci1 == ')') && ci2 == ':') {
                            start = i + 2;
                            done = false;
                        }
                    }
                }
            }
            int end = len;
            while (end > start && title.charAt(end - 1) < ' ') {
                --end;
            }
            normalizedTitle = start == 0 && end == len ? title : title.substring(start, end);
        }
        return normalizedTitle;
    }

    public static boolean isNewStateChange(Collection<? extends ModelEvent> events) {
        for (ModelEvent modelEvent : events) {
            boolean currentStateNew;
            NewsEvent newsEvent;
            boolean oldStateNew;
            if (!(modelEvent instanceof NewsEvent) || (oldStateNew = INews.State.NEW.equals((Object)((newsEvent = (NewsEvent)modelEvent).getOldNews() != null ? newsEvent.getOldNews().getState() : null))) == (currentStateNew = INews.State.NEW.equals((Object)newsEvent.getEntity().getState()))) continue;
            return true;
        }
        return false;
    }

    public static boolean changedFromReadToUnread(Collection<? extends ModelEvent> events) {
        for (ModelEvent modelEvent : events) {
            boolean currentStateNewUnreadUpdated;
            if (!(modelEvent instanceof NewsEvent)) continue;
            NewsEvent newsEvent = (NewsEvent)modelEvent;
            boolean oldStateRead = INews.State.READ.equals((Object)(newsEvent.getOldNews() != null ? newsEvent.getOldNews().getState() : null));
            INews.State currentState = newsEvent.getEntity().getState();
            boolean bl = currentStateNewUnreadUpdated = INews.State.NEW.equals((Object)currentState) || INews.State.UNREAD.equals((Object)currentState) || INews.State.UPDATED.equals((Object)currentState);
            if (!oldStateRead || !currentStateNewUnreadUpdated) continue;
            return true;
        }
        return false;
    }

    public static boolean isStickyStateChange(Collection<? extends ModelEvent> events) {
        return CoreUtils.isStickyStateChange(events, false);
    }

    public static boolean isStickyStateChange(NewsEvent newsEvent) {
        boolean oldSticky = newsEvent.getOldNews() != null ? newsEvent.getOldNews().isFlagged() : false;
        boolean currentSticky = newsEvent.getEntity().isVisible() && newsEvent.getEntity().isFlagged();
        return oldSticky ^ currentSticky;
    }

    public static boolean isStickyStateChange(Collection<? extends ModelEvent> events, boolean onlyHasBecomeSticky) {
        for (ModelEvent modelEvent : events) {
            boolean currentSticky;
            if (!(modelEvent instanceof NewsEvent)) continue;
            NewsEvent newsEvent = (NewsEvent)modelEvent;
            boolean oldSticky = newsEvent.getOldNews() != null ? newsEvent.getOldNews().isFlagged() : false;
            boolean bl = currentSticky = newsEvent.getEntity().isVisible() && newsEvent.getEntity().isFlagged();
            if (!(onlyHasBecomeSticky ? !oldSticky && currentSticky : oldSticky != currentSticky)) continue;
            return true;
        }
        return false;
    }

    public static boolean isReadStateChange(Collection<? extends ModelEvent> events) {
        return CoreUtils.isReadStateChange(events, false);
    }

    public static boolean isReadStateChange(Collection<? extends ModelEvent> events, boolean onlyHasBecomeUnread) {
        for (ModelEvent modelEvent : events) {
            if (!(modelEvent instanceof NewsEvent)) continue;
            NewsEvent newsEvent = (NewsEvent)modelEvent;
            boolean oldStateUnread = CoreUtils.isUnread(newsEvent.getOldNews() != null ? newsEvent.getOldNews().getState() : null);
            boolean newStateUnread = CoreUtils.isUnread(newsEvent.getEntity().getState());
            if (!(onlyHasBecomeUnread ? !oldStateUnread && newStateUnread : oldStateUnread != newStateUnread)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNewOrReadStateChange(Collection<? extends ModelEvent> events) {
        for (ModelEvent modelEvent : events) {
            boolean newStateUnread;
            boolean currentStateNew;
            if (!(modelEvent instanceof NewsEvent)) continue;
            NewsEvent newsEvent = (NewsEvent)modelEvent;
            boolean oldStateNew = INews.State.NEW.equals((Object)(newsEvent.getOldNews() != null ? newsEvent.getOldNews().getState() : null));
            if (oldStateNew != (currentStateNew = INews.State.NEW.equals((Object)newsEvent.getEntity().getState()))) {
                return true;
            }
            boolean oldStateUnread = CoreUtils.isUnread(newsEvent.getOldNews() != null ? newsEvent.getOldNews().getState() : null);
            if (oldStateUnread == (newStateUnread = CoreUtils.isUnread(newsEvent.getEntity().getState()))) continue;
            return true;
        }
        return false;
    }

    public static boolean isUnread(INews.State state) {
        return state == INews.State.NEW || state == INews.State.UPDATED || state == INews.State.UNREAD;
    }

    public static boolean isStateChange(Collection<NewsEvent> events) {
        for (NewsEvent event : events) {
            INews.State oldState;
            INews.State state = oldState = event.getOldNews() != null ? event.getOldNews().getState() : null;
            if (oldState == event.getEntity().getState()) continue;
            return true;
        }
        return false;
    }

    public static boolean isStateChange(NewsEvent newsEvent) {
        INews.State oldState;
        INews.State state = oldState = newsEvent.getOldNews() != null ? newsEvent.getOldNews().getState() : null;
        return oldState != newsEvent.getEntity().getState();
    }

    public static boolean gotDeleted(Collection<NewsEvent> events) {
        for (NewsEvent event : events) {
            boolean wasVisible;
            boolean isVisible = event.getEntity().isVisible();
            boolean bl = wasVisible = event.getOldNews() != null ? event.getOldNews().isVisible() : false;
            if (isVisible || !wasVisible) continue;
            return true;
        }
        return false;
    }

    public static boolean gotRestored(Collection<NewsEvent> events) {
        for (NewsEvent event : events) {
            boolean wasVisible;
            boolean isVisible = event.getEntity().isVisible();
            boolean bl = wasVisible = event.getOldNews() != null ? event.getOldNews().isVisible() : false;
            if (!isVisible || wasVisible || event.getOldNews() == null) continue;
            return true;
        }
        return false;
    }

    public static boolean isDateChange(Collection<NewsEvent> events) {
        for (NewsEvent event : events) {
            Date oldDate = event.getOldNews() != null ? DateUtils.getRecentDate(event.getOldNews()) : null;
            Date newDate = DateUtils.getRecentDate(event.getEntity());
            if (newDate.equals(oldDate)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPublishedDateChange(Collection<NewsEvent> events) {
        for (NewsEvent event : events) {
            Date oldDate = event.getOldNews() != null ? event.getOldNews().getPublishDate() : null;
            Date newDate = event.getEntity().getPublishDate();
            if (newDate != null && !newDate.equals(oldDate)) {
                return true;
            }
            if (oldDate == null || oldDate.equals(newDate)) continue;
            return true;
        }
        return false;
    }

    public static boolean isModifiedDateChange(Collection<NewsEvent> events) {
        for (NewsEvent event : events) {
            Date oldDate = event.getOldNews() != null ? event.getOldNews().getModifiedDate() : null;
            Date newDate = event.getEntity().getModifiedDate();
            if (newDate != null && !newDate.equals(oldDate)) {
                return true;
            }
            if (oldDate == null || oldDate.equals(newDate)) continue;
            return true;
        }
        return false;
    }

    public static boolean isLocationChange(Collection<NewsEvent> events) {
        Iterator<NewsEvent> iterator = events.iterator();
        if (iterator.hasNext()) {
            long newLocation;
            NewsEvent event = iterator.next();
            long oldLocation = event.getOldNews() != null ? event.getOldNews().getParentId() : 0L;
            return oldLocation != (newLocation = event.getEntity().getParentId()) && oldLocation != 0L;
        }
        return false;
    }

    public static boolean isAuthorChange(Collection<NewsEvent> events) {
        for (NewsEvent event : events) {
            IPerson oldAuthor = event.getOldNews() != null ? event.getOldNews().getAuthor() : null;
            IPerson newAuthor = event.getEntity().getAuthor();
            if (newAuthor != null && !newAuthor.equals(oldAuthor)) {
                return true;
            }
            if (oldAuthor == null || oldAuthor.equals(newAuthor)) continue;
            return true;
        }
        return false;
    }

    public static boolean isCategoryChange(Collection<NewsEvent> events) {
        for (NewsEvent event : events) {
            List<ICategory> oldCategories = event.getOldNews() != null ? event.getOldNews().getCategories() : null;
            List<ICategory> newCategories = event.getEntity().getCategories();
            if (newCategories.equals(oldCategories)) continue;
            return true;
        }
        return false;
    }

    public static boolean isLabelChange(Collection<NewsEvent> events) {
        return CoreUtils.isLabelChange(events, false);
    }

    public static boolean isLabelChange(Collection<NewsEvent> events, boolean onlyHasBecomeLabeled) {
        for (NewsEvent event : events) {
            Set<ILabel> oldLabels = event.getOldNews() != null ? event.getOldNews().getLabels() : null;
            Set<ILabel> newLabels = event.getEntity().getLabels();
            if (newLabels.equals(oldLabels)) continue;
            if (!onlyHasBecomeLabeled) {
                return true;
            }
            if (oldLabels != null && !oldLabels.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static boolean isLabelChange(NewsEvent event) {
        Set<ILabel> oldLabels = event.getOldNews() != null ? event.getOldNews().getLabels() : null;
        Set<ILabel> newLabels = event.getEntity().getLabels();
        return !newLabels.equals(oldLabels);
    }

    public static boolean isTitleChange(Collection<NewsEvent> events) {
        for (NewsEvent event : events) {
            String oldTopic = event.getOldNews() != null ? CoreUtils.getHeadline(event.getOldNews(), true) : null;
            String newTopic = CoreUtils.getHeadline(event.getEntity(), true);
            if (newTopic.equals(oldTopic)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasChildRelation(IFolder parent, IEntity entityToCheck) {
        if (entityToCheck instanceof IFolder) {
            IFolder folder = (IFolder)entityToCheck;
            if (parent.equals(folder)) {
                return true;
            }
            return CoreUtils.hasChildRelation(parent, folder.getParent());
        }
        if (entityToCheck instanceof IMark) {
            IMark mark = (IMark)entityToCheck;
            if (mark.getParent().equals(parent)) {
                return true;
            }
            return CoreUtils.hasChildRelation(parent, mark.getParent());
        }
        return false;
    }

    public static Set<String> getFeedLinks() {
        IBookMarkDAO bookMarkDAO = Owl.getPersistenceService().getDAOService().getBookMarkDAO();
        Collection bookMarks = bookMarkDAO.loadAll();
        HashSet<String> links = new HashSet<String>(bookMarks.size());
        for (IBookMark bookmark : bookMarks) {
            links.add(bookmark.getFeedLinkReference().getLinkAsText());
        }
        return links;
    }

    public static IBookMark getBookMark(FeedLinkReference feedRef) {
        return CoreUtils.getBookMark(feedRef.getLinkAsText());
    }

    public static IBookMark getBookMark(String feedRef) {
        IBookMarkDAO bookMarkDAO = Owl.getPersistenceService().getDAOService().getBookMarkDAO();
        Collection bookMarks = bookMarkDAO.loadAll();
        for (IBookMark bookMark : bookMarks) {
            if (!bookMark.getFeedLinkReference().getLinkAsText().equals(feedRef)) continue;
            return bookMark;
        }
        return null;
    }

    public static Map<INews.State, List<NewsReference>> toStateMap(Collection<INews> news) {
        HashMap<INews.State, List<NewsReference>> map = new HashMap<INews.State, List<NewsReference>>();
        for (INews newsitem : news) {
            INews.State state = newsitem.getState();
            ArrayList<NewsReference> newsrefs = (ArrayList<NewsReference>)map.get((Object)state);
            if (newsrefs == null) {
                newsrefs = new ArrayList<NewsReference>();
                map.put(state, newsrefs);
            }
            newsrefs.add(newsitem.toReference());
        }
        return map;
    }

    public static List<INews> resolveAll(Map<INews.State, List<NewsReference>> map) {
        ArrayList<INews> news = new ArrayList<INews>();
        Collection<List<NewsReference>> values = map.values();
        for (List<NewsReference> value : values) {
            for (NewsReference newsRef : value) {
                INews newsitem = newsRef.resolve();
                if (newsitem == null) continue;
                news.add(newsitem);
            }
        }
        return news;
    }

    public static Set<String> extractWords(List<ISearchCondition> conditions) {
        HashSet<String> words = new HashSet<String>(conditions.size());
        for (ISearchCondition cond : conditions) {
            if (!(cond.getValue() instanceof String)) continue;
            words.addAll(CoreUtils.extractWords(cond.getValue().toString()));
        }
        return words;
    }

    public static Set<String> extractWords(String str) {
        if (!StringUtils.isSet(str)) {
            return Collections.emptySet();
        }
        HashSet<String> words = new HashSet<String>();
        StringTokenizer tokenizer = new StringTokenizer(str, NON_CHAR_DIGIT_DELIMS);
        while (tokenizer.hasMoreElements()) {
            String nextWord = tokenizer.nextElement().toString().toLowerCase();
            if (STOP_WORDS.contains(nextWord) || !StringUtils.isSet(nextWord) || StringUtils.isWildcardsOnly(str)) continue;
            words.add(nextWord);
        }
        return words;
    }

    public static boolean isEmpty(INews news) {
        if (!StringUtils.isSet(news.getDescription())) {
            return true;
        }
        return StringUtils.isSet(news.getTitle()) && news.getTitle().equals(news.getDescription());
    }

    public static Set<IFolder> loadRootFolders() {
        TreeSet<IFolder> rootFolders = new TreeSet<IFolder>(new Comparator<IFolder>(){

            @Override
            public int compare(IFolder f1, IFolder f2) {
                if (f1.equals(f2)) {
                    return 0;
                }
                return f1.getId() < f2.getId() ? -1 : 1;
            }
        });
        rootFolders.addAll(DynamicDAO.getDAO(IFolderDAO.class).loadRoots());
        return rootFolders;
    }

    public static Set<ISearchMark> loadSortedSearchMarks() {
        TreeSet<ISearchMark> searchmarks = new TreeSet<ISearchMark>(new Comparator<ISearchMark>(){

            @Override
            public int compare(ISearchMark s1, ISearchMark s2) {
                if (s1.equals(s2)) {
                    return 0;
                }
                if (s1.getName().equalsIgnoreCase(s2.getName())) {
                    return -1;
                }
                return s1.getName().compareToIgnoreCase(s2.getName());
            }
        });
        searchmarks.addAll(DynamicDAO.loadAll(ISearchMark.class));
        return searchmarks;
    }

    public static Set<ISearchFilter> loadSortedNewsFilters() {
        TreeSet<ISearchFilter> filters = new TreeSet<ISearchFilter>(new Comparator<ISearchFilter>(){

            @Override
            public int compare(ISearchFilter f1, ISearchFilter f2) {
                if (f1.equals(f2)) {
                    return 0;
                }
                if (f1.getName().equalsIgnoreCase(f2.getName())) {
                    return -1;
                }
                return f1.getName().compareToIgnoreCase(f2.getName());
            }
        });
        filters.addAll(DynamicDAO.loadAll(ISearchFilter.class));
        return filters;
    }

    public static Set<ILabel> getSortedLabels(INews news) {
        Set<ILabel> newsLabels = news.getLabels();
        if (newsLabels.isEmpty() || newsLabels.size() == 1) {
            return newsLabels;
        }
        return CoreUtils.sortLabels(newsLabels);
    }

    public static Set<ILabel> loadSortedLabels() {
        return CoreUtils.sortLabels(DynamicDAO.loadAll(ILabel.class));
    }

    private static Set<ILabel> sortLabels(Collection<ILabel> labels) {
        TreeSet<ILabel> sortedLabels = new TreeSet<ILabel>(new Comparator<ILabel>(){

            @Override
            public int compare(ILabel l1, ILabel l2) {
                if (l1.equals(l2)) {
                    return 0;
                }
                return l1.getOrder() < l2.getOrder() ? -1 : 1;
            }
        });
        for (ILabel label : labels) {
            if (label == null) continue;
            sortedLabels.add(label);
        }
        return sortedLabels;
    }

    public static boolean containsState(Collection<NewsEvent> events, INews.State state) {
        for (NewsEvent event : events) {
            INews entity = event.getEntity();
            if (entity == null || entity.getState() != state) continue;
            return true;
        }
        return false;
    }

    public static Pair<ISearchCondition, List<ISearchCondition>> splitScope(List<ISearchCondition> conditions) {
        if (conditions == null) {
            return null;
        }
        ISearchCondition scope = null;
        ArrayList<ISearchCondition> otherConditions = new ArrayList<ISearchCondition>(conditions.size());
        for (ISearchCondition condition : conditions) {
            if (condition.getSpecifier() == SearchSpecifier.SCOPE) {
                scope = condition;
                continue;
            }
            otherConditions.add(condition);
        }
        return Pair.create(scope, otherConditions);
    }

    public static boolean isLocationConflict(List<ISearchCondition> conditions) {
        if (conditions == null || conditions.isEmpty()) {
            return false;
        }
        Pair<ISearchCondition, List<ISearchCondition>> splitConditions = CoreUtils.splitScope(conditions);
        if (splitConditions.getFirst() == null) {
            return false;
        }
        for (ISearchCondition condition : splitConditions.getSecond()) {
            if (condition.getField().getId() != 19) continue;
            return true;
        }
        return false;
    }

    public static void copy(InputStream fis, OutputStream fos) {
        block23: {
            try {
                try {
                    int nbytes;
                    byte[] buffer = new byte[65535];
                    while ((nbytes = fis.read(buffer)) != -1) {
                        fos.write(buffer, 0, nbytes);
                    }
                }
                catch (IOException e) {
                    block24: {
                        if (!(e instanceof MonitorCanceledException)) {
                            Activator.safeLogError(e.getMessage(), e);
                        }
                        if (fis != null) {
                            try {
                                fis.close();
                            }
                            catch (IOException e2) {
                                if (e2 instanceof MonitorCanceledException) break block24;
                                Activator.safeLogError(e2.getMessage(), e2);
                            }
                        }
                    }
                    if (fos == null) break block23;
                    try {
                        fos.close();
                    }
                    catch (IOException e3) {
                        if (!(e3 instanceof MonitorCanceledException)) {
                            Activator.safeLogError(e3.getMessage(), e3);
                        }
                    }
                }
            }
            finally {
                block26: {
                    block25: {
                        if (fis != null) {
                            try {
                                fis.close();
                            }
                            catch (IOException e) {
                                if (e instanceof MonitorCanceledException) break block25;
                                Activator.safeLogError(e.getMessage(), e);
                            }
                        }
                    }
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (IOException e) {
                            if (e instanceof MonitorCanceledException) break block26;
                            Activator.safeLogError(e.getMessage(), e);
                        }
                    }
                }
            }
        }
    }

    public static void write(String fileName, StringBuilder content) {
        block12: {
            OutputStreamWriter writer = null;
            try {
                try {
                    writer = new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), "UTF-8");
                    writer.write(content.toString());
                    writer.close();
                }
                catch (IOException e) {
                    Activator.safeLogError(e.getMessage(), e);
                    if (writer == null) break block12;
                    try {
                        writer.close();
                    }
                    catch (IOException e2) {
                        Activator.safeLogError(e2.getMessage(), e2);
                    }
                }
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException e) {
                        Activator.safeLogError(e.getMessage(), e);
                    }
                }
            }
        }
    }

    public static <T> List<T> removeIdentityDuplicates(List<T> list) {
        ArrayList<T> newList = new ArrayList<T>(list.size());
        IdentityHashMap<T, T> identityMap = new IdentityHashMap<T, T>();
        for (T t : list) {
            if (identityMap.containsKey(t)) continue;
            newList.add(t);
            identityMap.put(t, t);
        }
        return newList;
    }

    public static void reparentWithProperties(List<ReparentInfo<IFolderChild, IFolder>> reparenting) {
        for (ReparentInfo<IFolderChild, IFolder> info : reparenting) {
            IFolderChild objToReparent = info.getObject();
            IFolder newParent = info.getNewParent();
            Set<Map.Entry<String, Serializable>> set = newParent.getProperties().entrySet();
            for (Map.Entry<String, Serializable> entry : set) {
                if (objToReparent.getProperty(entry.getKey()) != null) continue;
                objToReparent.setProperty(entry.getKey(), entry.getValue());
            }
        }
        Owl.getPersistenceService().getDAOService().getFolderDAO().reparent(reparenting);
    }

    public static boolean existsSearchMark(ISearchMark search) {
        if (search == null || search.getParent() == null) {
            return false;
        }
        IFolder folder = CoreUtils.findFolder(search.getParent());
        if (folder != null) {
            List<IMark> marks = folder.getMarks();
            for (IMark mark : marks) {
                ISearchMark other;
                if (!(mark instanceof ISearchMark) || !CoreUtils.isIdentical(search, other = (ISearchMark)mark)) continue;
                return true;
            }
        }
        return false;
    }

    private static final boolean isIdentical(ISearchMark s1, ISearchMark s2) {
        if (s1.matchAllConditions() != s2.matchAllConditions()) {
            return false;
        }
        List conditions1 = s1.getSearchConditions();
        List conditions2 = s2.getSearchConditions();
        if (conditions1.size() != conditions2.size()) {
            return false;
        }
        int i = 0;
        while (i < conditions1.size()) {
            ISearchCondition condition1 = (ISearchCondition)conditions1.get(i);
            ISearchCondition condition2 = (ISearchCondition)conditions2.get(i);
            if (condition1.getField().getId() != condition2.getField().getId()) {
                return false;
            }
            if (condition1.getSpecifier() != condition2.getSpecifier()) {
                return false;
            }
            if (condition1.getField().getId() == 19 || condition2.getField().getId() == 19) {
                return false;
            }
            if (condition1.getValue() != null && !condition1.getValue().equals(condition2.getValue())) {
                return false;
            }
            if (condition1.getValue() == null && condition2.getValue() != null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean existsNewsBin(INewsBin bin) {
        if (bin == null || bin.getParent() == null) {
            return false;
        }
        IFolder folder = CoreUtils.findFolder(bin.getParent());
        if (folder != null) {
            List<IMark> marks = folder.getMarks();
            for (IMark mark : marks) {
                if (!(mark instanceof INewsBin) || !mark.getName().equals(bin.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public static IFolder findFolder(IFolder folder) {
        if (folder == null) {
            return null;
        }
        Collection<IFolder> folders = CoreUtils.loadRootFolders();
        if (folders.isEmpty()) {
            return null;
        }
        String defaultSetName = ((IFolder)folders.iterator().next()).getName();
        ArrayList<String> folderNameChain = new ArrayList<String>();
        if (folder.getProperty("org.rssowl.core.interpreter.typeimporter.TemporaryFolder") != null) {
            folderNameChain.add(defaultSetName);
        } else {
            folderNameChain.add(folder.getName());
        }
        IFolder parent = folder;
        while ((parent = parent.getParent()) != null) {
            if (parent.getProperty("org.rssowl.core.interpreter.typeimporter.TemporaryFolder") != null) {
                folderNameChain.add(defaultSetName);
                continue;
            }
            folderNameChain.add(parent.getName());
        }
        Collections.reverse(folderNameChain);
        IFolder foundFolder = null;
        for (String folderNameChainValue : folderNameChain) {
            foundFolder = CoreUtils.findFolderByName(folderNameChainValue, folders);
            if (foundFolder != null) {
                folders = foundFolder.getFolders();
                continue;
            }
            return null;
        }
        return foundFolder;
    }

    private static IFolder findFolderByName(String name, Collection<IFolder> folders) {
        for (IFolder folder : folders) {
            if (!folder.getName().equals(name)) continue;
            return folder;
        }
        return null;
    }

    public static URI findFeed(BufferedReader reader, URI base, IProgressMonitor monitor) {
        return CoreUtils.findUri(reader, base, FEED_MIME_TYPES, monitor);
    }

    public static URI findFavicon(BufferedReader reader, URI base, IProgressMonitor monitor) {
        return CoreUtils.findUri(reader, base, FAVICON_MARKERS, monitor);
    }

    private static URI findUri(BufferedReader reader, URI base, String[] markers, IProgressMonitor monitor) {
        try {
            String line;
            while (!monitor.isCanceled() && (line = reader.readLine()) != null) {
                String[] stringArray = markers;
                int n = markers.length;
                int n2 = 0;
                while (n2 < n) {
                    String marker = stringArray[n2];
                    int index = line.indexOf(marker);
                    if (index > -1) {
                        int i = index;
                        while (i >= 0) {
                            if (line.charAt(i) == '<') {
                                index = i;
                                break;
                            }
                            --i;
                        }
                        String usedHref = null;
                        int hrefIndex = -1;
                        String[] stringArray2 = HREF_VARIANTS;
                        int n3 = HREF_VARIANTS.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String href = stringArray2[n4];
                            hrefIndex = line.indexOf(href, index);
                            if (hrefIndex != -1) {
                                usedHref = href;
                                break;
                            }
                            ++n4;
                        }
                        if (hrefIndex > -1 && usedHref != null) {
                            String linkVal;
                            block20: {
                                boolean inQuotes = false;
                                StringBuilder str = new StringBuilder();
                                int i2 = hrefIndex + usedHref.length();
                                while (i2 < line.length()) {
                                    char c = line.charAt(i2);
                                    if (c == '\"' || c == '\'') {
                                        if (inQuotes) break;
                                        inQuotes = true;
                                    } else {
                                        if (Character.isWhitespace(c) || c == '>') break;
                                        str.append(c);
                                    }
                                    ++i2;
                                }
                                linkVal = str.toString();
                                linkVal = StringUtils.replaceAll(linkVal, "&amp;", "&");
                                try {
                                    URI uri = new URI(linkVal);
                                    linkVal = URIUtils.resolve(base, uri).toString();
                                }
                                catch (URISyntaxException uRISyntaxException) {
                                    if (linkVal.contains("://")) break block20;
                                    try {
                                        if (!linkVal.startsWith("/")) {
                                            linkVal = "/" + linkVal;
                                        }
                                        linkVal = base.resolve(linkVal).toString();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        linkVal = linkVal.startsWith("/") ? String.valueOf(base.toString()) + linkVal : String.valueOf(base.toString()) + "/" + linkVal;
                                    }
                                }
                            }
                            return new URI(URIUtils.fastEncode(linkVal));
                        }
                    }
                    ++n2;
                }
            }
        }
        catch (IOException e) {
            if (!(e instanceof MonitorCanceledException)) {
                Activator.safeLogError(e.getMessage(), e);
            }
        }
        catch (URISyntaxException e) {
            Activator.safeLogError(e.getMessage(), e);
        }
        return null;
    }

    public static String toMessage(Throwable ex) {
        if (ex instanceof InvocationTargetException && ex.getCause() != null && ex.getCause() instanceof Exception) {
            ex = ex.getCause();
        }
        if (ex instanceof UnknownProtocolException) {
            String protocol = ((UnknownProtocolException)((Object)ex)).getProtocol();
            return NLS.bind((String)Messages.CoreUtils_UNSUPPORTED_PROTOCOL, (Object)protocol);
        }
        if (ex instanceof UnknownFormatException) {
            String format = ((UnknownFormatException)((Object)ex)).getFormat();
            return NLS.bind((String)Messages.CoreUtils_UNSUPPORTED_FORMAT, (Object)format);
        }
        if (ex instanceof InterpreterException && ex.getCause() == null) {
            return Messages.CoreUtils_INVALID_FEED;
        }
        if (ex instanceof ParserException) {
            return Messages.CoreUtils_INVALID_FEED;
        }
        if (ex instanceof ConnectionException) {
            Throwable cause = ex.getCause();
            if (cause instanceof SocketTimeoutException) {
                return Messages.CoreUtils_CONNECTION_TIMEOUT;
            }
            if (cause instanceof UnknownHostException) {
                return Messages.CoreUtils_UNABLE_RESOLVE_HOST;
            }
            if (cause instanceof ConnectException) {
                return Messages.CoreUtils_UNABLE_CONNECT;
            }
            if (cause instanceof SocketException) {
                return Messages.CoreUtils_UNABLE_CONNECT;
            }
        }
        return ex.getMessage();
    }

    public static String getSafeFileNameForWindows(String fileName) {
        String candidate = fileName;
        String[] stringArray = RESERVED_FILENAME_CHARACTERS_WINDOWS;
        int n = RESERVED_FILENAME_CHARACTERS_WINDOWS.length;
        int n2 = 0;
        while (n2 < n) {
            String reservedChar = stringArray[n2];
            candidate = StringUtils.replaceAll(candidate, reservedChar, "");
            ++n2;
        }
        return candidate;
    }

    public static String getUserAgent() {
        String version = Activator.getDefault().getVersion();
        String os = Platform.getOS();
        if ("win32".equals(os)) {
            return "RSSOwl/" + version + " (Windows; U; en)";
        }
        if ("linux".equals(os)) {
            return "RSSOwl/" + version + " (X11; U; en)";
        }
        if ("macosx".equals(os)) {
            return "RSSOwl/" + version + " (Macintosh; U; en)";
        }
        return "RSSOwl/" + version;
    }

    public static List<INews> replace(List<INews> news, Map<INews, INews> replacements) {
        if (replacements == null || replacements.isEmpty()) {
            return news;
        }
        ArrayList<INews> replacedNews = new ArrayList<INews>();
        for (INews newsitem : news) {
            INews replacedItem = replacements.get(newsitem);
            if (replacedItem != null) {
                replacedNews.add(replacedItem);
                continue;
            }
            replacedNews.add(newsitem);
        }
        return replacedNews;
    }

    public static void appendLogMessage(String str) {
        if (str != null) {
            fgLogBuffer.append(str);
        }
    }

    public static String getAndFlushLogMessages() {
        String str = fgLogBuffer.toString();
        fgLogBuffer.setLength(0);
        return str;
    }

    public static void fillBookMarks(Collection<IBookMark> bookmarks, Collection<IFolder> folders) {
        for (IFolder folder : folders) {
            List<IFolderChild> children = folder.getChildren();
            for (IFolderChild child : children) {
                if (child instanceof IBookMark) {
                    bookmarks.add((IBookMark)child);
                    continue;
                }
                if (!(child instanceof IFolder)) continue;
                CoreUtils.fillBookMarks(bookmarks, Collections.singleton((IFolder)child));
            }
        }
    }

    public static void fillSearchMarks(Collection<ISearchMark> searchmarks, Collection<IFolder> folders) {
        for (IFolder folder : folders) {
            List<IFolderChild> children = folder.getChildren();
            for (IFolderChild child : children) {
                if (child instanceof ISearchMark) {
                    searchmarks.add((ISearchMark)child);
                    continue;
                }
                if (!(child instanceof IFolder)) continue;
                CoreUtils.fillSearchMarks(searchmarks, Collections.singleton((IFolder)child));
            }
        }
    }

    public static void fillNewsBins(Collection<INewsBin> newsbins, Collection<IFolder> folders) {
        for (IFolder folder : folders) {
            List<IFolderChild> children = folder.getChildren();
            for (IFolderChild child : children) {
                if (child instanceof INewsBin) {
                    newsbins.add((INewsBin)child);
                    continue;
                }
                if (!(child instanceof IFolder)) continue;
                CoreUtils.fillNewsBins(newsbins, Collections.singleton((IFolder)child));
            }
        }
    }

    public static void fillFolders(Collection<IFolder> foldersList, Collection<IFolder> folders) {
        for (IFolder folder : folders) {
            List<IFolder> children = folder.getFolders();
            for (IFolder child : children) {
                foldersList.add(child);
                CoreUtils.fillFolders(foldersList, Collections.singleton(child));
            }
        }
    }

    public static void removeFiltersByScope(Collection<ISearchFilter> filters, String feedLink) {
        ArrayList<ISearchFilter> filtersToRemove = new ArrayList<ISearchFilter>();
        block0: for (ISearchFilter filter : filters) {
            List<IFolderChild> scope = CoreUtils.getLocationScope(filter);
            if (scope == null) continue;
            for (IFolderChild entity : scope) {
                IBookMark bm;
                if (!(entity instanceof IBookMark) || feedLink.equals((bm = (IBookMark)entity).getFeedLinkReference().getLinkAsText())) continue block0;
            }
            filtersToRemove.add(filter);
        }
        if (!filtersToRemove.isEmpty()) {
            filters.removeAll(filtersToRemove);
        }
    }

    private static List<IFolderChild> getLocationScope(ISearchFilter filter) {
        if (filter.getSearch() == null || filter.matchAllNews()) {
            return null;
        }
        ArrayList<ISearchCondition> locationConditions = new ArrayList<ISearchCondition>(1);
        List<ISearchCondition> conditions = filter.getSearch().getSearchConditions();
        for (ISearchCondition condition : conditions) {
            if (condition.getSpecifier() == SearchSpecifier.SCOPE && condition.getValue() instanceof Long[][]) {
                return CoreUtils.toEntities((Long[][])condition.getValue());
            }
            if (condition.getField().getId() != 19) continue;
            locationConditions.add(condition);
        }
        if (locationConditions.size() == 1 && ((ISearchCondition)locationConditions.get(0)).getValue() instanceof Long[][] && (filter.getSearch().matchAllConditions() || conditions.size() == 1)) {
            return CoreUtils.toEntities((Long[][])((ISearchCondition)locationConditions.get(0)).getValue());
        }
        return null;
    }

    public static INewsBin findArchive() {
        Collection<INewsBin> bins = DynamicDAO.loadAll(INewsBin.class);
        for (INewsBin bin : bins) {
            if (bin.getProperty(DefaultPreferences.ARCHIVE_BIN_MARKER) == null) continue;
            return bin;
        }
        return null;
    }

    public static void reportIndexIssue() {
        IPreferenceScope preferences;
        if (!fgReportedIndexIssue.getAndSet(true) && !(preferences = Owl.getPreferenceService().getGlobalScope()).getBoolean(DefaultPreferences.CLEAN_UP_INDEX)) {
            preferences.putBoolean(DefaultPreferences.CLEAN_UP_INDEX, true);
            if (!preferences.getBoolean(DefaultPreferences.CLEAN_UP_REMINDER_STATE)) {
                preferences.putBoolean(DefaultPreferences.CLEAN_UP_READ_NEWS_STATE, true);
            }
        }
    }

    public static boolean hasAttachment(INews news, URI link) {
        List<IAttachment> attachments = news.getAttachments();
        for (IAttachment attachment : attachments) {
            if (!link.equals(attachment.getLink())) continue;
            return true;
        }
        return false;
    }

    public static boolean isOrphaned(ISearchFilter filter) {
        ISearch search = filter.getSearch();
        if (search != null && CoreUtils.isOrphaned(search)) {
            return true;
        }
        boolean isOrphaned = false;
        List<IFilterAction> actions = filter.getActions();
        for (IFilterAction action : actions) {
            if (!"org.rssowl.core.CopyNewsAction".equals(action.getActionId()) && !"org.rssowl.core.MoveNewsAction".equals(action.getActionId())) {
                return false;
            }
            Object data = action.getData();
            if (!(data instanceof Long[][])) continue;
            List<IFolderChild> entities = CoreUtils.toEntities((Long[][])data);
            if (!entities.isEmpty()) {
                return false;
            }
            isOrphaned = true;
        }
        return isOrphaned;
    }

    public static boolean isOrphaned(ISearch search) {
        List<ISearchCondition> conditions = search.getSearchConditions();
        for (ISearchCondition condition : conditions) {
            List<IFolderChild> entities;
            Object value;
            if (!(condition.getSpecifier() == SearchSpecifier.SCOPE ? ((value = condition.getValue()) instanceof Long[][] ? (entities = CoreUtils.toEntities((Long[][])value)).isEmpty() : value == null) : condition.getField().getId() == 19 && ((value = condition.getValue()) instanceof Long[][] ? (entities = CoreUtils.toEntities((Long[][])value)).isEmpty() && (search.matchAllConditions() || conditions.size() == 1) : value == null))) continue;
            return true;
        }
        return false;
    }

    public static <T> List<List<T>> toChunks(List<T> list, int chunkSize) {
        ArrayList<List<T>> chunkList = new ArrayList<List<T>>();
        ArrayList<T> currentChunk = new ArrayList<T>(chunkSize);
        chunkList.add(currentChunk);
        int counter = 0;
        for (T entry : list) {
            currentChunk.add(entry);
            if (++counter % chunkSize != 0) continue;
            currentChunk = new ArrayList(chunkSize);
            chunkList.add(currentChunk);
        }
        if (currentChunk.isEmpty()) {
            chunkList.remove(currentChunk);
        }
        return chunkList;
    }
}

