/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.eclipse.core.runtime.Assert;
import org.rssowl.core.internal.persist.News;
import org.rssowl.core.persist.INews;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateUtils {
    public static final long DAY = 86400000L;
    public static final long WEEK = 604800000L;
    private static final DateFormat[] CUSTOM_DATE_FORMATS;
    private static final TimeZone TIMEZONE;

    static {
        TIMEZONE = TimeZone.getTimeZone("UTC");
        String[] possibleDateFormats = new String[]{"EEE, dd MMM yy HH:mm:ss z", "EEE, dd MMM yyyy HH:mm:ss z", "EEE, dd MMM yy HH:mm:ss", "EEE, MMM dd yy HH:mm:ss", "EEE, dd MMM yy HH:mm z", "EEE dd MMM yyyy HH:mm:ss", "dd MMM yy HH:mm:ss z", "dd MMM yy HH:mm z", "yyyy-MM-dd'T'HH:mm:ssZ", "yyyy-MM-dd'T'HH:mm:ss'Z'", "yyyy-MM-dd'T'HH:mm:sszzzz", "yyyy-MM-dd'T'HH:mm:ss z", "yyyy-MM-dd'T'HH:mm:ssz", "yyyy-MM-dd'T'HH:mm:ss.SSSz", "yyyy-MM-dd'T'HHmmss.SSSz", "yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd'T'HH:mmZ", "yyyy-MM-dd'T'HH:mm'Z'", "dd MMM yyyy HH:mm:ss z", "dd MMM yyyy HH:mm z", "yyyy-MM-dd", "MMM dd, yyyy"};
        CUSTOM_DATE_FORMATS = new SimpleDateFormat[possibleDateFormats.length];
        int i = 0;
        while (i < possibleDateFormats.length) {
            DateUtils.CUSTOM_DATE_FORMATS[i] = new SimpleDateFormat(possibleDateFormats[i], Locale.ENGLISH);
            CUSTOM_DATE_FORMATS[i].setTimeZone(TIMEZONE);
            ++i;
        }
    }

    public static Calendar getToday() {
        Calendar today = Calendar.getInstance();
        today.set(11, 0);
        today.set(12, 0);
        today.set(13, 0);
        today.set(14, 0);
        return today;
    }

    public static boolean isAfterIncludingToday(Date date, long todayMidnightInMillies) {
        long time = date.getTime();
        return todayMidnightInMillies <= time;
    }

    public static Date getRecentDate(INews news) {
        return ((News)news).fastGetRecentDate();
    }

    public static Date getRecentDate(List<INews> news) {
        Assert.isTrue((!news.isEmpty() ? 1 : 0) != 0);
        Date mostRecentDate = null;
        for (INews newsitem : news) {
            Date date = DateUtils.getRecentDate(newsitem);
            if (mostRecentDate != null && !date.after(mostRecentDate)) continue;
            mostRecentDate = date;
        }
        return mostRecentDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date parseDate(String strdate) {
        if (strdate == null || strdate.length() == 0) {
            return null;
        }
        Date result = null;
        if ((strdate = strdate.trim()).length() > 10) {
            String dateEnd;
            if ((strdate.substring(strdate.length() - 5).indexOf("+") == 0 || strdate.substring(strdate.length() - 5).indexOf("-") == 0) && strdate.substring(strdate.length() - 5).indexOf(":") == 2) {
                String sign = strdate.substring(strdate.length() - 5, strdate.length() - 4);
                strdate = String.valueOf(strdate.substring(0, strdate.length() - 5)) + sign + "0" + strdate.substring(strdate.length() - 4);
            }
            if (!((dateEnd = strdate.substring(strdate.length() - 6)).indexOf("-") != 0 && dateEnd.indexOf("+") != 0 || dateEnd.indexOf(":") != 3 || "GMT".equals(strdate.substring(strdate.length() - 9, strdate.length() - 6)))) {
                String oldDate = strdate;
                String newEnd = String.valueOf(dateEnd.substring(0, 3)) + dateEnd.substring(4);
                strdate = String.valueOf(oldDate.substring(0, oldDate.length() - 6)) + newEnd;
            }
        }
        int i = 0;
        while (i < CUSTOM_DATE_FORMATS.length) {
            try {
                DateFormat dateFormat = CUSTOM_DATE_FORMATS[i];
                synchronized (dateFormat) {
                    return CUSTOM_DATE_FORMATS[i].parse(strdate);
                }
            }
            catch (ParseException parseException) {
                ++i;
            }
            catch (NumberFormatException numberFormatException) {
                ++i;
            }
        }
        return result;
    }
}

