/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;

final class PlasticBumps
implements Icon {
    private static final List<BumpBuffer> BUFFERS = new ArrayList<BumpBuffer>();
    private int xBumps;
    private int yBumps;
    private Color topColor;
    private Color shadowColor;
    private Color backColor;
    private BumpBuffer buffer;

    PlasticBumps(int width, int height, Color newTopColor, Color newShadowColor, Color newBackColor) {
        this.setBumpArea(width, height);
        this.setBumpColors(newTopColor, newShadowColor, newBackColor);
    }

    void setBumpArea(int width, int height) {
        this.xBumps = width / 2;
        this.yBumps = height / 2;
    }

    void setBumpColors(Color newTopColor, Color newShadowColor, Color newBackColor) {
        this.topColor = newTopColor;
        this.shadowColor = newShadowColor;
        this.backColor = newBackColor;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        GraphicsConfiguration gc = g instanceof Graphics2D ? ((Graphics2D)g).getDeviceConfiguration() : null;
        this.buffer = this.getBuffer(gc, this.topColor, this.shadowColor, this.backColor);
        int bufferWidth = BumpBuffer.getImageSize().width;
        int bufferHeight = BumpBuffer.getImageSize().height;
        int iconWidth = this.getIconWidth();
        int iconHeight = this.getIconHeight();
        int x2 = x + iconWidth;
        int y2 = y + iconHeight;
        int savex = x;
        while (y < y2) {
            int h = Math.min(y2 - y, bufferHeight);
            for (x = savex; x < x2; x += bufferWidth) {
                int w = Math.min(x2 - x, bufferWidth);
                g.drawImage(this.buffer.getImage(), x, y, x + w, y + h, 0, 0, w, h, null);
            }
            y += bufferHeight;
        }
    }

    @Override
    public int getIconWidth() {
        return this.xBumps * 2;
    }

    @Override
    public int getIconHeight() {
        return this.yBumps * 2;
    }

    private BumpBuffer getBuffer(GraphicsConfiguration gc, Color aTopColor, Color aShadowColor, Color aBackColor) {
        if (this.buffer != null && this.buffer.hasSameConfiguration(gc, aTopColor, aShadowColor, aBackColor)) {
            return this.buffer;
        }
        BumpBuffer result = null;
        for (BumpBuffer aBuffer : BUFFERS) {
            if (!aBuffer.hasSameConfiguration(gc, aTopColor, aShadowColor, aBackColor)) continue;
            result = aBuffer;
            break;
        }
        if (result == null) {
            result = new BumpBuffer(gc, this.topColor, this.shadowColor, this.backColor);
            BUFFERS.add(result);
        }
        return result;
    }

    private static final class BumpBuffer {
        private static final int IMAGE_SIZE = 64;
        private static Dimension imageSize = new Dimension(64, 64);
        transient Image image;
        private final Color topColor;
        private final Color shadowColor;
        private final Color backColor;
        private final GraphicsConfiguration gc;

        BumpBuffer(GraphicsConfiguration gc, Color aTopColor, Color aShadowColor, Color aBackColor) {
            this.gc = gc;
            this.topColor = aTopColor;
            this.shadowColor = aShadowColor;
            this.backColor = aBackColor;
            this.createImage();
            this.fillBumpBuffer();
        }

        boolean hasSameConfiguration(GraphicsConfiguration aGC, Color aTopColor, Color aShadowColor, Color aBackColor) {
            if (this.gc != null ? !this.gc.equals(aGC) : aGC != null) {
                return false;
            }
            return this.topColor.equals(aTopColor) && this.shadowColor.equals(aShadowColor) && this.backColor.equals(aBackColor);
        }

        Image getImage() {
            return this.image;
        }

        static Dimension getImageSize() {
            return imageSize;
        }

        private void fillBumpBuffer() {
            int y;
            int x;
            Graphics g = this.image.getGraphics();
            g.setColor(this.backColor);
            g.fillRect(0, 0, 64, 64);
            g.setColor(this.topColor);
            for (x = 0; x < 64; x += 4) {
                for (y = 0; y < 64; y += 4) {
                    g.drawLine(x, y, x, y);
                    g.drawLine(x + 2, y + 2, x + 2, y + 2);
                }
            }
            g.setColor(this.shadowColor);
            for (x = 0; x < 64; x += 4) {
                for (y = 0; y < 64; y += 4) {
                    g.drawLine(x + 1, y + 1, x + 1, y + 1);
                    g.drawLine(x + 3, y + 3, x + 3, y + 3);
                }
            }
            g.dispose();
        }

        private void createImage() {
            if (this.gc != null) {
                this.image = this.gc.createCompatibleImage(64, 64);
            } else {
                int[] cmap = new int[]{this.backColor.getRGB(), this.topColor.getRGB(), this.shadowColor.getRGB()};
                IndexColorModel icm = new IndexColorModel(8, 3, cmap, 0, false, -1, 0);
                this.image = new BufferedImage(64, 64, 13, icm);
            }
        }
    }
}

