/*
 * Decompiled with CFR 0.152.
 */
package gnu.dtools.ritopt;

import gnu.dtools.ritopt.Option;

public class OptionEvent {
    private String command;
    private String value;
    private Option target;

    public OptionEvent() {
        this("Default", "", null);
    }

    public OptionEvent(String command) {
        this(command, "", null);
    }

    public OptionEvent(String command, String value) {
        this(command, value, null);
    }

    public OptionEvent(Option option) {
        this.target = option;
        this.value = option.getStringValue();
        String longOption = option.getLongOption();
        char shortOption = option.getShortOption();
        this.command = longOption != null ? longOption : (shortOption != '\u0000' ? new Character(shortOption).toString() : "Default");
    }

    public OptionEvent(String command, String value, Option target) {
        this.command = command;
        this.value = value;
        this.target = target;
    }

    public String getCommand() {
        return this.command;
    }

    public String getValue() {
        return this.value;
    }

    public Option getTarget() {
        return this.target;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setTarget(Option target) {
        this.target = target;
    }
}

