/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import java.util.prefs.BackingStoreException;
import java.util.prefs.InvalidPreferencesFormatException;
import java.util.prefs.Preferences;
import javax.swing.KeyStroke;
import net.sf.jabref.CustomEntryType;
import net.sf.jabref.EntryEditorTabList;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.ImportSettingsTab;
import net.sf.jabref.JabRef;
import net.sf.jabref.Util;
import net.sf.jabref.export.CustomExportList;
import net.sf.jabref.export.ExportComparator;
import net.sf.jabref.external.ExternalFileType;
import net.sf.jabref.external.UnknownExternalFileType;
import net.sf.jabref.gui.CleanUpAction;
import net.sf.jabref.imports.CustomImportList;
import net.sf.jabref.labelPattern.LabelPattern;
import net.sf.jabref.specialfields.SpecialFieldsUtils;

public class JabRefPreferences {
    public static final String CUSTOM_TYPE_NAME = "customTypeName_";
    public static final String CUSTOM_TYPE_REQ = "customTypeReq_";
    public static final String CUSTOM_TYPE_OPT = "customTypeOpt_";
    public static final String CUSTOM_TYPE_PRIOPT = "customTypePriOpt_";
    public static final String CUSTOM_TAB_NAME = "customTabName_";
    public static final String CUSTOM_TAB_FIELDS = "customTabFields_";
    public static final String EMACS_PATH = "emacsPath";
    public static final String EMACS_ADDITIONAL_PARAMETERS = "emacsParameters";
    public static final String EMACS_23 = "emacsUseV23InsertString";
    public static final String EDIT_GROUP_MEMBERSHIP_MODE = "groupEditGroupMembershipMode";
    public static final String PDF_PREVIEW = "pdfPreview";
    public static final String SHOWONELETTERHEADINGFORICONCOLUMNS = "showOneLetterHeadingForIconColumns";
    public static final String SHORTEST_TO_COMPLETE = "shortestToComplete";
    public static final String AUTOCOMPLETE_FIRSTNAME_MODE = "autoCompFirstNameMode";
    public static final String AUTOCOMPLETE_FIRSTNAME_MODE_BOTH = "both";
    public static final String AUTOCOMPLETE_FIRSTNAME_MODE_ONLY_FULL = "fullOnly";
    public static final String AUTOCOMPLETE_FIRSTNAME_MODE_ONLY_ABBR = "abbrOnly";
    public static final String FILE_TYPE_REMOVED_FLAG = "REMOVED";
    public String WRAPPED_USERNAME;
    public String MARKING_WITH_NUMBER_PATTERN;
    Preferences prefs;
    public HashMap<String, Object> defaults = new HashMap();
    public HashMap<String, String> keyBinds = new HashMap();
    public HashMap<String, String> defKeyBinds = new HashMap();
    private HashSet<String> putBracesAroundCapitalsFields = new HashSet(4);
    private HashSet<String> nonWrappableFields = new HashSet(5);
    private static LabelPattern keyPattern;
    public CustomExportList customExports;
    public CustomImportList customImports;
    private EntryEditorTabList tabList = null;
    private TreeSet<ExternalFileType> externalFileTypes = new TreeSet();
    public final ExternalFileType HTML_FALLBACK_TYPE = new ExternalFileType("URL", "html", "text/html", "", "www");
    public String[] fileDirForDatabase = null;
    public File databaseFile = null;
    public HashMap<String, String> customExportNameFormatters = null;
    private static JabRefPreferences singleton;
    public static final String DEFAULT_REG_EXP_SEARCH_EXPRESSION_KEY = "defaultRegExpSearchExpression";
    public static final String REG_EXP_SEARCH_EXPRESSION_KEY = "regExpSearchExpression";
    public static final String USE_REG_EXP_SEARCH_KEY = "useRegExpSearch";
    public static final String EMAIL_SUBJECT = "emailSubject";
    public static final String OPEN_FOLDERS_OF_ATTACHED_FILES = "openFoldersOfAttachedFiles";

    public static JabRefPreferences getInstance() {
        if (singleton == null) {
            singleton = new JabRefPreferences();
        }
        return singleton;
    }

    private JabRefPreferences() {
        try {
            if (new File("jabref.xml").exists()) {
                this.importPreferences("jabref.xml");
            }
        }
        catch (IOException e) {
            Globals.logger("Could not import preferences from jabref.xml:" + e.getLocalizedMessage());
        }
        this.prefs = Preferences.userNodeForPackage(JabRef.class);
        if (Globals.osName.equals("Mac OS X")) {
            this.defaults.put(EMACS_PATH, "emacsclient");
            this.defaults.put(EMACS_23, true);
            this.defaults.put(EMACS_ADDITIONAL_PARAMETERS, "-n -e");
            this.defaults.put("fontFamily", "SansSerif");
        } else if (Globals.osName.toLowerCase().startsWith("windows")) {
            this.defaults.put("lookAndFeel", "com.jgoodies.looks.windows.WindowsLookAndFeel");
            this.defaults.put("winEdtPath", "C:\\Program Files\\WinEdt Team\\WinEdt\\WinEdt.exe");
            this.defaults.put("latexEditorPath", "C:\\Program Files\\LEd\\LEd.exe");
            this.defaults.put(EMACS_PATH, "emacsclient.exe");
            this.defaults.put(EMACS_23, true);
            this.defaults.put(EMACS_ADDITIONAL_PARAMETERS, "-n -e");
            this.defaults.put("fontFamily", "Arial");
        } else {
            this.defaults.put("lookAndFeel", "com.jgoodies.plaf.plastic.Plastic3DLookAndFeel");
            this.defaults.put("fontFamily", "SansSerif");
            this.defaults.put(EMACS_PATH, "gnuclient");
            this.defaults.put(EMACS_23, false);
            this.defaults.put(EMACS_ADDITIONAL_PARAMETERS, "-batch -eval");
        }
        this.defaults.put(PDF_PREVIEW, Boolean.FALSE);
        this.defaults.put("useDefaultLookAndFeel", Boolean.TRUE);
        this.defaults.put("lyxpipe", System.getProperty("user.home") + File.separator + ".lyx/lyxpipe");
        this.defaults.put("vim", "vim");
        this.defaults.put("vimServer", "vim");
        this.defaults.put("posX", new Integer(0));
        this.defaults.put("posY", new Integer(0));
        this.defaults.put("sizeX", new Integer(840));
        this.defaults.put("sizeY", new Integer(680));
        this.defaults.put("windowMaximised", Boolean.FALSE);
        this.defaults.put("autoResizeMode", new Integer(4));
        this.defaults.put("previewPanelHeight", 200);
        this.defaults.put("entryEditorHeight", 400);
        this.defaults.put("tableColorCodesOn", Boolean.TRUE);
        this.defaults.put("namesAsIs", Boolean.FALSE);
        this.defaults.put("namesFf", Boolean.FALSE);
        this.defaults.put("namesLf", Boolean.FALSE);
        this.defaults.put("namesNatbib", Boolean.TRUE);
        this.defaults.put("abbrAuthorNames", Boolean.TRUE);
        this.defaults.put("namesLastOnly", Boolean.TRUE);
        this.defaults.put("language", "en");
        this.defaults.put("showShort", Boolean.TRUE);
        this.defaults.put("priSort", "author");
        this.defaults.put("priDescending", Boolean.FALSE);
        this.defaults.put("priBinary", Boolean.FALSE);
        this.defaults.put("secSort", "year");
        this.defaults.put("secDescending", Boolean.TRUE);
        this.defaults.put("terSort", "author");
        this.defaults.put("terDescending", Boolean.FALSE);
        this.defaults.put("columnNames", "entrytype;author;title;year;journal;owner;timestamp;bibtexkey");
        this.defaults.put("columnWidths", "75;280;400;60;100;100;100;100");
        this.defaults.put("ActivatePersistenceTableColumnListener", new Boolean(true));
        this.defaults.put("xmpPrivacyFilters", "pdf;timestamp;keywords;owner;note;review");
        this.defaults.put("useXmpPrivacyFilter", Boolean.FALSE);
        this.defaults.put("numberColWidth", new Integer(GUIGlobals.NUMBER_COL_LENGTH));
        this.defaults.put("workingDirectory", System.getProperty("user.home"));
        this.defaults.put("exportWorkingDirectory", System.getProperty("user.home"));
        this.defaults.put("importWorkingDirectory", System.getProperty("user.home"));
        this.defaults.put("fileWorkingDirectory", System.getProperty("user.home"));
        this.defaults.put("autoOpenForm", Boolean.TRUE);
        this.defaults.put("entryTypeFormHeightFactor", new Integer(1));
        this.defaults.put("entryTypeFormWidth", new Integer(1));
        this.defaults.put("backup", Boolean.TRUE);
        this.defaults.put("openLastEdited", Boolean.TRUE);
        this.defaults.put("lastEdited", null);
        this.defaults.put("stringsPosX", new Integer(0));
        this.defaults.put("stringsPosY", new Integer(0));
        this.defaults.put("stringsSizeX", new Integer(600));
        this.defaults.put("stringsSizeY", new Integer(400));
        this.defaults.put("defaultShowSource", Boolean.FALSE);
        this.defaults.put("showSource", Boolean.TRUE);
        this.defaults.put("defaultAutoSort", Boolean.FALSE);
        this.defaults.put("enableSourceEditing", Boolean.TRUE);
        this.defaults.put("caseSensitiveSearch", Boolean.FALSE);
        this.defaults.put("searchReq", Boolean.TRUE);
        this.defaults.put("searchOpt", Boolean.TRUE);
        this.defaults.put("searchGen", Boolean.TRUE);
        this.defaults.put("searchAll", Boolean.FALSE);
        this.defaults.put("incrementS", Boolean.FALSE);
        this.defaults.put("searchAutoComplete", Boolean.TRUE);
        this.defaults.put("saveInStandardOrder", Boolean.TRUE);
        this.defaults.put("saveInOriginalOrder", Boolean.FALSE);
        this.defaults.put("exportInStandardOrder", Boolean.TRUE);
        this.defaults.put("exportInOriginalOrder", Boolean.FALSE);
        this.defaults.put("selectS", Boolean.FALSE);
        this.defaults.put("regExpSearch", Boolean.TRUE);
        this.defaults.put("highLightWords", Boolean.TRUE);
        this.defaults.put("searchPanePosX", new Integer(0));
        this.defaults.put("searchPanePosY", new Integer(0));
        this.defaults.put("autoComplete", Boolean.TRUE);
        this.defaults.put("autoCompleteFields", "author;editor;title;journal;publisher;keywords;crossref");
        this.defaults.put("autoCompFF", Boolean.FALSE);
        this.defaults.put("autoCompLF", Boolean.FALSE);
        this.defaults.put(SHORTEST_TO_COMPLETE, new Integer(2));
        this.defaults.put(AUTOCOMPLETE_FIRSTNAME_MODE, AUTOCOMPLETE_FIRSTNAME_MODE_BOTH);
        this.defaults.put("groupSelectorVisible", Boolean.TRUE);
        this.defaults.put("groupFloatSelections", Boolean.TRUE);
        this.defaults.put("groupIntersectSelections", Boolean.TRUE);
        this.defaults.put("groupInvertSelections", Boolean.FALSE);
        this.defaults.put("groupShowOverlapping", Boolean.FALSE);
        this.defaults.put("groupSelectMatches", Boolean.FALSE);
        this.defaults.put("groupsDefaultField", "keywords");
        this.defaults.put("groupShowIcons", Boolean.TRUE);
        this.defaults.put("groupShowDynamic", Boolean.TRUE);
        this.defaults.put("groupExpandTree", Boolean.TRUE);
        this.defaults.put("groupAutoShow", Boolean.TRUE);
        this.defaults.put("groupAutoHide", Boolean.TRUE);
        this.defaults.put("autoAssignGroup", Boolean.TRUE);
        this.defaults.put("groupKeywordSeparator", ", ");
        this.defaults.put(EDIT_GROUP_MEMBERSHIP_MODE, Boolean.FALSE);
        this.defaults.put("highlightGroupsMatchingAny", Boolean.FALSE);
        this.defaults.put("highlightGroupsMatchingAll", Boolean.FALSE);
        this.defaults.put("searchPanelVisible", Boolean.FALSE);
        this.defaults.put("defaultEncoding", System.getProperty("file.encoding"));
        this.defaults.put("groupsVisibleRows", new Integer(8));
        this.defaults.put("defaultOwner", System.getProperty("user.name"));
        this.defaults.put("preserveFieldFormatting", Boolean.FALSE);
        this.defaults.put("memoryStickMode", Boolean.FALSE);
        this.defaults.put("renameOnMoveFileToFileDir", Boolean.TRUE);
        this.defaults.put("generalFields", "crossref;keywords;file;doi;url;urldate;pdf;comment;owner");
        this.defaults.put("useCustomIconTheme", Boolean.FALSE);
        this.defaults.put("customIconThemeFile", "/home/alver/div/crystaltheme_16/Icons.properties");
        this.defaults.put("historySize", new Integer(8));
        this.defaults.put("fontStyle", new Integer(0));
        this.defaults.put("fontSize", new Integer(12));
        this.defaults.put("overrideDefaultFonts", Boolean.FALSE);
        this.defaults.put("menuFontFamily", "Times");
        this.defaults.put("menuFontStyle", new Integer(0));
        this.defaults.put("menuFontSize", new Integer(11));
        this.defaults.put("tableBackground", "255:255:255");
        this.defaults.put("tableReqFieldBackground", "230:235:255");
        this.defaults.put("tableOptFieldBackground", "230:255:230");
        this.defaults.put("tableText", "0:0:0");
        this.defaults.put("gridColor", "210:210:210");
        this.defaults.put("grayedOutBackground", "210:210:210");
        this.defaults.put("grayedOutText", "40:40:40");
        this.defaults.put("veryGrayedOutBackground", "180:180:180");
        this.defaults.put("veryGrayedOutText", "40:40:40");
        this.defaults.put("markedEntryBackground0", "255:255:180");
        this.defaults.put("markedEntryBackground1", "255:220:180");
        this.defaults.put("markedEntryBackground2", "255:180:160");
        this.defaults.put("markedEntryBackground3", "255:120:120");
        this.defaults.put("markedEntryBackground4", "255:75:75");
        this.defaults.put("markedEntryBackground5", "220:255:220");
        this.defaults.put("validFieldBackgroundColor", "255:255:255");
        this.defaults.put("invalidFieldBackgroundColor", "255:0:0");
        this.defaults.put("activeFieldEditorBackgroundColor", "220:220:255");
        this.defaults.put("fieldEditorTextColor", "0:0:0");
        this.defaults.put("incompleteEntryBackground", "250:175:175");
        this.defaults.put("antialias", Boolean.FALSE);
        this.defaults.put("ctrlClick", Boolean.FALSE);
        this.defaults.put("disableOnMultipleSelection", Boolean.FALSE);
        this.defaults.put("pdfColumn", Boolean.FALSE);
        this.defaults.put("urlColumn", Boolean.TRUE);
        this.defaults.put("fileColumn", Boolean.TRUE);
        this.defaults.put("arxivColumn", Boolean.FALSE);
        this.defaults.put("specialFieldsEnabled", SpecialFieldsUtils.PREF_SPECIALFIELDSENABLED_DEFAULT);
        this.defaults.put("showPriorityColumn", SpecialFieldsUtils.PREF_SHOWCOLUMN_PRIORITY_DEFAULT);
        this.defaults.put("showQualityColumn", SpecialFieldsUtils.PREF_SHOWCOLUMN_QUALITY_DEFAULT);
        this.defaults.put("showRankingColumn", SpecialFieldsUtils.PREF_SHOWCOLUMN_RANKING_DEFAULT);
        this.defaults.put("compactRankingColumn", SpecialFieldsUtils.PREF_RANKING_COMPACT_DEFAULT);
        this.defaults.put("showRelevanceColumn", SpecialFieldsUtils.PREF_SHOWCOLUMN_RELEVANCE_DEFAULT);
        this.defaults.put("autoSyncSpecialFieldsToKeywords", SpecialFieldsUtils.PREF_AUTOSYNCSPECIALFIELDSTOKEYWORDS_DEFAULT);
        this.defaults.put("serializeSpecialFields", SpecialFieldsUtils.PREF_SERIALIZESPECIALFIELDS_DEFAULT);
        this.defaults.put(SHOWONELETTERHEADINGFORICONCOLUMNS, Boolean.FALSE);
        this.defaults.put("useOwner", Boolean.TRUE);
        this.defaults.put("overwriteOwner", Boolean.FALSE);
        this.defaults.put("allowTableEditing", Boolean.FALSE);
        this.defaults.put("dialogWarningForDuplicateKey", Boolean.TRUE);
        this.defaults.put("dialogWarningForEmptyKey", Boolean.TRUE);
        this.defaults.put("displayKeyWarningDialogAtStartup", Boolean.TRUE);
        this.defaults.put("avoidOverwritingKey", Boolean.FALSE);
        this.defaults.put("warnBeforeOverwritingKey", Boolean.TRUE);
        this.defaults.put("confirmDelete", Boolean.TRUE);
        this.defaults.put("grayOutNonHits", Boolean.TRUE);
        this.defaults.put("floatSearch", Boolean.TRUE);
        this.defaults.put("showSearchInDialog", Boolean.FALSE);
        this.defaults.put("searchAllBases", Boolean.FALSE);
        this.defaults.put("defaultLabelPattern", "[auth][year]");
        this.defaults.put("previewEnabled", Boolean.TRUE);
        this.defaults.put("activePreview", 0);
        this.defaults.put("preview0", "<font face=\"arial\"><b><i>\\bibtextype</i><a name=\"\\bibtexkey\">\\begin{bibtexkey} (\\bibtexkey)</a>\\end{bibtexkey}</b><br>__NEWLINE__\\begin{author} \\format[Authors(LastFirst,Initials,Semicolon,Amp),HTMLChars]{\\author}<BR>\\end{author}__NEWLINE__\\begin{editor} \\format[Authors(LastFirst,Initials,Semicolon,Amp),HTMLChars]{\\editor} <i>(\\format[IfPlural(Eds.,Ed.)]{\\editor})</i><BR>\\end{editor}__NEWLINE__\\begin{title} \\format[HTMLChars]{\\title} \\end{title}<BR>__NEWLINE__\\begin{chapter} \\format[HTMLChars]{\\chapter}<BR>\\end{chapter}__NEWLINE__\\begin{journal} <em>\\format[HTMLChars]{\\journal}, </em>\\end{journal}__NEWLINE__\\begin{booktitle} <em>\\format[HTMLChars]{\\booktitle}, </em>\\end{booktitle}__NEWLINE__\\begin{school} <em>\\format[HTMLChars]{\\school}, </em>\\end{school}__NEWLINE__\\begin{institution} <em>\\format[HTMLChars]{\\institution}, </em>\\end{institution}__NEWLINE__\\begin{publisher} <em>\\format[HTMLChars]{\\publisher}, </em>\\end{publisher}__NEWLINE__\\begin{year}<b>\\year</b>\\end{year}\\begin{volume}<i>, \\volume</i>\\end{volume}\\begin{pages}, \\format[FormatPagesForHTML]{\\pages} \\end{pages}__NEWLINE__\\begin{abstract}<BR><BR><b>Abstract: </b> \\format[HTMLChars]{\\abstract} \\end{abstract}__NEWLINE__\\begin{review}<BR><BR><b>Review: </b> \\format[HTMLChars]{\\review} \\end{review}</dd>__NEWLINE__<p></p></font>");
        this.defaults.put("preview1", "<font face=\"arial\"><b><i>\\bibtextype</i><a name=\"\\bibtexkey\">\\begin{bibtexkey} (\\bibtexkey)</a>\\end{bibtexkey}</b><br>__NEWLINE__\\begin{author} \\format[Authors(LastFirst,Initials,Semicolon,Amp),HTMLChars]{\\author}<BR>\\end{author}__NEWLINE__\\begin{editor} \\format[Authors(LastFirst,Initials,Semicolon,Amp),HTMLChars]{\\editor} <i>(\\format[IfPlural(Eds.,Ed.)]{\\editor})</i><BR>\\end{editor}__NEWLINE__\\begin{title} \\format[HTMLChars]{\\title} \\end{title}<BR>__NEWLINE__\\begin{chapter} \\format[HTMLChars]{\\chapter}<BR>\\end{chapter}__NEWLINE__\\begin{journal} <em>\\format[HTMLChars]{\\journal}, </em>\\end{journal}__NEWLINE__\\begin{booktitle} <em>\\format[HTMLChars]{\\booktitle}, </em>\\end{booktitle}__NEWLINE__\\begin{school} <em>\\format[HTMLChars]{\\school}, </em>\\end{school}__NEWLINE__\\begin{institution} <em>\\format[HTMLChars]{\\institution}, </em>\\end{institution}__NEWLINE__\\begin{publisher} <em>\\format[HTMLChars]{\\publisher}, </em>\\end{publisher}__NEWLINE__\\begin{year}<b>\\year</b>\\end{year}\\begin{volume}<i>, \\volume</i>\\end{volume}\\begin{pages}, \\format[FormatPagesForHTML]{\\pages} \\end{pages}</dd>__NEWLINE__<p></p></font>");
        this.defaults.put("previewPrintButton", Boolean.FALSE);
        this.defaults.put("autoDoubleBraces", Boolean.FALSE);
        this.defaults.put("doNotResolveStringsFor", "url");
        this.defaults.put("resolveStringsAllFields", Boolean.FALSE);
        this.defaults.put("putBracesAroundCapitals", "");
        this.defaults.put("nonWrappableFields", "pdf;ps;url;doi;file");
        this.defaults.put("useImportInspectionDialog", Boolean.TRUE);
        this.defaults.put("useImportInspectionDialogForSingle", Boolean.TRUE);
        this.defaults.put("generateKeysAfterInspection", Boolean.TRUE);
        this.defaults.put("markImportedEntries", Boolean.TRUE);
        this.defaults.put("unmarkAllEntriesBeforeImporting", Boolean.TRUE);
        this.defaults.put("warnAboutDuplicatesInInspection", Boolean.TRUE);
        this.defaults.put("useTimeStamp", Boolean.TRUE);
        this.defaults.put("overwriteTimeStamp", Boolean.FALSE);
        this.defaults.put("timeStampFormat", "yyyy.MM.dd");
        this.defaults.put("timeStampField", "timestamp");
        this.defaults.put("generateKeysBeforeSaving", Boolean.FALSE);
        this.defaults.put("useRemoteServer", Boolean.FALSE);
        this.defaults.put("remoteServerPort", new Integer(6050));
        this.defaults.put("personalJournalList", null);
        this.defaults.put("externalJournalLists", null);
        this.defaults.put("citeCommand", "cite");
        this.defaults.put("citeCommandVim", "\\cite");
        this.defaults.put("citeCommandEmacs", "\\cite");
        this.defaults.put("citeCommandWinEdt", "\\cite");
        this.defaults.put("citeCommandLed", "\\cite");
        this.defaults.put("floatMarkedEntries", Boolean.TRUE);
        this.defaults.put("useNativeFileDialogOnMac", Boolean.FALSE);
        this.defaults.put("filechooserDisableRename", Boolean.TRUE);
        this.defaults.put("lastUsedExport", null);
        this.defaults.put("sidePaneWidth", new Integer(-1));
        this.defaults.put("importInspectionDialogWidth", new Integer(650));
        this.defaults.put("importInspectionDialogHeight", new Integer(650));
        this.defaults.put("searchDialogWidth", new Integer(650));
        this.defaults.put("searchDialogHeight", new Integer(500));
        this.defaults.put("showFileLinksUpgradeWarning", Boolean.TRUE);
        this.defaults.put("autolinkExactKeyOnly", Boolean.TRUE);
        this.defaults.put("numericFields", "mittnum;author");
        this.defaults.put("runAutomaticFileSearch", Boolean.FALSE);
        this.defaults.put("useLockFiles", Boolean.TRUE);
        this.defaults.put("autoSave", Boolean.TRUE);
        this.defaults.put("autoSaveInterval", 5);
        this.defaults.put("promptBeforeUsingAutosave", Boolean.TRUE);
        this.defaults.put("deletePlugins", "");
        this.defaults.put("enforceLegalBibtexKey", Boolean.TRUE);
        this.defaults.put("biblatexMode", Boolean.FALSE);
        this.defaults.put("keyGenFirstLetterA", Boolean.TRUE);
        this.defaults.put("keyGenAlwaysAddLetter", Boolean.FALSE);
        this.defaults.put(EMAIL_SUBJECT, Globals.lang("References"));
        this.defaults.put(OPEN_FOLDERS_OF_ATTACHED_FILES, Boolean.FALSE);
        this.defaults.put("allowFileAutoOpenBrowse", Boolean.TRUE);
        this.defaults.put("webSearchVisible", Boolean.FALSE);
        this.defaults.put("selectedFetcherIndex", 0);
        this.defaults.put("bibLocationAsFileDir", Boolean.TRUE);
        this.defaults.put("bibLocAsPrimaryDir", Boolean.FALSE);
        this.defaults.put("dbConnectServerType", "MySQL");
        this.defaults.put("dbConnectHostname", "localhost");
        this.defaults.put("dbConnectDatabase", "jabref");
        this.defaults.put("dbConnectUsername", "root");
        CleanUpAction.putDefaults(this.defaults);
        this.defaults.put("DroppedFileHandler_LeaveFileInDir", Boolean.FALSE);
        this.defaults.put("DroppedFileHandler_CopyFile", Boolean.TRUE);
        this.defaults.put("DroppedFileHandler_MoveFile", Boolean.FALSE);
        this.defaults.put("DroppedFileHandler_RenameFile", Boolean.FALSE);
        this.defaults.put("importAlwaysUsePDFImportStyle", Boolean.FALSE);
        this.defaults.put("importDefaultPDFimportStyle", 2);
        this.defaults.put("importFileNamePattern", ImportSettingsTab.DEFAULT_FILENAMEPATTERNS[0]);
        this.restoreKeyBindings();
        this.customExports = new CustomExportList(new ExportComparator());
        this.customImports = new CustomImportList(this);
        this.updateSpecialFieldHandling();
        this.WRAPPED_USERNAME = "[" + this.get("defaultOwner") + "]";
        this.MARKING_WITH_NUMBER_PATTERN = "\\[" + this.get("defaultOwner").replaceAll("\\\\", "\\\\\\\\") + ":(\\d+)\\]";
        String defaultExpression = "**/.*[bibtexkey].*\\\\.[extension]";
        this.defaults.put(DEFAULT_REG_EXP_SEARCH_EXPRESSION_KEY, defaultExpression);
        this.defaults.put(REG_EXP_SEARCH_EXPRESSION_KEY, defaultExpression);
        this.defaults.put(USE_REG_EXP_SEARCH_KEY, Boolean.FALSE);
        this.defaults.put("useIEEEAbrv", Boolean.TRUE);
        this.defaults.put("useConvertToEquation", Boolean.FALSE);
        this.defaults.put("useCaseKeeperOnSearch", Boolean.TRUE);
        this.defaults.put("userFileDir", "fileDirectory");
        try {
            this.defaults.put("userFileDirIndividual", "fileDirectory-" + this.get("defaultOwner") + "@" + InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException ex) {
            Globals.logger("Hostname not found.");
            this.defaults.put("userFileDirIndividual", "fileDirectory-" + this.get("defaultOwner"));
        }
    }

    public void setLanguageDependentDefaultValues() {
        this.defaults.put("customTabName__def0", Globals.lang("General"));
        this.defaults.put("customTabFields__def0", "crossref;keywords;file;doi;url;comment;owner;timestamp");
        this.defaults.put("customTabFields__def1", "abstract");
        this.defaults.put("customTabName__def1", Globals.lang("Abstract"));
        this.defaults.put("customTabFields__def2", "review");
        this.defaults.put("customTabName__def2", Globals.lang("Review"));
    }

    public boolean putBracesAroundCapitals(String fieldName) {
        return this.putBracesAroundCapitalsFields.contains(fieldName);
    }

    public void updateSpecialFieldHandling() {
        int i;
        String[] fields;
        this.putBracesAroundCapitalsFields.clear();
        String fieldString = this.get("putBracesAroundCapitals");
        if (fieldString.length() > 0) {
            fields = fieldString.split(";");
            for (i = 0; i < fields.length; ++i) {
                this.putBracesAroundCapitalsFields.add(fields[i].trim());
            }
        }
        this.nonWrappableFields.clear();
        fieldString = this.get("nonWrappableFields");
        if (fieldString.length() > 0) {
            fields = fieldString.split(";");
            for (i = 0; i < fields.length; ++i) {
                this.nonWrappableFields.add(fields[i].trim());
            }
        }
    }

    public boolean hasKey(String key) {
        return this.prefs.get(key, null) != null;
    }

    public String get(String key) {
        return this.prefs.get(key, (String)this.defaults.get(key));
    }

    public String get(String key, String def) {
        return this.prefs.get(key, def);
    }

    public boolean getBoolean(String key) {
        return this.prefs.getBoolean(key, this.getBooleanDefault(key));
    }

    public boolean getBooleanDefault(String key) {
        return (Boolean)this.defaults.get(key);
    }

    public double getDouble(String key) {
        return this.prefs.getDouble(key, this.getDoubleDefault(key));
    }

    public double getDoubleDefault(String key) {
        return (Double)this.defaults.get(key);
    }

    public int getInt(String key) {
        return this.prefs.getInt(key, this.getIntDefault(key));
    }

    public int getIntDefault(String key) {
        return (Integer)this.defaults.get(key);
    }

    public byte[] getByteArray(String key) {
        return this.prefs.getByteArray(key, this.getByteArrayDefault(key));
    }

    public byte[] getByteArrayDefault(String key) {
        return (byte[])this.defaults.get(key);
    }

    public void put(String key, String value) {
        this.prefs.put(key, value);
    }

    public void putBoolean(String key, boolean value) {
        this.prefs.putBoolean(key, value);
    }

    public void putDouble(String key, double value) {
        this.prefs.putDouble(key, value);
    }

    public void putInt(String key, int value) {
        this.prefs.putInt(key, value);
    }

    public void putByteArray(String key, byte[] value) {
        this.prefs.putByteArray(key, value);
    }

    public void remove(String key) {
        this.prefs.remove(key);
    }

    public void putStringArray(String key, String[] value) {
        if (value == null) {
            this.remove(key);
            return;
        }
        if (value.length > 0) {
            StringBuffer linked = new StringBuffer();
            for (int i = 0; i < value.length - 1; ++i) {
                linked.append(this.makeEscape(value[i]));
                linked.append(";");
            }
            linked.append(this.makeEscape(value[value.length - 1]));
            this.put(key, linked.toString());
        } else {
            this.put(key, "");
        }
    }

    public String[] getStringArray(String key) {
        String names = this.get(key);
        if (names == null) {
            return null;
        }
        StringReader rd = new StringReader(names);
        Vector<String> arr = new Vector<String>();
        try {
            String rs;
            while ((rs = this.getNextUnit(rd)) != null) {
                arr.add(rs);
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        String[] res = new String[arr.size()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = (String)arr.elementAt(i);
        }
        return res;
    }

    public Color getColor(String key) {
        String value = this.get(key);
        int[] rgb = this.getRgb(value);
        return new Color(rgb[0], rgb[1], rgb[2]);
    }

    public Color getDefaultColor(String key) {
        String value = (String)this.defaults.get(key);
        int[] rgb = this.getRgb(value);
        return new Color(rgb[0], rgb[1], rgb[2]);
    }

    public void putDefaultValue(String key, Object value) {
        this.defaults.put(key, value);
    }

    public void putColor(String key, Color color) {
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(color.getRed()));
        sb.append(':');
        sb.append(String.valueOf(color.getGreen()));
        sb.append(':');
        sb.append(String.valueOf(color.getBlue()));
        this.put(key, sb.toString());
    }

    public int[] getRgb(String value) {
        String[] elements = value.split(":");
        int[] values = new int[]{Integer.parseInt(elements[0]), Integer.parseInt(elements[1]), Integer.parseInt(elements[2])};
        return values;
    }

    public KeyStroke getKey(String bindName) {
        String s = this.keyBinds.get(bindName);
        if (s == null) {
            s = this.defKeyBinds.get(bindName);
            this.keyBinds.put(bindName, s);
        }
        if (s == null) {
            Globals.logger("Could not get key binding for \"" + bindName + "\"");
        }
        if (Globals.ON_MAC) {
            return this.getKeyForMac(KeyStroke.getKeyStroke(s));
        }
        return KeyStroke.getKeyStroke(s);
    }

    private KeyStroke getKeyForMac(KeyStroke ks) {
        if (ks == null) {
            return null;
        }
        int keyCode = ks.getKeyCode();
        if ((ks.getModifiers() & 2) == 0) {
            return ks;
        }
        int modifiers = 0;
        if ((ks.getModifiers() & 1) != 0) {
            modifiers |= 1;
        }
        if ((ks.getModifiers() & 8) != 0) {
            modifiers |= 8;
        }
        return KeyStroke.getKeyStroke(keyCode, Globals.getShortcutMask() + modifiers);
    }

    public HashMap<String, String> getKeyBindings() {
        return this.keyBinds;
    }

    public HashMap<String, String> getDefaultKeys() {
        return this.defKeyBinds;
    }

    public void clear() throws BackingStoreException {
        this.prefs.clear();
    }

    public void clear(String key) throws BackingStoreException {
        this.prefs.remove(key);
    }

    public void flush() {
        if (this.getBoolean("memoryStickMode")) {
            try {
                this.exportPreferences("jabref.xml");
            }
            catch (IOException e) {
                Globals.logger("Could not save preferences for memory stick mode: " + e.getLocalizedMessage());
            }
        }
        try {
            this.prefs.flush();
        }
        catch (BackingStoreException ex) {
            ex.printStackTrace();
        }
    }

    public void setNewKeyBindings(HashMap<String, String> newBindings) {
        if (!newBindings.equals(this.keyBinds)) {
            String[] bindNames = new String[newBindings.size()];
            String[] bindings = new String[newBindings.size()];
            int index = 0;
            for (String nm : newBindings.keySet()) {
                String bnd = newBindings.get(nm);
                bindNames[index] = nm;
                bindings[index] = bnd;
                ++index;
            }
            this.putStringArray("bindNames", bindNames);
            this.putStringArray("bindings", bindings);
            this.keyBinds = newBindings;
        }
    }

    public LabelPattern getKeyPattern() {
        keyPattern = new LabelPattern();
        Preferences pre = Preferences.userNodeForPackage(LabelPattern.class);
        try {
            String[] keys = pre.keys();
            if (keys.length > 0) {
                for (int i = 0; i < keys.length; ++i) {
                    keyPattern.addLabelPattern(keys[i], pre.get(keys[i], null));
                }
            }
        }
        catch (BackingStoreException ex) {
            Globals.logger("BackingStoreException in JabRefPreferences.getKeyPattern");
        }
        return keyPattern;
    }

    public void putKeyPattern(LabelPattern pattern) {
        keyPattern = pattern;
        LabelPattern parent = pattern.getParent();
        Preferences pre = Preferences.userNodeForPackage(LabelPattern.class);
        try {
            pre.clear();
        }
        catch (BackingStoreException ex) {
            Globals.logger("BackingStoreException in JabRefPreferences.putKeyPattern");
        }
        for (String s : pattern.keySet()) {
            ArrayList value = (ArrayList)pattern.get(s);
            if (value == null) continue;
            pre.put(s, (String)value.get(0));
        }
    }

    private void restoreKeyBindings() {
        this.defineDefaultKeyBindings();
        String[] bindNames = this.getStringArray("bindNames");
        String[] bindings = this.getStringArray("bindings");
        if (bindNames == null || bindings == null || bindNames.length != bindings.length) {
            this.setDefaultKeyBindings();
            return;
        }
        for (int i = 0; i < bindNames.length; ++i) {
            this.keyBinds.put(bindNames[i], bindings[i]);
        }
    }

    private void setDefaultKeyBindings() {
        this.keyBinds = this.defKeyBinds;
    }

    private void defineDefaultKeyBindings() {
        this.defKeyBinds.put("Push to application", "ctrl L");
        this.defKeyBinds.put("Push to LyX", "ctrl L");
        this.defKeyBinds.put("Push to WinEdt", "ctrl shift W");
        this.defKeyBinds.put("Quit JabRef", "ctrl Q");
        this.defKeyBinds.put("Open database", "ctrl O");
        this.defKeyBinds.put("Save database", "ctrl S");
        this.defKeyBinds.put("Save database as ...", "ctrl shift S");
        this.defKeyBinds.put("Save all", "ctrl alt S");
        this.defKeyBinds.put("Close database", "ctrl W");
        this.defKeyBinds.put("New entry", "ctrl N");
        this.defKeyBinds.put("Cut", "ctrl X");
        this.defKeyBinds.put("Copy", "ctrl C");
        this.defKeyBinds.put("Paste", "ctrl V");
        this.defKeyBinds.put("Undo", "ctrl Z");
        this.defKeyBinds.put("Redo", "ctrl Y");
        this.defKeyBinds.put("Help", "F1");
        this.defKeyBinds.put("New article", "ctrl shift A");
        this.defKeyBinds.put("New book", "ctrl shift B");
        this.defKeyBinds.put("New phdthesis", "ctrl shift T");
        this.defKeyBinds.put("New inbook", "ctrl shift I");
        this.defKeyBinds.put("New mastersthesis", "ctrl shift M");
        this.defKeyBinds.put("New proceedings", "ctrl shift P");
        this.defKeyBinds.put("New unpublished", "ctrl shift U");
        this.defKeyBinds.put("Edit strings", "ctrl T");
        this.defKeyBinds.put("Edit preamble", "ctrl P");
        this.defKeyBinds.put("Select all", "ctrl A");
        this.defKeyBinds.put("Toggle groups interface", "ctrl shift G");
        this.defKeyBinds.put("Autogenerate BibTeX keys", "ctrl G");
        this.defKeyBinds.put("Search", "ctrl F");
        this.defKeyBinds.put("Incremental search", "ctrl shift F");
        this.defKeyBinds.put("Repeat incremental search", "ctrl shift F");
        this.defKeyBinds.put("Close dialog", "ESCAPE");
        this.defKeyBinds.put("Close entry editor", "ESCAPE");
        this.defKeyBinds.put("Close preamble editor", "ESCAPE");
        this.defKeyBinds.put("Back, help dialog", "LEFT");
        this.defKeyBinds.put("Forward, help dialog", "RIGHT");
        this.defKeyBinds.put("Preamble editor, store changes", "alt S");
        this.defKeyBinds.put("Clear search", "ESCAPE");
        this.defKeyBinds.put("Entry editor, next panel", "ctrl TAB");
        this.defKeyBinds.put("Entry editor, previous panel", "ctrl shift TAB");
        this.defKeyBinds.put("Entry editor, next panel 2", "ctrl PLUS");
        this.defKeyBinds.put("Entry editor, previous panel 2", "ctrl MINUS");
        this.defKeyBinds.put("Entry editor, next entry", "ctrl shift DOWN");
        this.defKeyBinds.put("Entry editor, previous entry", "ctrl shift UP");
        this.defKeyBinds.put("Entry editor, store field", "alt S");
        this.defKeyBinds.put("String dialog, add string", "ctrl N");
        this.defKeyBinds.put("String dialog, remove string", "shift DELETE");
        this.defKeyBinds.put("String dialog, move string up", "ctrl UP");
        this.defKeyBinds.put("String dialog, move string down", "ctrl DOWN");
        this.defKeyBinds.put("Save session", "F11");
        this.defKeyBinds.put("Load session", "F12");
        this.defKeyBinds.put("Copy \\cite{BibTeX key}", "ctrl K");
        this.defKeyBinds.put("Copy BibTeX key", "ctrl shift K");
        this.defKeyBinds.put("Copy BibTeX key and title", "ctrl shift alt K");
        this.defKeyBinds.put("Next tab", "ctrl PAGE_DOWN");
        this.defKeyBinds.put("Previous tab", "ctrl PAGE_UP");
        this.defKeyBinds.put("Replace string", "ctrl R");
        this.defKeyBinds.put("Delete", "DELETE");
        this.defKeyBinds.put("Open file", "F4");
        this.defKeyBinds.put("Open PDF or PS", "shift F5");
        this.defKeyBinds.put("Open URL or DOI", "F3");
        this.defKeyBinds.put("Open SPIRES entry", "ctrl F3");
        this.defKeyBinds.put("Toggle entry preview", "ctrl F9");
        this.defKeyBinds.put("Switch preview layout", "F9");
        this.defKeyBinds.put("Edit entry", "ctrl E");
        this.defKeyBinds.put("Mark entries", "ctrl M");
        this.defKeyBinds.put("Unmark entries", "ctrl shift M");
        this.defKeyBinds.put("Fetch Medline", "F5");
        this.defKeyBinds.put("Search ScienceDirect", "ctrl F5");
        this.defKeyBinds.put("Search ADS", "ctrl shift F6");
        this.defKeyBinds.put("New from plain text", "ctrl shift N");
        this.defKeyBinds.put("Synchronize files", "ctrl F4");
        this.defKeyBinds.put("Synchronize PDF", "shift F4");
        this.defKeyBinds.put("Synchronize PS", "ctrl shift F4");
        this.defKeyBinds.put("Focus entry table", "ctrl shift E");
        this.defKeyBinds.put("Abbreviate", "ctrl alt A");
        this.defKeyBinds.put("Unabbreviate", "ctrl alt shift A");
        this.defKeyBinds.put("Search IEEEXplore", "alt F8");
        this.defKeyBinds.put("Search ACM Portal", "ctrl shift F8");
        this.defKeyBinds.put("Fetch ArXiv.org", "shift F8");
        this.defKeyBinds.put("Search JSTOR", "shift F9");
        this.defKeyBinds.put("Write XMP", "ctrl F4");
        this.defKeyBinds.put("New file link", "ctrl N");
        this.defKeyBinds.put("Fetch SPIRES", "ctrl F8");
        this.defKeyBinds.put("Fetch INSPIRE", "ctrl F2");
        this.defKeyBinds.put("Back", "alt LEFT");
        this.defKeyBinds.put("Forward", "alt RIGHT");
        this.defKeyBinds.put("Import into current database", "ctrl I");
        this.defKeyBinds.put("Import into new database", "ctrl alt I");
        this.defKeyBinds.put("findUnlinkedFiles", "");
        this.defKeyBinds.put("Increase table font size", "ctrl PLUS");
        this.defKeyBinds.put("Decrease table font size", "ctrl MINUS");
        this.defKeyBinds.put("Automatically link files", "alt F");
        this.defKeyBinds.put("Resolve duplicate BibTeX keys", "ctrl shift D");
        this.defKeyBinds.put("Refresh OO", "ctrl alt O");
        this.defKeyBinds.put("File list editor, move entry up", "ctrl UP");
        this.defKeyBinds.put("File list editor, move entry down", "ctrl DOWN");
        this.defKeyBinds.put("Minimize to system tray", "ctrl alt W");
    }

    private String getNextUnit(Reader data) throws IOException {
        int c;
        boolean escape = false;
        boolean done = false;
        StringBuffer res = new StringBuffer();
        while (!done && (c = data.read()) != -1) {
            if (c == 92) {
                if (!escape) {
                    escape = true;
                    continue;
                }
                escape = false;
                res.append('\\');
                continue;
            }
            if (c == 59) {
                if (!escape) {
                    done = true;
                } else {
                    res.append(';');
                }
            } else {
                res.append((char)c);
            }
            escape = false;
        }
        if (res.length() > 0) {
            return res.toString();
        }
        return null;
    }

    private String makeEscape(String s) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\' || c == ';') {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public void storeCustomEntryType(CustomEntryType tp, int number) {
        String nr = "" + number;
        this.put(CUSTOM_TYPE_NAME + nr, tp.getName());
        this.put(CUSTOM_TYPE_REQ + nr, tp.getRequiredFieldsString());
        this.putStringArray(CUSTOM_TYPE_OPT + nr, tp.getOptionalFields());
        this.putStringArray(CUSTOM_TYPE_PRIOPT + nr, tp.getPrimaryOptionalFields());
    }

    public CustomEntryType getCustomEntryType(int number) {
        int i;
        String nr = "" + number;
        String name = this.get(CUSTOM_TYPE_NAME + nr);
        String[] req = this.getStringArray(CUSTOM_TYPE_REQ + nr);
        String[] opt = this.getStringArray(CUSTOM_TYPE_OPT + nr);
        String[] priOpt = this.getStringArray(CUSTOM_TYPE_PRIOPT + nr);
        if (name == null) {
            return null;
        }
        if (priOpt == null) {
            return new CustomEntryType(Util.nCase(name), req, opt);
        }
        ArrayList<String> secOpt = new ArrayList<String>();
        for (i = 0; i < opt.length; ++i) {
            secOpt.add(opt[i]);
        }
        for (i = 0; i < priOpt.length; ++i) {
            secOpt.remove(priOpt[i]);
        }
        return new CustomEntryType(Util.nCase(name), req, priOpt, secOpt.toArray(new String[secOpt.size()]));
    }

    public List<ExternalFileType> getDefaultExternalFileTypes() {
        ArrayList<ExternalFileType> list = new ArrayList<ExternalFileType>();
        list.add(new ExternalFileType("PDF", "pdf", "application/pdf", "evince", "pdfSmall"));
        list.add(new ExternalFileType("PostScript", "ps", "application/postscript", "evince", "psSmall"));
        list.add(new ExternalFileType("Word", "doc", "application/msword", "oowriter", "openoffice"));
        list.add(new ExternalFileType("Word 2007+", "docx", "application/vnd.openxmlformats-officedocument.wordprocessingml.document", "oowriter", "openoffice"));
        list.add(new ExternalFileType("OpenDocument text", "odt", "application/vnd.oasis.opendocument.text", "oowriter", "openoffice"));
        list.add(new ExternalFileType("Excel", "xls", "application/excel", "oocalc", "openoffice"));
        list.add(new ExternalFileType("Excel 2007+", "xlsx", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "oocalc", "openoffice"));
        list.add(new ExternalFileType("OpenDocument spreadsheet", "ods", "application/vnd.oasis.opendocument.spreadsheet", "oocalc", "openoffice"));
        list.add(new ExternalFileType("PowerPoint", "ppt", "application/vnd.ms-powerpoint", "ooimpress", "openoffice"));
        list.add(new ExternalFileType("PowerPoint 2007+", "pptx", "application/vnd.openxmlformats-officedocument.presentationml.presentation", "ooimpress", "openoffice"));
        list.add(new ExternalFileType("OpenDocument presentation", "odp", "application/vnd.oasis.opendocument.presentation", "ooimpress", "openoffice"));
        list.add(new ExternalFileType("Rich Text Format", "rtf", "application/rtf", "oowriter", "openoffice"));
        list.add(new ExternalFileType("PNG image", "png", "image/png", "gimp", "picture"));
        list.add(new ExternalFileType("GIF image", "gif", "image/gif", "gimp", "picture"));
        list.add(new ExternalFileType("JPG image", "jpg", "image/jpeg", "gimp", "picture"));
        list.add(new ExternalFileType("Djvu", "djvu", "", "evince", "psSmall"));
        list.add(new ExternalFileType("Text", "txt", "text/plain", "emacs", "emacs"));
        list.add(new ExternalFileType("LaTeX", "tex", "application/x-latex", "emacs", "emacs"));
        list.add(new ExternalFileType("CHM", "chm", "application/mshelp", "gnochm", "www"));
        list.add(new ExternalFileType("TIFF image", "tiff", "image/tiff", "gimp", "picture"));
        list.add(new ExternalFileType("URL", "html", "text/html", "firefox", "www"));
        list.add(new ExternalFileType("MHT", "mht", "multipart/related", "firefox", "www"));
        list.add(new ExternalFileType("ePUB", "epub", "application/epub+zip", "firefox", "www"));
        for (ExternalFileType type : list) {
            type.setOpenWith("");
        }
        return list;
    }

    public ExternalFileType[] getExternalFileTypeSelection() {
        return this.externalFileTypes.toArray(new ExternalFileType[this.externalFileTypes.size()]);
    }

    public ExternalFileType getExternalFileTypeByName(String name) {
        for (ExternalFileType type : this.externalFileTypes) {
            if (!type.getName().equals(name)) continue;
            return type;
        }
        return new UnknownExternalFileType(name);
    }

    public ExternalFileType getExternalFileTypeByExt(String extension) {
        for (ExternalFileType type : this.externalFileTypes) {
            if (type.getExtension() == null || !type.getExtension().equalsIgnoreCase(extension)) continue;
            return type;
        }
        return null;
    }

    public ExternalFileType getExternalFileTypeForName(String filename) {
        int longestFound = -1;
        ExternalFileType foundType = null;
        for (ExternalFileType type : this.externalFileTypes) {
            if (type.getExtension() == null || !filename.toLowerCase().endsWith(type.getExtension().toLowerCase()) || type.getExtension().length() <= longestFound) continue;
            longestFound = type.getExtension().length();
            foundType = type;
        }
        return foundType;
    }

    public ExternalFileType getExternalFileTypeByMimeType(String mimeType) {
        for (ExternalFileType type : this.externalFileTypes) {
            if (type.getMimeType() == null || !type.getMimeType().equals(mimeType)) continue;
            return type;
        }
        if (mimeType.equals("text/html")) {
            return this.HTML_FALLBACK_TYPE;
        }
        return null;
    }

    public void setExternalFileTypes(List<ExternalFileType> types) {
        List<ExternalFileType> defTypes = this.getDefaultExternalFileTypes();
        ArrayList<ExternalFileType> unchanged = new ArrayList<ExternalFileType>();
        this.externalFileTypes.clear();
        for (ExternalFileType type : types) {
            this.externalFileTypes.add(type);
            ExternalFileType found = null;
            for (ExternalFileType defType : defTypes) {
                if (!defType.getName().equals(type.getName())) continue;
                found = defType;
                break;
            }
            if (found == null) continue;
            if (found.equals(type)) {
                unchanged.add(type);
                continue;
            }
            defTypes.remove(found);
        }
        for (ExternalFileType type : unchanged) {
            defTypes.remove(type);
            types.remove(type);
        }
        String[][] array = new String[types.size() + defTypes.size()][];
        int i = 0;
        for (ExternalFileType type : types) {
            array[i] = type.getStringArrayRepresentation();
            ++i;
        }
        for (ExternalFileType type : defTypes) {
            array[i] = new String[]{type.getName(), FILE_TYPE_REMOVED_FLAG};
            ++i;
        }
        this.put("externalFileTypes", Util.encodeStringArray(array));
    }

    public void updateExternalFileTypes() {
        List<ExternalFileType> types = this.getDefaultExternalFileTypes();
        if (this.prefs.get("externalFileTypes", null) == null) {
            this.externalFileTypes.clear();
            this.externalFileTypes.addAll(types);
            return;
        }
        String[][] vals = Util.decodeStringDoubleArray(this.prefs.get("externalFileTypes", ""));
        for (int i = 0; i < vals.length; ++i) {
            if (vals[i].length == 2 && vals[i][1].equals(FILE_TYPE_REMOVED_FLAG)) {
                ExternalFileType toRemove = null;
                for (ExternalFileType type : types) {
                    if (!type.getName().equals(vals[i][0])) continue;
                    toRemove = type;
                    break;
                }
                if (toRemove == null) continue;
                types.remove(toRemove);
                continue;
            }
            ExternalFileType type = new ExternalFileType(vals[i]);
            ExternalFileType toRemove = null;
            for (ExternalFileType defType : types) {
                if (!type.getName().equals(defType.getName())) continue;
                toRemove = defType;
                break;
            }
            if (toRemove != null) {
                types.remove(toRemove);
            }
            types.add(type);
        }
        for (ExternalFileType type : types) {
            this.externalFileTypes.add(type);
        }
    }

    public void purgeCustomEntryTypes(int number) {
        this.purgeSeries(CUSTOM_TYPE_NAME, number);
        this.purgeSeries(CUSTOM_TYPE_REQ, number);
        this.purgeSeries(CUSTOM_TYPE_OPT, number);
        this.purgeSeries(CUSTOM_TYPE_PRIOPT, number);
    }

    public void purgeSeries(String prefix, int number) {
        while (this.get(prefix + number) != null) {
            this.remove(prefix + number);
            ++number;
        }
    }

    public EntryEditorTabList getEntryEditorTabList() {
        if (this.tabList == null) {
            this.updateEntryEditorTabList();
        }
        return this.tabList;
    }

    public void updateEntryEditorTabList() {
        this.tabList = new EntryEditorTabList();
    }

    public void exportPreferences(String filename) throws IOException {
        File f = new File(filename);
        FileOutputStream os = new FileOutputStream(f);
        try {
            this.prefs.exportSubtree(os);
        }
        catch (BackingStoreException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    public void importPreferences(String filename) throws IOException {
        File f = new File(filename);
        FileInputStream is = new FileInputStream(f);
        try {
            Preferences.importPreferences(is);
        }
        catch (InvalidPreferencesFormatException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    public boolean isNonWrappableField(String fieldName) {
        return this.nonWrappableFields.contains(fieldName);
    }

    static {
        singleton = null;
    }
}

